/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.media.AudioDeviceAttributes;
import android.media.CallbackUtil;
import android.media.IAudioDeviceVolumeDispatcher;
import android.media.IAudioService;
import android.media.IDeviceVolumeBehaviorDispatcher;
import android.media.VolumeInfo;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class AudioDeviceVolumeManager {
    private static final String TAG = "AudioDeviceVolumeManager";
    public static final int ADJUST_MODE_NORMAL = 0;
    public static final int ADJUST_MODE_START = 1;
    public static final int ADJUST_MODE_END = 2;
    private static IAudioService sService;
    private final String mPackageName;
    private final Object mDeviceVolumeListenerLock = new Object();
    @GuardedBy(value={"mDeviceVolumeListenerLock"})
    private ArrayList<ListenerInfo> mDeviceVolumeListeners;
    @GuardedBy(value={"mDeviceVolumeListenerLock"})
    private DeviceVolumeDispatcherStub mDeviceVolumeDispatcherStub;
    private final CallbackUtil.LazyListenerManager<OnDeviceVolumeBehaviorChangedListener> mDeviceVolumeBehaviorChangedListenerMgr = new CallbackUtil.LazyListenerManager();

    public AudioDeviceVolumeManager(Context context) {
        Objects.requireNonNull(context);
        this.mPackageName = context.getApplicationContext().getOpPackageName();
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setDeviceAbsoluteVolumeBehavior(AudioDeviceAttributes device, VolumeInfo volume, Executor executor, OnAudioDeviceVolumeChangedListener vclistener, boolean handlesVolumeAdjustment) {
        ArrayList<VolumeInfo> volumes = new ArrayList<VolumeInfo>(1);
        volumes.add(volume);
        this.setDeviceAbsoluteMultiVolumeBehavior(device, volumes, executor, vclistener, handlesVolumeAdjustment);
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setDeviceAbsoluteMultiVolumeBehavior(AudioDeviceAttributes device, List<VolumeInfo> volumes, Executor executor, OnAudioDeviceVolumeChangedListener vclistener, boolean handlesVolumeAdjustment) {
        this.baseSetDeviceAbsoluteMultiVolumeBehavior(device, volumes, executor, vclistener, handlesVolumeAdjustment, 3);
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setDeviceAbsoluteVolumeAdjustOnlyBehavior(AudioDeviceAttributes device, VolumeInfo volume, Executor executor, OnAudioDeviceVolumeChangedListener vclistener, boolean handlesVolumeAdjustment) {
        ArrayList<VolumeInfo> volumes = new ArrayList<VolumeInfo>(1);
        volumes.add(volume);
        this.setDeviceAbsoluteMultiVolumeAdjustOnlyBehavior(device, volumes, executor, vclistener, handlesVolumeAdjustment);
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setDeviceAbsoluteMultiVolumeAdjustOnlyBehavior(AudioDeviceAttributes device, List<VolumeInfo> volumes, Executor executor, OnAudioDeviceVolumeChangedListener vclistener, boolean handlesVolumeAdjustment) {
        this.baseSetDeviceAbsoluteMultiVolumeBehavior(device, volumes, executor, vclistener, handlesVolumeAdjustment, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    private void baseSetDeviceAbsoluteMultiVolumeBehavior(AudioDeviceAttributes device, List<VolumeInfo> volumes, Executor executor, OnAudioDeviceVolumeChangedListener vclistener, boolean handlesVolumeAdjustment, int behavior) {
        Objects.requireNonNull(device);
        Objects.requireNonNull(volumes);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(vclistener);
        ListenerInfo listenerInfo = new ListenerInfo(vclistener, executor, device, handlesVolumeAdjustment);
        Object object = this.mDeviceVolumeListenerLock;
        synchronized (object) {
            if (this.mDeviceVolumeListeners == null) {
                this.mDeviceVolumeListeners = new ArrayList();
            }
            if (this.mDeviceVolumeListeners.size() == 0) {
                if (this.mDeviceVolumeDispatcherStub == null) {
                    this.mDeviceVolumeDispatcherStub = new DeviceVolumeDispatcherStub();
                }
            } else {
                this.mDeviceVolumeListeners.removeIf(info -> info.mDevice.equalTypeAddress(device));
            }
            this.mDeviceVolumeListeners.add(listenerInfo);
            this.mDeviceVolumeDispatcherStub.register(true, device, volumes, handlesVolumeAdjustment, behavior);
        }
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE"})
    public void addOnDeviceVolumeBehaviorChangedListener(Executor executor, OnDeviceVolumeBehaviorChangedListener listener) throws SecurityException {
        this.mDeviceVolumeBehaviorChangedListenerMgr.addListener(executor, listener, "addOnDeviceVolumeBehaviorChangedListener", () -> new DeviceVolumeBehaviorDispatcherStub());
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE"})
    public void removeOnDeviceVolumeBehaviorChangedListener(OnDeviceVolumeBehaviorChangedListener listener) {
        this.mDeviceVolumeBehaviorChangedListenerMgr.removeListener(listener, "removeOnDeviceVolumeBehaviorChangedListener");
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public void setDeviceVolume(VolumeInfo vi, AudioDeviceAttributes ada) {
        try {
            AudioDeviceVolumeManager.getService().setDeviceVolume(vi, ada, this.mPackageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public VolumeInfo getDeviceVolume(VolumeInfo vi, AudioDeviceAttributes ada) {
        try {
            return AudioDeviceVolumeManager.getService().getDeviceVolume(vi, ada, this.mPackageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return VolumeInfo.getDefaultVolumeInfo();
        }
    }

    public static String volumeBehaviorName(int behavior) {
        switch (behavior) {
            case 0: {
                return "DEVICE_VOLUME_BEHAVIOR_VARIABLE";
            }
            case 1: {
                return "DEVICE_VOLUME_BEHAVIOR_FULL";
            }
            case 2: {
                return "DEVICE_VOLUME_BEHAVIOR_FIXED";
            }
            case 3: {
                return "DEVICE_VOLUME_BEHAVIOR_ABSOLUTE";
            }
            case 4: {
                return "DEVICE_VOLUME_BEHAVIOR_ABSOLUTE_MULTI_MODE";
            }
            case 5: {
                return "DEVICE_VOLUME_BEHAVIOR_ABSOLUTE_ADJUST_ONLY";
            }
        }
        return "invalid volume behavior " + behavior;
    }

    private static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    public static interface OnAudioDeviceVolumeChangedListener {
        public void onAudioDeviceVolumeChanged(AudioDeviceAttributes var1, VolumeInfo var2);

        public void onAudioDeviceVolumeAdjusted(AudioDeviceAttributes var1, VolumeInfo var2, int var3, int var4);
    }

    static class ListenerInfo {
        final OnAudioDeviceVolumeChangedListener mListener;
        final Executor mExecutor;
        final AudioDeviceAttributes mDevice;
        final boolean mHandlesVolumeAdjustment;

        ListenerInfo(OnAudioDeviceVolumeChangedListener listener, Executor exe, AudioDeviceAttributes device, boolean handlesVolumeAdjustment) {
            this.mListener = listener;
            this.mExecutor = exe;
            this.mDevice = device;
            this.mHandlesVolumeAdjustment = handlesVolumeAdjustment;
        }
    }

    class DeviceVolumeDispatcherStub
    extends IAudioDeviceVolumeDispatcher.Stub {
        DeviceVolumeDispatcherStub() {
        }

        @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
        public void register(boolean register, AudioDeviceAttributes device, List<VolumeInfo> volumes, boolean handlesVolumeAdjustment, int behavior) {
            try {
                AudioDeviceVolumeManager.getService().registerDeviceVolumeDispatcherForAbsoluteVolume(register, this, AudioDeviceVolumeManager.this.mPackageName, Objects.requireNonNull(device), Objects.requireNonNull(volumes), handlesVolumeAdjustment, behavior);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchDeviceVolumeChanged(AudioDeviceAttributes device, VolumeInfo vol) {
            ArrayList volumeListeners;
            Iterator iterator = AudioDeviceVolumeManager.this.mDeviceVolumeListenerLock;
            synchronized (iterator) {
                volumeListeners = (ArrayList)AudioDeviceVolumeManager.this.mDeviceVolumeListeners.clone();
            }
            for (ListenerInfo listenerInfo : volumeListeners) {
                if (!listenerInfo.mDevice.equalTypeAddress(device)) continue;
                listenerInfo.mExecutor.execute(() -> listenerInfo.mListener.onAudioDeviceVolumeChanged(device, vol));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchDeviceVolumeAdjusted(AudioDeviceAttributes device, VolumeInfo vol, int direction, int mode) {
            ArrayList volumeListeners;
            Iterator iterator = AudioDeviceVolumeManager.this.mDeviceVolumeListenerLock;
            synchronized (iterator) {
                volumeListeners = (ArrayList)AudioDeviceVolumeManager.this.mDeviceVolumeListeners.clone();
            }
            for (ListenerInfo listenerInfo : volumeListeners) {
                if (!listenerInfo.mDevice.equalTypeAddress(device)) continue;
                listenerInfo.mExecutor.execute(() -> listenerInfo.mListener.onAudioDeviceVolumeAdjusted(device, vol, direction, mode));
            }
        }
    }

    private class DeviceVolumeBehaviorDispatcherStub
    extends IDeviceVolumeBehaviorDispatcher.Stub
    implements CallbackUtil.DispatcherStub {
        private DeviceVolumeBehaviorDispatcherStub() {
        }

        @Override
        public void register(boolean register) {
            try {
                AudioDeviceVolumeManager.getService().registerDeviceVolumeBehaviorDispatcher(register, this);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }

        @Override
        public void dispatchDeviceVolumeBehaviorChanged(AudioDeviceAttributes device, int volumeBehavior) {
            AudioDeviceVolumeManager.this.mDeviceVolumeBehaviorChangedListenerMgr.callListeners(listener -> listener.onDeviceVolumeBehaviorChanged(device, volumeBehavior));
        }
    }

    public static interface OnDeviceVolumeBehaviorChangedListener {
        public void onDeviceVolumeBehaviorChanged(AudioDeviceAttributes var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VolumeAdjustmentMode {
    }
}

