/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioHalVersion;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.List;

public class AudioHalVersionInfo
implements Parcelable,
Comparable<AudioHalVersionInfo> {
    public static final int AUDIO_HAL_TYPE_HIDL = 0;
    public static final int AUDIO_HAL_TYPE_AIDL = 1;
    public static final AudioHalVersionInfo AIDL_1_0 = new AudioHalVersionInfo(1, 1, 0);
    public static final AudioHalVersionInfo HIDL_7_1 = new AudioHalVersionInfo(0, 7, 1);
    public static final AudioHalVersionInfo HIDL_7_0 = new AudioHalVersionInfo(0, 7, 0);
    public static final AudioHalVersionInfo HIDL_6_0 = new AudioHalVersionInfo(0, 6, 0);
    public static final AudioHalVersionInfo HIDL_5_0 = new AudioHalVersionInfo(0, 5, 0);
    public static final AudioHalVersionInfo HIDL_4_0 = new AudioHalVersionInfo(0, 4, 0);
    public static final AudioHalVersionInfo HIDL_2_0 = new AudioHalVersionInfo(0, 2, 0);
    public static final List<AudioHalVersionInfo> VERSIONS = List.of(HIDL_7_1, HIDL_7_0, HIDL_6_0, HIDL_5_0, HIDL_4_0);
    private static final String TAG = "AudioHalVersionInfo";
    private AudioHalVersion mHalVersion = new AudioHalVersion();
    public static final Parcelable.Creator<AudioHalVersionInfo> CREATOR = new Parcelable.Creator<AudioHalVersionInfo>(){

        @Override
        public AudioHalVersionInfo createFromParcel(Parcel in) {
            return new AudioHalVersionInfo(in);
        }

        public AudioHalVersionInfo[] newArray(int size) {
            return new AudioHalVersionInfo[size];
        }
    };

    @AudioHalType
    public int getHalType() {
        return this.mHalVersion.type;
    }

    public int getMajorVersion() {
        return this.mHalVersion.major;
    }

    public int getMinorVersion() {
        return this.mHalVersion.minor;
    }

    private static String typeToString(@AudioHalType int type) {
        if (type == 0) {
            return "HIDL";
        }
        if (type == 1) {
            return "AIDL";
        }
        return "INVALID";
    }

    private static String toString(@AudioHalType int type, int major, int minor) {
        return AudioHalVersionInfo.typeToString(type) + ":" + Integer.toString(major) + "." + Integer.toString(minor);
    }

    private AudioHalVersionInfo(@AudioHalType int type, int major, int minor) {
        this.mHalVersion.type = type;
        this.mHalVersion.major = major;
        this.mHalVersion.minor = minor;
    }

    private AudioHalVersionInfo(Parcel in) {
        this.mHalVersion = in.readTypedObject(AudioHalVersion.CREATOR);
    }

    public String toString() {
        return AudioHalVersionInfo.toString(this.mHalVersion.type, this.mHalVersion.major, this.mHalVersion.minor);
    }

    @Override
    public int compareTo(AudioHalVersionInfo other) {
        int indexOther = VERSIONS.indexOf(other);
        int indexThis = VERSIONS.indexOf(this);
        if (indexThis < 0 || indexOther < 0) {
            return indexThis - indexOther;
        }
        return indexOther - indexThis;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flag) {
        out.writeTypedObject(this.mHalVersion, flag);
    }

    public static @interface AudioHalType {
    }
}

