/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioFormat;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class AudioMixerAttributes
implements Parcelable {
    public static final int MIXER_BEHAVIOR_DEFAULT = 0;
    public static final int MIXER_BEHAVIOR_BIT_PERFECT = 1;
    private final AudioFormat mFormat;
    private final int mMixerBehavior;
    public static final Parcelable.Creator<AudioMixerAttributes> CREATOR = new Parcelable.Creator<AudioMixerAttributes>(){

        @Override
        public AudioMixerAttributes createFromParcel(Parcel p) {
            return new AudioMixerAttributes(p);
        }

        public AudioMixerAttributes[] newArray(int size) {
            return new AudioMixerAttributes[size];
        }
    };

    AudioMixerAttributes(AudioFormat format, int mixerBehavior) {
        this.mFormat = format;
        this.mMixerBehavior = mixerBehavior;
    }

    public AudioFormat getFormat() {
        return this.mFormat;
    }

    public int getMixerBehavior() {
        return this.mMixerBehavior;
    }

    public int hashCode() {
        return Objects.hash(this.mFormat, this.mMixerBehavior);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioMixerAttributes that = (AudioMixerAttributes)o;
        return this.mFormat.equals(that.mFormat) && this.mMixerBehavior == that.mMixerBehavior;
    }

    private String mixerBehaviorToString(int mixerBehavior) {
        switch (mixerBehavior) {
            case 0: {
                return "default";
            }
            case 1: {
                return "bit-perfect";
            }
        }
        return "unknown";
    }

    public String toString() {
        return new String("AudioMixerAttributes: format:" + this.mFormat.toString() + " mixer behavior:" + this.mixerBehaviorToString(this.mMixerBehavior));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mFormat, flags);
        dest.writeInt(this.mMixerBehavior);
    }

    private AudioMixerAttributes(Parcel in) {
        this.mFormat = in.readParcelable(AudioFormat.class.getClassLoader(), AudioFormat.class);
        this.mMixerBehavior = in.readInt();
    }

    public static class Builder {
        private final AudioFormat mFormat;
        private int mMixerBehavior = 0;

        public Builder(AudioFormat format) {
            Objects.requireNonNull(format);
            this.mFormat = format;
        }

        public AudioMixerAttributes build() {
            AudioMixerAttributes ama = new AudioMixerAttributes(this.mFormat, this.mMixerBehavior);
            return ama;
        }

        public Builder setMixerBehavior(int mixerBehavior) {
            switch (mixerBehavior) {
                case 0: 
                case 1: {
                    this.mMixerBehavior = mixerBehavior;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid mixer behavior " + mixerBehavior);
                }
            }
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MixerBehavior {
    }
}

