/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SuppressLint;
import android.media.permission.ClearCallingIdentityContext;
import android.media.permission.SafeCloseable;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;

class CallbackUtil {
    private static final String TAG = "CallbackUtil";

    CallbackUtil() {
    }

    static <T> ListenerInfo<T> getListenerInfo(T listener, ArrayList<ListenerInfo<T>> listeners) {
        if (listeners == null) {
            return null;
        }
        for (ListenerInfo<T> info : listeners) {
            if (info.mListener != listener) continue;
            return info;
        }
        return null;
    }

    static <T> boolean hasListener(T listener, ArrayList<ListenerInfo<T>> listeners) {
        return CallbackUtil.getListenerInfo(listener, listeners) != null;
    }

    static <T> boolean removeListener(T listener, ArrayList<ListenerInfo<T>> listeners) {
        ListenerInfo<T> infoToRemove = CallbackUtil.getListenerInfo(listener, listeners);
        if (infoToRemove != null) {
            listeners.remove(infoToRemove);
            return true;
        }
        return false;
    }

    static <T, S> Pair<ArrayList<ListenerInfo<T>>, S> addListener(String methodName, Executor executor, T listener, ArrayList<ListenerInfo<T>> listeners, S dispatchStub, Supplier<S> newStub, Consumer<S> registerStub) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        if (CallbackUtil.hasListener(listener, listeners)) {
            throw new IllegalArgumentException("attempt to call " + methodName + "on a previously registered listener");
        }
        if (listeners == null) {
            listeners = new ArrayList();
        }
        if (listeners.size() == 0) {
            if (dispatchStub == null) {
                try {
                    dispatchStub = newStub.get();
                }
                catch (Exception e) {
                    Log.e(TAG, "Exception while creating stub in " + methodName, e);
                    return new Pair<Object, Object>(null, null);
                }
            }
            registerStub.accept(dispatchStub);
        }
        listeners.add(new ListenerInfo<T>(listener, executor));
        return new Pair<ArrayList<ListenerInfo<Object>>, S>(listeners, dispatchStub);
    }

    static <T, S> Pair<ArrayList<ListenerInfo<T>>, S> removeListener(String methodName, T listener, ArrayList<ListenerInfo<T>> listeners, S dispatchStub, Consumer<S> unregisterStub) {
        Objects.requireNonNull(listener);
        if (!CallbackUtil.removeListener(listener, listeners)) {
            throw new IllegalArgumentException("attempt to call " + methodName + " on an unregistered listener");
        }
        if (listeners.size() == 0) {
            unregisterStub.accept(dispatchStub);
            return new Pair<Object, Object>(null, null);
        }
        return new Pair<ArrayList<ListenerInfo<T>>, S>(listeners, dispatchStub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void callListeners(ArrayList<ListenerInfo<T>> listeners, Object listenerLock, CallbackMethod<T> callback) {
        ArrayList listenersShallowCopy;
        Objects.requireNonNull(listenerLock);
        Object object = listenerLock;
        synchronized (object) {
            if (listeners == null || listeners.size() == 0) {
                return;
            }
            listenersShallowCopy = (ArrayList)listeners.clone();
        }
        try (SafeCloseable ignored = ClearCallingIdentityContext.create();){
            for (ListenerInfo info : listenersShallowCopy) {
                info.mExecutor.execute(() -> callback.callbackMethod(info.mListener));
            }
        }
    }

    static class ListenerInfo<T> {
        final T mListener;
        final Executor mExecutor;

        ListenerInfo(T listener, Executor exe) {
            this.mListener = listener;
            this.mExecutor = exe;
        }
    }

    static interface CallbackMethod<T> {
        public void callbackMethod(T var1);
    }

    static class LazyListenerManager<T> {
        private final Object mListenerLock = new Object();
        @GuardedBy(value={"mListenerLock"})
        private ArrayList<ListenerInfo<T>> mListeners;
        @GuardedBy(value={"mListenerLock"})
        private DispatcherStub mDispatcherStub;

        LazyListenerManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addListener(Executor executor, T listener, String methodName, Supplier<DispatcherStub> newStub) {
            Object object = this.mListenerLock;
            synchronized (object) {
                Pair<ArrayList<ListenerInfo<T>>, DispatcherStub> res = CallbackUtil.addListener(methodName, executor, listener, this.mListeners, this.mDispatcherStub, newStub, stub -> stub.register(true));
                this.mListeners = (ArrayList)res.first;
                this.mDispatcherStub = (DispatcherStub)res.second;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeListener(T listener, String methodName) {
            Object object = this.mListenerLock;
            synchronized (object) {
                Pair<ArrayList<ListenerInfo<T>>, DispatcherStub> res = CallbackUtil.removeListener(methodName, listener, this.mListeners, this.mDispatcherStub, stub -> stub.register(false));
                this.mListeners = (ArrayList)res.first;
                this.mDispatcherStub = (DispatcherStub)res.second;
            }
        }

        @SuppressLint(value={"GuardedBy"})
        void callListeners(CallbackMethod<T> callback) {
            CallbackUtil.callListeners(this.mListeners, this.mListenerLock, callback);
        }
    }

    static interface DispatcherStub {
        public void register(boolean var1);
    }
}

