/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Color;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class Cea708CCParser {
    private static final String TAG = "Cea708CCParser";
    private static final boolean DEBUG = false;
    private static final String MUSIC_NOTE_CHAR = new String("\u266b".getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
    private final StringBuffer mBuffer = new StringBuffer();
    private int mCommand = 0;
    private DisplayListener mListener = new DisplayListener(){

        @Override
        public void emitEvent(CaptionEvent event) {
        }
    };
    public static final int CAPTION_EMIT_TYPE_BUFFER = 1;
    public static final int CAPTION_EMIT_TYPE_CONTROL = 2;
    public static final int CAPTION_EMIT_TYPE_COMMAND_CWX = 3;
    public static final int CAPTION_EMIT_TYPE_COMMAND_CLW = 4;
    public static final int CAPTION_EMIT_TYPE_COMMAND_DSW = 5;
    public static final int CAPTION_EMIT_TYPE_COMMAND_HDW = 6;
    public static final int CAPTION_EMIT_TYPE_COMMAND_TGW = 7;
    public static final int CAPTION_EMIT_TYPE_COMMAND_DLW = 8;
    public static final int CAPTION_EMIT_TYPE_COMMAND_DLY = 9;
    public static final int CAPTION_EMIT_TYPE_COMMAND_DLC = 10;
    public static final int CAPTION_EMIT_TYPE_COMMAND_RST = 11;
    public static final int CAPTION_EMIT_TYPE_COMMAND_SPA = 12;
    public static final int CAPTION_EMIT_TYPE_COMMAND_SPC = 13;
    public static final int CAPTION_EMIT_TYPE_COMMAND_SPL = 14;
    public static final int CAPTION_EMIT_TYPE_COMMAND_SWA = 15;
    public static final int CAPTION_EMIT_TYPE_COMMAND_DFX = 16;

    Cea708CCParser(DisplayListener listener) {
        if (listener != null) {
            this.mListener = listener;
        }
    }

    private void emitCaptionEvent(CaptionEvent captionEvent) {
        this.emitCaptionBuffer();
        this.mListener.emitEvent(captionEvent);
    }

    private void emitCaptionBuffer() {
        if (this.mBuffer.length() > 0) {
            this.mListener.emitEvent(new CaptionEvent(1, this.mBuffer.toString()));
            this.mBuffer.setLength(0);
        }
    }

    public void parse(byte[] data) {
        int pos = 0;
        while (pos < data.length) {
            pos = this.parseServiceBlockData(data, pos);
        }
        this.emitCaptionBuffer();
    }

    private int parseServiceBlockData(byte[] data, int pos) {
        this.mCommand = data[pos] & 0xFF;
        ++pos;
        if (this.mCommand == 16) {
            pos = this.parseExt1(data, pos);
        } else if (this.mCommand >= 0 && this.mCommand <= 31) {
            pos = this.parseC0(data, pos);
        } else if (this.mCommand >= 128 && this.mCommand <= 159) {
            pos = this.parseC1(data, pos);
        } else if (this.mCommand >= 32 && this.mCommand <= 127) {
            pos = this.parseG0(data, pos);
        } else if (this.mCommand >= 160 && this.mCommand <= 255) {
            pos = this.parseG1(data, pos);
        }
        return pos;
    }

    private int parseC0(byte[] data, int pos) {
        if (this.mCommand >= 24 && this.mCommand <= 31) {
            if (this.mCommand == 24) {
                try {
                    if (data[pos] == 0) {
                        this.mBuffer.append((char)data[pos + 1]);
                    } else {
                        String value = new String(Arrays.copyOfRange(data, pos, pos + 2), "EUC-KR");
                        this.mBuffer.append(value);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    Log.e(TAG, "P16 Code - Could not find supported encoding", e);
                }
            }
            pos += 2;
        } else if (this.mCommand >= 16 && this.mCommand <= 23) {
            ++pos;
        } else {
            switch (this.mCommand) {
                case 0: {
                    break;
                }
                case 3: {
                    this.emitCaptionEvent(new CaptionEvent(2, Character.valueOf((char)this.mCommand)));
                    break;
                }
                case 8: {
                    this.emitCaptionEvent(new CaptionEvent(2, Character.valueOf((char)this.mCommand)));
                    break;
                }
                case 12: {
                    this.emitCaptionEvent(new CaptionEvent(2, Character.valueOf((char)this.mCommand)));
                    break;
                }
                case 13: {
                    this.mBuffer.append('\n');
                    break;
                }
                case 14: {
                    this.emitCaptionEvent(new CaptionEvent(2, Character.valueOf((char)this.mCommand)));
                    break;
                }
            }
        }
        return pos;
    }

    private int parseC1(byte[] data, int pos) {
        switch (this.mCommand) {
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                int windowId = this.mCommand - 128;
                this.emitCaptionEvent(new CaptionEvent(3, windowId));
                break;
            }
            case 136: {
                int windowBitmap = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(4, windowBitmap));
                break;
            }
            case 137: {
                int windowBitmap = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(5, windowBitmap));
                break;
            }
            case 138: {
                int windowBitmap = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(6, windowBitmap));
                break;
            }
            case 139: {
                int windowBitmap = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(7, windowBitmap));
                break;
            }
            case 140: {
                int windowBitmap = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(8, windowBitmap));
                break;
            }
            case 141: {
                int tenthsOfSeconds = data[pos] & 0xFF;
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(9, tenthsOfSeconds));
                break;
            }
            case 142: {
                this.emitCaptionEvent(new CaptionEvent(10, null));
                break;
            }
            case 143: {
                this.emitCaptionEvent(new CaptionEvent(11, null));
                break;
            }
            case 144: {
                int textTag = (data[pos] & 0xF0) >> 4;
                int penSize = data[pos] & 3;
                int penOffset = (data[pos] & 0xC) >> 2;
                boolean italic = (data[pos + 1] & 0x80) != 0;
                boolean underline = (data[pos + 1] & 0x40) != 0;
                int edgeType = (data[pos + 1] & 0x38) >> 3;
                int fontTag = data[pos + 1] & 7;
                pos += 2;
                this.emitCaptionEvent(new CaptionEvent(12, new CaptionPenAttr(penSize, penOffset, textTag, fontTag, edgeType, underline, italic)));
                break;
            }
            case 145: {
                int opacity = (data[pos] & 0xC0) >> 6;
                int red = (data[pos] & 0x30) >> 4;
                int green = (data[pos] & 0xC) >> 2;
                int blue = data[pos] & 3;
                CaptionColor foregroundColor = new CaptionColor(opacity, red, green, blue);
                opacity = (data[++pos] & 0xC0) >> 6;
                red = (data[pos] & 0x30) >> 4;
                green = (data[pos] & 0xC) >> 2;
                blue = data[pos] & 3;
                CaptionColor backgroundColor = new CaptionColor(opacity, red, green, blue);
                red = (data[++pos] & 0x30) >> 4;
                green = (data[pos] & 0xC) >> 2;
                blue = data[pos] & 3;
                CaptionColor edgeColor = new CaptionColor(0, red, green, blue);
                ++pos;
                this.emitCaptionEvent(new CaptionEvent(13, new CaptionPenColor(foregroundColor, backgroundColor, edgeColor)));
                break;
            }
            case 146: {
                int row = data[pos] & 0xF;
                int column = data[pos + 1] & 0x3F;
                pos += 2;
                this.emitCaptionEvent(new CaptionEvent(14, new CaptionPenLocation(row, column)));
                break;
            }
            case 151: {
                int opacity = (data[pos] & 0xC0) >> 6;
                int red = (data[pos] & 0x30) >> 4;
                int green = (data[pos] & 0xC) >> 2;
                int blue = data[pos] & 3;
                CaptionColor fillColor = new CaptionColor(opacity, red, green, blue);
                int borderType = (data[pos + 1] & 0xC0) >> 6 | (data[pos + 2] & 0x80) >> 5;
                red = (data[pos + 1] & 0x30) >> 4;
                green = (data[pos + 1] & 0xC) >> 2;
                blue = data[pos + 1] & 3;
                CaptionColor borderColor = new CaptionColor(0, red, green, blue);
                boolean wordWrap = (data[pos + 2] & 0x40) != 0;
                int printDirection = (data[pos + 2] & 0x30) >> 4;
                int scrollDirection = (data[pos + 2] & 0xC) >> 2;
                int justify = data[pos + 2] & 3;
                int effectSpeed = (data[pos + 3] & 0xF0) >> 4;
                int effectDirection = (data[pos + 3] & 0xC) >> 2;
                int displayEffect = data[pos + 3] & 3;
                pos += 4;
                this.emitCaptionEvent(new CaptionEvent(15, new CaptionWindowAttr(fillColor, borderColor, borderType, wordWrap, printDirection, scrollDirection, justify, effectDirection, effectSpeed, displayEffect)));
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                int windowId = this.mCommand - 152;
                boolean visible = (data[pos] & 0x20) != 0;
                boolean rowLock = (data[pos] & 0x10) != 0;
                boolean columnLock = (data[pos] & 8) != 0;
                int priority = data[pos] & 7;
                boolean relativePositioning = (data[pos + 1] & 0x80) != 0;
                int anchorVertical = data[pos + 1] & 0x7F;
                int anchorHorizontal = data[pos + 2] & 0xFF;
                int anchorId = (data[pos + 3] & 0xF0) >> 4;
                int rowCount = data[pos + 3] & 0xF;
                int columnCount = data[pos + 4] & 0x3F;
                int windowStyle = (data[pos + 5] & 0x38) >> 3;
                int penStyle = data[pos + 5] & 7;
                pos += 6;
                this.emitCaptionEvent(new CaptionEvent(16, new CaptionWindow(windowId, visible, rowLock, columnLock, priority, relativePositioning, anchorVertical, anchorHorizontal, anchorId, rowCount, columnCount, penStyle, windowStyle)));
                break;
            }
        }
        return pos;
    }

    private int parseG0(byte[] data, int pos) {
        if (this.mCommand == 127) {
            this.mBuffer.append(MUSIC_NOTE_CHAR);
        } else {
            this.mBuffer.append((char)this.mCommand);
        }
        return pos;
    }

    private int parseG1(byte[] data, int pos) {
        this.mBuffer.append((char)this.mCommand);
        return pos;
    }

    private int parseExt1(byte[] data, int pos) {
        this.mCommand = data[pos] & 0xFF;
        ++pos;
        if (this.mCommand >= 0 && this.mCommand <= 31) {
            pos = this.parseC2(data, pos);
        } else if (this.mCommand >= 128 && this.mCommand <= 159) {
            pos = this.parseC3(data, pos);
        } else if (this.mCommand >= 32 && this.mCommand <= 127) {
            pos = this.parseG2(data, pos);
        } else if (this.mCommand >= 160 && this.mCommand <= 255) {
            pos = this.parseG3(data, pos);
        }
        return pos;
    }

    private int parseC2(byte[] data, int pos) {
        if (this.mCommand < 0 || this.mCommand > 7) {
            if (this.mCommand >= 8 && this.mCommand <= 15) {
                ++pos;
            } else if (this.mCommand >= 16 && this.mCommand <= 23) {
                pos += 2;
            } else if (this.mCommand >= 24 && this.mCommand <= 31) {
                pos += 3;
            }
        }
        return pos;
    }

    private int parseC3(byte[] data, int pos) {
        if (this.mCommand >= 128 && this.mCommand <= 135) {
            pos += 4;
        } else if (this.mCommand >= 136 && this.mCommand <= 143) {
            pos += 5;
        }
        return pos;
    }

    private int parseG2(byte[] data, int pos) {
        switch (this.mCommand) {
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 48: {
                break;
            }
        }
        return pos;
    }

    private int parseG3(byte[] data, int pos) {
        if (this.mCommand == 160) {
            // empty if block
        }
        return pos;
    }

    static interface DisplayListener {
        public void emitEvent(CaptionEvent var1);
    }

    public static class CaptionEvent {
        public final int type;
        public final Object obj;

        public CaptionEvent(int type, Object obj) {
            this.type = type;
            this.obj = obj;
        }
    }

    private static class Const {
        public static final int CODE_C0_RANGE_START = 0;
        public static final int CODE_C0_RANGE_END = 31;
        public static final int CODE_C1_RANGE_START = 128;
        public static final int CODE_C1_RANGE_END = 159;
        public static final int CODE_G0_RANGE_START = 32;
        public static final int CODE_G0_RANGE_END = 127;
        public static final int CODE_G1_RANGE_START = 160;
        public static final int CODE_G1_RANGE_END = 255;
        public static final int CODE_C2_RANGE_START = 0;
        public static final int CODE_C2_RANGE_END = 31;
        public static final int CODE_C3_RANGE_START = 128;
        public static final int CODE_C3_RANGE_END = 159;
        public static final int CODE_G2_RANGE_START = 32;
        public static final int CODE_G2_RANGE_END = 127;
        public static final int CODE_G3_RANGE_START = 160;
        public static final int CODE_G3_RANGE_END = 255;
        public static final int CODE_C0_SKIP2_RANGE_START = 24;
        public static final int CODE_C0_SKIP2_RANGE_END = 31;
        public static final int CODE_C0_SKIP1_RANGE_START = 16;
        public static final int CODE_C0_SKIP1_RANGE_END = 23;
        public static final int CODE_C2_SKIP0_RANGE_START = 0;
        public static final int CODE_C2_SKIP0_RANGE_END = 7;
        public static final int CODE_C2_SKIP1_RANGE_START = 8;
        public static final int CODE_C2_SKIP1_RANGE_END = 15;
        public static final int CODE_C2_SKIP2_RANGE_START = 16;
        public static final int CODE_C2_SKIP2_RANGE_END = 23;
        public static final int CODE_C2_SKIP3_RANGE_START = 24;
        public static final int CODE_C2_SKIP3_RANGE_END = 31;
        public static final int CODE_C3_SKIP4_RANGE_START = 128;
        public static final int CODE_C3_SKIP4_RANGE_END = 135;
        public static final int CODE_C3_SKIP5_RANGE_START = 136;
        public static final int CODE_C3_SKIP5_RANGE_END = 143;
        public static final int CODE_C0_NUL = 0;
        public static final int CODE_C0_ETX = 3;
        public static final int CODE_C0_BS = 8;
        public static final int CODE_C0_FF = 12;
        public static final int CODE_C0_CR = 13;
        public static final int CODE_C0_HCR = 14;
        public static final int CODE_C0_EXT1 = 16;
        public static final int CODE_C0_P16 = 24;
        public static final int CODE_G0_MUSICNOTE = 127;
        public static final int CODE_G2_TSP = 32;
        public static final int CODE_G2_NBTSP = 33;
        public static final int CODE_G2_BLK = 48;
        public static final int CODE_G3_CC = 160;
        public static final int CODE_C1_CW0 = 128;
        public static final int CODE_C1_CW1 = 129;
        public static final int CODE_C1_CW2 = 130;
        public static final int CODE_C1_CW3 = 131;
        public static final int CODE_C1_CW4 = 132;
        public static final int CODE_C1_CW5 = 133;
        public static final int CODE_C1_CW6 = 134;
        public static final int CODE_C1_CW7 = 135;
        public static final int CODE_C1_CLW = 136;
        public static final int CODE_C1_DSW = 137;
        public static final int CODE_C1_HDW = 138;
        public static final int CODE_C1_TGW = 139;
        public static final int CODE_C1_DLW = 140;
        public static final int CODE_C1_DLY = 141;
        public static final int CODE_C1_DLC = 142;
        public static final int CODE_C1_RST = 143;
        public static final int CODE_C1_SPA = 144;
        public static final int CODE_C1_SPC = 145;
        public static final int CODE_C1_SPL = 146;
        public static final int CODE_C1_SWA = 151;
        public static final int CODE_C1_DF0 = 152;
        public static final int CODE_C1_DF1 = 153;
        public static final int CODE_C1_DF2 = 154;
        public static final int CODE_C1_DF3 = 155;
        public static final int CODE_C1_DF4 = 156;
        public static final int CODE_C1_DF5 = 157;
        public static final int CODE_C1_DF6 = 158;
        public static final int CODE_C1_DF7 = 159;

        private Const() {
        }
    }

    public static class CaptionPenAttr {
        public static final int PEN_SIZE_SMALL = 0;
        public static final int PEN_SIZE_STANDARD = 1;
        public static final int PEN_SIZE_LARGE = 2;
        public static final int OFFSET_SUBSCRIPT = 0;
        public static final int OFFSET_NORMAL = 1;
        public static final int OFFSET_SUPERSCRIPT = 2;
        public final int penSize;
        public final int penOffset;
        public final int textTag;
        public final int fontTag;
        public final int edgeType;
        public final boolean underline;
        public final boolean italic;

        public CaptionPenAttr(int penSize, int penOffset, int textTag, int fontTag, int edgeType, boolean underline, boolean italic) {
            this.penSize = penSize;
            this.penOffset = penOffset;
            this.textTag = textTag;
            this.fontTag = fontTag;
            this.edgeType = edgeType;
            this.underline = underline;
            this.italic = italic;
        }
    }

    public static class CaptionColor {
        public static final int OPACITY_SOLID = 0;
        public static final int OPACITY_FLASH = 1;
        public static final int OPACITY_TRANSLUCENT = 2;
        public static final int OPACITY_TRANSPARENT = 3;
        private static final int[] COLOR_MAP = new int[]{0, 15, 240, 255};
        private static final int[] OPACITY_MAP = new int[]{255, 254, 128, 0};
        public final int opacity;
        public final int red;
        public final int green;
        public final int blue;

        public CaptionColor(int opacity, int red, int green, int blue) {
            this.opacity = opacity;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public int getArgbValue() {
            return Color.argb(OPACITY_MAP[this.opacity], COLOR_MAP[this.red], COLOR_MAP[this.green], COLOR_MAP[this.blue]);
        }
    }

    public static class CaptionPenColor {
        public final CaptionColor foregroundColor;
        public final CaptionColor backgroundColor;
        public final CaptionColor edgeColor;

        public CaptionPenColor(CaptionColor foregroundColor, CaptionColor backgroundColor, CaptionColor edgeColor) {
            this.foregroundColor = foregroundColor;
            this.backgroundColor = backgroundColor;
            this.edgeColor = edgeColor;
        }
    }

    public static class CaptionPenLocation {
        public final int row;
        public final int column;

        public CaptionPenLocation(int row, int column) {
            this.row = row;
            this.column = column;
        }
    }

    public static class CaptionWindowAttr {
        public final CaptionColor fillColor;
        public final CaptionColor borderColor;
        public final int borderType;
        public final boolean wordWrap;
        public final int printDirection;
        public final int scrollDirection;
        public final int justify;
        public final int effectDirection;
        public final int effectSpeed;
        public final int displayEffect;

        public CaptionWindowAttr(CaptionColor fillColor, CaptionColor borderColor, int borderType, boolean wordWrap, int printDirection, int scrollDirection, int justify, int effectDirection, int effectSpeed, int displayEffect) {
            this.fillColor = fillColor;
            this.borderColor = borderColor;
            this.borderType = borderType;
            this.wordWrap = wordWrap;
            this.printDirection = printDirection;
            this.scrollDirection = scrollDirection;
            this.justify = justify;
            this.effectDirection = effectDirection;
            this.effectSpeed = effectSpeed;
            this.displayEffect = displayEffect;
        }
    }

    public static class CaptionWindow {
        public final int id;
        public final boolean visible;
        public final boolean rowLock;
        public final boolean columnLock;
        public final int priority;
        public final boolean relativePositioning;
        public final int anchorVertical;
        public final int anchorHorizontal;
        public final int anchorId;
        public final int rowCount;
        public final int columnCount;
        public final int penStyle;
        public final int windowStyle;

        public CaptionWindow(int id2, boolean visible, boolean rowLock, boolean columnLock, int priority, boolean relativePositioning, int anchorVertical, int anchorHorizontal, int anchorId, int rowCount, int columnCount, int penStyle, int windowStyle) {
            this.id = id2;
            this.visible = visible;
            this.rowLock = rowLock;
            this.columnLock = columnLock;
            this.priority = priority;
            this.relativePositioning = relativePositioning;
            this.anchorVertical = anchorVertical;
            this.anchorHorizontal = anchorHorizontal;
            this.anchorId = anchorId;
            this.rowCount = rowCount;
            this.columnCount = columnCount;
            this.penStyle = penStyle;
            this.windowStyle = windowStyle;
        }
    }
}

