/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.EnforcePermission;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.bluetooth.BluetoothDevice;
import android.compat.annotation.UnsupportedAppUsage;
import android.media.AudioAttributes;
import android.media.AudioDeviceAttributes;
import android.media.AudioFocusInfo;
import android.media.AudioFormat;
import android.media.AudioHalVersionInfo;
import android.media.AudioMixerAttributes;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecordingConfiguration;
import android.media.AudioRoutesInfo;
import android.media.BluetoothProfileConnectionInfo;
import android.media.IAudioDeviceVolumeDispatcher;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioModeDispatcher;
import android.media.IAudioRoutesObserver;
import android.media.IAudioServerStateDispatcher;
import android.media.ICapturePresetDevicesRoleDispatcher;
import android.media.ICommunicationDeviceDispatcher;
import android.media.IDeviceVolumeBehaviorDispatcher;
import android.media.IDevicesForAttributesCallback;
import android.media.IMuteAwaitConnectionCallback;
import android.media.IPlaybackConfigDispatcher;
import android.media.IPreferredMixerAttributesDispatcher;
import android.media.IRecordingConfigDispatcher;
import android.media.IRingtonePlayer;
import android.media.ISpatializerCallback;
import android.media.ISpatializerHeadToSoundStagePoseCallback;
import android.media.ISpatializerHeadTrackerAvailableCallback;
import android.media.ISpatializerHeadTrackingModeCallback;
import android.media.ISpatializerOutputCallback;
import android.media.IStrategyNonDefaultDevicesDispatcher;
import android.media.IStrategyPreferredDevicesDispatcher;
import android.media.IStreamAliasingDispatcher;
import android.media.IVolumeController;
import android.media.PlayerBase;
import android.media.VolumeInfo;
import android.media.VolumePolicy;
import android.media.audiopolicy.AudioPolicyConfig;
import android.media.audiopolicy.AudioProductStrategy;
import android.media.audiopolicy.AudioVolumeGroup;
import android.media.audiopolicy.IAudioPolicyCallback;
import android.media.projection.IMediaProjection;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.view.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IAudioService
extends IInterface {
    public int trackPlayer(PlayerBase.PlayerIdCard var1) throws RemoteException;

    public void playerAttributes(int var1, AudioAttributes var2) throws RemoteException;

    public void playerEvent(int var1, int var2, int var3) throws RemoteException;

    public void releasePlayer(int var1) throws RemoteException;

    public int trackRecorder(IBinder var1) throws RemoteException;

    public void recorderEvent(int var1, int var2) throws RemoteException;

    public void releaseRecorder(int var1) throws RemoteException;

    public void playerSessionId(int var1, int var2) throws RemoteException;

    public void portEvent(int var1, int var2, PersistableBundle var3) throws RemoteException;

    public void adjustStreamVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    public void adjustStreamVolumeWithAttribution(int var1, int var2, int var3, String var4, String var5) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:104:1:104:69")
    public void setStreamVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    public void setStreamVolumeWithAttribution(int var1, int var2, int var3, String var4, String var5) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public void setDeviceVolume(VolumeInfo var1, AudioDeviceAttributes var2, String var3) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public VolumeInfo getDeviceVolume(VolumeInfo var1, AudioDeviceAttributes var2, String var3) throws RemoteException;

    public void handleVolumeKey(KeyEvent var1, boolean var2, String var3, String var4) throws RemoteException;

    public boolean isStreamMute(int var1) throws RemoteException;

    public void forceRemoteSubmixFullVolume(boolean var1, IBinder var2) throws RemoteException;

    public boolean isMasterMute() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setMasterMute(boolean var1, int var2, String var3, int var4, String var5) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:131:1:131:25")
    public int getStreamVolume(int var1) throws RemoteException;

    public int getStreamMinVolume(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:136:1:136:25")
    public int getStreamMaxVolume(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioVolumeGroup> getAudioVolumeGroups() throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"})
    public void setVolumeGroupVolumeIndex(int var1, int var2, int var3, String var4, String var5) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"})
    public int getVolumeGroupVolumeIndex(int var1) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"})
    public int getVolumeGroupMaxVolumeIndex(int var1) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"})
    public int getVolumeGroupMinVolumeIndex(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.QUERY_AUDIO_STATE")
    public int getLastAudibleVolumeForVolumeGroup(int var1) throws RemoteException;

    public boolean isVolumeGroupMuted(int var1) throws RemoteException;

    public void adjustVolumeGroupVolume(int var1, int var2, int var3, String var4) throws RemoteException;

    @EnforcePermission(value="android.permission.QUERY_AUDIO_STATE")
    public int getLastAudibleStreamVolume(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setSupportedSystemUsages(int[] var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int[] getSupportedSystemUsages() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioProductStrategy> getAudioProductStrategies() throws RemoteException;

    public boolean isMicrophoneMuted() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_ULTRASOUND")
    public boolean isUltrasoundSupported() throws RemoteException;

    @EnforcePermission(value="android.permission.CAPTURE_AUDIO_HOTWORD")
    public boolean isHotwordStreamSupported(boolean var1) throws RemoteException;

    public void setMicrophoneMute(boolean var1, String var2, int var3, String var4) throws RemoteException;

    public void setMicrophoneMuteFromSwitch(boolean var1) throws RemoteException;

    public void setRingerModeExternal(int var1, String var2) throws RemoteException;

    public void setRingerModeInternal(int var1, String var2) throws RemoteException;

    public int getRingerModeExternal() throws RemoteException;

    public int getRingerModeInternal() throws RemoteException;

    public boolean isValidRingerMode(int var1) throws RemoteException;

    public void setVibrateSetting(int var1, int var2) throws RemoteException;

    public int getVibrateSetting(int var1) throws RemoteException;

    public boolean shouldVibrate(int var1) throws RemoteException;

    public void setMode(int var1, IBinder var2, String var3) throws RemoteException;

    public int getMode() throws RemoteException;

    public void playSoundEffect(int var1, int var2) throws RemoteException;

    public void playSoundEffectVolume(int var1, float var2) throws RemoteException;

    public boolean loadSoundEffects() throws RemoteException;

    public void unloadSoundEffects() throws RemoteException;

    public void reloadAudioSettings() throws RemoteException;

    public Map getSurroundFormats() throws RemoteException;

    public List getReportedSurroundFormats() throws RemoteException;

    public boolean setSurroundFormatEnabled(int var1, boolean var2) throws RemoteException;

    public boolean isSurroundFormatEnabled(int var1) throws RemoteException;

    public boolean setEncodedSurroundMode(int var1) throws RemoteException;

    public int getEncodedSurroundMode(int var1) throws RemoteException;

    public void setSpeakerphoneOn(IBinder var1, boolean var2) throws RemoteException;

    public boolean isSpeakerphoneOn() throws RemoteException;

    public void setBluetoothScoOn(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.BLUETOOTH_STACK")
    public void setA2dpSuspended(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.BLUETOOTH_STACK")
    public void setLeAudioSuspended(boolean var1) throws RemoteException;

    public boolean isBluetoothScoOn() throws RemoteException;

    public void setBluetoothA2dpOn(boolean var1) throws RemoteException;

    public boolean isBluetoothA2dpOn() throws RemoteException;

    public int requestAudioFocus(AudioAttributes var1, int var2, IBinder var3, IAudioFocusDispatcher var4, String var5, String var6, String var7, int var8, IAudioPolicyCallback var9, int var10) throws RemoteException;

    public int abandonAudioFocus(IAudioFocusDispatcher var1, String var2, AudioAttributes var3, String var4) throws RemoteException;

    public void unregisterAudioFocusClient(String var1) throws RemoteException;

    public int getCurrentAudioFocus() throws RemoteException;

    public void startBluetoothSco(IBinder var1, int var2) throws RemoteException;

    public void startBluetoothScoVirtualCall(IBinder var1) throws RemoteException;

    public void stopBluetoothSco(IBinder var1) throws RemoteException;

    public void forceVolumeControlStream(int var1, IBinder var2) throws RemoteException;

    public void setRingtonePlayer(IRingtonePlayer var1) throws RemoteException;

    public IRingtonePlayer getRingtonePlayer() throws RemoteException;

    public int getUiSoundsStreamType() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public List getIndependentStreamTypes() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int getStreamTypeAlias(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean isVolumeControlUsingVolumeGroups() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void registerStreamAliasingDispatcher(IStreamAliasingDispatcher var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setNotifAliasRingForTest(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setWiredDeviceConnectionState(AudioDeviceAttributes var1, int var2, String var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/IAudioService.aidl:285:1:285:25")
    public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver var1) throws RemoteException;

    public boolean isCameraSoundForced() throws RemoteException;

    public void setVolumeController(IVolumeController var1) throws RemoteException;

    public IVolumeController getVolumeController() throws RemoteException;

    public void notifyVolumeControllerVisible(IVolumeController var1, boolean var2) throws RemoteException;

    public boolean isStreamAffectedByRingerMode(int var1) throws RemoteException;

    public boolean isStreamAffectedByMute(int var1) throws RemoteException;

    public void disableSafeMediaVolume(String var1) throws RemoteException;

    public void lowerVolumeToRs1(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public float getOutputRs2UpperBound() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setOutputRs2UpperBound(float var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public float getCsd() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setCsd(float var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void forceUseFrameworkMel(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void forceComputeCsdOnAllDevices(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean isCsdEnabled() throws RemoteException;

    public int setHdmiSystemAudioSupported(boolean var1) throws RemoteException;

    public boolean isHdmiSystemAudioSupported() throws RemoteException;

    public String registerAudioPolicy(AudioPolicyConfig var1, IAudioPolicyCallback var2, boolean var3, boolean var4, boolean var5, boolean var6, IMediaProjection var7) throws RemoteException;

    public void unregisterAudioPolicyAsync(IAudioPolicyCallback var1) throws RemoteException;

    public void unregisterAudioPolicy(IAudioPolicyCallback var1) throws RemoteException;

    public int addMixForPolicy(AudioPolicyConfig var1, IAudioPolicyCallback var2) throws RemoteException;

    public int removeMixForPolicy(AudioPolicyConfig var1, IAudioPolicyCallback var2) throws RemoteException;

    public int setFocusPropertiesForPolicy(int var1, IAudioPolicyCallback var2) throws RemoteException;

    public void setVolumePolicy(VolumePolicy var1) throws RemoteException;

    public boolean hasRegisteredDynamicPolicy() throws RemoteException;

    public void registerRecordingCallback(IRecordingConfigDispatcher var1) throws RemoteException;

    public void unregisterRecordingCallback(IRecordingConfigDispatcher var1) throws RemoteException;

    public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() throws RemoteException;

    public void registerPlaybackCallback(IPlaybackConfigDispatcher var1) throws RemoteException;

    public void unregisterPlaybackCallback(IPlaybackConfigDispatcher var1) throws RemoteException;

    public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() throws RemoteException;

    public int getFocusRampTimeMs(int var1, AudioAttributes var2) throws RemoteException;

    public int dispatchFocusChange(AudioFocusInfo var1, int var2, IAudioPolicyCallback var3) throws RemoteException;

    public void playerHasOpPlayAudio(int var1, boolean var2) throws RemoteException;

    public void handleBluetoothActiveDeviceChanged(BluetoothDevice var1, BluetoothDevice var2, BluetoothProfileConnectionInfo var3) throws RemoteException;

    public void setFocusRequestResultFromExtPolicy(AudioFocusInfo var1, int var2, IAudioPolicyCallback var3) throws RemoteException;

    public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher var1) throws RemoteException;

    public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher var1) throws RemoteException;

    public boolean isAudioServerRunning() throws RemoteException;

    public int setUidDeviceAffinity(IAudioPolicyCallback var1, int var2, int[] var3, String[] var4) throws RemoteException;

    public int removeUidDeviceAffinity(IAudioPolicyCallback var1, int var2) throws RemoteException;

    public int setUserIdDeviceAffinity(IAudioPolicyCallback var1, int var2, int[] var3, String[] var4) throws RemoteException;

    public int removeUserIdDeviceAffinity(IAudioPolicyCallback var1, int var2) throws RemoteException;

    public boolean hasHapticChannels(Uri var1) throws RemoteException;

    public boolean isCallScreeningModeSupported() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int setPreferredDevicesForStrategy(int var1, List<AudioDeviceAttributes> var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int removePreferredDevicesForStrategy(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioDeviceAttributes> getPreferredDevicesForStrategy(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int setDeviceAsNonDefaultForStrategy(int var1, AudioDeviceAttributes var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int removeDeviceAsNonDefaultForStrategy(int var1, AudioDeviceAttributes var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioDeviceAttributes> getNonDefaultDevicesForStrategy(int var1) throws RemoteException;

    public List<AudioDeviceAttributes> getDevicesForAttributes(AudioAttributes var1) throws RemoteException;

    public List<AudioDeviceAttributes> getDevicesForAttributesUnprotected(AudioAttributes var1) throws RemoteException;

    public void addOnDevicesForAttributesChangedListener(AudioAttributes var1, IDevicesForAttributesCallback var2) throws RemoteException;

    public void removeOnDevicesForAttributesChangedListener(IDevicesForAttributesCallback var1) throws RemoteException;

    public int setAllowedCapturePolicy(int var1) throws RemoteException;

    public int getAllowedCapturePolicy() throws RemoteException;

    public void registerStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher var1) throws RemoteException;

    public void unregisterStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher var1) throws RemoteException;

    public void registerStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher var1) throws RemoteException;

    public void unregisterStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher var1) throws RemoteException;

    public void setRttEnabled(boolean var1) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public void setDeviceVolumeBehavior(AudioDeviceAttributes var1, int var2, String var3) throws RemoteException;

    @EnforcePermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public int getDeviceVolumeBehavior(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setMultiAudioFocusEnabled(boolean var1) throws RemoteException;

    public int setPreferredDevicesForCapturePreset(int var1, List<AudioDeviceAttributes> var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int clearPreferredDevicesForCapturePreset(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioDeviceAttributes> getPreferredDevicesForCapturePreset(int var1) throws RemoteException;

    public void registerCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher var1) throws RemoteException;

    public void unregisterCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher var1) throws RemoteException;

    public void adjustStreamVolumeForUid(int var1, int var2, int var3, String var4, int var5, int var6, UserHandle var7, int var8) throws RemoteException;

    public void adjustSuggestedStreamVolumeForUid(int var1, int var2, int var3, String var4, int var5, int var6, UserHandle var7, int var8) throws RemoteException;

    public void setStreamVolumeForUid(int var1, int var2, int var3, String var4, int var5, int var6, UserHandle var7, int var8) throws RemoteException;

    public boolean isMusicActive(boolean var1) throws RemoteException;

    public int getDeviceMaskForStream(int var1) throws RemoteException;

    public int[] getAvailableCommunicationDeviceIds() throws RemoteException;

    public boolean setCommunicationDevice(IBinder var1, int var2) throws RemoteException;

    public int getCommunicationDevice() throws RemoteException;

    public void registerCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher var1) throws RemoteException;

    public void unregisterCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher var1) throws RemoteException;

    public boolean areNavigationRepeatSoundEffectsEnabled() throws RemoteException;

    public void setNavigationRepeatSoundEffectsEnabled(boolean var1) throws RemoteException;

    public boolean isHomeSoundEffectEnabled() throws RemoteException;

    public void setHomeSoundEffectEnabled(boolean var1) throws RemoteException;

    public boolean setAdditionalOutputDeviceDelay(AudioDeviceAttributes var1, long var2) throws RemoteException;

    public long getAdditionalOutputDeviceDelay(AudioDeviceAttributes var1) throws RemoteException;

    public long getMaxAdditionalOutputDeviceDelay(AudioDeviceAttributes var1) throws RemoteException;

    public int requestAudioFocusForTest(AudioAttributes var1, int var2, IBinder var3, IAudioFocusDispatcher var4, String var5, String var6, int var7, int var8, int var9) throws RemoteException;

    public int abandonAudioFocusForTest(IAudioFocusDispatcher var1, String var2, AudioAttributes var3, String var4) throws RemoteException;

    public long getFadeOutDurationOnFocusLossMillis(AudioAttributes var1) throws RemoteException;

    public void registerModeDispatcher(IAudioModeDispatcher var1) throws RemoteException;

    public void unregisterModeDispatcher(IAudioModeDispatcher var1) throws RemoteException;

    public int getSpatializerImmersiveAudioLevel() throws RemoteException;

    public boolean isSpatializerEnabled() throws RemoteException;

    public boolean isSpatializerAvailable() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public boolean isSpatializerAvailableForDevice(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public boolean hasHeadTracker(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setHeadTrackerEnabled(boolean var1, AudioDeviceAttributes var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public boolean isHeadTrackerEnabled(AudioDeviceAttributes var1) throws RemoteException;

    public boolean isHeadTrackerAvailable() throws RemoteException;

    public void registerSpatializerHeadTrackerAvailableCallback(ISpatializerHeadTrackerAvailableCallback var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setSpatializerEnabled(boolean var1) throws RemoteException;

    public boolean canBeSpatialized(AudioAttributes var1, AudioFormat var2) throws RemoteException;

    public void registerSpatializerCallback(ISpatializerCallback var1) throws RemoteException;

    public void unregisterSpatializerCallback(ISpatializerCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void registerSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void unregisterSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void registerHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void unregisterHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public List<AudioDeviceAttributes> getSpatializerCompatibleAudioDevices() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void addSpatializerCompatibleAudioDevice(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void removeSpatializerCompatibleAudioDevice(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setDesiredHeadTrackingMode(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public int getDesiredHeadTrackingMode() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public int[] getSupportedHeadTrackingModes() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public int getActualHeadTrackingMode() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setSpatializerGlobalTransform(float[] var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void recenterHeadTracker() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void setSpatializerParameter(int var1, byte[] var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void getSpatializerParameter(int var1, byte[] var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public int getSpatializerOutput() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void registerSpatializerOutputCallback(ISpatializerOutputCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS")
    public void unregisterSpatializerOutputCallback(ISpatializerOutputCallback var1) throws RemoteException;

    public boolean isVolumeFixed() throws RemoteException;

    public VolumeInfo getDefaultVolumeInfo() throws RemoteException;

    @EnforcePermission(value="android.permission.CALL_AUDIO_INTERCEPTION")
    public boolean isPstnCallAudioInterceptable() throws RemoteException;

    public void muteAwaitConnection(int[] var1, AudioDeviceAttributes var2, long var3) throws RemoteException;

    public void cancelMuteAwaitConnection(AudioDeviceAttributes var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public AudioDeviceAttributes getMutingExpectedDevice() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void registerMuteAwaitConnectionDispatcher(IMuteAwaitConnectionCallback var1, boolean var2) throws RemoteException;

    public void setTestDeviceConnectionState(AudioDeviceAttributes var1, boolean var2) throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE"})
    public void registerDeviceVolumeBehaviorDispatcher(boolean var1, IDeviceVolumeBehaviorDispatcher var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioFocusInfo> getFocusStack() throws RemoteException;

    public boolean sendFocusLoss(AudioFocusInfo var1, IAudioPolicyCallback var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void addAssistantServicesUids(int[] var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void removeAssistantServicesUids(int[] var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setActiveAssistantServiceUids(int[] var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int[] getAssistantServicesUids() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public int[] getActiveAssistantServiceUids() throws RemoteException;

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerDeviceVolumeDispatcherForAbsoluteVolume(boolean var1, IAudioDeviceVolumeDispatcher var2, String var3, AudioDeviceAttributes var4, List<VolumeInfo> var5, boolean var6, int var7) throws RemoteException;

    public AudioHalVersionInfo getHalVersion() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS")
    public int setPreferredMixerAttributes(AudioAttributes var1, int var2, AudioMixerAttributes var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS")
    public int clearPreferredMixerAttributes(AudioAttributes var1, int var2) throws RemoteException;

    public void registerPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher var1) throws RemoteException;

    public void unregisterPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public boolean supportsBluetoothVariableLatency() throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void setBluetoothVariableLatencyEnabled(boolean var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    @EnforcePermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public boolean isBluetoothVariableLatencyEnabled() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAudioService {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.media.IAudioService";
        static final int TRANSACTION_trackPlayer = 1;
        static final int TRANSACTION_playerAttributes = 2;
        static final int TRANSACTION_playerEvent = 3;
        static final int TRANSACTION_releasePlayer = 4;
        static final int TRANSACTION_trackRecorder = 5;
        static final int TRANSACTION_recorderEvent = 6;
        static final int TRANSACTION_releaseRecorder = 7;
        static final int TRANSACTION_playerSessionId = 8;
        static final int TRANSACTION_portEvent = 9;
        static final int TRANSACTION_adjustStreamVolume = 10;
        static final int TRANSACTION_adjustStreamVolumeWithAttribution = 11;
        static final int TRANSACTION_setStreamVolume = 12;
        static final int TRANSACTION_setStreamVolumeWithAttribution = 13;
        static final int TRANSACTION_setDeviceVolume = 14;
        static final String[] PERMISSIONS_setDeviceVolume = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"};
        static final int TRANSACTION_getDeviceVolume = 15;
        static final String[] PERMISSIONS_getDeviceVolume = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"};
        static final int TRANSACTION_handleVolumeKey = 16;
        static final int TRANSACTION_isStreamMute = 17;
        static final int TRANSACTION_forceRemoteSubmixFullVolume = 18;
        static final int TRANSACTION_isMasterMute = 19;
        static final int TRANSACTION_setMasterMute = 20;
        static final int TRANSACTION_getStreamVolume = 21;
        static final int TRANSACTION_getStreamMinVolume = 22;
        static final int TRANSACTION_getStreamMaxVolume = 23;
        static final int TRANSACTION_getAudioVolumeGroups = 24;
        static final int TRANSACTION_setVolumeGroupVolumeIndex = 25;
        static final String[] PERMISSIONS_setVolumeGroupVolumeIndex = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"};
        static final int TRANSACTION_getVolumeGroupVolumeIndex = 26;
        static final String[] PERMISSIONS_getVolumeGroupVolumeIndex = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"};
        static final int TRANSACTION_getVolumeGroupMaxVolumeIndex = 27;
        static final String[] PERMISSIONS_getVolumeGroupMaxVolumeIndex = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"};
        static final int TRANSACTION_getVolumeGroupMinVolumeIndex = 28;
        static final String[] PERMISSIONS_getVolumeGroupMinVolumeIndex = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.MODIFY_AUDIO_ROUTING"};
        static final int TRANSACTION_getLastAudibleVolumeForVolumeGroup = 29;
        static final int TRANSACTION_isVolumeGroupMuted = 30;
        static final int TRANSACTION_adjustVolumeGroupVolume = 31;
        static final int TRANSACTION_getLastAudibleStreamVolume = 32;
        static final int TRANSACTION_setSupportedSystemUsages = 33;
        static final int TRANSACTION_getSupportedSystemUsages = 34;
        static final int TRANSACTION_getAudioProductStrategies = 35;
        static final int TRANSACTION_isMicrophoneMuted = 36;
        static final int TRANSACTION_isUltrasoundSupported = 37;
        static final int TRANSACTION_isHotwordStreamSupported = 38;
        static final int TRANSACTION_setMicrophoneMute = 39;
        static final int TRANSACTION_setMicrophoneMuteFromSwitch = 40;
        static final int TRANSACTION_setRingerModeExternal = 41;
        static final int TRANSACTION_setRingerModeInternal = 42;
        static final int TRANSACTION_getRingerModeExternal = 43;
        static final int TRANSACTION_getRingerModeInternal = 44;
        static final int TRANSACTION_isValidRingerMode = 45;
        static final int TRANSACTION_setVibrateSetting = 46;
        static final int TRANSACTION_getVibrateSetting = 47;
        static final int TRANSACTION_shouldVibrate = 48;
        static final int TRANSACTION_setMode = 49;
        static final int TRANSACTION_getMode = 50;
        static final int TRANSACTION_playSoundEffect = 51;
        static final int TRANSACTION_playSoundEffectVolume = 52;
        static final int TRANSACTION_loadSoundEffects = 53;
        static final int TRANSACTION_unloadSoundEffects = 54;
        static final int TRANSACTION_reloadAudioSettings = 55;
        static final int TRANSACTION_getSurroundFormats = 56;
        static final int TRANSACTION_getReportedSurroundFormats = 57;
        static final int TRANSACTION_setSurroundFormatEnabled = 58;
        static final int TRANSACTION_isSurroundFormatEnabled = 59;
        static final int TRANSACTION_setEncodedSurroundMode = 60;
        static final int TRANSACTION_getEncodedSurroundMode = 61;
        static final int TRANSACTION_setSpeakerphoneOn = 62;
        static final int TRANSACTION_isSpeakerphoneOn = 63;
        static final int TRANSACTION_setBluetoothScoOn = 64;
        static final int TRANSACTION_setA2dpSuspended = 65;
        static final int TRANSACTION_setLeAudioSuspended = 66;
        static final int TRANSACTION_isBluetoothScoOn = 67;
        static final int TRANSACTION_setBluetoothA2dpOn = 68;
        static final int TRANSACTION_isBluetoothA2dpOn = 69;
        static final int TRANSACTION_requestAudioFocus = 70;
        static final int TRANSACTION_abandonAudioFocus = 71;
        static final int TRANSACTION_unregisterAudioFocusClient = 72;
        static final int TRANSACTION_getCurrentAudioFocus = 73;
        static final int TRANSACTION_startBluetoothSco = 74;
        static final int TRANSACTION_startBluetoothScoVirtualCall = 75;
        static final int TRANSACTION_stopBluetoothSco = 76;
        static final int TRANSACTION_forceVolumeControlStream = 77;
        static final int TRANSACTION_setRingtonePlayer = 78;
        static final int TRANSACTION_getRingtonePlayer = 79;
        static final int TRANSACTION_getUiSoundsStreamType = 80;
        static final int TRANSACTION_getIndependentStreamTypes = 81;
        static final int TRANSACTION_getStreamTypeAlias = 82;
        static final int TRANSACTION_isVolumeControlUsingVolumeGroups = 83;
        static final int TRANSACTION_registerStreamAliasingDispatcher = 84;
        static final int TRANSACTION_setNotifAliasRingForTest = 85;
        static final int TRANSACTION_setWiredDeviceConnectionState = 86;
        static final int TRANSACTION_startWatchingRoutes = 87;
        static final int TRANSACTION_isCameraSoundForced = 88;
        static final int TRANSACTION_setVolumeController = 89;
        static final int TRANSACTION_getVolumeController = 90;
        static final int TRANSACTION_notifyVolumeControllerVisible = 91;
        static final int TRANSACTION_isStreamAffectedByRingerMode = 92;
        static final int TRANSACTION_isStreamAffectedByMute = 93;
        static final int TRANSACTION_disableSafeMediaVolume = 94;
        static final int TRANSACTION_lowerVolumeToRs1 = 95;
        static final int TRANSACTION_getOutputRs2UpperBound = 96;
        static final int TRANSACTION_setOutputRs2UpperBound = 97;
        static final int TRANSACTION_getCsd = 98;
        static final int TRANSACTION_setCsd = 99;
        static final int TRANSACTION_forceUseFrameworkMel = 100;
        static final int TRANSACTION_forceComputeCsdOnAllDevices = 101;
        static final int TRANSACTION_isCsdEnabled = 102;
        static final int TRANSACTION_setHdmiSystemAudioSupported = 103;
        static final int TRANSACTION_isHdmiSystemAudioSupported = 104;
        static final int TRANSACTION_registerAudioPolicy = 105;
        static final int TRANSACTION_unregisterAudioPolicyAsync = 106;
        static final int TRANSACTION_unregisterAudioPolicy = 107;
        static final int TRANSACTION_addMixForPolicy = 108;
        static final int TRANSACTION_removeMixForPolicy = 109;
        static final int TRANSACTION_setFocusPropertiesForPolicy = 110;
        static final int TRANSACTION_setVolumePolicy = 111;
        static final int TRANSACTION_hasRegisteredDynamicPolicy = 112;
        static final int TRANSACTION_registerRecordingCallback = 113;
        static final int TRANSACTION_unregisterRecordingCallback = 114;
        static final int TRANSACTION_getActiveRecordingConfigurations = 115;
        static final int TRANSACTION_registerPlaybackCallback = 116;
        static final int TRANSACTION_unregisterPlaybackCallback = 117;
        static final int TRANSACTION_getActivePlaybackConfigurations = 118;
        static final int TRANSACTION_getFocusRampTimeMs = 119;
        static final int TRANSACTION_dispatchFocusChange = 120;
        static final int TRANSACTION_playerHasOpPlayAudio = 121;
        static final int TRANSACTION_handleBluetoothActiveDeviceChanged = 122;
        static final int TRANSACTION_setFocusRequestResultFromExtPolicy = 123;
        static final int TRANSACTION_registerAudioServerStateDispatcher = 124;
        static final int TRANSACTION_unregisterAudioServerStateDispatcher = 125;
        static final int TRANSACTION_isAudioServerRunning = 126;
        static final int TRANSACTION_setUidDeviceAffinity = 127;
        static final int TRANSACTION_removeUidDeviceAffinity = 128;
        static final int TRANSACTION_setUserIdDeviceAffinity = 129;
        static final int TRANSACTION_removeUserIdDeviceAffinity = 130;
        static final int TRANSACTION_hasHapticChannels = 131;
        static final int TRANSACTION_isCallScreeningModeSupported = 132;
        static final int TRANSACTION_setPreferredDevicesForStrategy = 133;
        static final int TRANSACTION_removePreferredDevicesForStrategy = 134;
        static final int TRANSACTION_getPreferredDevicesForStrategy = 135;
        static final int TRANSACTION_setDeviceAsNonDefaultForStrategy = 136;
        static final int TRANSACTION_removeDeviceAsNonDefaultForStrategy = 137;
        static final int TRANSACTION_getNonDefaultDevicesForStrategy = 138;
        static final int TRANSACTION_getDevicesForAttributes = 139;
        static final int TRANSACTION_getDevicesForAttributesUnprotected = 140;
        static final int TRANSACTION_addOnDevicesForAttributesChangedListener = 141;
        static final int TRANSACTION_removeOnDevicesForAttributesChangedListener = 142;
        static final int TRANSACTION_setAllowedCapturePolicy = 143;
        static final int TRANSACTION_getAllowedCapturePolicy = 144;
        static final int TRANSACTION_registerStrategyPreferredDevicesDispatcher = 145;
        static final int TRANSACTION_unregisterStrategyPreferredDevicesDispatcher = 146;
        static final int TRANSACTION_registerStrategyNonDefaultDevicesDispatcher = 147;
        static final int TRANSACTION_unregisterStrategyNonDefaultDevicesDispatcher = 148;
        static final int TRANSACTION_setRttEnabled = 149;
        static final int TRANSACTION_setDeviceVolumeBehavior = 150;
        static final String[] PERMISSIONS_setDeviceVolumeBehavior = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"};
        static final int TRANSACTION_getDeviceVolumeBehavior = 151;
        static final String[] PERMISSIONS_getDeviceVolumeBehavior = new String[]{"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"};
        static final int TRANSACTION_setMultiAudioFocusEnabled = 152;
        static final int TRANSACTION_setPreferredDevicesForCapturePreset = 153;
        static final int TRANSACTION_clearPreferredDevicesForCapturePreset = 154;
        static final int TRANSACTION_getPreferredDevicesForCapturePreset = 155;
        static final int TRANSACTION_registerCapturePresetDevicesRoleDispatcher = 156;
        static final int TRANSACTION_unregisterCapturePresetDevicesRoleDispatcher = 157;
        static final int TRANSACTION_adjustStreamVolumeForUid = 158;
        static final int TRANSACTION_adjustSuggestedStreamVolumeForUid = 159;
        static final int TRANSACTION_setStreamVolumeForUid = 160;
        static final int TRANSACTION_isMusicActive = 161;
        static final int TRANSACTION_getDeviceMaskForStream = 162;
        static final int TRANSACTION_getAvailableCommunicationDeviceIds = 163;
        static final int TRANSACTION_setCommunicationDevice = 164;
        static final int TRANSACTION_getCommunicationDevice = 165;
        static final int TRANSACTION_registerCommunicationDeviceDispatcher = 166;
        static final int TRANSACTION_unregisterCommunicationDeviceDispatcher = 167;
        static final int TRANSACTION_areNavigationRepeatSoundEffectsEnabled = 168;
        static final int TRANSACTION_setNavigationRepeatSoundEffectsEnabled = 169;
        static final int TRANSACTION_isHomeSoundEffectEnabled = 170;
        static final int TRANSACTION_setHomeSoundEffectEnabled = 171;
        static final int TRANSACTION_setAdditionalOutputDeviceDelay = 172;
        static final int TRANSACTION_getAdditionalOutputDeviceDelay = 173;
        static final int TRANSACTION_getMaxAdditionalOutputDeviceDelay = 174;
        static final int TRANSACTION_requestAudioFocusForTest = 175;
        static final int TRANSACTION_abandonAudioFocusForTest = 176;
        static final int TRANSACTION_getFadeOutDurationOnFocusLossMillis = 177;
        static final int TRANSACTION_registerModeDispatcher = 178;
        static final int TRANSACTION_unregisterModeDispatcher = 179;
        static final int TRANSACTION_getSpatializerImmersiveAudioLevel = 180;
        static final int TRANSACTION_isSpatializerEnabled = 181;
        static final int TRANSACTION_isSpatializerAvailable = 182;
        static final int TRANSACTION_isSpatializerAvailableForDevice = 183;
        static final int TRANSACTION_hasHeadTracker = 184;
        static final int TRANSACTION_setHeadTrackerEnabled = 185;
        static final int TRANSACTION_isHeadTrackerEnabled = 186;
        static final int TRANSACTION_isHeadTrackerAvailable = 187;
        static final int TRANSACTION_registerSpatializerHeadTrackerAvailableCallback = 188;
        static final int TRANSACTION_setSpatializerEnabled = 189;
        static final int TRANSACTION_canBeSpatialized = 190;
        static final int TRANSACTION_registerSpatializerCallback = 191;
        static final int TRANSACTION_unregisterSpatializerCallback = 192;
        static final int TRANSACTION_registerSpatializerHeadTrackingCallback = 193;
        static final int TRANSACTION_unregisterSpatializerHeadTrackingCallback = 194;
        static final int TRANSACTION_registerHeadToSoundstagePoseCallback = 195;
        static final int TRANSACTION_unregisterHeadToSoundstagePoseCallback = 196;
        static final int TRANSACTION_getSpatializerCompatibleAudioDevices = 197;
        static final int TRANSACTION_addSpatializerCompatibleAudioDevice = 198;
        static final int TRANSACTION_removeSpatializerCompatibleAudioDevice = 199;
        static final int TRANSACTION_setDesiredHeadTrackingMode = 200;
        static final int TRANSACTION_getDesiredHeadTrackingMode = 201;
        static final int TRANSACTION_getSupportedHeadTrackingModes = 202;
        static final int TRANSACTION_getActualHeadTrackingMode = 203;
        static final int TRANSACTION_setSpatializerGlobalTransform = 204;
        static final int TRANSACTION_recenterHeadTracker = 205;
        static final int TRANSACTION_setSpatializerParameter = 206;
        static final int TRANSACTION_getSpatializerParameter = 207;
        static final int TRANSACTION_getSpatializerOutput = 208;
        static final int TRANSACTION_registerSpatializerOutputCallback = 209;
        static final int TRANSACTION_unregisterSpatializerOutputCallback = 210;
        static final int TRANSACTION_isVolumeFixed = 211;
        static final int TRANSACTION_getDefaultVolumeInfo = 212;
        static final int TRANSACTION_isPstnCallAudioInterceptable = 213;
        static final int TRANSACTION_muteAwaitConnection = 214;
        static final int TRANSACTION_cancelMuteAwaitConnection = 215;
        static final int TRANSACTION_getMutingExpectedDevice = 216;
        static final int TRANSACTION_registerMuteAwaitConnectionDispatcher = 217;
        static final int TRANSACTION_setTestDeviceConnectionState = 218;
        static final int TRANSACTION_registerDeviceVolumeBehaviorDispatcher = 219;
        static final int TRANSACTION_getFocusStack = 220;
        static final int TRANSACTION_sendFocusLoss = 221;
        static final int TRANSACTION_addAssistantServicesUids = 222;
        static final int TRANSACTION_removeAssistantServicesUids = 223;
        static final int TRANSACTION_setActiveAssistantServiceUids = 224;
        static final int TRANSACTION_getAssistantServicesUids = 225;
        static final int TRANSACTION_getActiveAssistantServiceUids = 226;
        static final int TRANSACTION_registerDeviceVolumeDispatcherForAbsoluteVolume = 227;
        static final int TRANSACTION_getHalVersion = 228;
        static final int TRANSACTION_setPreferredMixerAttributes = 229;
        static final int TRANSACTION_clearPreferredMixerAttributes = 230;
        static final int TRANSACTION_registerPreferredMixerAttributesDispatcher = 231;
        static final int TRANSACTION_unregisterPreferredMixerAttributesDispatcher = 232;
        static final int TRANSACTION_supportsBluetoothVariableLatency = 233;
        static final int TRANSACTION_setBluetoothVariableLatencyEnabled = 234;
        static final int TRANSACTION_isBluetoothVariableLatencyEnabled = 235;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IAudioService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAudioService) {
                return (IAudioService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "trackPlayer";
                }
                case 2: {
                    return "playerAttributes";
                }
                case 3: {
                    return "playerEvent";
                }
                case 4: {
                    return "releasePlayer";
                }
                case 5: {
                    return "trackRecorder";
                }
                case 6: {
                    return "recorderEvent";
                }
                case 7: {
                    return "releaseRecorder";
                }
                case 8: {
                    return "playerSessionId";
                }
                case 9: {
                    return "portEvent";
                }
                case 10: {
                    return "adjustStreamVolume";
                }
                case 11: {
                    return "adjustStreamVolumeWithAttribution";
                }
                case 12: {
                    return "setStreamVolume";
                }
                case 13: {
                    return "setStreamVolumeWithAttribution";
                }
                case 14: {
                    return "setDeviceVolume";
                }
                case 15: {
                    return "getDeviceVolume";
                }
                case 16: {
                    return "handleVolumeKey";
                }
                case 17: {
                    return "isStreamMute";
                }
                case 18: {
                    return "forceRemoteSubmixFullVolume";
                }
                case 19: {
                    return "isMasterMute";
                }
                case 20: {
                    return "setMasterMute";
                }
                case 21: {
                    return "getStreamVolume";
                }
                case 22: {
                    return "getStreamMinVolume";
                }
                case 23: {
                    return "getStreamMaxVolume";
                }
                case 24: {
                    return "getAudioVolumeGroups";
                }
                case 25: {
                    return "setVolumeGroupVolumeIndex";
                }
                case 26: {
                    return "getVolumeGroupVolumeIndex";
                }
                case 27: {
                    return "getVolumeGroupMaxVolumeIndex";
                }
                case 28: {
                    return "getVolumeGroupMinVolumeIndex";
                }
                case 29: {
                    return "getLastAudibleVolumeForVolumeGroup";
                }
                case 30: {
                    return "isVolumeGroupMuted";
                }
                case 31: {
                    return "adjustVolumeGroupVolume";
                }
                case 32: {
                    return "getLastAudibleStreamVolume";
                }
                case 33: {
                    return "setSupportedSystemUsages";
                }
                case 34: {
                    return "getSupportedSystemUsages";
                }
                case 35: {
                    return "getAudioProductStrategies";
                }
                case 36: {
                    return "isMicrophoneMuted";
                }
                case 37: {
                    return "isUltrasoundSupported";
                }
                case 38: {
                    return "isHotwordStreamSupported";
                }
                case 39: {
                    return "setMicrophoneMute";
                }
                case 40: {
                    return "setMicrophoneMuteFromSwitch";
                }
                case 41: {
                    return "setRingerModeExternal";
                }
                case 42: {
                    return "setRingerModeInternal";
                }
                case 43: {
                    return "getRingerModeExternal";
                }
                case 44: {
                    return "getRingerModeInternal";
                }
                case 45: {
                    return "isValidRingerMode";
                }
                case 46: {
                    return "setVibrateSetting";
                }
                case 47: {
                    return "getVibrateSetting";
                }
                case 48: {
                    return "shouldVibrate";
                }
                case 49: {
                    return "setMode";
                }
                case 50: {
                    return "getMode";
                }
                case 51: {
                    return "playSoundEffect";
                }
                case 52: {
                    return "playSoundEffectVolume";
                }
                case 53: {
                    return "loadSoundEffects";
                }
                case 54: {
                    return "unloadSoundEffects";
                }
                case 55: {
                    return "reloadAudioSettings";
                }
                case 56: {
                    return "getSurroundFormats";
                }
                case 57: {
                    return "getReportedSurroundFormats";
                }
                case 58: {
                    return "setSurroundFormatEnabled";
                }
                case 59: {
                    return "isSurroundFormatEnabled";
                }
                case 60: {
                    return "setEncodedSurroundMode";
                }
                case 61: {
                    return "getEncodedSurroundMode";
                }
                case 62: {
                    return "setSpeakerphoneOn";
                }
                case 63: {
                    return "isSpeakerphoneOn";
                }
                case 64: {
                    return "setBluetoothScoOn";
                }
                case 65: {
                    return "setA2dpSuspended";
                }
                case 66: {
                    return "setLeAudioSuspended";
                }
                case 67: {
                    return "isBluetoothScoOn";
                }
                case 68: {
                    return "setBluetoothA2dpOn";
                }
                case 69: {
                    return "isBluetoothA2dpOn";
                }
                case 70: {
                    return "requestAudioFocus";
                }
                case 71: {
                    return "abandonAudioFocus";
                }
                case 72: {
                    return "unregisterAudioFocusClient";
                }
                case 73: {
                    return "getCurrentAudioFocus";
                }
                case 74: {
                    return "startBluetoothSco";
                }
                case 75: {
                    return "startBluetoothScoVirtualCall";
                }
                case 76: {
                    return "stopBluetoothSco";
                }
                case 77: {
                    return "forceVolumeControlStream";
                }
                case 78: {
                    return "setRingtonePlayer";
                }
                case 79: {
                    return "getRingtonePlayer";
                }
                case 80: {
                    return "getUiSoundsStreamType";
                }
                case 81: {
                    return "getIndependentStreamTypes";
                }
                case 82: {
                    return "getStreamTypeAlias";
                }
                case 83: {
                    return "isVolumeControlUsingVolumeGroups";
                }
                case 84: {
                    return "registerStreamAliasingDispatcher";
                }
                case 85: {
                    return "setNotifAliasRingForTest";
                }
                case 86: {
                    return "setWiredDeviceConnectionState";
                }
                case 87: {
                    return "startWatchingRoutes";
                }
                case 88: {
                    return "isCameraSoundForced";
                }
                case 89: {
                    return "setVolumeController";
                }
                case 90: {
                    return "getVolumeController";
                }
                case 91: {
                    return "notifyVolumeControllerVisible";
                }
                case 92: {
                    return "isStreamAffectedByRingerMode";
                }
                case 93: {
                    return "isStreamAffectedByMute";
                }
                case 94: {
                    return "disableSafeMediaVolume";
                }
                case 95: {
                    return "lowerVolumeToRs1";
                }
                case 96: {
                    return "getOutputRs2UpperBound";
                }
                case 97: {
                    return "setOutputRs2UpperBound";
                }
                case 98: {
                    return "getCsd";
                }
                case 99: {
                    return "setCsd";
                }
                case 100: {
                    return "forceUseFrameworkMel";
                }
                case 101: {
                    return "forceComputeCsdOnAllDevices";
                }
                case 102: {
                    return "isCsdEnabled";
                }
                case 103: {
                    return "setHdmiSystemAudioSupported";
                }
                case 104: {
                    return "isHdmiSystemAudioSupported";
                }
                case 105: {
                    return "registerAudioPolicy";
                }
                case 106: {
                    return "unregisterAudioPolicyAsync";
                }
                case 107: {
                    return "unregisterAudioPolicy";
                }
                case 108: {
                    return "addMixForPolicy";
                }
                case 109: {
                    return "removeMixForPolicy";
                }
                case 110: {
                    return "setFocusPropertiesForPolicy";
                }
                case 111: {
                    return "setVolumePolicy";
                }
                case 112: {
                    return "hasRegisteredDynamicPolicy";
                }
                case 113: {
                    return "registerRecordingCallback";
                }
                case 114: {
                    return "unregisterRecordingCallback";
                }
                case 115: {
                    return "getActiveRecordingConfigurations";
                }
                case 116: {
                    return "registerPlaybackCallback";
                }
                case 117: {
                    return "unregisterPlaybackCallback";
                }
                case 118: {
                    return "getActivePlaybackConfigurations";
                }
                case 119: {
                    return "getFocusRampTimeMs";
                }
                case 120: {
                    return "dispatchFocusChange";
                }
                case 121: {
                    return "playerHasOpPlayAudio";
                }
                case 122: {
                    return "handleBluetoothActiveDeviceChanged";
                }
                case 123: {
                    return "setFocusRequestResultFromExtPolicy";
                }
                case 124: {
                    return "registerAudioServerStateDispatcher";
                }
                case 125: {
                    return "unregisterAudioServerStateDispatcher";
                }
                case 126: {
                    return "isAudioServerRunning";
                }
                case 127: {
                    return "setUidDeviceAffinity";
                }
                case 128: {
                    return "removeUidDeviceAffinity";
                }
                case 129: {
                    return "setUserIdDeviceAffinity";
                }
                case 130: {
                    return "removeUserIdDeviceAffinity";
                }
                case 131: {
                    return "hasHapticChannels";
                }
                case 132: {
                    return "isCallScreeningModeSupported";
                }
                case 133: {
                    return "setPreferredDevicesForStrategy";
                }
                case 134: {
                    return "removePreferredDevicesForStrategy";
                }
                case 135: {
                    return "getPreferredDevicesForStrategy";
                }
                case 136: {
                    return "setDeviceAsNonDefaultForStrategy";
                }
                case 137: {
                    return "removeDeviceAsNonDefaultForStrategy";
                }
                case 138: {
                    return "getNonDefaultDevicesForStrategy";
                }
                case 139: {
                    return "getDevicesForAttributes";
                }
                case 140: {
                    return "getDevicesForAttributesUnprotected";
                }
                case 141: {
                    return "addOnDevicesForAttributesChangedListener";
                }
                case 142: {
                    return "removeOnDevicesForAttributesChangedListener";
                }
                case 143: {
                    return "setAllowedCapturePolicy";
                }
                case 144: {
                    return "getAllowedCapturePolicy";
                }
                case 145: {
                    return "registerStrategyPreferredDevicesDispatcher";
                }
                case 146: {
                    return "unregisterStrategyPreferredDevicesDispatcher";
                }
                case 147: {
                    return "registerStrategyNonDefaultDevicesDispatcher";
                }
                case 148: {
                    return "unregisterStrategyNonDefaultDevicesDispatcher";
                }
                case 149: {
                    return "setRttEnabled";
                }
                case 150: {
                    return "setDeviceVolumeBehavior";
                }
                case 151: {
                    return "getDeviceVolumeBehavior";
                }
                case 152: {
                    return "setMultiAudioFocusEnabled";
                }
                case 153: {
                    return "setPreferredDevicesForCapturePreset";
                }
                case 154: {
                    return "clearPreferredDevicesForCapturePreset";
                }
                case 155: {
                    return "getPreferredDevicesForCapturePreset";
                }
                case 156: {
                    return "registerCapturePresetDevicesRoleDispatcher";
                }
                case 157: {
                    return "unregisterCapturePresetDevicesRoleDispatcher";
                }
                case 158: {
                    return "adjustStreamVolumeForUid";
                }
                case 159: {
                    return "adjustSuggestedStreamVolumeForUid";
                }
                case 160: {
                    return "setStreamVolumeForUid";
                }
                case 161: {
                    return "isMusicActive";
                }
                case 162: {
                    return "getDeviceMaskForStream";
                }
                case 163: {
                    return "getAvailableCommunicationDeviceIds";
                }
                case 164: {
                    return "setCommunicationDevice";
                }
                case 165: {
                    return "getCommunicationDevice";
                }
                case 166: {
                    return "registerCommunicationDeviceDispatcher";
                }
                case 167: {
                    return "unregisterCommunicationDeviceDispatcher";
                }
                case 168: {
                    return "areNavigationRepeatSoundEffectsEnabled";
                }
                case 169: {
                    return "setNavigationRepeatSoundEffectsEnabled";
                }
                case 170: {
                    return "isHomeSoundEffectEnabled";
                }
                case 171: {
                    return "setHomeSoundEffectEnabled";
                }
                case 172: {
                    return "setAdditionalOutputDeviceDelay";
                }
                case 173: {
                    return "getAdditionalOutputDeviceDelay";
                }
                case 174: {
                    return "getMaxAdditionalOutputDeviceDelay";
                }
                case 175: {
                    return "requestAudioFocusForTest";
                }
                case 176: {
                    return "abandonAudioFocusForTest";
                }
                case 177: {
                    return "getFadeOutDurationOnFocusLossMillis";
                }
                case 178: {
                    return "registerModeDispatcher";
                }
                case 179: {
                    return "unregisterModeDispatcher";
                }
                case 180: {
                    return "getSpatializerImmersiveAudioLevel";
                }
                case 181: {
                    return "isSpatializerEnabled";
                }
                case 182: {
                    return "isSpatializerAvailable";
                }
                case 183: {
                    return "isSpatializerAvailableForDevice";
                }
                case 184: {
                    return "hasHeadTracker";
                }
                case 185: {
                    return "setHeadTrackerEnabled";
                }
                case 186: {
                    return "isHeadTrackerEnabled";
                }
                case 187: {
                    return "isHeadTrackerAvailable";
                }
                case 188: {
                    return "registerSpatializerHeadTrackerAvailableCallback";
                }
                case 189: {
                    return "setSpatializerEnabled";
                }
                case 190: {
                    return "canBeSpatialized";
                }
                case 191: {
                    return "registerSpatializerCallback";
                }
                case 192: {
                    return "unregisterSpatializerCallback";
                }
                case 193: {
                    return "registerSpatializerHeadTrackingCallback";
                }
                case 194: {
                    return "unregisterSpatializerHeadTrackingCallback";
                }
                case 195: {
                    return "registerHeadToSoundstagePoseCallback";
                }
                case 196: {
                    return "unregisterHeadToSoundstagePoseCallback";
                }
                case 197: {
                    return "getSpatializerCompatibleAudioDevices";
                }
                case 198: {
                    return "addSpatializerCompatibleAudioDevice";
                }
                case 199: {
                    return "removeSpatializerCompatibleAudioDevice";
                }
                case 200: {
                    return "setDesiredHeadTrackingMode";
                }
                case 201: {
                    return "getDesiredHeadTrackingMode";
                }
                case 202: {
                    return "getSupportedHeadTrackingModes";
                }
                case 203: {
                    return "getActualHeadTrackingMode";
                }
                case 204: {
                    return "setSpatializerGlobalTransform";
                }
                case 205: {
                    return "recenterHeadTracker";
                }
                case 206: {
                    return "setSpatializerParameter";
                }
                case 207: {
                    return "getSpatializerParameter";
                }
                case 208: {
                    return "getSpatializerOutput";
                }
                case 209: {
                    return "registerSpatializerOutputCallback";
                }
                case 210: {
                    return "unregisterSpatializerOutputCallback";
                }
                case 211: {
                    return "isVolumeFixed";
                }
                case 212: {
                    return "getDefaultVolumeInfo";
                }
                case 213: {
                    return "isPstnCallAudioInterceptable";
                }
                case 214: {
                    return "muteAwaitConnection";
                }
                case 215: {
                    return "cancelMuteAwaitConnection";
                }
                case 216: {
                    return "getMutingExpectedDevice";
                }
                case 217: {
                    return "registerMuteAwaitConnectionDispatcher";
                }
                case 218: {
                    return "setTestDeviceConnectionState";
                }
                case 219: {
                    return "registerDeviceVolumeBehaviorDispatcher";
                }
                case 220: {
                    return "getFocusStack";
                }
                case 221: {
                    return "sendFocusLoss";
                }
                case 222: {
                    return "addAssistantServicesUids";
                }
                case 223: {
                    return "removeAssistantServicesUids";
                }
                case 224: {
                    return "setActiveAssistantServiceUids";
                }
                case 225: {
                    return "getAssistantServicesUids";
                }
                case 226: {
                    return "getActiveAssistantServiceUids";
                }
                case 227: {
                    return "registerDeviceVolumeDispatcherForAbsoluteVolume";
                }
                case 228: {
                    return "getHalVersion";
                }
                case 229: {
                    return "setPreferredMixerAttributes";
                }
                case 230: {
                    return "clearPreferredMixerAttributes";
                }
                case 231: {
                    return "registerPreferredMixerAttributesDispatcher";
                }
                case 232: {
                    return "unregisterPreferredMixerAttributesDispatcher";
                }
                case 233: {
                    return "supportsBluetoothVariableLatency";
                }
                case 234: {
                    return "setBluetoothVariableLatencyEnabled";
                }
                case 235: {
                    return "isBluetoothVariableLatencyEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    PlayerBase.PlayerIdCard _arg0 = data.readTypedObject(PlayerBase.PlayerIdCard.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.trackPlayer(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    AudioAttributes _arg1 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.playerAttributes(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.playerEvent(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releasePlayer(_arg0);
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.trackRecorder(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.recorderEvent(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseRecorder(_arg0);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.playerSessionId(_arg0, _arg1);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.portEvent(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.adjustStreamVolume(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.adjustStreamVolumeWithAttribution(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setStreamVolume(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setStreamVolumeWithAttribution(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    VolumeInfo _arg0 = data.readTypedObject(VolumeInfo.CREATOR);
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setDeviceVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    VolumeInfo _arg0 = data.readTypedObject(VolumeInfo.CREATOR);
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    VolumeInfo _result = this.getDeviceVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 16: {
                    KeyEvent _arg0 = data.readTypedObject(KeyEvent.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.handleVolumeKey(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStreamMute(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    boolean _arg0 = data.readBoolean();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.forceRemoteSubmixFullVolume(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    boolean _result = this.isMasterMute();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setMasterMute(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamMinVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamMaxVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 24: {
                    List<AudioVolumeGroup> _result = this.getAudioVolumeGroups();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setVolumeGroupVolumeIndex(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getVolumeGroupVolumeIndex(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getVolumeGroupMaxVolumeIndex(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getVolumeGroupMinVolumeIndex(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getLastAudibleVolumeForVolumeGroup(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isVolumeGroupMuted(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.adjustVolumeGroupVolume(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getLastAudibleStreamVolume(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 33: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setSupportedSystemUsages(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    int[] _result = this.getSupportedSystemUsages();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 35: {
                    List<AudioProductStrategy> _result = this.getAudioProductStrategies();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 36: {
                    boolean _result = this.isMicrophoneMuted();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 37: {
                    boolean _result = this.isUltrasoundSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 38: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.isHotwordStreamSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setMicrophoneMute(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setMicrophoneMuteFromSwitch(_arg0);
                    break;
                }
                case 41: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setRingerModeExternal(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setRingerModeInternal(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    int _result = this.getRingerModeExternal();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 44: {
                    int _result = this.getRingerModeInternal();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 45: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isValidRingerMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setVibrateSetting(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getVibrateSetting(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldVibrate(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    int _result = this.getMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.playSoundEffect(_arg0, _arg1);
                    break;
                }
                case 52: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.playSoundEffectVolume(_arg0, _arg1);
                    break;
                }
                case 53: {
                    boolean _result = this.loadSoundEffects();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 54: {
                    this.unloadSoundEffects();
                    break;
                }
                case 55: {
                    this.reloadAudioSettings();
                    break;
                }
                case 56: {
                    Map _result = this.getSurroundFormats();
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 57: {
                    List _result = this.getReportedSurroundFormats();
                    reply.writeNoException();
                    reply.writeList(_result);
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setSurroundFormatEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 59: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSurroundFormatEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 60: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setEncodedSurroundMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 61: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getEncodedSurroundMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 62: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSpeakerphoneOn(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 63: {
                    boolean _result = this.isSpeakerphoneOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 64: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBluetoothScoOn(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 65: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setA2dpSuspended(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setLeAudioSuspended(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 67: {
                    boolean _result = this.isBluetoothScoOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 68: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBluetoothA2dpOn(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 69: {
                    boolean _result = this.isBluetoothA2dpOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 70: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    IAudioFocusDispatcher _arg3 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    String _arg6 = data.readString();
                    int _arg7 = data.readInt();
                    IAudioPolicyCallback _arg8 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg9 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.requestAudioFocus(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 71: {
                    IAudioFocusDispatcher _arg0 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    AudioAttributes _arg2 = data.readTypedObject(AudioAttributes.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.abandonAudioFocus(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 72: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterAudioFocusClient(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 73: {
                    int _result = this.getCurrentAudioFocus();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 74: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startBluetoothSco(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 75: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.startBluetoothScoVirtualCall(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 76: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.stopBluetoothSco(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 77: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.forceVolumeControlStream(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 78: {
                    IRingtonePlayer _arg0 = IRingtonePlayer.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setRingtonePlayer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 79: {
                    IRingtonePlayer _result = this.getRingtonePlayer();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 80: {
                    int _result = this.getUiSoundsStreamType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 81: {
                    List _result = this.getIndependentStreamTypes();
                    reply.writeNoException();
                    reply.writeList(_result);
                    break;
                }
                case 82: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getStreamTypeAlias(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 83: {
                    boolean _result = this.isVolumeControlUsingVolumeGroups();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 84: {
                    IStreamAliasingDispatcher _arg0 = IStreamAliasingDispatcher.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.registerStreamAliasingDispatcher(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 85: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotifAliasRingForTest(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 86: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setWiredDeviceConnectionState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 87: {
                    IAudioRoutesObserver _arg0 = IAudioRoutesObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    AudioRoutesInfo _result = this.startWatchingRoutes(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 88: {
                    boolean _result = this.isCameraSoundForced();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 89: {
                    IVolumeController _arg0 = IVolumeController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setVolumeController(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 90: {
                    IVolumeController _result = this.getVolumeController();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 91: {
                    IVolumeController _arg0 = IVolumeController.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyVolumeControllerVisible(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 92: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStreamAffectedByRingerMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 93: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isStreamAffectedByMute(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 94: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.disableSafeMediaVolume(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 95: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.lowerVolumeToRs1(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 96: {
                    float _result = this.getOutputRs2UpperBound();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 97: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setOutputRs2UpperBound(_arg0);
                    break;
                }
                case 98: {
                    float _result = this.getCsd();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 99: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setCsd(_arg0);
                    break;
                }
                case 100: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceUseFrameworkMel(_arg0);
                    break;
                }
                case 101: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceComputeCsdOnAllDevices(_arg0);
                    break;
                }
                case 102: {
                    boolean _result = this.isCsdEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 103: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.setHdmiSystemAudioSupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 104: {
                    boolean _result = this.isHdmiSystemAudioSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 105: {
                    AudioPolicyConfig _arg0 = data.readTypedObject(AudioPolicyConfig.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    IMediaProjection _arg6 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    String _result = this.registerAudioPolicy(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 106: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAudioPolicyAsync(_arg0);
                    break;
                }
                case 107: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAudioPolicy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 108: {
                    AudioPolicyConfig _arg0 = data.readTypedObject(AudioPolicyConfig.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.addMixForPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 109: {
                    AudioPolicyConfig _arg0 = data.readTypedObject(AudioPolicyConfig.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.removeMixForPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 110: {
                    int _arg0 = data.readInt();
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.setFocusPropertiesForPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 111: {
                    VolumePolicy _arg0 = data.readTypedObject(VolumePolicy.CREATOR);
                    data.enforceNoDataAvail();
                    this.setVolumePolicy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 112: {
                    boolean _result = this.hasRegisteredDynamicPolicy();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 113: {
                    IRecordingConfigDispatcher _arg0 = IRecordingConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerRecordingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 114: {
                    IRecordingConfigDispatcher _arg0 = IRecordingConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterRecordingCallback(_arg0);
                    break;
                }
                case 115: {
                    List<AudioRecordingConfiguration> _result = this.getActiveRecordingConfigurations();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 116: {
                    IPlaybackConfigDispatcher _arg0 = IPlaybackConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerPlaybackCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 117: {
                    IPlaybackConfigDispatcher _arg0 = IPlaybackConfigDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterPlaybackCallback(_arg0);
                    break;
                }
                case 118: {
                    List<AudioPlaybackConfiguration> _result = this.getActivePlaybackConfigurations();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 119: {
                    int _arg0 = data.readInt();
                    AudioAttributes _arg1 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getFocusRampTimeMs(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 120: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    int _arg1 = data.readInt();
                    IAudioPolicyCallback _arg2 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.dispatchFocusChange(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 121: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.playerHasOpPlayAudio(_arg0, _arg1);
                    break;
                }
                case 122: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    BluetoothDevice _arg1 = data.readTypedObject(BluetoothDevice.CREATOR);
                    BluetoothProfileConnectionInfo _arg2 = data.readTypedObject(BluetoothProfileConnectionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.handleBluetoothActiveDeviceChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 123: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    int _arg1 = data.readInt();
                    IAudioPolicyCallback _arg2 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setFocusRequestResultFromExtPolicy(_arg0, _arg1, _arg2);
                    break;
                }
                case 124: {
                    IAudioServerStateDispatcher _arg0 = IAudioServerStateDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAudioServerStateDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 125: {
                    IAudioServerStateDispatcher _arg0 = IAudioServerStateDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAudioServerStateDispatcher(_arg0);
                    break;
                }
                case 126: {
                    boolean _result = this.isAudioServerRunning();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 127: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    String[] _arg3 = data.createStringArray();
                    data.enforceNoDataAvail();
                    int _result = this.setUidDeviceAffinity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 128: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.removeUidDeviceAffinity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 129: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    String[] _arg3 = data.createStringArray();
                    data.enforceNoDataAvail();
                    int _result = this.setUserIdDeviceAffinity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 130: {
                    IAudioPolicyCallback _arg0 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.removeUserIdDeviceAffinity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 131: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasHapticChannels(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 132: {
                    boolean _result = this.isCallScreeningModeSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 133: {
                    int _arg0 = data.readInt();
                    ArrayList<AudioDeviceAttributes> _arg1 = data.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setPreferredDevicesForStrategy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 134: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.removePreferredDevicesForStrategy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 135: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getPreferredDevicesForStrategy(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 136: {
                    int _arg0 = data.readInt();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setDeviceAsNonDefaultForStrategy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 137: {
                    int _arg0 = data.readInt();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.removeDeviceAsNonDefaultForStrategy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 138: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getNonDefaultDevicesForStrategy(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 139: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getDevicesForAttributes(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 140: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getDevicesForAttributesUnprotected(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 141: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    IDevicesForAttributesCallback _arg1 = IDevicesForAttributesCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addOnDevicesForAttributesChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 142: {
                    IDevicesForAttributesCallback _arg0 = IDevicesForAttributesCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeOnDevicesForAttributesChangedListener(_arg0);
                    break;
                }
                case 143: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setAllowedCapturePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 144: {
                    int _result = this.getAllowedCapturePolicy();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 145: {
                    IStrategyPreferredDevicesDispatcher _arg0 = IStrategyPreferredDevicesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerStrategyPreferredDevicesDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 146: {
                    IStrategyPreferredDevicesDispatcher _arg0 = IStrategyPreferredDevicesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterStrategyPreferredDevicesDispatcher(_arg0);
                    break;
                }
                case 147: {
                    IStrategyNonDefaultDevicesDispatcher _arg0 = IStrategyNonDefaultDevicesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerStrategyNonDefaultDevicesDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 148: {
                    IStrategyNonDefaultDevicesDispatcher _arg0 = IStrategyNonDefaultDevicesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterStrategyNonDefaultDevicesDispatcher(_arg0);
                    break;
                }
                case 149: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRttEnabled(_arg0);
                    break;
                }
                case 150: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setDeviceVolumeBehavior(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 151: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getDeviceVolumeBehavior(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 152: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setMultiAudioFocusEnabled(_arg0);
                    break;
                }
                case 153: {
                    int _arg0 = data.readInt();
                    ArrayList<AudioDeviceAttributes> _arg1 = data.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setPreferredDevicesForCapturePreset(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 154: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.clearPreferredDevicesForCapturePreset(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 155: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AudioDeviceAttributes> _result = this.getPreferredDevicesForCapturePreset(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 156: {
                    ICapturePresetDevicesRoleDispatcher _arg0 = ICapturePresetDevicesRoleDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCapturePresetDevicesRoleDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 157: {
                    ICapturePresetDevicesRoleDispatcher _arg0 = ICapturePresetDevicesRoleDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCapturePresetDevicesRoleDispatcher(_arg0);
                    break;
                }
                case 158: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    UserHandle _arg6 = data.readTypedObject(UserHandle.CREATOR);
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.adjustStreamVolumeForUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 159: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    UserHandle _arg6 = data.readTypedObject(UserHandle.CREATOR);
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.adjustSuggestedStreamVolumeForUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 160: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    UserHandle _arg6 = data.readTypedObject(UserHandle.CREATOR);
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setStreamVolumeForUid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 161: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.isMusicActive(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 162: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDeviceMaskForStream(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 163: {
                    int[] _result = this.getAvailableCommunicationDeviceIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 164: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setCommunicationDevice(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 165: {
                    int _result = this.getCommunicationDevice();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 166: {
                    ICommunicationDeviceDispatcher _arg0 = ICommunicationDeviceDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCommunicationDeviceDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 167: {
                    ICommunicationDeviceDispatcher _arg0 = ICommunicationDeviceDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCommunicationDeviceDispatcher(_arg0);
                    break;
                }
                case 168: {
                    boolean _result = this.areNavigationRepeatSoundEffectsEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 169: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNavigationRepeatSoundEffectsEnabled(_arg0);
                    break;
                }
                case 170: {
                    boolean _result = this.isHomeSoundEffectEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 171: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setHomeSoundEffectEnabled(_arg0);
                    break;
                }
                case 172: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.setAdditionalOutputDeviceDelay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 173: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getAdditionalOutputDeviceDelay(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 174: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getMaxAdditionalOutputDeviceDelay(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 175: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    IAudioFocusDispatcher _arg3 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    int _arg8 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.requestAudioFocusForTest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 176: {
                    IAudioFocusDispatcher _arg0 = IAudioFocusDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    AudioAttributes _arg2 = data.readTypedObject(AudioAttributes.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.abandonAudioFocusForTest(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 177: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getFadeOutDurationOnFocusLossMillis(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 178: {
                    IAudioModeDispatcher _arg0 = IAudioModeDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerModeDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 179: {
                    IAudioModeDispatcher _arg0 = IAudioModeDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterModeDispatcher(_arg0);
                    break;
                }
                case 180: {
                    int _result = this.getSpatializerImmersiveAudioLevel();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 181: {
                    boolean _result = this.isSpatializerEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 182: {
                    boolean _result = this.isSpatializerAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 183: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isSpatializerAvailableForDevice(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 184: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasHeadTracker(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 185: {
                    boolean _arg0 = data.readBoolean();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.setHeadTrackerEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 186: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isHeadTrackerEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 187: {
                    boolean _result = this.isHeadTrackerAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 188: {
                    ISpatializerHeadTrackerAvailableCallback _arg0 = ISpatializerHeadTrackerAvailableCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.registerSpatializerHeadTrackerAvailableCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 189: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSpatializerEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 190: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    AudioFormat _arg1 = data.readTypedObject(AudioFormat.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.canBeSpatialized(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 191: {
                    ISpatializerCallback _arg0 = ISpatializerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSpatializerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 192: {
                    ISpatializerCallback _arg0 = ISpatializerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSpatializerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 193: {
                    ISpatializerHeadTrackingModeCallback _arg0 = ISpatializerHeadTrackingModeCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSpatializerHeadTrackingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 194: {
                    ISpatializerHeadTrackingModeCallback _arg0 = ISpatializerHeadTrackingModeCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSpatializerHeadTrackingCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 195: {
                    ISpatializerHeadToSoundStagePoseCallback _arg0 = ISpatializerHeadToSoundStagePoseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerHeadToSoundstagePoseCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 196: {
                    ISpatializerHeadToSoundStagePoseCallback _arg0 = ISpatializerHeadToSoundStagePoseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterHeadToSoundstagePoseCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 197: {
                    List<AudioDeviceAttributes> _result = this.getSpatializerCompatibleAudioDevices();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 198: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.addSpatializerCompatibleAudioDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 199: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeSpatializerCompatibleAudioDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 200: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDesiredHeadTrackingMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 201: {
                    int _result = this.getDesiredHeadTrackingMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 202: {
                    int[] _result = this.getSupportedHeadTrackingModes();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 203: {
                    int _result = this.getActualHeadTrackingMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 204: {
                    float[] _arg0 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.setSpatializerGlobalTransform(_arg0);
                    break;
                }
                case 205: {
                    this.recenterHeadTracker();
                    break;
                }
                case 206: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.setSpatializerParameter(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 207: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.getSpatializerParameter(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_arg1);
                    break;
                }
                case 208: {
                    int _result = this.getSpatializerOutput();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 209: {
                    ISpatializerOutputCallback _arg0 = ISpatializerOutputCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSpatializerOutputCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 210: {
                    ISpatializerOutputCallback _arg0 = ISpatializerOutputCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSpatializerOutputCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 211: {
                    boolean _result = this.isVolumeFixed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 212: {
                    VolumeInfo _result = this.getDefaultVolumeInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 213: {
                    boolean _result = this.isPstnCallAudioInterceptable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 214: {
                    int[] _arg0 = data.createIntArray();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.muteAwaitConnection(_arg0, _arg1, _arg2);
                    break;
                }
                case 215: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.cancelMuteAwaitConnection(_arg0);
                    break;
                }
                case 216: {
                    AudioDeviceAttributes _result = this.getMutingExpectedDevice();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 217: {
                    IMuteAwaitConnectionCallback _arg0 = IMuteAwaitConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.registerMuteAwaitConnectionDispatcher(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 218: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTestDeviceConnectionState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 219: {
                    boolean _arg0 = data.readBoolean();
                    IDeviceVolumeBehaviorDispatcher _arg1 = IDeviceVolumeBehaviorDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerDeviceVolumeBehaviorDispatcher(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 220: {
                    List<AudioFocusInfo> _result = this.getFocusStack();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 221: {
                    AudioFocusInfo _arg0 = data.readTypedObject(AudioFocusInfo.CREATOR);
                    IAudioPolicyCallback _arg1 = IAudioPolicyCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.sendFocusLoss(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 222: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.addAssistantServicesUids(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 223: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.removeAssistantServicesUids(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 224: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setActiveAssistantServiceUids(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 225: {
                    int[] _result = this.getAssistantServicesUids();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 226: {
                    int[] _result = this.getActiveAssistantServiceUids();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 227: {
                    boolean _arg0 = data.readBoolean();
                    IAudioDeviceVolumeDispatcher _arg1 = IAudioDeviceVolumeDispatcher.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    AudioDeviceAttributes _arg3 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    ArrayList<VolumeInfo> _arg4 = data.createTypedArrayList(VolumeInfo.CREATOR);
                    boolean _arg5 = data.readBoolean();
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerDeviceVolumeDispatcherForAbsoluteVolume(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 228: {
                    AudioHalVersionInfo _result = this.getHalVersion();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 229: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    AudioMixerAttributes _arg2 = data.readTypedObject(AudioMixerAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setPreferredMixerAttributes(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 230: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.clearPreferredMixerAttributes(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 231: {
                    IPreferredMixerAttributesDispatcher _arg0 = IPreferredMixerAttributesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerPreferredMixerAttributesDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 232: {
                    IPreferredMixerAttributesDispatcher _arg0 = IPreferredMixerAttributesDispatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterPreferredMixerAttributesDispatcher(_arg0);
                    break;
                }
                case 233: {
                    boolean _result = this.supportsBluetoothVariableLatency();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 234: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBluetoothVariableLatencyEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 235: {
                    boolean _result = this.isBluetoothVariableLatencyEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setDeviceVolume_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_setDeviceVolume, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDeviceVolume_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getDeviceVolume, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setMasterMute_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAudioVolumeGroups_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setVolumeGroupVolumeIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_setVolumeGroupVolumeIndex, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getVolumeGroupVolumeIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getVolumeGroupVolumeIndex, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getVolumeGroupMaxVolumeIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getVolumeGroupMaxVolumeIndex, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getVolumeGroupMinVolumeIndex_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getVolumeGroupMinVolumeIndex, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getLastAudibleVolumeForVolumeGroup_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_AUDIO_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getLastAudibleStreamVolume_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.QUERY_AUDIO_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setSupportedSystemUsages_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSupportedSystemUsages_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAudioProductStrategies_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isUltrasoundSupported_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_ULTRASOUND", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isHotwordStreamSupported_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CAPTURE_AUDIO_HOTWORD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setA2dpSuspended_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BLUETOOTH_STACK", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setLeAudioSuspended_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BLUETOOTH_STACK", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getIndependentStreamTypes_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getStreamTypeAlias_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isVolumeControlUsingVolumeGroups_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerStreamAliasingDispatcher_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setNotifAliasRingForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setWiredDeviceConnectionState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getOutputRs2UpperBound_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setOutputRs2UpperBound_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getCsd_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setCsd_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void forceUseFrameworkMel_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void forceComputeCsdOnAllDevices_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isCsdEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setPreferredDevicesForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removePreferredDevicesForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getPreferredDevicesForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDeviceAsNonDefaultForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeDeviceAsNonDefaultForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getNonDefaultDevicesForStrategy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDeviceVolumeBehavior_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_setDeviceVolumeBehavior, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDeviceVolumeBehavior_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAnyOf(PERMISSIONS_getDeviceVolumeBehavior, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setMultiAudioFocusEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void clearPreferredDevicesForCapturePreset_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getPreferredDevicesForCapturePreset_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isSpatializerAvailableForDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void hasHeadTracker_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setHeadTrackerEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isHeadTrackerEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setSpatializerEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerSpatializerHeadTrackingCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterSpatializerHeadTrackingCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerHeadToSoundstagePoseCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterHeadToSoundstagePoseCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSpatializerCompatibleAudioDevices_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addSpatializerCompatibleAudioDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeSpatializerCompatibleAudioDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDesiredHeadTrackingMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDesiredHeadTrackingMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSupportedHeadTrackingModes_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getActualHeadTrackingMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setSpatializerGlobalTransform_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void recenterHeadTracker_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setSpatializerParameter_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSpatializerParameter_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getSpatializerOutput_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerSpatializerOutputCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterSpatializerOutputCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_DEFAULT_AUDIO_EFFECTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isPstnCallAudioInterceptable_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CALL_AUDIO_INTERCEPTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getMutingExpectedDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerMuteAwaitConnectionDispatcher_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getFocusStack_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addAssistantServicesUids_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeAssistantServicesUids_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setActiveAssistantServiceUids_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAssistantServicesUids_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getActiveAssistantServiceUids_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void supportsBluetoothVariableLatency_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setBluetoothVariableLatencyEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isBluetoothVariableLatencyEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_AUDIO_ROUTING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 234;
        }

        private static class Proxy
        implements IAudioService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int trackPlayer(PlayerBase.PlayerIdCard pic) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(pic, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerAttributes(int piid, AudioAttributes attr2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeTypedObject(attr2, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerEvent(int piid, int event, int eventId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeInt(event);
                    _data.writeInt(eventId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releasePlayer(int piid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int trackRecorder(IBinder recorder) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(recorder);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recorderEvent(int riid, int event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(riid);
                    _data.writeInt(event);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseRecorder(int riid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(riid);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerSessionId(int piid, int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void portEvent(int portId, int event, PersistableBundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(portId);
                    _data.writeInt(event);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustStreamVolumeWithAttribution(int streamType, int direction, int flags, String callingPackage, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStreamVolume(int streamType, int index, int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(index);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStreamVolumeWithAttribution(int streamType, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(index);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceVolume(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(vi, 0);
                    _data.writeTypedObject(ada, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VolumeInfo getDeviceVolume(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
                VolumeInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(vi, 0);
                    _data.writeTypedObject(ada, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VolumeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleVolumeKey(KeyEvent event, boolean isOnTv, String callingPackage, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    _data.writeBoolean(isOnTv);
                    _data.writeString(callingPackage);
                    _data.writeString(caller);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreamMute(int streamType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceRemoteSubmixFullVolume(boolean startForcing, IBinder cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(startForcing);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMasterMute() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMasterMute(boolean mute, int flags, String callingPackage, int userId, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(mute);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamMinVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamMaxVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioVolumeGroup> getAudioVolumeGroups() throws RemoteException {
                ArrayList<AudioVolumeGroup> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioVolumeGroup.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeGroupVolumeIndex(int groupId, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeInt(index);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVolumeGroupVolumeIndex(int groupId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVolumeGroupMaxVolumeIndex(int groupId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVolumeGroupMinVolumeIndex(int groupId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastAudibleVolumeForVolumeGroup(int groupId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVolumeGroupMuted(int groupId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustVolumeGroupVolume(int groupId, int direction, int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLastAudibleStreamVolume(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSupportedSystemUsages(int[] systemUsages) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(systemUsages);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSupportedSystemUsages() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioProductStrategy> getAudioProductStrategies() throws RemoteException {
                ArrayList<AudioProductStrategy> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioProductStrategy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMicrophoneMuted() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUltrasoundSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHotwordStreamSupported(boolean lookbackAudio) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(lookbackAudio);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMicrophoneMute(boolean on, String callingPackage, int userId, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMicrophoneMuteFromSwitch(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean bl = this.mRemote.transact(40, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRingerModeExternal(int ringerMode, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ringerMode);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRingerModeInternal(int ringerMode, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ringerMode);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRingerModeExternal() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRingerModeInternal() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isValidRingerMode(int ringerMode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(ringerMode);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVibrateSetting(int vibrateType, int vibrateSetting) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(vibrateType);
                    _data.writeInt(vibrateSetting);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVibrateSetting(int vibrateType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(vibrateType);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldVibrate(int vibrateType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(vibrateType);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMode(int mode, IBinder cb, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeStrongBinder(cb);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playSoundEffect(int effectType, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(effectType);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(51, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playSoundEffectVolume(int effectType, float volume) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(effectType);
                    _data.writeFloat(volume);
                    boolean bl = this.mRemote.transact(52, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean loadSoundEffects() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void unloadSoundEffects() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(54, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void reloadAudioSettings() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(55, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getSurroundFormats() throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List getReportedSurroundFormats() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readArrayList(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSurroundFormatEnabled(int audioFormat, boolean enabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(audioFormat);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSurroundFormatEnabled(int audioFormat) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(audioFormat);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setEncodedSurroundMode(int mode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getEncodedSurroundMode(int targetSdkVersion) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(targetSdkVersion);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpeakerphoneOn(IBinder cb, boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpeakerphoneOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBluetoothScoOn(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setA2dpSuspended(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLeAudioSuspended(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBluetoothScoOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBluetoothA2dpOn(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBluetoothA2dpOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestAudioFocus(AudioAttributes aa, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, String attributionTag, int flags, IAudioPolicyCallback pcb, int sdk) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(durationHint);
                    _data.writeStrongBinder(cb);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeString(callingPackageName);
                    _data.writeString(attributionTag);
                    _data.writeInt(flags);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(sdk);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int abandonAudioFocus(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeTypedObject(aa, 0);
                    _data.writeString(callingPackageName);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioFocusClient(String clientId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(clientId);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCurrentAudioFocus() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startBluetoothSco(IBinder cb, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeInt(targetSdkVersion);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startBluetoothScoVirtualCall(IBinder cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopBluetoothSco(IBinder cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceVolumeControlStream(int streamType, IBinder cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeStrongBinder(cb);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRingtonePlayer(IRingtonePlayer player) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(player);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRingtonePlayer getRingtonePlayer() throws RemoteException {
                IRingtonePlayer _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                    _result = IRingtonePlayer.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getUiSoundsStreamType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List getIndependentStreamTypes() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readArrayList(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStreamTypeAlias(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVolumeControlUsingVolumeGroups() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerStreamAliasingDispatcher(IStreamAliasingDispatcher isad, boolean register) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(isad);
                    _data.writeBoolean(register);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotifAliasRingForTest(boolean alias) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(alias);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWiredDeviceConnectionState(AudioDeviceAttributes aa, int state, String caller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(state);
                    _data.writeString(caller);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) throws RemoteException {
                AudioRoutesInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AudioRoutesInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCameraSoundForced() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeController(IVolumeController controller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVolumeController getVolumeController() throws RemoteException {
                IVolumeController _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                    _result = IVolumeController.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyVolumeControllerVisible(IVolumeController controller, boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    _data.writeBoolean(visible);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreamAffectedByRingerMode(int streamType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isStreamAffectedByMute(int streamType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableSafeMediaVolume(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lowerVolumeToRs1(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getOutputRs2UpperBound() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOutputRs2UpperBound(float rs2Value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(rs2Value);
                    boolean bl = this.mRemote.transact(97, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getCsd() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCsd(float csd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(csd);
                    boolean bl = this.mRemote.transact(99, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceUseFrameworkMel(boolean useFrameworkMel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(useFrameworkMel);
                    boolean bl = this.mRemote.transact(100, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceComputeCsdOnAllDevices(boolean computeCsdOnAllDevices) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(computeCsdOnAllDevices);
                    boolean bl = this.mRemote.transact(101, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCsdEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setHdmiSystemAudioSupported(boolean on) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHdmiSystemAudioSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String registerAudioPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb, boolean hasFocusListener, boolean isFocusPolicy, boolean isTestFocusPolicy, boolean isVolumeController, IMediaProjection projection) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policyConfig, 0);
                    _data.writeStrongInterface(pcb);
                    _data.writeBoolean(hasFocusListener);
                    _data.writeBoolean(isFocusPolicy);
                    _data.writeBoolean(isTestFocusPolicy);
                    _data.writeBoolean(isVolumeController);
                    _data.writeStrongInterface(projection);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioPolicyAsync(IAudioPolicyCallback pcb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    boolean bl = this.mRemote.transact(106, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioPolicy(IAudioPolicyCallback pcb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policyConfig, 0);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policyConfig, 0);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setFocusPropertiesForPolicy(int duckingBehavior, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(duckingBehavior);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumePolicy(VolumePolicy policy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(policy, 0);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasRegisteredDynamicPolicy() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(rcdb);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(rcdb);
                    boolean bl = this.mRemote.transact(114, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() throws RemoteException {
                ArrayList<AudioRecordingConfiguration> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioRecordingConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcdb);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcdb);
                    boolean bl = this.mRemote.transact(117, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() throws RemoteException {
                ArrayList<AudioPlaybackConfiguration> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(118, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioPlaybackConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFocusRampTimeMs(int focusGain, AudioAttributes attr2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(focusGain);
                    _data.writeTypedObject(attr2, 0);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int dispatchFocusChange(AudioFocusInfo afi, int focusChange, IAudioPolicyCallback pcb) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(afi, 0);
                    _data.writeInt(focusChange);
                    _data.writeStrongInterface(pcb);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playerHasOpPlayAudio(int piid, boolean hasOpPlayAudio) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(piid);
                    _data.writeBoolean(hasOpPlayAudio);
                    boolean bl = this.mRemote.transact(121, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleBluetoothActiveDeviceChanged(BluetoothDevice newDevice, BluetoothDevice previousDevice, BluetoothProfileConnectionInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(newDevice, 0);
                    _data.writeTypedObject(previousDevice, 0);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFocusRequestResultFromExtPolicy(AudioFocusInfo afi, int requestResult, IAudioPolicyCallback pcb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(afi, 0);
                    _data.writeInt(requestResult);
                    _data.writeStrongInterface(pcb);
                    boolean bl = this.mRemote.transact(123, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(asd);
                    boolean _status = this.mRemote.transact(124, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(asd);
                    boolean bl = this.mRemote.transact(125, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAudioServerRunning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(126, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setUidDeviceAffinity(IAudioPolicyCallback pcb, int uid, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(uid);
                    _data.writeIntArray(deviceTypes);
                    _data.writeStringArray(deviceAddresses);
                    boolean _status = this.mRemote.transact(127, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeUidDeviceAffinity(IAudioPolicyCallback pcb, int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(128, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(userId);
                    _data.writeIntArray(deviceTypes);
                    _data.writeStringArray(deviceAddresses);
                    boolean _status = this.mRemote.transact(129, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(pcb);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(130, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasHapticChannels(Uri uri) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uri, 0);
                    boolean _status = this.mRemote.transact(131, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCallScreeningModeSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(132, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setPreferredDevicesForStrategy(int strategy, List<AudioDeviceAttributes> devices) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    _data.writeTypedList(devices, 0);
                    boolean _status = this.mRemote.transact(133, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removePreferredDevicesForStrategy(int strategy) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    boolean _status = this.mRemote.transact(134, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getPreferredDevicesForStrategy(int strategy) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    boolean _status = this.mRemote.transact(135, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDeviceAsNonDefaultForStrategy(int strategy, AudioDeviceAttributes device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(136, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeDeviceAsNonDefaultForStrategy(int strategy, AudioDeviceAttributes device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(137, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getNonDefaultDevicesForStrategy(int strategy) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strategy);
                    boolean _status = this.mRemote.transact(138, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getDevicesForAttributes(AudioAttributes attributes) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributes, 0);
                    boolean _status = this.mRemote.transact(139, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getDevicesForAttributesUnprotected(AudioAttributes attributes) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributes, 0);
                    boolean _status = this.mRemote.transact(140, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnDevicesForAttributesChangedListener(AudioAttributes attributes, IDevicesForAttributesCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributes, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(141, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnDevicesForAttributesChangedListener(IDevicesForAttributesCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(142, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setAllowedCapturePolicy(int capturePolicy) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePolicy);
                    boolean _status = this.mRemote.transact(143, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAllowedCapturePolicy() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(144, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(145, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(146, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(147, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(148, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRttEnabled(boolean rttEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(rttEnabled);
                    boolean bl = this.mRemote.transact(149, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceVolumeBehavior(AudioDeviceAttributes device, int deviceVolumeBehavior, String pkgName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(deviceVolumeBehavior);
                    _data.writeString(pkgName);
                    boolean _status = this.mRemote.transact(150, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeviceVolumeBehavior(AudioDeviceAttributes device) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(151, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMultiAudioFocusEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(152, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setPreferredDevicesForCapturePreset(int capturePreset, List<AudioDeviceAttributes> devices) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePreset);
                    _data.writeTypedList(devices, 0);
                    boolean _status = this.mRemote.transact(153, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int clearPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePreset);
                    boolean _status = this.mRemote.transact(154, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capturePreset);
                    boolean _status = this.mRemote.transact(155, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(156, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(157, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(targetSdkVersion);
                    boolean bl = this.mRemote.transact(158, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustSuggestedStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(targetSdkVersion);
                    boolean bl = this.mRemote.transact(159, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(targetSdkVersion);
                    boolean bl = this.mRemote.transact(160, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMusicActive(boolean remotely) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(remotely);
                    boolean _status = this.mRemote.transact(161, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeviceMaskForStream(int streamType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    boolean _status = this.mRemote.transact(162, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAvailableCommunicationDeviceIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(163, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setCommunicationDevice(IBinder cb, int portId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb);
                    _data.writeInt(portId);
                    boolean _status = this.mRemote.transact(164, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCommunicationDevice() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(165, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(166, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(167, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areNavigationRepeatSoundEffectsEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(168, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavigationRepeatSoundEffectsEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(169, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHomeSoundEffectEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(170, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHomeSoundEffectEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(171, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAdditionalOutputDeviceDelay(AudioDeviceAttributes device, long delayMillis) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeLong(delayMillis);
                    boolean _status = this.mRemote.transact(172, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(173, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getMaxAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(174, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int requestAudioFocusForTest(AudioAttributes aa, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, int flags, int uid, int sdk) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(durationHint);
                    _data.writeStrongBinder(cb);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeString(callingPackageName);
                    _data.writeInt(flags);
                    _data.writeInt(uid);
                    _data.writeInt(sdk);
                    boolean _status = this.mRemote.transact(175, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int abandonAudioFocusForTest(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(fd);
                    _data.writeString(clientId);
                    _data.writeTypedObject(aa, 0);
                    _data.writeString(callingPackageName);
                    boolean _status = this.mRemote.transact(176, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getFadeOutDurationOnFocusLossMillis(AudioAttributes aa) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    boolean _status = this.mRemote.transact(177, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(178, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(179, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSpatializerImmersiveAudioLevel() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(180, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpatializerEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(181, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpatializerAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(182, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpatializerAvailableForDevice(AudioDeviceAttributes device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(183, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasHeadTracker(AudioDeviceAttributes device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(184, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHeadTrackerEnabled(boolean enabled, AudioDeviceAttributes device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(185, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHeadTrackerEnabled(AudioDeviceAttributes device) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(186, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHeadTrackerAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(187, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerHeadTrackerAvailableCallback(ISpatializerHeadTrackerAvailableCallback cb, boolean register) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    _data.writeBoolean(register);
                    boolean _status = this.mRemote.transact(188, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpatializerEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(189, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canBeSpatialized(AudioAttributes aa, AudioFormat af) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeTypedObject(af, 0);
                    boolean _status = this.mRemote.transact(190, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(191, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(192, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(193, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(194, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(195, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(196, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioDeviceAttributes> getSpatializerCompatibleAudioDevices() throws RemoteException {
                ArrayList<AudioDeviceAttributes> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(197, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ada, 0);
                    boolean _status = this.mRemote.transact(198, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ada, 0);
                    boolean _status = this.mRemote.transact(199, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDesiredHeadTrackingMode(int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(200, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDesiredHeadTrackingMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(201, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSupportedHeadTrackingModes() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(202, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActualHeadTrackingMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(203, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpatializerGlobalTransform(float[] transform) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloatArray(transform);
                    boolean bl = this.mRemote.transact(204, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void recenterHeadTracker() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(205, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSpatializerParameter(int key, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    boolean _status = this.mRemote.transact(206, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getSpatializerParameter(int key, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    boolean _status = this.mRemote.transact(207, _data, _reply, 0);
                    _reply.readException();
                    _reply.readByteArray(value);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSpatializerOutput() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(208, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(209, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(210, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVolumeFixed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(211, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VolumeInfo getDefaultVolumeInfo() throws RemoteException {
                VolumeInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(212, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VolumeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPstnCallAudioInterceptable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(213, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void muteAwaitConnection(int[] usagesToMute, AudioDeviceAttributes dev, long timeOutMs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(usagesToMute);
                    _data.writeTypedObject(dev, 0);
                    _data.writeLong(timeOutMs);
                    boolean bl = this.mRemote.transact(214, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelMuteAwaitConnection(AudioDeviceAttributes dev) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(dev, 0);
                    boolean bl = this.mRemote.transact(215, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AudioDeviceAttributes getMutingExpectedDevice() throws RemoteException {
                AudioDeviceAttributes _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(216, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AudioDeviceAttributes.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerMuteAwaitConnectionDispatcher(IMuteAwaitConnectionCallback cb, boolean register) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    _data.writeBoolean(register);
                    boolean _status = this.mRemote.transact(217, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestDeviceConnectionState(AudioDeviceAttributes device, boolean connected) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(connected);
                    boolean _status = this.mRemote.transact(218, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDeviceVolumeBehaviorDispatcher(boolean register, IDeviceVolumeBehaviorDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(register);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(219, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AudioFocusInfo> getFocusStack() throws RemoteException {
                ArrayList<AudioFocusInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(220, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AudioFocusInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendFocusLoss(AudioFocusInfo focusLoser, IAudioPolicyCallback apcb) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(focusLoser, 0);
                    _data.writeStrongInterface(apcb);
                    boolean _status = this.mRemote.transact(221, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAssistantServicesUids(int[] assistantUID) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(assistantUID);
                    boolean _status = this.mRemote.transact(222, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAssistantServicesUids(int[] assistantUID) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(assistantUID);
                    boolean _status = this.mRemote.transact(223, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActiveAssistantServiceUids(int[] activeUids) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(activeUids);
                    boolean _status = this.mRemote.transact(224, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAssistantServicesUids() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(225, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getActiveAssistantServiceUids() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(226, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDeviceVolumeDispatcherForAbsoluteVolume(boolean register, IAudioDeviceVolumeDispatcher cb, String packageName, AudioDeviceAttributes device, List<VolumeInfo> volumes, boolean handlesvolumeAdjustment, int volumeBehavior) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(register);
                    _data.writeStrongInterface(cb);
                    _data.writeString(packageName);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedList(volumes, 0);
                    _data.writeBoolean(handlesvolumeAdjustment);
                    _data.writeInt(volumeBehavior);
                    boolean _status = this.mRemote.transact(227, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AudioHalVersionInfo getHalVersion() throws RemoteException {
                AudioHalVersionInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(228, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AudioHalVersionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setPreferredMixerAttributes(AudioAttributes aa, int portId, AudioMixerAttributes mixerAttributes) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(portId);
                    _data.writeTypedObject(mixerAttributes, 0);
                    boolean _status = this.mRemote.transact(229, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int clearPreferredMixerAttributes(AudioAttributes aa, int portId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aa, 0);
                    _data.writeInt(portId);
                    boolean _status = this.mRemote.transact(230, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean _status = this.mRemote.transact(231, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher dispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(dispatcher);
                    boolean bl = this.mRemote.transact(232, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean supportsBluetoothVariableLatency() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(233, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBluetoothVariableLatencyEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(234, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBluetoothVariableLatencyEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(235, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IAudioService {
        @Override
        public int trackPlayer(PlayerBase.PlayerIdCard pic) throws RemoteException {
            return 0;
        }

        @Override
        public void playerAttributes(int piid, AudioAttributes attr2) throws RemoteException {
        }

        @Override
        public void playerEvent(int piid, int event, int eventId) throws RemoteException {
        }

        @Override
        public void releasePlayer(int piid) throws RemoteException {
        }

        @Override
        public int trackRecorder(IBinder recorder) throws RemoteException {
            return 0;
        }

        @Override
        public void recorderEvent(int riid, int event) throws RemoteException {
        }

        @Override
        public void releaseRecorder(int riid) throws RemoteException {
        }

        @Override
        public void playerSessionId(int piid, int sessionId) throws RemoteException {
        }

        @Override
        public void portEvent(int portId, int event, PersistableBundle extras) throws RemoteException {
        }

        @Override
        public void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) throws RemoteException {
        }

        @Override
        public void adjustStreamVolumeWithAttribution(int streamType, int direction, int flags, String callingPackage, String attributionTag) throws RemoteException {
        }

        @Override
        public void setStreamVolume(int streamType, int index, int flags, String callingPackage) throws RemoteException {
        }

        @Override
        public void setStreamVolumeWithAttribution(int streamType, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
        }

        @Override
        public void setDeviceVolume(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
        }

        @Override
        public VolumeInfo getDeviceVolume(VolumeInfo vi, AudioDeviceAttributes ada, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void handleVolumeKey(KeyEvent event, boolean isOnTv, String callingPackage, String caller) throws RemoteException {
        }

        @Override
        public boolean isStreamMute(int streamType) throws RemoteException {
            return false;
        }

        @Override
        public void forceRemoteSubmixFullVolume(boolean startForcing, IBinder cb) throws RemoteException {
        }

        @Override
        public boolean isMasterMute() throws RemoteException {
            return false;
        }

        @Override
        public void setMasterMute(boolean mute, int flags, String callingPackage, int userId, String attributionTag) throws RemoteException {
        }

        @Override
        public int getStreamVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public int getStreamMinVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public int getStreamMaxVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioVolumeGroup> getAudioVolumeGroups() throws RemoteException {
            return null;
        }

        @Override
        public void setVolumeGroupVolumeIndex(int groupId, int index, int flags, String callingPackage, String attributionTag) throws RemoteException {
        }

        @Override
        public int getVolumeGroupVolumeIndex(int groupId) throws RemoteException {
            return 0;
        }

        @Override
        public int getVolumeGroupMaxVolumeIndex(int groupId) throws RemoteException {
            return 0;
        }

        @Override
        public int getVolumeGroupMinVolumeIndex(int groupId) throws RemoteException {
            return 0;
        }

        @Override
        public int getLastAudibleVolumeForVolumeGroup(int groupId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isVolumeGroupMuted(int groupId) throws RemoteException {
            return false;
        }

        @Override
        public void adjustVolumeGroupVolume(int groupId, int direction, int flags, String callingPackage) throws RemoteException {
        }

        @Override
        public int getLastAudibleStreamVolume(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public void setSupportedSystemUsages(int[] systemUsages) throws RemoteException {
        }

        @Override
        public int[] getSupportedSystemUsages() throws RemoteException {
            return null;
        }

        @Override
        public List<AudioProductStrategy> getAudioProductStrategies() throws RemoteException {
            return null;
        }

        @Override
        public boolean isMicrophoneMuted() throws RemoteException {
            return false;
        }

        @Override
        public boolean isUltrasoundSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isHotwordStreamSupported(boolean lookbackAudio) throws RemoteException {
            return false;
        }

        @Override
        public void setMicrophoneMute(boolean on, String callingPackage, int userId, String attributionTag) throws RemoteException {
        }

        @Override
        public void setMicrophoneMuteFromSwitch(boolean on) throws RemoteException {
        }

        @Override
        public void setRingerModeExternal(int ringerMode, String caller) throws RemoteException {
        }

        @Override
        public void setRingerModeInternal(int ringerMode, String caller) throws RemoteException {
        }

        @Override
        public int getRingerModeExternal() throws RemoteException {
            return 0;
        }

        @Override
        public int getRingerModeInternal() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isValidRingerMode(int ringerMode) throws RemoteException {
            return false;
        }

        @Override
        public void setVibrateSetting(int vibrateType, int vibrateSetting) throws RemoteException {
        }

        @Override
        public int getVibrateSetting(int vibrateType) throws RemoteException {
            return 0;
        }

        @Override
        public boolean shouldVibrate(int vibrateType) throws RemoteException {
            return false;
        }

        @Override
        public void setMode(int mode, IBinder cb, String callingPackage) throws RemoteException {
        }

        @Override
        public int getMode() throws RemoteException {
            return 0;
        }

        @Override
        public void playSoundEffect(int effectType, int userId) throws RemoteException {
        }

        @Override
        public void playSoundEffectVolume(int effectType, float volume) throws RemoteException {
        }

        @Override
        public boolean loadSoundEffects() throws RemoteException {
            return false;
        }

        @Override
        public void unloadSoundEffects() throws RemoteException {
        }

        @Override
        public void reloadAudioSettings() throws RemoteException {
        }

        @Override
        public Map getSurroundFormats() throws RemoteException {
            return null;
        }

        @Override
        public List getReportedSurroundFormats() throws RemoteException {
            return null;
        }

        @Override
        public boolean setSurroundFormatEnabled(int audioFormat, boolean enabled) throws RemoteException {
            return false;
        }

        @Override
        public boolean isSurroundFormatEnabled(int audioFormat) throws RemoteException {
            return false;
        }

        @Override
        public boolean setEncodedSurroundMode(int mode) throws RemoteException {
            return false;
        }

        @Override
        public int getEncodedSurroundMode(int targetSdkVersion) throws RemoteException {
            return 0;
        }

        @Override
        public void setSpeakerphoneOn(IBinder cb, boolean on) throws RemoteException {
        }

        @Override
        public boolean isSpeakerphoneOn() throws RemoteException {
            return false;
        }

        @Override
        public void setBluetoothScoOn(boolean on) throws RemoteException {
        }

        @Override
        public void setA2dpSuspended(boolean on) throws RemoteException {
        }

        @Override
        public void setLeAudioSuspended(boolean enable) throws RemoteException {
        }

        @Override
        public boolean isBluetoothScoOn() throws RemoteException {
            return false;
        }

        @Override
        public void setBluetoothA2dpOn(boolean on) throws RemoteException {
        }

        @Override
        public boolean isBluetoothA2dpOn() throws RemoteException {
            return false;
        }

        @Override
        public int requestAudioFocus(AudioAttributes aa, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, String attributionTag, int flags, IAudioPolicyCallback pcb, int sdk) throws RemoteException {
            return 0;
        }

        @Override
        public int abandonAudioFocus(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
            return 0;
        }

        @Override
        public void unregisterAudioFocusClient(String clientId) throws RemoteException {
        }

        @Override
        public int getCurrentAudioFocus() throws RemoteException {
            return 0;
        }

        @Override
        public void startBluetoothSco(IBinder cb, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public void startBluetoothScoVirtualCall(IBinder cb) throws RemoteException {
        }

        @Override
        public void stopBluetoothSco(IBinder cb) throws RemoteException {
        }

        @Override
        public void forceVolumeControlStream(int streamType, IBinder cb) throws RemoteException {
        }

        @Override
        public void setRingtonePlayer(IRingtonePlayer player) throws RemoteException {
        }

        @Override
        public IRingtonePlayer getRingtonePlayer() throws RemoteException {
            return null;
        }

        @Override
        public int getUiSoundsStreamType() throws RemoteException {
            return 0;
        }

        @Override
        public List getIndependentStreamTypes() throws RemoteException {
            return null;
        }

        @Override
        public int getStreamTypeAlias(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isVolumeControlUsingVolumeGroups() throws RemoteException {
            return false;
        }

        @Override
        public void registerStreamAliasingDispatcher(IStreamAliasingDispatcher isad, boolean register) throws RemoteException {
        }

        @Override
        public void setNotifAliasRingForTest(boolean alias) throws RemoteException {
        }

        @Override
        public void setWiredDeviceConnectionState(AudioDeviceAttributes aa, int state, String caller) throws RemoteException {
        }

        @Override
        public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) throws RemoteException {
            return null;
        }

        @Override
        public boolean isCameraSoundForced() throws RemoteException {
            return false;
        }

        @Override
        public void setVolumeController(IVolumeController controller) throws RemoteException {
        }

        @Override
        public IVolumeController getVolumeController() throws RemoteException {
            return null;
        }

        @Override
        public void notifyVolumeControllerVisible(IVolumeController controller, boolean visible) throws RemoteException {
        }

        @Override
        public boolean isStreamAffectedByRingerMode(int streamType) throws RemoteException {
            return false;
        }

        @Override
        public boolean isStreamAffectedByMute(int streamType) throws RemoteException {
            return false;
        }

        @Override
        public void disableSafeMediaVolume(String callingPackage) throws RemoteException {
        }

        @Override
        public void lowerVolumeToRs1(String callingPackage) throws RemoteException {
        }

        @Override
        public float getOutputRs2UpperBound() throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setOutputRs2UpperBound(float rs2Value) throws RemoteException {
        }

        @Override
        public float getCsd() throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setCsd(float csd) throws RemoteException {
        }

        @Override
        public void forceUseFrameworkMel(boolean useFrameworkMel) throws RemoteException {
        }

        @Override
        public void forceComputeCsdOnAllDevices(boolean computeCsdOnAllDevices) throws RemoteException {
        }

        @Override
        public boolean isCsdEnabled() throws RemoteException {
            return false;
        }

        @Override
        public int setHdmiSystemAudioSupported(boolean on) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isHdmiSystemAudioSupported() throws RemoteException {
            return false;
        }

        @Override
        public String registerAudioPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb, boolean hasFocusListener, boolean isFocusPolicy, boolean isTestFocusPolicy, boolean isVolumeController, IMediaProjection projection) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterAudioPolicyAsync(IAudioPolicyCallback pcb) throws RemoteException {
        }

        @Override
        public void unregisterAudioPolicy(IAudioPolicyCallback pcb) throws RemoteException {
        }

        @Override
        public int addMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public int removeMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public int setFocusPropertiesForPolicy(int duckingBehavior, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public void setVolumePolicy(VolumePolicy policy) throws RemoteException {
        }

        @Override
        public boolean hasRegisteredDynamicPolicy() throws RemoteException {
            return false;
        }

        @Override
        public void registerRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
        }

        @Override
        public void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) throws RemoteException {
        }

        @Override
        public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() throws RemoteException {
            return null;
        }

        @Override
        public void registerPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
        }

        @Override
        public void unregisterPlaybackCallback(IPlaybackConfigDispatcher pcdb) throws RemoteException {
        }

        @Override
        public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() throws RemoteException {
            return null;
        }

        @Override
        public int getFocusRampTimeMs(int focusGain, AudioAttributes attr2) throws RemoteException {
            return 0;
        }

        @Override
        public int dispatchFocusChange(AudioFocusInfo afi, int focusChange, IAudioPolicyCallback pcb) throws RemoteException {
            return 0;
        }

        @Override
        public void playerHasOpPlayAudio(int piid, boolean hasOpPlayAudio) throws RemoteException {
        }

        @Override
        public void handleBluetoothActiveDeviceChanged(BluetoothDevice newDevice, BluetoothDevice previousDevice, BluetoothProfileConnectionInfo info) throws RemoteException {
        }

        @Override
        public void setFocusRequestResultFromExtPolicy(AudioFocusInfo afi, int requestResult, IAudioPolicyCallback pcb) throws RemoteException {
        }

        @Override
        public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
        }

        @Override
        public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher asd) throws RemoteException {
        }

        @Override
        public boolean isAudioServerRunning() throws RemoteException {
            return false;
        }

        @Override
        public int setUidDeviceAffinity(IAudioPolicyCallback pcb, int uid, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
            return 0;
        }

        @Override
        public int removeUidDeviceAffinity(IAudioPolicyCallback pcb, int uid) throws RemoteException {
            return 0;
        }

        @Override
        public int setUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId, int[] deviceTypes, String[] deviceAddresses) throws RemoteException {
            return 0;
        }

        @Override
        public int removeUserIdDeviceAffinity(IAudioPolicyCallback pcb, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean hasHapticChannels(Uri uri) throws RemoteException {
            return false;
        }

        @Override
        public boolean isCallScreeningModeSupported() throws RemoteException {
            return false;
        }

        @Override
        public int setPreferredDevicesForStrategy(int strategy, List<AudioDeviceAttributes> devices) throws RemoteException {
            return 0;
        }

        @Override
        public int removePreferredDevicesForStrategy(int strategy) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioDeviceAttributes> getPreferredDevicesForStrategy(int strategy) throws RemoteException {
            return null;
        }

        @Override
        public int setDeviceAsNonDefaultForStrategy(int strategy, AudioDeviceAttributes device) throws RemoteException {
            return 0;
        }

        @Override
        public int removeDeviceAsNonDefaultForStrategy(int strategy, AudioDeviceAttributes device) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioDeviceAttributes> getNonDefaultDevicesForStrategy(int strategy) throws RemoteException {
            return null;
        }

        @Override
        public List<AudioDeviceAttributes> getDevicesForAttributes(AudioAttributes attributes) throws RemoteException {
            return null;
        }

        @Override
        public List<AudioDeviceAttributes> getDevicesForAttributesUnprotected(AudioAttributes attributes) throws RemoteException {
            return null;
        }

        @Override
        public void addOnDevicesForAttributesChangedListener(AudioAttributes attributes, IDevicesForAttributesCallback callback) throws RemoteException {
        }

        @Override
        public void removeOnDevicesForAttributesChangedListener(IDevicesForAttributesCallback callback) throws RemoteException {
        }

        @Override
        public int setAllowedCapturePolicy(int capturePolicy) throws RemoteException {
            return 0;
        }

        @Override
        public int getAllowedCapturePolicy() throws RemoteException {
            return 0;
        }

        @Override
        public void registerStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterStrategyPreferredDevicesDispatcher(IStrategyPreferredDevicesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void registerStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterStrategyNonDefaultDevicesDispatcher(IStrategyNonDefaultDevicesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void setRttEnabled(boolean rttEnabled) throws RemoteException {
        }

        @Override
        public void setDeviceVolumeBehavior(AudioDeviceAttributes device, int deviceVolumeBehavior, String pkgName) throws RemoteException {
        }

        @Override
        public int getDeviceVolumeBehavior(AudioDeviceAttributes device) throws RemoteException {
            return 0;
        }

        @Override
        public void setMultiAudioFocusEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public int setPreferredDevicesForCapturePreset(int capturePreset, List<AudioDeviceAttributes> devices) throws RemoteException {
            return 0;
        }

        @Override
        public int clearPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
            return 0;
        }

        @Override
        public List<AudioDeviceAttributes> getPreferredDevicesForCapturePreset(int capturePreset) throws RemoteException {
            return null;
        }

        @Override
        public void registerCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterCapturePresetDevicesRoleDispatcher(ICapturePresetDevicesRoleDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void adjustStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public void adjustSuggestedStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public void setStreamVolumeForUid(int streamType, int direction, int flags, String packageName, int uid, int pid, UserHandle userHandle, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public boolean isMusicActive(boolean remotely) throws RemoteException {
            return false;
        }

        @Override
        public int getDeviceMaskForStream(int streamType) throws RemoteException {
            return 0;
        }

        @Override
        public int[] getAvailableCommunicationDeviceIds() throws RemoteException {
            return null;
        }

        @Override
        public boolean setCommunicationDevice(IBinder cb, int portId) throws RemoteException {
            return false;
        }

        @Override
        public int getCommunicationDevice() throws RemoteException {
            return 0;
        }

        @Override
        public void registerCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterCommunicationDeviceDispatcher(ICommunicationDeviceDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public boolean areNavigationRepeatSoundEffectsEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setNavigationRepeatSoundEffectsEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isHomeSoundEffectEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setHomeSoundEffectEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean setAdditionalOutputDeviceDelay(AudioDeviceAttributes device, long delayMillis) throws RemoteException {
            return false;
        }

        @Override
        public long getAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
            return 0L;
        }

        @Override
        public long getMaxAdditionalOutputDeviceDelay(AudioDeviceAttributes device) throws RemoteException {
            return 0L;
        }

        @Override
        public int requestAudioFocusForTest(AudioAttributes aa, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, int flags, int uid, int sdk) throws RemoteException {
            return 0;
        }

        @Override
        public int abandonAudioFocusForTest(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) throws RemoteException {
            return 0;
        }

        @Override
        public long getFadeOutDurationOnFocusLossMillis(AudioAttributes aa) throws RemoteException {
            return 0L;
        }

        @Override
        public void registerModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterModeDispatcher(IAudioModeDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public int getSpatializerImmersiveAudioLevel() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isSpatializerEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isSpatializerAvailable() throws RemoteException {
            return false;
        }

        @Override
        public boolean isSpatializerAvailableForDevice(AudioDeviceAttributes device) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasHeadTracker(AudioDeviceAttributes device) throws RemoteException {
            return false;
        }

        @Override
        public void setHeadTrackerEnabled(boolean enabled, AudioDeviceAttributes device) throws RemoteException {
        }

        @Override
        public boolean isHeadTrackerEnabled(AudioDeviceAttributes device) throws RemoteException {
            return false;
        }

        @Override
        public boolean isHeadTrackerAvailable() throws RemoteException {
            return false;
        }

        @Override
        public void registerSpatializerHeadTrackerAvailableCallback(ISpatializerHeadTrackerAvailableCallback cb, boolean register) throws RemoteException {
        }

        @Override
        public void setSpatializerEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean canBeSpatialized(AudioAttributes aa, AudioFormat af) throws RemoteException {
            return false;
        }

        @Override
        public void registerSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterSpatializerCallback(ISpatializerCallback cb) throws RemoteException {
        }

        @Override
        public void registerSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterSpatializerHeadTrackingCallback(ISpatializerHeadTrackingModeCallback cb) throws RemoteException {
        }

        @Override
        public void registerHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterHeadToSoundstagePoseCallback(ISpatializerHeadToSoundStagePoseCallback cb) throws RemoteException {
        }

        @Override
        public List<AudioDeviceAttributes> getSpatializerCompatibleAudioDevices() throws RemoteException {
            return null;
        }

        @Override
        public void addSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
        }

        @Override
        public void removeSpatializerCompatibleAudioDevice(AudioDeviceAttributes ada) throws RemoteException {
        }

        @Override
        public void setDesiredHeadTrackingMode(int mode) throws RemoteException {
        }

        @Override
        public int getDesiredHeadTrackingMode() throws RemoteException {
            return 0;
        }

        @Override
        public int[] getSupportedHeadTrackingModes() throws RemoteException {
            return null;
        }

        @Override
        public int getActualHeadTrackingMode() throws RemoteException {
            return 0;
        }

        @Override
        public void setSpatializerGlobalTransform(float[] transform) throws RemoteException {
        }

        @Override
        public void recenterHeadTracker() throws RemoteException {
        }

        @Override
        public void setSpatializerParameter(int key, byte[] value) throws RemoteException {
        }

        @Override
        public void getSpatializerParameter(int key, byte[] value) throws RemoteException {
        }

        @Override
        public int getSpatializerOutput() throws RemoteException {
            return 0;
        }

        @Override
        public void registerSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterSpatializerOutputCallback(ISpatializerOutputCallback cb) throws RemoteException {
        }

        @Override
        public boolean isVolumeFixed() throws RemoteException {
            return false;
        }

        @Override
        public VolumeInfo getDefaultVolumeInfo() throws RemoteException {
            return null;
        }

        @Override
        public boolean isPstnCallAudioInterceptable() throws RemoteException {
            return false;
        }

        @Override
        public void muteAwaitConnection(int[] usagesToMute, AudioDeviceAttributes dev, long timeOutMs) throws RemoteException {
        }

        @Override
        public void cancelMuteAwaitConnection(AudioDeviceAttributes dev) throws RemoteException {
        }

        @Override
        public AudioDeviceAttributes getMutingExpectedDevice() throws RemoteException {
            return null;
        }

        @Override
        public void registerMuteAwaitConnectionDispatcher(IMuteAwaitConnectionCallback cb, boolean register) throws RemoteException {
        }

        @Override
        public void setTestDeviceConnectionState(AudioDeviceAttributes device, boolean connected) throws RemoteException {
        }

        @Override
        public void registerDeviceVolumeBehaviorDispatcher(boolean register, IDeviceVolumeBehaviorDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public List<AudioFocusInfo> getFocusStack() throws RemoteException {
            return null;
        }

        @Override
        public boolean sendFocusLoss(AudioFocusInfo focusLoser, IAudioPolicyCallback apcb) throws RemoteException {
            return false;
        }

        @Override
        public void addAssistantServicesUids(int[] assistantUID) throws RemoteException {
        }

        @Override
        public void removeAssistantServicesUids(int[] assistantUID) throws RemoteException {
        }

        @Override
        public void setActiveAssistantServiceUids(int[] activeUids) throws RemoteException {
        }

        @Override
        public int[] getAssistantServicesUids() throws RemoteException {
            return null;
        }

        @Override
        public int[] getActiveAssistantServiceUids() throws RemoteException {
            return null;
        }

        @Override
        public void registerDeviceVolumeDispatcherForAbsoluteVolume(boolean register, IAudioDeviceVolumeDispatcher cb, String packageName, AudioDeviceAttributes device, List<VolumeInfo> volumes, boolean handlesvolumeAdjustment, int volumeBehavior) throws RemoteException {
        }

        @Override
        public AudioHalVersionInfo getHalVersion() throws RemoteException {
            return null;
        }

        @Override
        public int setPreferredMixerAttributes(AudioAttributes aa, int portId, AudioMixerAttributes mixerAttributes) throws RemoteException {
            return 0;
        }

        @Override
        public int clearPreferredMixerAttributes(AudioAttributes aa, int portId) throws RemoteException {
            return 0;
        }

        @Override
        public void registerPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public void unregisterPreferredMixerAttributesDispatcher(IPreferredMixerAttributesDispatcher dispatcher) throws RemoteException {
        }

        @Override
        public boolean supportsBluetoothVariableLatency() throws RemoteException {
            return false;
        }

        @Override
        public void setBluetoothVariableLatencyEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isBluetoothVariableLatencyEnabled() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

