/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaRoute2Info;
import android.media.RouteDiscoveryPreference;
import android.media.RouteListingPreference;
import android.media.RoutingSessionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IMediaRouter2Manager
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IMediaRouter2Manager";

    public void notifySessionCreated(int var1, RoutingSessionInfo var2) throws RemoteException;

    public void notifySessionUpdated(RoutingSessionInfo var1) throws RemoteException;

    public void notifySessionReleased(RoutingSessionInfo var1) throws RemoteException;

    public void notifyDiscoveryPreferenceChanged(String var1, RouteDiscoveryPreference var2) throws RemoteException;

    public void notifyRouteListingPreferenceChange(String var1, RouteListingPreference var2) throws RemoteException;

    public void notifyRoutesUpdated(List<MediaRoute2Info> var1) throws RemoteException;

    public void notifyRequestFailed(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaRouter2Manager {
        static final int TRANSACTION_notifySessionCreated = 1;
        static final int TRANSACTION_notifySessionUpdated = 2;
        static final int TRANSACTION_notifySessionReleased = 3;
        static final int TRANSACTION_notifyDiscoveryPreferenceChanged = 4;
        static final int TRANSACTION_notifyRouteListingPreferenceChange = 5;
        static final int TRANSACTION_notifyRoutesUpdated = 6;
        static final int TRANSACTION_notifyRequestFailed = 7;

        public Stub() {
            this.attachInterface(this, IMediaRouter2Manager.DESCRIPTOR);
        }

        public static IMediaRouter2Manager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMediaRouter2Manager.DESCRIPTOR);
            if (iin != null && iin instanceof IMediaRouter2Manager) {
                return (IMediaRouter2Manager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "notifySessionCreated";
                }
                case 2: {
                    return "notifySessionUpdated";
                }
                case 3: {
                    return "notifySessionReleased";
                }
                case 4: {
                    return "notifyDiscoveryPreferenceChanged";
                }
                case 5: {
                    return "notifyRouteListingPreferenceChange";
                }
                case 6: {
                    return "notifyRoutesUpdated";
                }
                case 7: {
                    return "notifyRequestFailed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMediaRouter2Manager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    RoutingSessionInfo _arg1 = data.readTypedObject(RoutingSessionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifySessionCreated(_arg0, _arg1);
                    break;
                }
                case 2: {
                    RoutingSessionInfo _arg0 = data.readTypedObject(RoutingSessionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifySessionUpdated(_arg0);
                    break;
                }
                case 3: {
                    RoutingSessionInfo _arg0 = data.readTypedObject(RoutingSessionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifySessionReleased(_arg0);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    RouteDiscoveryPreference _arg1 = data.readTypedObject(RouteDiscoveryPreference.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyDiscoveryPreferenceChanged(_arg0, _arg1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    RouteListingPreference _arg1 = data.readTypedObject(RouteListingPreference.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyRouteListingPreferenceChange(_arg0, _arg1);
                    break;
                }
                case 6: {
                    ArrayList<MediaRoute2Info> _arg0 = data.createTypedArrayList(MediaRoute2Info.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyRoutesUpdated(_arg0);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyRequestFailed(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IMediaRouter2Manager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMediaRouter2Manager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionCreated(int requestId, RoutingSessionInfo session) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(session, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionUpdated(RoutingSessionInfo session) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySessionReleased(RoutingSessionInfo session) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeTypedObject(session, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDiscoveryPreferenceChanged(String packageName, RouteDiscoveryPreference discoveryPreference) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(discoveryPreference, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRouteListingPreferenceChange(String packageName, RouteListingPreference routeListingPreference) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(routeListingPreference, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRoutesUpdated(List<MediaRoute2Info> routes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeTypedList(routes, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRequestFailed(int requestId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMediaRouter2Manager.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaRouter2Manager {
        @Override
        public void notifySessionCreated(int requestId, RoutingSessionInfo session) throws RemoteException {
        }

        @Override
        public void notifySessionUpdated(RoutingSessionInfo session) throws RemoteException {
        }

        @Override
        public void notifySessionReleased(RoutingSessionInfo session) throws RemoteException {
        }

        @Override
        public void notifyDiscoveryPreferenceChanged(String packageName, RouteDiscoveryPreference discoveryPreference) throws RemoteException {
        }

        @Override
        public void notifyRouteListingPreferenceChange(String packageName, RouteListingPreference routeListingPreference) throws RemoteException {
        }

        @Override
        public void notifyRoutesUpdated(List<MediaRoute2Info> routes) throws RemoteException {
        }

        @Override
        public void notifyRequestFailed(int requestId, int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

