/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.Controller2Link;
import android.media.Session2Command;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;

public interface IMediaSession2
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IMediaSession2";

    public void connect(Controller2Link var1, int var2, Bundle var3) throws RemoteException;

    public void disconnect(Controller2Link var1, int var2) throws RemoteException;

    public void sendSessionCommand(Controller2Link var1, int var2, Session2Command var3, Bundle var4, ResultReceiver var5) throws RemoteException;

    public void cancelSessionCommand(Controller2Link var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaSession2 {
        static final int TRANSACTION_connect = 1;
        static final int TRANSACTION_disconnect = 2;
        static final int TRANSACTION_sendSessionCommand = 3;
        static final int TRANSACTION_cancelSessionCommand = 4;

        public Stub() {
            this.attachInterface(this, IMediaSession2.DESCRIPTOR);
        }

        public static IMediaSession2 asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMediaSession2.DESCRIPTOR);
            if (iin != null && iin instanceof IMediaSession2) {
                return (IMediaSession2)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "connect";
                }
                case 2: {
                    return "disconnect";
                }
                case 3: {
                    return "sendSessionCommand";
                }
                case 4: {
                    return "cancelSessionCommand";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMediaSession2.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Controller2Link _arg0 = data.readTypedObject(Controller2Link.CREATOR);
                    int _arg1 = data.readInt();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    this.connect(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    Controller2Link _arg0 = data.readTypedObject(Controller2Link.CREATOR);
                    int _arg1 = data.readInt();
                    this.disconnect(_arg0, _arg1);
                    break;
                }
                case 3: {
                    Controller2Link _arg0 = data.readTypedObject(Controller2Link.CREATOR);
                    int _arg1 = data.readInt();
                    Session2Command _arg2 = data.readTypedObject(Session2Command.CREATOR);
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    ResultReceiver _arg4 = data.readTypedObject(ResultReceiver.CREATOR);
                    this.sendSessionCommand(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 4: {
                    Controller2Link _arg0 = data.readTypedObject(Controller2Link.CREATOR);
                    int _arg1 = data.readInt();
                    this.cancelSessionCommand(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IMediaSession2 {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMediaSession2.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(Controller2Link caller, int seq, Bundle connectionRequest) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaSession2.DESCRIPTOR);
                    _data.writeTypedObject(caller, 0);
                    _data.writeInt(seq);
                    _data.writeTypedObject(connectionRequest, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect(Controller2Link caller, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaSession2.DESCRIPTOR);
                    _data.writeTypedObject(caller, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSessionCommand(Controller2Link caller, int seq, Session2Command sessionCommand, Bundle args, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaSession2.DESCRIPTOR);
                    _data.writeTypedObject(caller, 0);
                    _data.writeInt(seq);
                    _data.writeTypedObject(sessionCommand, 0);
                    _data.writeTypedObject(args, 0);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelSessionCommand(Controller2Link caller, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaSession2.DESCRIPTOR);
                    _data.writeTypedObject(caller, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaSession2 {
        @Override
        public void connect(Controller2Link caller, int seq, Bundle connectionRequest) throws RemoteException {
        }

        @Override
        public void disconnect(Controller2Link caller, int seq) throws RemoteException {
        }

        @Override
        public void sendSessionCommand(Controller2Link caller, int seq, Session2Command sessionCommand, Bundle args, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void cancelSessionCommand(Controller2Link caller, int seq) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

