/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioDeviceAttributes;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMuteAwaitConnectionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IMuteAwaitConnectionCallback";

    public void dispatchOnMutedUntilConnection(AudioDeviceAttributes var1, int[] var2) throws RemoteException;

    public void dispatchOnUnmutedEvent(int var1, AudioDeviceAttributes var2, int[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMuteAwaitConnectionCallback {
        static final int TRANSACTION_dispatchOnMutedUntilConnection = 1;
        static final int TRANSACTION_dispatchOnUnmutedEvent = 2;

        public Stub() {
            this.attachInterface(this, IMuteAwaitConnectionCallback.DESCRIPTOR);
        }

        public static IMuteAwaitConnectionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMuteAwaitConnectionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IMuteAwaitConnectionCallback) {
                return (IMuteAwaitConnectionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "dispatchOnMutedUntilConnection";
                }
                case 2: {
                    return "dispatchOnUnmutedEvent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMuteAwaitConnectionCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.dispatchOnMutedUntilConnection(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    AudioDeviceAttributes _arg1 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    int[] _arg2 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.dispatchOnUnmutedEvent(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IMuteAwaitConnectionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMuteAwaitConnectionCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchOnMutedUntilConnection(AudioDeviceAttributes device, int[] mutedUsages) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMuteAwaitConnectionCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeIntArray(mutedUsages);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchOnUnmutedEvent(int event, AudioDeviceAttributes device, int[] mutedUsages) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMuteAwaitConnectionCallback.DESCRIPTOR);
                    _data.writeInt(event);
                    _data.writeTypedObject(device, 0);
                    _data.writeIntArray(mutedUsages);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMuteAwaitConnectionCallback {
        @Override
        public void dispatchOnMutedUntilConnection(AudioDeviceAttributes device, int[] mutedUsages) throws RemoteException {
        }

        @Override
        public void dispatchOnUnmutedEvent(int event, AudioDeviceAttributes device, int[] mutedUsages) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

