/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.VolumeShaperConfiguration;
import android.media.VolumeShaperOperation;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IPlayer
extends IInterface {
    public void start() throws RemoteException;

    public void pause() throws RemoteException;

    public void stop() throws RemoteException;

    public void setVolume(float var1) throws RemoteException;

    public void setPan(float var1) throws RemoteException;

    public void setStartDelayMs(int var1) throws RemoteException;

    public void applyVolumeShaper(VolumeShaperConfiguration var1, VolumeShaperOperation var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPlayer {
        public static final String DESCRIPTOR = "android.media.IPlayer";
        static final int TRANSACTION_start = 1;
        static final int TRANSACTION_pause = 2;
        static final int TRANSACTION_stop = 3;
        static final int TRANSACTION_setVolume = 4;
        static final int TRANSACTION_setPan = 5;
        static final int TRANSACTION_setStartDelayMs = 6;
        static final int TRANSACTION_applyVolumeShaper = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPlayer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPlayer) {
                return (IPlayer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "start";
                }
                case 2: {
                    return "pause";
                }
                case 3: {
                    return "stop";
                }
                case 4: {
                    return "setVolume";
                }
                case 5: {
                    return "setPan";
                }
                case 6: {
                    return "setStartDelayMs";
                }
                case 7: {
                    return "applyVolumeShaper";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.start();
                    break;
                }
                case 2: {
                    this.pause();
                    break;
                }
                case 3: {
                    this.stop();
                    break;
                }
                case 4: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setVolume(_arg0);
                    break;
                }
                case 5: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setPan(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setStartDelayMs(_arg0);
                    break;
                }
                case 7: {
                    VolumeShaperConfiguration _arg0 = data.readTypedObject(VolumeShaperConfiguration.CREATOR);
                    VolumeShaperOperation _arg1 = data.readTypedObject(VolumeShaperOperation.CREATOR);
                    data.enforceNoDataAvail();
                    this.applyVolumeShaper(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IPlayer {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void start() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void pause() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void stop() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolume(float vol) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(vol);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPan(float pan) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(pan);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStartDelayMs(int delayMs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(delayMs);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyVolumeShaper(VolumeShaperConfiguration configuration, VolumeShaperOperation operation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(configuration, 0);
                    _data.writeTypedObject(operation, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPlayer {
        @Override
        public void start() throws RemoteException {
        }

        @Override
        public void pause() throws RemoteException {
        }

        @Override
        public void stop() throws RemoteException {
        }

        @Override
        public void setVolume(float vol) throws RemoteException {
        }

        @Override
        public void setPan(float pan) throws RemoteException {
        }

        @Override
        public void setStartDelayMs(int delayMs) throws RemoteException {
        }

        @Override
        public void applyVolumeShaper(VolumeShaperConfiguration configuration, VolumeShaperOperation operation) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

