/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.SoundDoseRecord;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISoundDose
extends IInterface {
    public static final String DESCRIPTOR = "android$media$ISoundDose".replace('$', '.');

    public void setOutputRs2UpperBound(float var1) throws RemoteException;

    public void resetCsd(float var1, SoundDoseRecord[] var2) throws RemoteException;

    public void updateAttenuation(float var1, int var2) throws RemoteException;

    public void setCsdEnabled(boolean var1) throws RemoteException;

    public float getOutputRs2UpperBound() throws RemoteException;

    public float getCsd() throws RemoteException;

    public boolean isSoundDoseHalSupported() throws RemoteException;

    public void forceUseFrameworkMel(boolean var1) throws RemoteException;

    public void forceComputeCsdOnAllDevices(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISoundDose {
        static final int TRANSACTION_setOutputRs2UpperBound = 1;
        static final int TRANSACTION_resetCsd = 2;
        static final int TRANSACTION_updateAttenuation = 3;
        static final int TRANSACTION_setCsdEnabled = 4;
        static final int TRANSACTION_getOutputRs2UpperBound = 5;
        static final int TRANSACTION_getCsd = 6;
        static final int TRANSACTION_isSoundDoseHalSupported = 7;
        static final int TRANSACTION_forceUseFrameworkMel = 8;
        static final int TRANSACTION_forceComputeCsdOnAllDevices = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISoundDose asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISoundDose) {
                return (ISoundDose)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setOutputRs2UpperBound(_arg0);
                    break;
                }
                case 2: {
                    float _arg0 = data.readFloat();
                    SoundDoseRecord[] _arg1 = data.createTypedArray(SoundDoseRecord.CREATOR);
                    data.enforceNoDataAvail();
                    this.resetCsd(_arg0, _arg1);
                    break;
                }
                case 3: {
                    float _arg0 = data.readFloat();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateAttenuation(_arg0, _arg1);
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setCsdEnabled(_arg0);
                    break;
                }
                case 5: {
                    float _result = this.getOutputRs2UpperBound();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 6: {
                    float _result = this.getCsd();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 7: {
                    boolean _result = this.isSoundDoseHalSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceUseFrameworkMel(_arg0);
                    break;
                }
                case 9: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.forceComputeCsdOnAllDevices(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ISoundDose {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOutputRs2UpperBound(float rs2Value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeFloat(rs2Value);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetCsd(float currentCsd, SoundDoseRecord[] records) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeFloat(currentCsd);
                    _data.writeTypedArray(records, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateAttenuation(float attenuationDB, int device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeFloat(attenuationDB);
                    _data.writeInt(device);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCsdEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getOutputRs2UpperBound() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getCsd() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSoundDoseHalSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceUseFrameworkMel(boolean useFrameworkMel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeBoolean(useFrameworkMel);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceComputeCsdOnAllDevices(boolean computeCsdOnAllDevices) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeBoolean(computeCsdOnAllDevices);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISoundDose {
        @Override
        public void setOutputRs2UpperBound(float rs2Value) throws RemoteException {
        }

        @Override
        public void resetCsd(float currentCsd, SoundDoseRecord[] records) throws RemoteException {
        }

        @Override
        public void updateAttenuation(float attenuationDB, int device) throws RemoteException {
        }

        @Override
        public void setCsdEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public float getOutputRs2UpperBound() throws RemoteException {
            return 0.0f;
        }

        @Override
        public float getCsd() throws RemoteException {
            return 0.0f;
        }

        @Override
        public boolean isSoundDoseHalSupported() throws RemoteException {
            return false;
        }

        @Override
        public void forceUseFrameworkMel(boolean useFrameworkMel) throws RemoteException {
        }

        @Override
        public void forceComputeCsdOnAllDevices(boolean computeCsdOnAllDevices) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

