/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISpatializerCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.ISpatializerCallback";

    public void dispatchSpatializerEnabledChanged(boolean var1) throws RemoteException;

    public void dispatchSpatializerAvailableChanged(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISpatializerCallback {
        static final int TRANSACTION_dispatchSpatializerEnabledChanged = 1;
        static final int TRANSACTION_dispatchSpatializerAvailableChanged = 2;

        public Stub() {
            this.attachInterface(this, ISpatializerCallback.DESCRIPTOR);
        }

        public static ISpatializerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISpatializerCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISpatializerCallback) {
                return (ISpatializerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "dispatchSpatializerEnabledChanged";
                }
                case 2: {
                    return "dispatchSpatializerAvailableChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISpatializerCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.dispatchSpatializerEnabledChanged(_arg0);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.dispatchSpatializerAvailableChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ISpatializerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISpatializerCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchSpatializerEnabledChanged(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISpatializerCallback.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchSpatializerAvailableChanged(boolean available) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISpatializerCallback.DESCRIPTOR);
                    _data.writeBoolean(available);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISpatializerCallback {
        @Override
        public void dispatchSpatializerEnabledChanged(boolean enabled) throws RemoteException {
        }

        @Override
        public void dispatchSpatializerAvailableChanged(boolean available) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

