/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioPresentation;
import android.media.DrmInitData;
import android.media.MediaCas;
import android.media.MediaCodec;
import android.media.MediaDataSource;
import android.media.MediaFormat;
import android.media.MediaHTTPService;
import android.media.metrics.LogSessionId;
import android.net.Uri;
import android.os.IBinder;
import android.os.IHwBinder;
import android.os.PersistableBundle;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class MediaExtractor {
    public static final int SEEK_TO_PREVIOUS_SYNC = 0;
    public static final int SEEK_TO_NEXT_SYNC = 1;
    public static final int SEEK_TO_CLOSEST_SYNC = 2;
    public static final int SAMPLE_FLAG_SYNC = 1;
    public static final int SAMPLE_FLAG_ENCRYPTED = 2;
    public static final int SAMPLE_FLAG_PARTIAL_FRAME = 4;
    private MediaCas mMediaCas;
    private LogSessionId mLogSessionId = LogSessionId.LOG_SESSION_ID_NONE;
    private long mNativeContext;

    public MediaExtractor() {
        this.native_setup();
    }

    public void setDataSource(MediaDataSource mediaDataSource) throws IOException {
        OverrideMethod.invokeV("android.media.MediaExtractor#setDataSource(Landroid/media/MediaDataSource;)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(fd.getFileDescriptor());
            } else {
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        this.setDataSource(uri.toString(), headers);
    }

    public void setDataSource(String path, Map<String, String> headers) throws IOException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, keys, values);
    }

    private void nativeSetDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IOException {
        OverrideMethod.invokeV("android.media.MediaExtractor#nativeSetDataSource(Landroid/os/IBinder;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    public void setDataSource(String path) throws IOException {
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, null, null);
    }

    public void setDataSource(AssetFileDescriptor afd) throws IOException, IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull(afd);
        if (afd.getDeclaredLength() < 0L) {
            this.setDataSource(afd.getFileDescriptor());
        } else {
            this.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
        }
    }

    public void setDataSource(FileDescriptor fd) throws IOException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public void setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException {
        OverrideMethod.invokeV("android.media.MediaExtractor#setDataSource(Ljava/io/FileDescriptor;JJ)V", true, this);
    }

    @Deprecated
    public void setMediaCas(MediaCas mediaCas) {
        this.mMediaCas = mediaCas;
        this.nativeSetMediaCas(mediaCas.getBinder());
    }

    private void nativeSetMediaCas(IHwBinder iHwBinder) {
        OverrideMethod.invokeV("android.media.MediaExtractor#nativeSetMediaCas(Landroid/os/IHwBinder;)V", true, this);
    }

    public CasInfo getCasInfo(int index) {
        Map<String, Object> formatMap = this.getTrackFormatNative(index);
        if (formatMap.containsKey("ca-system-id")) {
            ByteBuffer buf;
            int systemId = (Integer)formatMap.get("ca-system-id");
            MediaCas.Session session = null;
            byte[] privateData = null;
            if (formatMap.containsKey("ca-private-data")) {
                buf = (ByteBuffer)formatMap.get("ca-private-data");
                buf.rewind();
                privateData = new byte[buf.remaining()];
                buf.get(privateData);
            }
            if (this.mMediaCas != null && formatMap.containsKey("ca-session-id")) {
                buf = (ByteBuffer)formatMap.get("ca-session-id");
                buf.rewind();
                byte[] sessionId = new byte[buf.remaining()];
                buf.get(sessionId);
                session = this.mMediaCas.createFromSessionId(sessionId);
            }
            return new CasInfo(systemId, session, privateData);
        }
        return null;
    }

    protected void finalize() {
        this.native_finalize();
    }

    public void release() {
        OverrideMethod.invokeV("android.media.MediaExtractor#release()V", true, this);
    }

    public int getTrackCount() {
        return OverrideMethod.invokeI("android.media.MediaExtractor#getTrackCount()I", true, this);
    }

    public DrmInitData getDrmInitData() {
        Map<String, Object> formatMap = this.getFileFormatNative();
        if (formatMap == null) {
            return null;
        }
        if (formatMap.containsKey("pssh")) {
            Map<UUID, byte[]> psshMap = this.getPsshInfo();
            final DrmInitData.SchemeInitData[] schemeInitDatas = (DrmInitData.SchemeInitData[])psshMap.entrySet().stream().map(entry -> new DrmInitData.SchemeInitData((UUID)entry.getKey(), "cenc", (byte[])entry.getValue())).toArray(DrmInitData.SchemeInitData[]::new);
            final Map<UUID, DrmInitData.SchemeInitData> initDataMap = Arrays.stream(schemeInitDatas).collect(Collectors.toMap(initData -> initData.uuid, initData -> initData));
            return new DrmInitData(){

                @Override
                public DrmInitData.SchemeInitData get(UUID schemeUuid) {
                    return (DrmInitData.SchemeInitData)initDataMap.get(schemeUuid);
                }

                @Override
                public int getSchemeInitDataCount() {
                    return schemeInitDatas.length;
                }

                @Override
                public DrmInitData.SchemeInitData getSchemeInitDataAt(int index) {
                    return schemeInitDatas[index];
                }
            };
        }
        int numTracks = this.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            Map<String, Object> trackFormatMap = this.getTrackFormatNative(i);
            if (!trackFormatMap.containsKey("crypto-key")) continue;
            ByteBuffer buf = (ByteBuffer)trackFormatMap.get("crypto-key");
            buf.rewind();
            byte[] data = new byte[buf.remaining()];
            buf.get(data);
            final DrmInitData.SchemeInitData webmSchemeInitData = new DrmInitData.SchemeInitData(DrmInitData.SchemeInitData.UUID_NIL, "webm", data);
            return new DrmInitData(){

                @Override
                public DrmInitData.SchemeInitData get(UUID schemeUuid) {
                    return webmSchemeInitData;
                }

                @Override
                public int getSchemeInitDataCount() {
                    return 1;
                }

                @Override
                public DrmInitData.SchemeInitData getSchemeInitDataAt(int index) {
                    return webmSchemeInitData;
                }
            };
        }
        return null;
    }

    public List<AudioPresentation> getAudioPresentations(int trackIndex) {
        return this.native_getAudioPresentations(trackIndex);
    }

    private List<AudioPresentation> native_getAudioPresentations(int n) {
        return (List)OverrideMethod.invokeA("android.media.MediaExtractor#native_getAudioPresentations(I)Ljava/util/List;", true, this);
    }

    public Map<UUID, byte[]> getPsshInfo() {
        HashMap<UUID, byte[]> psshMap = null;
        Map<String, Object> formatMap = this.getFileFormatNative();
        if (formatMap != null && formatMap.containsKey("pssh")) {
            ByteBuffer rawpssh = (ByteBuffer)formatMap.get("pssh");
            rawpssh.order(ByteOrder.nativeOrder());
            rawpssh.rewind();
            formatMap.remove("pssh");
            psshMap = new HashMap<UUID, byte[]>();
            while (rawpssh.remaining() > 0) {
                rawpssh.order(ByteOrder.BIG_ENDIAN);
                long msb = rawpssh.getLong();
                long lsb = rawpssh.getLong();
                UUID uuid = new UUID(msb, lsb);
                rawpssh.order(ByteOrder.nativeOrder());
                int datalen = rawpssh.getInt();
                byte[] psshdata = new byte[datalen];
                rawpssh.get(psshdata);
                psshMap.put(uuid, psshdata);
            }
        }
        return psshMap;
    }

    private Map<String, Object> getFileFormatNative() {
        return (Map)OverrideMethod.invokeA("android.media.MediaExtractor#getFileFormatNative()Ljava/util/Map;", true, this);
    }

    public MediaFormat getTrackFormat(int index) {
        return new MediaFormat(this.getTrackFormatNative(index));
    }

    private Map<String, Object> getTrackFormatNative(int n) {
        return (Map)OverrideMethod.invokeA("android.media.MediaExtractor#getTrackFormatNative(I)Ljava/util/Map;", true, this);
    }

    public void selectTrack(int n) {
        OverrideMethod.invokeV("android.media.MediaExtractor#selectTrack(I)V", true, this);
    }

    public void unselectTrack(int n) {
        OverrideMethod.invokeV("android.media.MediaExtractor#unselectTrack(I)V", true, this);
    }

    public void seekTo(long l, int n) {
        OverrideMethod.invokeV("android.media.MediaExtractor#seekTo(JI)V", true, this);
    }

    public boolean advance() {
        return OverrideMethod.invokeI("android.media.MediaExtractor#advance()Z", true, this) != 0;
    }

    public int readSampleData(ByteBuffer byteBuffer, int n) {
        return OverrideMethod.invokeI("android.media.MediaExtractor#readSampleData(Ljava/nio/ByteBuffer;I)I", true, this);
    }

    public int getSampleTrackIndex() {
        return OverrideMethod.invokeI("android.media.MediaExtractor#getSampleTrackIndex()I", true, this);
    }

    public long getSampleTime() {
        return OverrideMethod.invokeL("android.media.MediaExtractor#getSampleTime()J", true, this);
    }

    public long getSampleSize() {
        return OverrideMethod.invokeL("android.media.MediaExtractor#getSampleSize()J", true, this);
    }

    public int getSampleFlags() {
        return OverrideMethod.invokeI("android.media.MediaExtractor#getSampleFlags()I", true, this);
    }

    public boolean getSampleCryptoInfo(MediaCodec.CryptoInfo cryptoInfo) {
        return OverrideMethod.invokeI("android.media.MediaExtractor#getSampleCryptoInfo(Landroid/media/MediaCodec$CryptoInfo;)Z", true, this) != 0;
    }

    public long getCachedDuration() {
        return OverrideMethod.invokeL("android.media.MediaExtractor#getCachedDuration()J", true, this);
    }

    public boolean hasCacheReachedEndOfStream() {
        return OverrideMethod.invokeI("android.media.MediaExtractor#hasCacheReachedEndOfStream()Z", true, this) != 0;
    }

    public void setLogSessionId(LogSessionId logSessionId) {
        this.mLogSessionId = Objects.requireNonNull(logSessionId);
        this.native_setLogSessionId(logSessionId.getStringId());
    }

    public LogSessionId getLogSessionId() {
        return this.mLogSessionId;
    }

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private void native_setLogSessionId(String string2) {
        OverrideMethod.invokeV("android.media.MediaExtractor#native_setLogSessionId(Ljava/lang/String;)V", true, this);
    }

    private PersistableBundle native_getMetrics() {
        return (PersistableBundle)OverrideMethod.invokeA("android.media.MediaExtractor#native_getMetrics()Landroid/os/PersistableBundle;", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaExtractor#native_init()V", true, null);
    }

    private void native_setup() {
        OverrideMethod.invokeV("android.media.MediaExtractor#native_setup()V", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaExtractor#native_finalize()V", true, this);
    }

    static {
        System_Delegate.loadLibrary("media_jni");
        MediaExtractor.native_init();
    }

    public static class CasInfo {
        private final int mSystemId;
        private final MediaCas.Session mSession;
        private final byte[] mPrivateData;

        CasInfo(int systemId, MediaCas.Session session, byte[] privateData) {
            this.mSystemId = systemId;
            this.mSession = session;
            this.mPrivateData = privateData;
        }

        public int getSystemId() {
            return this.mSystemId;
        }

        public byte[] getPrivateData() {
            return this.mPrivateData;
        }

        public MediaCas.Session getSession() {
            return this.mSession;
        }
    }

    public static class MetricsConstants {
        public static final String FORMAT = "android.media.mediaextractor.fmt";
        public static final String MIME_TYPE = "android.media.mediaextractor.mime";
        public static final String TRACKS = "android.media.mediaextractor.ntrk";

        private MetricsConstants() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SampleFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeekMode {
    }
}

