/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaRouter2Utils;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class MediaRoute2Info
implements Parcelable {
    public static final Parcelable.Creator<MediaRoute2Info> CREATOR = new Parcelable.Creator<MediaRoute2Info>(){

        @Override
        public MediaRoute2Info createFromParcel(Parcel in) {
            return new MediaRoute2Info(in);
        }

        public MediaRoute2Info[] newArray(int size) {
            return new MediaRoute2Info[size];
        }
    };
    public static final String ROUTE_ID_DEVICE = "DEVICE_ROUTE";
    public static final String ROUTE_ID_DEFAULT = "DEFAULT_ROUTE";
    public static final int CONNECTION_STATE_DISCONNECTED = 0;
    public static final int CONNECTION_STATE_CONNECTING = 1;
    public static final int CONNECTION_STATE_CONNECTED = 2;
    public static final int PLAYBACK_VOLUME_FIXED = 0;
    public static final int PLAYBACK_VOLUME_VARIABLE = 1;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_BUILTIN_SPEAKER = 2;
    public static final int TYPE_WIRED_HEADSET = 3;
    public static final int TYPE_WIRED_HEADPHONES = 4;
    public static final int TYPE_BLUETOOTH_A2DP = 8;
    public static final int TYPE_HDMI = 9;
    public static final int TYPE_USB_DEVICE = 11;
    public static final int TYPE_USB_ACCESSORY = 12;
    public static final int TYPE_DOCK = 13;
    public static final int TYPE_USB_HEADSET = 22;
    public static final int TYPE_HEARING_AID = 23;
    public static final int TYPE_BLE_HEADSET = 26;
    public static final int TYPE_REMOTE_TV = 1001;
    public static final int TYPE_REMOTE_SPEAKER = 1002;
    public static final int TYPE_REMOTE_AUDIO_VIDEO_RECEIVER = 1003;
    public static final int TYPE_REMOTE_TABLET = 1004;
    public static final int TYPE_REMOTE_TABLET_DOCKED = 1005;
    public static final int TYPE_REMOTE_COMPUTER = 1006;
    public static final int TYPE_REMOTE_GAME_CONSOLE = 1007;
    public static final int TYPE_REMOTE_CAR = 1008;
    public static final int TYPE_REMOTE_SMARTWATCH = 1009;
    public static final int TYPE_REMOTE_SMARTPHONE = 1010;
    public static final int TYPE_GROUP = 2000;
    public static final String FEATURE_LIVE_AUDIO = "android.media.route.feature.LIVE_AUDIO";
    public static final String FEATURE_LIVE_VIDEO = "android.media.route.feature.LIVE_VIDEO";
    public static final String FEATURE_LOCAL_PLAYBACK = "android.media.route.feature.LOCAL_PLAYBACK";
    public static final String FEATURE_REMOTE_PLAYBACK = "android.media.route.feature.REMOTE_PLAYBACK";
    public static final String FEATURE_REMOTE_AUDIO_PLAYBACK = "android.media.route.feature.REMOTE_AUDIO_PLAYBACK";
    public static final String FEATURE_REMOTE_VIDEO_PLAYBACK = "android.media.route.feature.REMOTE_VIDEO_PLAYBACK";
    public static final String FEATURE_REMOTE_GROUP_PLAYBACK = "android.media.route.feature.REMOTE_GROUP_PLAYBACK";
    final String mId;
    final CharSequence mName;
    final List<String> mFeatures;
    final int mType;
    final boolean mIsSystem;
    final Uri mIconUri;
    final CharSequence mDescription;
    final int mConnectionState;
    final String mClientPackageName;
    final String mPackageName;
    final int mVolumeHandling;
    final int mVolumeMax;
    final int mVolume;
    final String mAddress;
    final Set<String> mDeduplicationIds;
    final Bundle mExtras;
    final String mProviderId;
    final boolean mIsVisibilityRestricted;
    final Set<String> mAllowedPackages;

    MediaRoute2Info(Builder builder) {
        this.mId = builder.mId;
        this.mName = builder.mName;
        this.mFeatures = builder.mFeatures;
        this.mType = builder.mType;
        this.mIsSystem = builder.mIsSystem;
        this.mIconUri = builder.mIconUri;
        this.mDescription = builder.mDescription;
        this.mConnectionState = builder.mConnectionState;
        this.mClientPackageName = builder.mClientPackageName;
        this.mPackageName = builder.mPackageName;
        this.mVolumeHandling = builder.mVolumeHandling;
        this.mVolumeMax = builder.mVolumeMax;
        this.mVolume = builder.mVolume;
        this.mAddress = builder.mAddress;
        this.mDeduplicationIds = builder.mDeduplicationIds;
        this.mExtras = builder.mExtras;
        this.mProviderId = builder.mProviderId;
        this.mIsVisibilityRestricted = builder.mIsVisibilityRestricted;
        this.mAllowedPackages = builder.mAllowedPackages;
    }

    MediaRoute2Info(Parcel in) {
        this.mId = in.readString();
        Preconditions.checkArgument(!TextUtils.isEmpty(this.mId));
        this.mName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mFeatures = in.createStringArrayList();
        this.mType = in.readInt();
        this.mIsSystem = in.readBoolean();
        this.mIconUri = in.readParcelable(null, Uri.class);
        this.mDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mConnectionState = in.readInt();
        this.mClientPackageName = in.readString();
        this.mPackageName = in.readString();
        this.mVolumeHandling = in.readInt();
        this.mVolumeMax = in.readInt();
        this.mVolume = in.readInt();
        this.mAddress = in.readString();
        this.mDeduplicationIds = Set.of(in.readStringArray());
        this.mExtras = in.readBundle();
        this.mProviderId = in.readString();
        this.mIsVisibilityRestricted = in.readBoolean();
        this.mAllowedPackages = Set.of(in.createString8Array());
    }

    public String getId() {
        if (!TextUtils.isEmpty(this.mProviderId)) {
            return MediaRouter2Utils.toUniqueId(this.mProviderId, this.mId);
        }
        return this.mId;
    }

    public CharSequence getName() {
        return this.mName;
    }

    public List<String> getFeatures() {
        return this.mFeatures;
    }

    public int getType() {
        return this.mType;
    }

    public boolean isSystemRoute() {
        return this.mIsSystem;
    }

    public Uri getIconUri() {
        return this.mIconUri;
    }

    public CharSequence getDescription() {
        return this.mDescription;
    }

    public int getConnectionState() {
        return this.mConnectionState;
    }

    public String getClientPackageName() {
        return this.mClientPackageName;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public int getVolumeHandling() {
        return this.mVolumeHandling;
    }

    public int getVolumeMax() {
        return this.mVolumeMax;
    }

    public int getVolume() {
        return this.mVolume;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public Set<String> getDeduplicationIds() {
        return this.mDeduplicationIds;
    }

    public Bundle getExtras() {
        return this.mExtras == null ? null : new Bundle(this.mExtras);
    }

    public String getOriginalId() {
        return this.mId;
    }

    public String getProviderId() {
        return this.mProviderId;
    }

    public boolean hasAnyFeatures(Collection<String> features) {
        Objects.requireNonNull(features, "features must not be null");
        for (String feature : features) {
            if (!this.getFeatures().contains(feature)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllFeatures(Collection<String> features) {
        Objects.requireNonNull(features, "features must not be null");
        for (String feature : features) {
            if (this.getFeatures().contains(feature)) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return !TextUtils.isEmpty(this.getId()) && !TextUtils.isEmpty(this.getName()) && !TextUtils.isEmpty(this.getProviderId());
    }

    public boolean isVisibleTo(String packageName) {
        return !this.mIsVisibilityRestricted || this.getPackageName().equals(packageName) || this.mAllowedPackages.contains(packageName);
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "MediaRoute2Info");
        String indent = prefix + "  ";
        pw.println(indent + "mId=" + this.mId);
        pw.println(indent + "mName=" + this.mName);
        pw.println(indent + "mFeatures=" + this.mFeatures);
        pw.println(indent + "mType=" + MediaRoute2Info.getDeviceTypeString(this.mType));
        pw.println(indent + "mIsSystem=" + this.mIsSystem);
        pw.println(indent + "mIconUri=" + this.mIconUri);
        pw.println(indent + "mDescription=" + this.mDescription);
        pw.println(indent + "mConnectionState=" + this.mConnectionState);
        pw.println(indent + "mClientPackageName=" + this.mClientPackageName);
        pw.println(indent + "mPackageName=" + this.mPackageName);
        this.dumpVolume(pw, indent);
        pw.println(indent + "mAddress=" + this.mAddress);
        pw.println(indent + "mDeduplicationIds=" + this.mDeduplicationIds);
        pw.println(indent + "mExtras=" + this.mExtras);
        pw.println(indent + "mProviderId=" + this.mProviderId);
        pw.println(indent + "mIsVisibilityRestricted=" + this.mIsVisibilityRestricted);
        pw.println(indent + "mAllowedPackages=" + this.mAllowedPackages);
    }

    private void dumpVolume(PrintWriter pw, String prefix) {
        String volumeHandlingName;
        switch (this.mVolumeHandling) {
            case 0: {
                volumeHandlingName = "FIXED";
                break;
            }
            case 1: {
                volumeHandlingName = "VARIABLE";
                break;
            }
            default: {
                volumeHandlingName = "UNKNOWN";
            }
        }
        String volume = String.format(Locale.US, "volume(current=%d, max=%d, handling=%s(%d))", this.mVolume, this.mVolumeMax, volumeHandlingName, this.mVolumeHandling);
        pw.println(prefix + volume);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaRoute2Info)) {
            return false;
        }
        MediaRoute2Info other = (MediaRoute2Info)obj;
        return Objects.equals(this.mId, other.mId) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mFeatures, other.mFeatures) && this.mType == other.mType && this.mIsSystem == other.mIsSystem && Objects.equals(this.mIconUri, other.mIconUri) && Objects.equals(this.mDescription, other.mDescription) && this.mConnectionState == other.mConnectionState && Objects.equals(this.mClientPackageName, other.mClientPackageName) && Objects.equals(this.mPackageName, other.mPackageName) && this.mVolumeHandling == other.mVolumeHandling && this.mVolumeMax == other.mVolumeMax && this.mVolume == other.mVolume && Objects.equals(this.mAddress, other.mAddress) && Objects.equals(this.mDeduplicationIds, other.mDeduplicationIds) && Objects.equals(this.mProviderId, other.mProviderId) && this.mIsVisibilityRestricted == other.mIsVisibilityRestricted && Objects.equals(this.mAllowedPackages, other.mAllowedPackages);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mName, this.mFeatures, this.mType, this.mIsSystem, this.mIconUri, this.mDescription, this.mConnectionState, this.mClientPackageName, this.mPackageName, this.mVolumeHandling, this.mVolumeMax, this.mVolume, this.mAddress, this.mDeduplicationIds, this.mProviderId, this.mIsVisibilityRestricted, this.mAllowedPackages);
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("MediaRoute2Info{ ").append("id=").append(this.getId()).append(", name=").append(this.getName()).append(", features=").append(this.getFeatures()).append(", iconUri=").append(this.getIconUri()).append(", description=").append(this.getDescription()).append(", connectionState=").append(this.getConnectionState()).append(", clientPackageName=").append(this.getClientPackageName()).append(", volumeHandling=").append(this.getVolumeHandling()).append(", volumeMax=").append(this.getVolumeMax()).append(", volume=").append(this.getVolume()).append(", deduplicationIds=").append(String.join((CharSequence)",", this.getDeduplicationIds())).append(", providerId=").append(this.getProviderId()).append(", isVisibilityRestricted=").append(this.mIsVisibilityRestricted).append(", allowedPackages=").append(String.join((CharSequence)",", this.mAllowedPackages)).append(" }");
        return result.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        TextUtils.writeToParcel(this.mName, dest, flags);
        dest.writeStringList(this.mFeatures);
        dest.writeInt(this.mType);
        dest.writeBoolean(this.mIsSystem);
        dest.writeParcelable(this.mIconUri, flags);
        TextUtils.writeToParcel(this.mDescription, dest, flags);
        dest.writeInt(this.mConnectionState);
        dest.writeString(this.mClientPackageName);
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mVolumeHandling);
        dest.writeInt(this.mVolumeMax);
        dest.writeInt(this.mVolume);
        dest.writeString(this.mAddress);
        dest.writeStringArray(this.mDeduplicationIds.toArray(new String[this.mDeduplicationIds.size()]));
        dest.writeBundle(this.mExtras);
        dest.writeString(this.mProviderId);
        dest.writeBoolean(this.mIsVisibilityRestricted);
        dest.writeString8Array(this.mAllowedPackages.toArray(new String[0]));
    }

    private static String getDeviceTypeString(int deviceType) {
        switch (deviceType) {
            case 2: {
                return "BUILTIN_SPEAKER";
            }
            case 3: {
                return "WIRED_HEADSET";
            }
            case 4: {
                return "WIRED_HEADPHONES";
            }
            case 8: {
                return "BLUETOOTH_A2DP";
            }
            case 9: {
                return "HDMI";
            }
            case 13: {
                return "DOCK";
            }
            case 11: {
                return "USB_DEVICE";
            }
            case 12: {
                return "USB_ACCESSORY";
            }
            case 22: {
                return "USB_HEADSET";
            }
            case 23: {
                return "HEARING_AID";
            }
            case 1001: {
                return "REMOTE_TV";
            }
            case 1002: {
                return "REMOTE_SPEAKER";
            }
            case 1003: {
                return "REMOTE_AUDIO_VIDEO_RECEIVER";
            }
            case 1004: {
                return "REMOTE_TABLET";
            }
            case 1005: {
                return "REMOTE_TABLET_DOCKED";
            }
            case 1006: {
                return "REMOTE_COMPUTER";
            }
            case 1007: {
                return "REMOTE_GAME_CONSOLE";
            }
            case 1008: {
                return "REMOTE_CAR";
            }
            case 1009: {
                return "REMOTE_SMARTWATCH";
            }
            case 1010: {
                return "REMOTE_SMARTPHONE";
            }
            case 2000: {
                return "GROUP";
            }
        }
        return TextUtils.formatSimple("UNKNOWN(%d)", deviceType);
    }

    public static class Builder {
        final String mId;
        final CharSequence mName;
        final List<String> mFeatures;
        int mType = 0;
        boolean mIsSystem;
        Uri mIconUri;
        CharSequence mDescription;
        int mConnectionState;
        String mClientPackageName;
        String mPackageName;
        int mVolumeHandling = 0;
        int mVolumeMax;
        int mVolume;
        String mAddress;
        Set<String> mDeduplicationIds;
        Bundle mExtras;
        String mProviderId;
        boolean mIsVisibilityRestricted;
        Set<String> mAllowedPackages;

        public Builder(String id2, CharSequence name) {
            if (TextUtils.isEmpty(id2)) {
                throw new IllegalArgumentException("id must not be empty");
            }
            if (TextUtils.isEmpty(name)) {
                throw new IllegalArgumentException("name must not be empty");
            }
            this.mId = id2;
            this.mName = name;
            this.mFeatures = new ArrayList<String>();
            this.mDeduplicationIds = Set.of();
            this.mAllowedPackages = Set.of();
        }

        public Builder(MediaRoute2Info routeInfo) {
            this(routeInfo.mId, routeInfo);
        }

        public Builder(String id2, MediaRoute2Info routeInfo) {
            if (TextUtils.isEmpty(id2)) {
                throw new IllegalArgumentException("id must not be empty");
            }
            Objects.requireNonNull(routeInfo, "routeInfo must not be null");
            this.mId = id2;
            this.mName = routeInfo.mName;
            this.mFeatures = new ArrayList<String>(routeInfo.mFeatures);
            this.mType = routeInfo.mType;
            this.mIsSystem = routeInfo.mIsSystem;
            this.mIconUri = routeInfo.mIconUri;
            this.mDescription = routeInfo.mDescription;
            this.mConnectionState = routeInfo.mConnectionState;
            this.mClientPackageName = routeInfo.mClientPackageName;
            this.mPackageName = routeInfo.mPackageName;
            this.mVolumeHandling = routeInfo.mVolumeHandling;
            this.mVolumeMax = routeInfo.mVolumeMax;
            this.mVolume = routeInfo.mVolume;
            this.mAddress = routeInfo.mAddress;
            this.mDeduplicationIds = Set.copyOf(routeInfo.mDeduplicationIds);
            if (routeInfo.mExtras != null) {
                this.mExtras = new Bundle(routeInfo.mExtras);
            }
            this.mProviderId = routeInfo.mProviderId;
            this.mIsVisibilityRestricted = routeInfo.mIsVisibilityRestricted;
            this.mAllowedPackages = routeInfo.mAllowedPackages;
        }

        public Builder addFeature(String feature) {
            if (TextUtils.isEmpty(feature)) {
                throw new IllegalArgumentException("feature must not be null or empty");
            }
            this.mFeatures.add(feature);
            return this;
        }

        public Builder addFeatures(Collection<String> features) {
            Objects.requireNonNull(features, "features must not be null");
            for (String feature : features) {
                this.addFeature(feature);
            }
            return this;
        }

        public Builder clearFeatures() {
            this.mFeatures.clear();
            return this;
        }

        public Builder setType(int type) {
            this.mType = type;
            return this;
        }

        public Builder setSystemRoute(boolean isSystem) {
            this.mIsSystem = isSystem;
            return this;
        }

        public Builder setIconUri(Uri iconUri) {
            this.mIconUri = iconUri;
            return this;
        }

        public Builder setDescription(CharSequence description) {
            this.mDescription = description;
            return this;
        }

        public Builder setConnectionState(int connectionState) {
            this.mConnectionState = connectionState;
            return this;
        }

        public Builder setClientPackageName(String packageName) {
            this.mClientPackageName = packageName;
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.mPackageName = packageName;
            return this;
        }

        public Builder setVolumeHandling(int volumeHandling) {
            this.mVolumeHandling = volumeHandling;
            return this;
        }

        public Builder setVolumeMax(int volumeMax) {
            this.mVolumeMax = volumeMax;
            return this;
        }

        public Builder setVolume(int volume) {
            this.mVolume = volume;
            return this;
        }

        public Builder setAddress(String address) {
            this.mAddress = address;
            return this;
        }

        public Builder setDeduplicationIds(Set<String> id2) {
            this.mDeduplicationIds = Set.copyOf(id2);
            return this;
        }

        public Builder setExtras(Bundle extras) {
            if (extras == null) {
                this.mExtras = null;
                return this;
            }
            this.mExtras = new Bundle(extras);
            return this;
        }

        public Builder setProviderId(String providerId) {
            if (TextUtils.isEmpty(providerId)) {
                throw new IllegalArgumentException("providerId must not be null or empty");
            }
            this.mProviderId = providerId;
            return this;
        }

        public Builder setVisibilityPublic() {
            this.mIsVisibilityRestricted = false;
            this.mAllowedPackages = Set.of();
            return this;
        }

        public Builder setVisibilityRestricted(Set<String> allowedPackages) {
            this.mIsVisibilityRestricted = true;
            this.mAllowedPackages = Set.copyOf(allowedPackages);
            return this;
        }

        public MediaRoute2Info build() {
            if (this.mFeatures.isEmpty()) {
                throw new IllegalArgumentException("features must not be empty!");
            }
            return new MediaRoute2Info(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlaybackVolume {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionState {
    }
}

