/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.media.AudioManager;
import android.media.IAudioService;
import android.media.audiopolicy.AudioVolumeGroup;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.util.Objects;

@SystemApi
public class VolumeInfo
implements Parcelable {
    private static final String TAG = "VolumeInfo";
    private final boolean mUsesStreamType;
    private final boolean mHasMuteCommand;
    private final boolean mIsMuted;
    private final int mVolIndex;
    private final int mMinVolIndex;
    private final int mMaxVolIndex;
    private final AudioVolumeGroup mVolGroup;
    private final int mStreamType;
    private static IAudioService sService;
    private static VolumeInfo sDefaultVolumeInfo;
    public static final int INDEX_NOT_SET = -100;
    public static final Parcelable.Creator<VolumeInfo> CREATOR;

    private VolumeInfo(boolean usesStreamType, boolean hasMuteCommand, boolean isMuted, int volIndex, int minVolIndex, int maxVolIndex, AudioVolumeGroup volGroup, int streamType) {
        this.mUsesStreamType = usesStreamType;
        this.mHasMuteCommand = hasMuteCommand;
        this.mIsMuted = isMuted;
        this.mVolIndex = volIndex;
        this.mMinVolIndex = minVolIndex;
        this.mMaxVolIndex = maxVolIndex;
        this.mVolGroup = volGroup;
        this.mStreamType = streamType;
    }

    public boolean hasStreamType() {
        return this.mUsesStreamType;
    }

    public int getStreamType() {
        if (!this.mUsesStreamType) {
            throw new IllegalStateException("VolumeInfo doesn't use stream types");
        }
        return this.mStreamType;
    }

    public boolean hasVolumeGroup() {
        return !this.mUsesStreamType;
    }

    public AudioVolumeGroup getVolumeGroup() {
        if (this.mUsesStreamType) {
            throw new IllegalStateException("VolumeInfo doesn't use AudioVolumeGroup");
        }
        return this.mVolGroup;
    }

    public boolean hasMuteCommand() {
        return this.mHasMuteCommand;
    }

    public boolean isMuted() {
        return this.mIsMuted;
    }

    public int getVolumeIndex() {
        return this.mVolIndex;
    }

    public int getMinVolumeIndex() {
        return this.mMinVolIndex;
    }

    public int getMaxVolumeIndex() {
        return this.mMaxVolIndex;
    }

    public static VolumeInfo getDefaultVolumeInfo() {
        if (sService == null) {
            IBinder b = ServiceManager.getService("audio");
            sService = IAudioService.Stub.asInterface(b);
        }
        if (sDefaultVolumeInfo == null) {
            try {
                sDefaultVolumeInfo = sService.getDefaultVolumeInfo();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling getDefaultVolumeInfo", e);
                return new Builder(3).build();
            }
        }
        return sDefaultVolumeInfo;
    }

    public int hashCode() {
        return Objects.hash(this.mUsesStreamType, this.mHasMuteCommand, this.mStreamType, this.mIsMuted, this.mVolIndex, this.mMinVolIndex, this.mMaxVolIndex, this.mVolGroup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeInfo that = (VolumeInfo)o;
        return this.mUsesStreamType == that.mUsesStreamType && this.mStreamType == that.mStreamType && this.mHasMuteCommand == that.mHasMuteCommand && this.mIsMuted == that.mIsMuted && this.mVolIndex == that.mVolIndex && this.mMinVolIndex == that.mMinVolIndex && this.mMaxVolIndex == that.mMaxVolIndex && Objects.equals(this.mVolGroup, that.mVolGroup);
    }

    public String toString() {
        return new String("VolumeInfo:" + (this.mUsesStreamType ? " streamType:" + this.mStreamType : " volGroup:" + this.mVolGroup) + (this.mHasMuteCommand ? " muted:" + this.mIsMuted : "[no mute cmd]") + (this.mVolIndex != -100 ? " volIndex:" + this.mVolIndex : "") + (this.mMinVolIndex != -100 ? " min:" + this.mMinVolIndex : "") + (this.mMaxVolIndex != -100 ? " max:" + this.mMaxVolIndex : ""));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBoolean(this.mUsesStreamType);
        dest.writeInt(this.mStreamType);
        dest.writeBoolean(this.mHasMuteCommand);
        dest.writeBoolean(this.mIsMuted);
        dest.writeInt(this.mVolIndex);
        dest.writeInt(this.mMinVolIndex);
        dest.writeInt(this.mMaxVolIndex);
        if (!this.mUsesStreamType) {
            this.mVolGroup.writeToParcel(dest, 0);
        }
    }

    private VolumeInfo(Parcel in) {
        this.mUsesStreamType = in.readBoolean();
        this.mStreamType = in.readInt();
        this.mHasMuteCommand = in.readBoolean();
        this.mIsMuted = in.readBoolean();
        this.mVolIndex = in.readInt();
        this.mMinVolIndex = in.readInt();
        this.mMaxVolIndex = in.readInt();
        this.mVolGroup = !this.mUsesStreamType ? AudioVolumeGroup.CREATOR.createFromParcel(in) : null;
    }

    static {
        CREATOR = new Parcelable.Creator<VolumeInfo>(){

            @Override
            public VolumeInfo createFromParcel(Parcel p) {
                return new VolumeInfo(p);
            }

            public VolumeInfo[] newArray(int size) {
                return new VolumeInfo[size];
            }
        };
    }

    public static class Builder {
        private boolean mUsesStreamType = true;
        private int mStreamType = 3;
        private boolean mHasMuteCommand = false;
        private boolean mIsMuted = false;
        private int mVolIndex = -100;
        private int mMinVolIndex = -100;
        private int mMaxVolIndex = -100;
        private AudioVolumeGroup mVolGroup;

        public Builder(int streamType) {
            if (!AudioManager.isPublicStreamType((int)streamType)) {
                throw new IllegalArgumentException("Not a valid public stream type " + streamType);
            }
            this.mUsesStreamType = true;
            this.mStreamType = streamType;
        }

        public Builder(AudioVolumeGroup volGroup) {
            Objects.requireNonNull(volGroup);
            this.mUsesStreamType = false;
            this.mStreamType = Integer.MIN_VALUE;
            this.mVolGroup = volGroup;
        }

        public Builder(VolumeInfo info) {
            Objects.requireNonNull(info);
            this.mUsesStreamType = info.mUsesStreamType;
            this.mStreamType = info.mStreamType;
            this.mHasMuteCommand = info.mHasMuteCommand;
            this.mIsMuted = info.mIsMuted;
            this.mVolIndex = info.mVolIndex;
            this.mMinVolIndex = info.mMinVolIndex;
            this.mMaxVolIndex = info.mMaxVolIndex;
            this.mVolGroup = info.mVolGroup;
        }

        public Builder setMuted(boolean isMuted) {
            this.mHasMuteCommand = true;
            this.mIsMuted = isMuted;
            return this;
        }

        public Builder setVolumeIndex(int volIndex) {
            if (volIndex != -100 && volIndex < 0) {
                throw new IllegalArgumentException("Volume index cannot be negative");
            }
            this.mVolIndex = volIndex;
            return this;
        }

        public Builder setMinVolumeIndex(int minIndex) {
            if (minIndex != -100 && minIndex < 0) {
                throw new IllegalArgumentException("Min volume index cannot be negative");
            }
            this.mMinVolIndex = minIndex;
            return this;
        }

        public Builder setMaxVolumeIndex(int maxIndex) {
            if (maxIndex != -100 && maxIndex < 0) {
                throw new IllegalArgumentException("Max volume index cannot be negative");
            }
            this.mMaxVolIndex = maxIndex;
            return this;
        }

        public VolumeInfo build() {
            if (this.mVolIndex != -100) {
                if (this.mMinVolIndex != -100 && this.mVolIndex < this.mMinVolIndex) {
                    throw new IllegalArgumentException("Volume index:" + this.mVolIndex + " lower than min index:" + this.mMinVolIndex);
                }
                if (this.mMaxVolIndex != -100 && this.mVolIndex > this.mMaxVolIndex) {
                    throw new IllegalArgumentException("Volume index:" + this.mVolIndex + " greater than max index:" + this.mMaxVolIndex);
                }
            }
            if (this.mMinVolIndex != -100 && this.mMaxVolIndex != -100 && this.mMinVolIndex > this.mMaxVolIndex) {
                throw new IllegalArgumentException("Min volume index:" + this.mMinVolIndex + " greater than max index:" + this.mMaxVolIndex);
            }
            return new VolumeInfo(this.mUsesStreamType, this.mHasMuteCommand, this.mIsMuted, this.mVolIndex, this.mMinVolIndex, this.mMaxVolIndex, this.mVolGroup, this.mStreamType);
        }
    }
}

