/*
 * Decompiled with CFR 0.152.
 */
package android.media.audio.common;

import android.media.AudioDescriptor;
import android.media.AudioDeviceAttributes;
import android.media.AudioFormat;
import android.media.audio.common.AudioChannelLayout;
import android.media.audio.common.AudioConfig;
import android.media.audio.common.AudioConfigBase;
import android.media.audio.common.AudioDevice;
import android.media.audio.common.AudioDeviceAddress;
import android.media.audio.common.AudioDeviceDescription;
import android.media.audio.common.AudioEncapsulationType;
import android.media.audio.common.AudioFormatDescription;
import android.media.audio.common.AudioGain;
import android.media.audio.common.AudioIoFlags;
import android.media.audio.common.AudioPort;
import android.media.audio.common.AudioPortDeviceExt;
import android.media.audio.common.AudioPortExt;
import android.media.audio.common.AudioProfile;
import android.media.audio.common.AudioStandard;
import android.media.audio.common.ExtraAudioDescriptor;
import android.os.Parcel;
import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.stream.Collectors;

@VisibleForTesting
public class AidlConversion {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int aidl2legacy_AudioChannelLayout_audio_channel_mask_t(AudioChannelLayout aidl, boolean isInput) {
        Parcel out = Parcel.obtain();
        aidl.writeToParcel(out, 0);
        out.setDataPosition(0);
        try {
            int n = AidlConversion.aidl2legacy_AudioChannelLayout_Parcel_audio_channel_mask_t(out, isInput);
            return n;
        }
        finally {
            out.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioChannelLayout legacy2aidl_audio_channel_mask_t_AudioChannelLayout(int legacy, boolean isInput) {
        Parcel in = AidlConversion.legacy2aidl_audio_channel_mask_t_AudioChannelLayout_Parcel(legacy, isInput);
        if (in != null) {
            try {
                AudioChannelLayout audioChannelLayout = AudioChannelLayout.CREATOR.createFromParcel(in);
                return audioChannelLayout;
            }
            finally {
                in.recycle();
            }
        }
        throw new IllegalArgumentException("Failed to convert legacy audio " + (isInput ? "input" : "output") + " audio_channel_mask_t " + legacy + " value");
    }

    public static int aidl2legacy_AudioFormatDescription_audio_format_t(AudioFormatDescription aidl) {
        Parcel out = Parcel.obtain();
        aidl.writeToParcel(out, 0);
        out.setDataPosition(0);
        try {
            int n = AidlConversion.aidl2legacy_AudioFormatDescription_Parcel_audio_format_t(out);
            return n;
        }
        finally {
            out.recycle();
        }
    }

    public static AudioFormatDescription legacy2aidl_audio_format_t_AudioFormatDescription(int legacy) {
        Parcel in = AidlConversion.legacy2aidl_audio_format_t_AudioFormatDescription_Parcel(legacy);
        if (in != null) {
            try {
                AudioFormatDescription audioFormatDescription = AudioFormatDescription.CREATOR.createFromParcel(in);
                return audioFormatDescription;
            }
            finally {
                in.recycle();
            }
        }
        throw new IllegalArgumentException("Failed to convert legacy audio_format_t value " + legacy);
    }

    public static int aidl2legacy_AudioEncapsulationMode_audio_encapsulation_mode_t(int n) {
        return OverrideMethod.invokeI("android.media.audio.common.AidlConversion#aidl2legacy_AudioEncapsulationMode_audio_encapsulation_mode_t(I)I", true, null);
    }

    public static int legacy2aidl_audio_encapsulation_mode_t_AudioEncapsulationMode(int n) {
        return OverrideMethod.invokeI("android.media.audio.common.AidlConversion#legacy2aidl_audio_encapsulation_mode_t_AudioEncapsulationMode(I)I", true, null);
    }

    public static int aidl2legacy_AudioStreamType_audio_stream_type_t(int n) {
        return OverrideMethod.invokeI("android.media.audio.common.AidlConversion#aidl2legacy_AudioStreamType_audio_stream_type_t(I)I", true, null);
    }

    public static int legacy2aidl_audio_stream_type_t_AudioStreamType(int n) {
        return OverrideMethod.invokeI("android.media.audio.common.AidlConversion#legacy2aidl_audio_stream_type_t_AudioStreamType(I)I", true, null);
    }

    public static int aidl2legacy_AudioUsage_audio_usage_t(int n) {
        return OverrideMethod.invokeI("android.media.audio.common.AidlConversion#aidl2legacy_AudioUsage_audio_usage_t(I)I", true, null);
    }

    public static int legacy2aidl_audio_usage_t_AudioUsage(int n) {
        return OverrideMethod.invokeI("android.media.audio.common.AidlConversion#legacy2aidl_audio_usage_t_AudioUsage(I)I", true, null);
    }

    private static int aidl2api_AudioChannelLayoutBit_AudioFormatChannel(int aidlBit, boolean isInput) {
        if (isInput) {
            switch (aidlBit) {
                case 1: {
                    return 4;
                }
                case 2: {
                    return 8;
                }
                case 4: {
                    return 262144;
                }
                case 256: {
                    return 32;
                }
                case 16: {
                    return 65536;
                }
                case 32: {
                    return 131072;
                }
                case 8: {
                    return 0x100000;
                }
                case 262144: {
                    return 0x200000;
                }
                case 524288: {
                    return 0x400000;
                }
            }
            return 0;
        }
        switch (aidlBit) {
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 8: {
                return 32;
            }
            case 16: {
                return 64;
            }
            case 32: {
                return 128;
            }
            case 64: {
                return 256;
            }
            case 128: {
                return 512;
            }
            case 256: {
                return 1024;
            }
            case 512: {
                return 2048;
            }
            case 1024: {
                return 4096;
            }
            case 2048: {
                return 8192;
            }
            case 4096: {
                return 16384;
            }
            case 8192: {
                return 32768;
            }
            case 16384: {
                return 65536;
            }
            case 32768: {
                return 131072;
            }
            case 65536: {
                return 262144;
            }
            case 131072: {
                return 524288;
            }
            case 262144: {
                return 0x100000;
            }
            case 524288: {
                return 0x200000;
            }
            case 0x100000: {
                return 0x400000;
            }
            case 0x200000: {
                return 0x800000;
            }
            case 0x400000: {
                return 0x1000000;
            }
            case 0x800000: {
                return 0x2000000;
            }
            case 0x1000000: {
                return 0x4000000;
            }
            case 0x2000000: {
                return 0x8000000;
            }
            case 0x40000000: {
                return 0x20000000;
            }
            case 0x20000000: {
                return 0x10000000;
            }
        }
        return 0;
    }

    private static int aidl2api_AudioChannelLayoutBitMask_AudioFormatChannelMask(int aidlBitMask, boolean isInput) {
        int apiMask = 0;
        for (int bit = Integer.MIN_VALUE; bit != 0; bit >>>= 1) {
            if ((aidlBitMask & bit) != bit) continue;
            int apiBit = AidlConversion.aidl2api_AudioChannelLayoutBit_AudioFormatChannel(bit, isInput);
            if (apiBit == 0) break;
            apiMask |= apiBit;
            if ((aidlBitMask &= ~bit) != 0) continue;
            return apiMask;
        }
        return 0;
    }

    public static int aidl2api_AudioChannelLayout_AudioFormatChannelMask(AudioChannelLayout aidlMask, boolean isInput) {
        switch (aidlMask.getTag()) {
            case 0: {
                return isInput ? 1 : 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return aidlMask.getIndexMask();
            }
            case 3: {
                if (isInput) {
                    switch (aidlMask.getLayoutMask()) {
                        case 1: {
                            return 16;
                        }
                        case 3: {
                            return 12;
                        }
                        case 260: {
                            return 48;
                        }
                        case 786435: {
                            return 0x60000C;
                        }
                        case 786443: {
                            return 0x70000C;
                        }
                        case 786439: {
                            return 6553612;
                        }
                        case 786447: {
                            return 7602188;
                        }
                        case 63: {
                            return 1507340;
                        }
                    }
                } else {
                    switch (aidlMask.getLayoutMask()) {
                        case 1: {
                            return 4;
                        }
                        case 3: {
                            return 12;
                        }
                        case 11: {
                            return 44;
                        }
                        case 7: {
                            return 28;
                        }
                        case 259: {
                            return 1036;
                        }
                        case 15: {
                            return 60;
                        }
                        case 786435: {
                            return 0x30000C;
                        }
                        case 786443: {
                            return 3145772;
                        }
                        case 786439: {
                            return 3145756;
                        }
                        case 786447: {
                            return 0x30003C;
                        }
                        case 51: {
                            return 204;
                        }
                        case 1539: {
                            return 6156;
                        }
                        case 263: {
                            return 1052;
                        }
                        case 55: {
                            return 220;
                        }
                        case 63: {
                            return 252;
                        }
                        case 1551: {
                            return 6204;
                        }
                        case 786495: {
                            return 3145980;
                        }
                        case 184383: {
                            return 737532;
                        }
                        case 319: {
                            return 1276;
                        }
                        case 1599: {
                            return 6396;
                        }
                        case 788031: {
                            return 3152124;
                        }
                        case 185919: {
                            return 743676;
                        }
                        case 50517567: {
                            return 202070268;
                        }
                        case 51303999: {
                            return 205215996;
                        }
                        case 7534087: {
                            return 30136348;
                        }
                        case 0xFFFFFF: {
                            return 0x3FFFFFC;
                        }
                        case 0x40000001: {
                            return 0x20000004;
                        }
                        case 0x40000003: {
                            return 0x2000000C;
                        }
                        case 0x60000000: {
                            return 0x30000000;
                        }
                        case 0x60000001: {
                            return 0x30000004;
                        }
                        case 0x60000003: {
                            return 0x3000000C;
                        }
                        case 260: {
                            return 1040;
                        }
                    }
                }
                return AidlConversion.aidl2api_AudioChannelLayoutBitMask_AudioFormatChannelMask(aidlMask.getLayoutMask(), isInput);
            }
            case 4: {
                if (isInput) {
                    switch (aidlMask.getVoiceMask()) {
                        case 16384: {
                            return 16400;
                        }
                        case 32768: {
                            return 32784;
                        }
                        case 49152: {
                            return 49168;
                        }
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public static AudioFormat aidl2api_AudioConfig_AudioFormat(AudioConfig aidl, boolean isInput) {
        return AidlConversion.aidl2api_AudioConfigBase_AudioFormat(aidl.base, isInput);
    }

    public static AudioFormat aidl2api_AudioConfigBase_AudioFormat(AudioConfigBase aidl, boolean isInput) {
        AudioFormat.Builder apiBuilder = new AudioFormat.Builder();
        apiBuilder.setSampleRate(aidl.sampleRate);
        if (aidl.channelMask.getTag() != 2) {
            apiBuilder.setChannelMask(AidlConversion.aidl2api_AudioChannelLayout_AudioFormatChannelMask(aidl.channelMask, isInput));
        } else {
            apiBuilder.setChannelIndexMask(AidlConversion.aidl2api_AudioChannelLayout_AudioFormatChannelMask(aidl.channelMask, isInput));
        }
        apiBuilder.setEncoding(AidlConversion.aidl2api_AudioFormat_AudioFormatEncoding(aidl.format));
        return apiBuilder.build();
    }

    public static int aidl2api_AudioFormat_AudioFormatEncoding(AudioFormatDescription aidl) {
        switch (aidl.type) {
            case 1: {
                switch (aidl.pcm) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 22;
                    }
                    case 3: 
                    case 4: {
                        return 4;
                    }
                    case 5: {
                        return 21;
                    }
                }
                return 0;
            }
            case 0: {
                if (aidl.encoding != null && !aidl.encoding.isEmpty()) {
                    if ("audio/ac3".equals(aidl.encoding)) {
                        return 5;
                    }
                    if ("audio/eac3".equals(aidl.encoding)) {
                        return 6;
                    }
                    if ("audio/vnd.dts".equals(aidl.encoding)) {
                        return 7;
                    }
                    if ("audio/vnd.dts.hd".equals(aidl.encoding)) {
                        return 8;
                    }
                    if ("audio/mpeg".equals(aidl.encoding)) {
                        return 9;
                    }
                    if ("audio/mp4a.40.02".equals(aidl.encoding)) {
                        return 10;
                    }
                    if ("audio/mp4a.40.05".equals(aidl.encoding)) {
                        return 11;
                    }
                    if ("audio/mp4a.40.29".equals(aidl.encoding)) {
                        return 12;
                    }
                    if ("audio/x-iec61937".equals(aidl.encoding) && aidl.pcm == 1) {
                        return 13;
                    }
                    if ("audio/vnd.dolby.mlp".equals(aidl.encoding)) {
                        return 14;
                    }
                    if ("audio/mp4a.40.39".equals(aidl.encoding)) {
                        return 15;
                    }
                    if ("audio/mp4a.40.42".equals(aidl.encoding)) {
                        return 16;
                    }
                    if ("audio/ac4".equals(aidl.encoding)) {
                        return 17;
                    }
                    if ("audio/eac3-joc".equals(aidl.encoding)) {
                        return 18;
                    }
                    if ("audio/vnd.dolby.mat".equals(aidl.encoding) || aidl.encoding.startsWith("audio/vnd.dolby.mat.")) {
                        return 19;
                    }
                    if ("audio/opus".equals(aidl.encoding)) {
                        return 20;
                    }
                    if ("audio/mhm1.03".equals(aidl.encoding)) {
                        return 23;
                    }
                    if ("audio/mhm1.04".equals(aidl.encoding)) {
                        return 24;
                    }
                    if ("audio/mhm1.0d".equals(aidl.encoding)) {
                        return 25;
                    }
                    if ("audio/mhm1.0e".equals(aidl.encoding)) {
                        return 26;
                    }
                    if ("audio/vnd.dts.uhd".equals(aidl.encoding)) {
                        return 27;
                    }
                    if ("audio/vnd.dra".equals(aidl.encoding)) {
                        return 28;
                    }
                    return 0;
                }
                return 1;
            }
        }
        return 0;
    }

    public static AudioPort api2aidl_AudioDeviceAttributes_AudioPort(AudioDeviceAttributes attributes) {
        AudioPort port = new AudioPort();
        port.name = attributes.getName();
        port.profiles = new AudioProfile[0];
        port.extraAudioDescriptors = (ExtraAudioDescriptor[])attributes.getAudioDescriptors().stream().map(descriptor -> AidlConversion.api2aidl_AudioDescriptor_ExtraAudioDescriptor(descriptor)).collect(Collectors.toList()).toArray(ExtraAudioDescriptor[]::new);
        port.flags = new AudioIoFlags();
        port.gains = new AudioGain[0];
        AudioPortDeviceExt deviceExt = new AudioPortDeviceExt();
        deviceExt.device = new AudioDevice();
        deviceExt.encodedFormats = new AudioFormatDescription[0];
        deviceExt.device.type = AidlConversion.api2aidl_NativeType_AudioDeviceDescription(attributes.getInternalType());
        deviceExt.device.address = AudioDeviceAddress.id(attributes.getAddress());
        port.ext = AudioPortExt.device(deviceExt);
        return port;
    }

    public static ExtraAudioDescriptor api2aidl_AudioDescriptor_ExtraAudioDescriptor(AudioDescriptor descriptor) {
        ExtraAudioDescriptor extraDescriptor = new ExtraAudioDescriptor();
        extraDescriptor.standard = AidlConversion.api2aidl_AudioDescriptorStandard_AudioStandard(descriptor.getStandard());
        extraDescriptor.audioDescriptor = descriptor.getDescriptor();
        extraDescriptor.encapsulationType = AidlConversion.api2aidl_AudioProfileEncapsulationType_AudioEncapsulationType(descriptor.getEncapsulationType());
        return extraDescriptor;
    }

    public static AudioDescriptor aidl2api_ExtraAudioDescriptor_AudioDescriptor(ExtraAudioDescriptor extraDescriptor) {
        AudioDescriptor descriptor = new AudioDescriptor(AidlConversion.aidl2api_AudioStandard_AudioDescriptorStandard(extraDescriptor.standard), AidlConversion.aidl2api_AudioEncapsulationType_AudioProfileEncapsulationType(extraDescriptor.encapsulationType), extraDescriptor.audioDescriptor);
        return descriptor;
    }

    @AudioStandard
    public static int api2aidl_AudioDescriptorStandard_AudioStandard(int standard) {
        switch (standard) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public static int aidl2api_AudioStandard_AudioDescriptorStandard(@AudioStandard int standard) {
        switch (standard) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    @AudioEncapsulationType
    public static int api2aidl_AudioProfileEncapsulationType_AudioEncapsulationType(int type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public static int aidl2api_AudioEncapsulationType_AudioProfileEncapsulationType(@AudioEncapsulationType int type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public static AudioDeviceDescription api2aidl_NativeType_AudioDeviceDescription(int nativeType) {
        AudioDeviceDescription aidl = new AudioDeviceDescription();
        aidl.connection = "";
        switch (nativeType) {
            case 1: {
                aidl.type = 141;
                break;
            }
            case 2: {
                aidl.type = 140;
                break;
            }
            case 8: {
                aidl.type = 136;
                aidl.connection = "analog";
                break;
            }
            case 16: {
                aidl.type = 133;
                aidl.connection = "bt-sco";
                break;
            }
            case 64: {
                aidl.type = 132;
                aidl.connection = "bt-sco";
                break;
            }
            case 256: {
                aidl.type = 136;
                aidl.connection = "bt-a2dp";
                break;
            }
            case 512: {
                aidl.type = 140;
                aidl.connection = "bt-a2dp";
                break;
            }
            case 65536: {
                aidl.type = 144;
                break;
            }
            case 0x200000: {
                aidl.type = 139;
                break;
            }
            case 0x400000: {
                aidl.type = 142;
                break;
            }
            case 0x8000000: {
                aidl.type = 138;
                aidl.connection = "wireless";
                break;
            }
            case 0x10000000: {
                aidl.type = 134;
                break;
            }
            case 0x20000001: {
                aidl.type = 140;
                aidl.connection = "bt-le";
                break;
            }
            case 0x20000002: {
                aidl.type = 146;
                aidl.connection = "bt-le";
                break;
            }
            case -2147483644: {
                aidl.type = 9;
                break;
            }
            case -2147483520: {
                aidl.type = 10;
                break;
            }
            case -2147483584: {
                aidl.type = 12;
                break;
            }
            case -2147467264: {
                aidl.type = 13;
                break;
            }
            case -2147221504: {
                aidl.type = 8;
                break;
            }
            case -2080374784: {
                aidl.type = 4;
                aidl.connection = "bt-le";
                break;
            }
            case -1879048192: {
                aidl.type = 5;
                break;
            }
            case -2147483632: {
                aidl.type = 7;
                aidl.connection = "analog";
                break;
            }
            case 4: {
                aidl.type = 137;
                aidl.connection = "analog";
                break;
            }
            case -2147483640: {
                aidl.type = 7;
                aidl.connection = "bt-sco";
                break;
            }
            case 32: {
                aidl.type = 137;
                aidl.connection = "bt-sco";
                break;
            }
            case -2147483616: {
                aidl.type = 4;
                aidl.connection = "hdmi";
                break;
            }
            case 1024: {
                aidl.type = 133;
                aidl.connection = "hdmi";
                break;
            }
            case -2147483392: {
                aidl.type = 11;
                break;
            }
            case 32768: {
                aidl.type = 143;
                break;
            }
            case -2147483136: {
                aidl.type = 14;
                aidl.connection = "analog";
                break;
            }
            case 2048: {
                aidl.type = 145;
                aidl.connection = "analog";
                break;
            }
            case -2147482624: {
                aidl.type = 14;
                aidl.connection = "usb";
                break;
            }
            case 4096: {
                aidl.type = 145;
                aidl.connection = "usb";
                break;
            }
            case -2147481600: {
                aidl.type = 2;
                aidl.connection = "usb";
                break;
            }
            case 8192: {
                aidl.type = 130;
                aidl.connection = "usb";
                break;
            }
            case -2147479552: {
                aidl.type = 4;
                aidl.connection = "usb";
                break;
            }
            case 16384: {
                aidl.type = 133;
                aidl.connection = "usb";
                break;
            }
            case -2147475456: {
                aidl.type = 6;
                break;
            }
            case 0x100000: {
                aidl.type = 135;
                break;
            }
            case -2147450880: {
                aidl.type = 4;
                aidl.connection = "analog";
                break;
            }
            case 131072: {
                aidl.type = 133;
                aidl.connection = "analog";
                break;
            }
            case -2147418112: {
                aidl.type = 4;
                aidl.connection = "spdif";
                break;
            }
            case 524288: {
                aidl.type = 133;
                aidl.connection = "spdif";
                break;
            }
            case -2147352576: {
                aidl.type = 4;
                aidl.connection = "bt-a2dp";
                break;
            }
            case 128: {
                aidl.type = 133;
                aidl.connection = "bt-a2dp";
                break;
            }
            case -2146959360: {
                aidl.type = 4;
                aidl.connection = "ip-v4";
                break;
            }
            case 0x800000: {
                aidl.type = 133;
                aidl.connection = "ip-v4";
                break;
            }
            case -2146435072: {
                aidl.type = 4;
                aidl.connection = "bus";
                break;
            }
            case 0x1000000: {
                aidl.type = 133;
                aidl.connection = "bus";
                break;
            }
            case -2130706432: {
                aidl.type = 3;
                break;
            }
            case 0x2000000: {
                aidl.type = 131;
                break;
            }
            case -2113929216: {
                aidl.type = 7;
                aidl.connection = "usb";
                break;
            }
            case 0x4000000: {
                aidl.type = 137;
                aidl.connection = "usb";
                break;
            }
            case -2013265920: {
                aidl.type = 4;
                aidl.connection = "hdmi-arc";
                break;
            }
            case 262144: {
                aidl.type = 133;
                aidl.connection = "hdmi-arc";
                break;
            }
            case -2013265919: {
                aidl.type = 4;
                aidl.connection = "hdmi-earc";
                break;
            }
            case 262145: {
                aidl.type = 133;
                aidl.connection = "hdmi-earc";
                break;
            }
            case -1610612736: {
                aidl.type = 7;
                aidl.connection = "bt-le";
                break;
            }
            case 0x20000000: {
                aidl.type = 137;
                aidl.connection = "bt-le";
                break;
            }
            case -1073741824: {
                aidl.type = 1;
                break;
            }
            case 0x40000000: {
                aidl.type = 129;
                break;
            }
            default: {
                aidl.type = 0;
            }
        }
        return aidl;
    }

    private static int aidl2legacy_AudioChannelLayout_Parcel_audio_channel_mask_t(Parcel parcel, boolean bl) {
        return OverrideMethod.invokeI("android.media.audio.common.AidlConversion#aidl2legacy_AudioChannelLayout_Parcel_audio_channel_mask_t(Landroid/os/Parcel;Z)I", true, null);
    }

    private static Parcel legacy2aidl_audio_channel_mask_t_AudioChannelLayout_Parcel(int n, boolean bl) {
        return (Parcel)OverrideMethod.invokeA("android.media.audio.common.AidlConversion#legacy2aidl_audio_channel_mask_t_AudioChannelLayout_Parcel(IZ)Landroid/os/Parcel;", true, null);
    }

    private static int aidl2legacy_AudioFormatDescription_Parcel_audio_format_t(Parcel parcel) {
        return OverrideMethod.invokeI("android.media.audio.common.AidlConversion#aidl2legacy_AudioFormatDescription_Parcel_audio_format_t(Landroid/os/Parcel;)I", true, null);
    }

    private static Parcel legacy2aidl_audio_format_t_AudioFormatDescription_Parcel(int n) {
        return (Parcel)OverrideMethod.invokeA("android.media.audio.common.AidlConversion#legacy2aidl_audio_format_t_AudioFormatDescription_Parcel(I)Landroid/os/Parcel;", true, null);
    }
}

