/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.media.metrics.NetworkEvent;
import android.media.metrics.PlaybackErrorEvent;
import android.media.metrics.PlaybackMetrics;
import android.media.metrics.PlaybackStateEvent;
import android.media.metrics.TrackChangeEvent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;

public interface IMediaMetricsManager
extends IInterface {
    public static final String DESCRIPTOR = "android.media.metrics.IMediaMetricsManager";

    public void reportPlaybackMetrics(String var1, PlaybackMetrics var2, int var3) throws RemoteException;

    public String getPlaybackSessionId(int var1) throws RemoteException;

    public String getRecordingSessionId(int var1) throws RemoteException;

    public void reportNetworkEvent(String var1, NetworkEvent var2, int var3) throws RemoteException;

    public void reportPlaybackErrorEvent(String var1, PlaybackErrorEvent var2, int var3) throws RemoteException;

    public void reportPlaybackStateEvent(String var1, PlaybackStateEvent var2, int var3) throws RemoteException;

    public void reportTrackChangeEvent(String var1, TrackChangeEvent var2, int var3) throws RemoteException;

    public String getTranscodingSessionId(int var1) throws RemoteException;

    public String getEditingSessionId(int var1) throws RemoteException;

    public String getBundleSessionId(int var1) throws RemoteException;

    public void reportBundleMetrics(String var1, PersistableBundle var2, int var3) throws RemoteException;

    public void releaseSessionId(String var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaMetricsManager {
        static final int TRANSACTION_reportPlaybackMetrics = 1;
        static final int TRANSACTION_getPlaybackSessionId = 2;
        static final int TRANSACTION_getRecordingSessionId = 3;
        static final int TRANSACTION_reportNetworkEvent = 4;
        static final int TRANSACTION_reportPlaybackErrorEvent = 5;
        static final int TRANSACTION_reportPlaybackStateEvent = 6;
        static final int TRANSACTION_reportTrackChangeEvent = 7;
        static final int TRANSACTION_getTranscodingSessionId = 8;
        static final int TRANSACTION_getEditingSessionId = 9;
        static final int TRANSACTION_getBundleSessionId = 10;
        static final int TRANSACTION_reportBundleMetrics = 11;
        static final int TRANSACTION_releaseSessionId = 12;

        public Stub() {
            this.attachInterface(this, IMediaMetricsManager.DESCRIPTOR);
        }

        public static IMediaMetricsManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMediaMetricsManager.DESCRIPTOR);
            if (iin != null && iin instanceof IMediaMetricsManager) {
                return (IMediaMetricsManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "reportPlaybackMetrics";
                }
                case 2: {
                    return "getPlaybackSessionId";
                }
                case 3: {
                    return "getRecordingSessionId";
                }
                case 4: {
                    return "reportNetworkEvent";
                }
                case 5: {
                    return "reportPlaybackErrorEvent";
                }
                case 6: {
                    return "reportPlaybackStateEvent";
                }
                case 7: {
                    return "reportTrackChangeEvent";
                }
                case 8: {
                    return "getTranscodingSessionId";
                }
                case 9: {
                    return "getEditingSessionId";
                }
                case 10: {
                    return "getBundleSessionId";
                }
                case 11: {
                    return "reportBundleMetrics";
                }
                case 12: {
                    return "releaseSessionId";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMediaMetricsManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    PlaybackMetrics _arg1 = data.readTypedObject(PlaybackMetrics.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportPlaybackMetrics(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getPlaybackSessionId(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getRecordingSessionId(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    NetworkEvent _arg1 = data.readTypedObject(NetworkEvent.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportNetworkEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    PlaybackErrorEvent _arg1 = data.readTypedObject(PlaybackErrorEvent.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportPlaybackErrorEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    PlaybackStateEvent _arg1 = data.readTypedObject(PlaybackStateEvent.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportPlaybackStateEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    TrackChangeEvent _arg1 = data.readTypedObject(TrackChangeEvent.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportTrackChangeEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getTranscodingSessionId(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getEditingSessionId(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getBundleSessionId(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportBundleMetrics(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseSessionId(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IMediaMetricsManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMediaMetricsManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportPlaybackMetrics(String sessionId, PlaybackMetrics metrics, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(metrics, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPlaybackSessionId(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRecordingSessionId(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportNetworkEvent(String sessionId, NetworkEvent event, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(event, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportPlaybackErrorEvent(String sessionId, PlaybackErrorEvent event, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(event, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportPlaybackStateEvent(String sessionId, PlaybackStateEvent event, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(event, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportTrackChangeEvent(String sessionId, TrackChangeEvent event, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(event, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getTranscodingSessionId(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getEditingSessionId(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getBundleSessionId(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportBundleMetrics(String sessionId, PersistableBundle metrics, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeString(sessionId);
                    _data.writeTypedObject(metrics, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSessionId(String sessionId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaMetricsManager.DESCRIPTOR);
                    _data.writeString(sessionId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaMetricsManager {
        @Override
        public void reportPlaybackMetrics(String sessionId, PlaybackMetrics metrics, int userId) throws RemoteException {
        }

        @Override
        public String getPlaybackSessionId(int userId) throws RemoteException {
            return null;
        }

        @Override
        public String getRecordingSessionId(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void reportNetworkEvent(String sessionId, NetworkEvent event, int userId) throws RemoteException {
        }

        @Override
        public void reportPlaybackErrorEvent(String sessionId, PlaybackErrorEvent event, int userId) throws RemoteException {
        }

        @Override
        public void reportPlaybackStateEvent(String sessionId, PlaybackStateEvent event, int userId) throws RemoteException {
        }

        @Override
        public void reportTrackChangeEvent(String sessionId, TrackChangeEvent event, int userId) throws RemoteException {
        }

        @Override
        public String getTranscodingSessionId(int userId) throws RemoteException {
            return null;
        }

        @Override
        public String getEditingSessionId(int userId) throws RemoteException {
            return null;
        }

        @Override
        public String getBundleSessionId(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void reportBundleMetrics(String sessionId, PersistableBundle metrics, int userId) throws RemoteException {
        }

        @Override
        public void releaseSessionId(String sessionId, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

