/*
 * Decompiled with CFR 0.152.
 */
package android.media.metrics;

import android.annotation.NonNull;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PlaybackMetrics
implements Parcelable {
    public static final int STREAM_SOURCE_UNKNOWN = 0;
    public static final int STREAM_SOURCE_NETWORK = 1;
    public static final int STREAM_SOURCE_DEVICE = 2;
    public static final int STREAM_SOURCE_MIXED = 3;
    public static final int STREAM_TYPE_UNKNOWN = 0;
    public static final int STREAM_TYPE_OTHER = 1;
    public static final int STREAM_TYPE_PROGRESSIVE = 2;
    public static final int STREAM_TYPE_DASH = 3;
    public static final int STREAM_TYPE_HLS = 4;
    public static final int STREAM_TYPE_SS = 5;
    public static final int PLAYBACK_TYPE_UNKNOWN = 0;
    public static final int PLAYBACK_TYPE_VOD = 1;
    public static final int PLAYBACK_TYPE_LIVE = 2;
    public static final int PLAYBACK_TYPE_OTHER = 3;
    public static final int DRM_TYPE_NONE = 0;
    public static final int DRM_TYPE_OTHER = 1;
    public static final int DRM_TYPE_PLAY_READY = 2;
    public static final int DRM_TYPE_WIDEVINE_L1 = 3;
    public static final int DRM_TYPE_WIDEVINE_L3 = 4;
    public static final int DRM_TYPE_WV_L3_FALLBACK = 5;
    public static final int DRM_TYPE_CLEARKEY = 6;
    public static final int CONTENT_TYPE_UNKNOWN = 0;
    public static final int CONTENT_TYPE_MAIN = 1;
    public static final int CONTENT_TYPE_AD = 2;
    public static final int CONTENT_TYPE_OTHER = 3;
    private final long mMediaDurationMillis;
    private final int mStreamSource;
    private final int mStreamType;
    private final int mPlaybackType;
    private final int mDrmType;
    private final int mContentType;
    private final String mPlayerName;
    private final String mPlayerVersion;
    private final long[] mExperimentIds;
    private final int mVideoFramesPlayed;
    private final int mVideoFramesDropped;
    private final int mAudioUnderrunCount;
    private final long mNetworkBytesRead;
    private final long mLocalBytesRead;
    private final long mNetworkTransferDurationMillis;
    private final byte[] mDrmSessionId;
    private final Bundle mMetricsBundle;
    public static final Parcelable.Creator<PlaybackMetrics> CREATOR = new Parcelable.Creator<PlaybackMetrics>(){

        public PlaybackMetrics[] newArray(int size) {
            return new PlaybackMetrics[size];
        }

        @Override
        public PlaybackMetrics createFromParcel(Parcel in) {
            return new PlaybackMetrics(in);
        }
    };

    public PlaybackMetrics(long mediaDurationMillis, int streamSource, int streamType, int playbackType, int drmType, int contentType, String playerName, String playerVersion, long[] experimentIds, int videoFramesPlayed, int videoFramesDropped, int audioUnderrunCount, long networkBytesRead, long localBytesRead, long networkTransferDurationMillis, byte[] drmSessionId, Bundle extras) {
        this.mMediaDurationMillis = mediaDurationMillis;
        this.mStreamSource = streamSource;
        this.mStreamType = streamType;
        this.mPlaybackType = playbackType;
        this.mDrmType = drmType;
        this.mContentType = contentType;
        this.mPlayerName = playerName;
        this.mPlayerVersion = playerVersion;
        this.mExperimentIds = experimentIds;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mExperimentIds);
        this.mVideoFramesPlayed = videoFramesPlayed;
        this.mVideoFramesDropped = videoFramesDropped;
        this.mAudioUnderrunCount = audioUnderrunCount;
        this.mNetworkBytesRead = networkBytesRead;
        this.mLocalBytesRead = localBytesRead;
        this.mNetworkTransferDurationMillis = networkTransferDurationMillis;
        this.mDrmSessionId = drmSessionId;
        this.mMetricsBundle = extras.deepCopy();
    }

    public long getMediaDurationMillis() {
        return this.mMediaDurationMillis;
    }

    public int getStreamSource() {
        return this.mStreamSource;
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    public int getPlaybackType() {
        return this.mPlaybackType;
    }

    public int getDrmType() {
        return this.mDrmType;
    }

    public int getContentType() {
        return this.mContentType;
    }

    public String getPlayerName() {
        return this.mPlayerName;
    }

    public String getPlayerVersion() {
        return this.mPlayerVersion;
    }

    public long[] getExperimentIds() {
        return Arrays.copyOf(this.mExperimentIds, this.mExperimentIds.length);
    }

    public int getVideoFramesPlayed() {
        return this.mVideoFramesPlayed;
    }

    public int getVideoFramesDropped() {
        return this.mVideoFramesDropped;
    }

    public int getAudioUnderrunCount() {
        return this.mAudioUnderrunCount;
    }

    public long getNetworkBytesRead() {
        return this.mNetworkBytesRead;
    }

    public long getLocalBytesRead() {
        return this.mLocalBytesRead;
    }

    public long getNetworkTransferDurationMillis() {
        return this.mNetworkTransferDurationMillis;
    }

    public byte[] getDrmSessionId() {
        return this.mDrmSessionId;
    }

    public Bundle getMetricsBundle() {
        return this.mMetricsBundle;
    }

    public String toString() {
        return "PlaybackMetrics { mediaDurationMillis = " + this.mMediaDurationMillis + ", streamSource = " + this.mStreamSource + ", streamType = " + this.mStreamType + ", playbackType = " + this.mPlaybackType + ", drmType = " + this.mDrmType + ", contentType = " + this.mContentType + ", playerName = " + this.mPlayerName + ", playerVersion = " + this.mPlayerVersion + ", experimentIds = " + Arrays.toString(this.mExperimentIds) + ", videoFramesPlayed = " + this.mVideoFramesPlayed + ", videoFramesDropped = " + this.mVideoFramesDropped + ", audioUnderrunCount = " + this.mAudioUnderrunCount + ", networkBytesRead = " + this.mNetworkBytesRead + ", localBytesRead = " + this.mLocalBytesRead + ", networkTransferDurationMillis = " + this.mNetworkTransferDurationMillis + "drmSessionId = " + Arrays.toString(this.mDrmSessionId) + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaybackMetrics that = (PlaybackMetrics)o;
        return this.mMediaDurationMillis == that.mMediaDurationMillis && this.mStreamSource == that.mStreamSource && this.mStreamType == that.mStreamType && this.mPlaybackType == that.mPlaybackType && this.mDrmType == that.mDrmType && this.mContentType == that.mContentType && Objects.equals(this.mPlayerName, that.mPlayerName) && Objects.equals(this.mPlayerVersion, that.mPlayerVersion) && Arrays.equals(this.mExperimentIds, that.mExperimentIds) && this.mVideoFramesPlayed == that.mVideoFramesPlayed && this.mVideoFramesDropped == that.mVideoFramesDropped && this.mAudioUnderrunCount == that.mAudioUnderrunCount && this.mNetworkBytesRead == that.mNetworkBytesRead && this.mLocalBytesRead == that.mLocalBytesRead && this.mNetworkTransferDurationMillis == that.mNetworkTransferDurationMillis && Arrays.equals(this.mDrmSessionId, that.mDrmSessionId);
    }

    public int hashCode() {
        return Objects.hash(this.mMediaDurationMillis, this.mStreamSource, this.mStreamType, this.mPlaybackType, this.mDrmType, this.mContentType, this.mPlayerName, this.mPlayerVersion, Arrays.hashCode(this.mExperimentIds), this.mVideoFramesPlayed, this.mVideoFramesDropped, this.mAudioUnderrunCount, this.mNetworkBytesRead, this.mLocalBytesRead, this.mNetworkTransferDurationMillis, Arrays.hashCode(this.mDrmSessionId));
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        long flg = 0L;
        if (this.mPlayerName != null) {
            flg |= 0x80L;
        }
        if (this.mPlayerVersion != null) {
            flg |= 0x100L;
        }
        dest.writeLong(flg);
        dest.writeLong(this.mMediaDurationMillis);
        dest.writeInt(this.mStreamSource);
        dest.writeInt(this.mStreamType);
        dest.writeInt(this.mPlaybackType);
        dest.writeInt(this.mDrmType);
        dest.writeInt(this.mContentType);
        if (this.mPlayerName != null) {
            dest.writeString(this.mPlayerName);
        }
        if (this.mPlayerVersion != null) {
            dest.writeString(this.mPlayerVersion);
        }
        dest.writeLongArray(this.mExperimentIds);
        dest.writeInt(this.mVideoFramesPlayed);
        dest.writeInt(this.mVideoFramesDropped);
        dest.writeInt(this.mAudioUnderrunCount);
        dest.writeLong(this.mNetworkBytesRead);
        dest.writeLong(this.mLocalBytesRead);
        dest.writeLong(this.mNetworkTransferDurationMillis);
        dest.writeInt(this.mDrmSessionId.length);
        dest.writeByteArray(this.mDrmSessionId);
        dest.writeBundle(this.mMetricsBundle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    PlaybackMetrics(Parcel in) {
        long flg = in.readLong();
        long mediaDurationMillis = in.readLong();
        int streamSource = in.readInt();
        int streamType = in.readInt();
        int playbackType = in.readInt();
        int drmType = in.readInt();
        int contentType = in.readInt();
        String playerName = (flg & 0x80L) == 0L ? null : in.readString();
        String playerVersion = (flg & 0x100L) == 0L ? null : in.readString();
        long[] experimentIds = in.createLongArray();
        int videoFramesPlayed = in.readInt();
        int videoFramesDropped = in.readInt();
        int audioUnderrunCount = in.readInt();
        long networkBytesRead = in.readLong();
        long localBytesRead = in.readLong();
        long networkTransferDurationMillis = in.readLong();
        int drmSessionIdLen = in.readInt();
        byte[] drmSessionId = new byte[drmSessionIdLen];
        in.readByteArray(drmSessionId);
        Bundle extras = in.readBundle();
        this.mMediaDurationMillis = mediaDurationMillis;
        this.mStreamSource = streamSource;
        this.mStreamType = streamType;
        this.mPlaybackType = playbackType;
        this.mDrmType = drmType;
        this.mContentType = contentType;
        this.mPlayerName = playerName;
        this.mPlayerVersion = playerVersion;
        this.mExperimentIds = experimentIds;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mExperimentIds);
        this.mVideoFramesPlayed = videoFramesPlayed;
        this.mVideoFramesDropped = videoFramesDropped;
        this.mAudioUnderrunCount = audioUnderrunCount;
        this.mNetworkBytesRead = networkBytesRead;
        this.mLocalBytesRead = localBytesRead;
        this.mNetworkTransferDurationMillis = networkTransferDurationMillis;
        this.mDrmSessionId = drmSessionId;
        this.mMetricsBundle = extras;
    }

    public static class Builder {
        private long mMediaDurationMillis = -1L;
        private int mStreamSource = 0;
        private int mStreamType = 0;
        private int mPlaybackType = 0;
        private int mDrmType = 0;
        private int mContentType = 0;
        private String mPlayerName;
        private String mPlayerVersion;
        private List<Long> mExperimentIds = new ArrayList<Long>();
        private int mVideoFramesPlayed = -1;
        private int mVideoFramesDropped = -1;
        private int mAudioUnderrunCount = -1;
        private long mNetworkBytesRead = -1L;
        private long mLocalBytesRead = -1L;
        private long mNetworkTransferDurationMillis = -1L;
        private byte[] mDrmSessionId = new byte[0];
        private Bundle mMetricsBundle = new Bundle();

        public Builder setMediaDurationMillis(long value) {
            this.mMediaDurationMillis = value;
            return this;
        }

        public Builder setStreamSource(int value) {
            this.mStreamSource = value;
            return this;
        }

        public Builder setStreamType(int value) {
            this.mStreamType = value;
            return this;
        }

        public Builder setPlaybackType(int value) {
            this.mPlaybackType = value;
            return this;
        }

        public Builder setDrmType(int value) {
            this.mDrmType = value;
            return this;
        }

        public Builder setContentType(int value) {
            this.mContentType = value;
            return this;
        }

        public Builder setPlayerName(String value) {
            this.mPlayerName = value;
            return this;
        }

        public Builder setPlayerVersion(String value) {
            this.mPlayerVersion = value;
            return this;
        }

        public Builder addExperimentId(long value) {
            this.mExperimentIds.add(value);
            return this;
        }

        public Builder setVideoFramesPlayed(int value) {
            this.mVideoFramesPlayed = value;
            return this;
        }

        public Builder setVideoFramesDropped(int value) {
            this.mVideoFramesDropped = value;
            return this;
        }

        public Builder setAudioUnderrunCount(int value) {
            this.mAudioUnderrunCount = value;
            return this;
        }

        public Builder setNetworkBytesRead(long value) {
            this.mNetworkBytesRead = value;
            return this;
        }

        public Builder setLocalBytesRead(long value) {
            this.mLocalBytesRead = value;
            return this;
        }

        public Builder setNetworkTransferDurationMillis(long value) {
            this.mNetworkTransferDurationMillis = value;
            return this;
        }

        public Builder setDrmSessionId(byte[] drmSessionId) {
            this.mDrmSessionId = drmSessionId;
            return this;
        }

        public Builder setMetricsBundle(Bundle metricsBundle) {
            this.mMetricsBundle = metricsBundle;
            return this;
        }

        public PlaybackMetrics build() {
            PlaybackMetrics o = new PlaybackMetrics(this.mMediaDurationMillis, this.mStreamSource, this.mStreamType, this.mPlaybackType, this.mDrmType, this.mContentType, this.mPlayerName, this.mPlayerVersion, this.idsToLongArray(), this.mVideoFramesPlayed, this.mVideoFramesDropped, this.mAudioUnderrunCount, this.mNetworkBytesRead, this.mLocalBytesRead, this.mNetworkTransferDurationMillis, this.mDrmSessionId, this.mMetricsBundle);
            return o;
        }

        private long[] idsToLongArray() {
            long[] ids = new long[this.mExperimentIds.size()];
            for (int i = 0; i < this.mExperimentIds.size(); ++i) {
                ids[i] = this.mExperimentIds.get(i);
            }
            return ids;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ContentType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DrmType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlaybackType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StreamType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StreamSource {
    }
}

