/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.media.midi.MidiDeviceInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.io.FileDescriptor;

public interface IMidiDeviceServer
extends IInterface {
    public FileDescriptor openInputPort(IBinder var1, int var2) throws RemoteException;

    public FileDescriptor openOutputPort(IBinder var1, int var2) throws RemoteException;

    public void closePort(IBinder var1) throws RemoteException;

    public void closeDevice() throws RemoteException;

    public int connectPorts(IBinder var1, FileDescriptor var2, int var3) throws RemoteException;

    public MidiDeviceInfo getDeviceInfo() throws RemoteException;

    public void setDeviceInfo(MidiDeviceInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMidiDeviceServer {
        public static final String DESCRIPTOR = "android.media.midi.IMidiDeviceServer";
        static final int TRANSACTION_openInputPort = 1;
        static final int TRANSACTION_openOutputPort = 2;
        static final int TRANSACTION_closePort = 3;
        static final int TRANSACTION_closeDevice = 4;
        static final int TRANSACTION_connectPorts = 5;
        static final int TRANSACTION_getDeviceInfo = 6;
        static final int TRANSACTION_setDeviceInfo = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMidiDeviceServer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMidiDeviceServer) {
                return (IMidiDeviceServer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "openInputPort";
                }
                case 2: {
                    return "openOutputPort";
                }
                case 3: {
                    return "closePort";
                }
                case 4: {
                    return "closeDevice";
                }
                case 5: {
                    return "connectPorts";
                }
                case 6: {
                    return "getDeviceInfo";
                }
                case 7: {
                    return "setDeviceInfo";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    FileDescriptor _result = this.openInputPort(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeRawFileDescriptor(_result);
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    FileDescriptor _result = this.openOutputPort(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeRawFileDescriptor(_result);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.closePort(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    this.closeDevice();
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    FileDescriptor _arg1 = data.readRawFileDescriptor();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.connectPorts(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    MidiDeviceInfo _result = this.getDeviceInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    MidiDeviceInfo _arg0 = data.readTypedObject(MidiDeviceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDeviceInfo(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IMidiDeviceServer {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileDescriptor openInputPort(IBinder token, int portNumber) throws RemoteException {
                FileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(portNumber);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readRawFileDescriptor();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileDescriptor openOutputPort(IBinder token, int portNumber) throws RemoteException {
                FileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(portNumber);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readRawFileDescriptor();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closePort(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void closeDevice() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int connectPorts(IBinder token, FileDescriptor fd, int outputPortNumber) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeRawFileDescriptor(fd);
                    _data.writeInt(outputPortNumber);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MidiDeviceInfo getDeviceInfo() throws RemoteException {
                MidiDeviceInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MidiDeviceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceInfo(MidiDeviceInfo deviceInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(deviceInfo, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMidiDeviceServer {
        @Override
        public FileDescriptor openInputPort(IBinder token, int portNumber) throws RemoteException {
            return null;
        }

        @Override
        public FileDescriptor openOutputPort(IBinder token, int portNumber) throws RemoteException {
            return null;
        }

        @Override
        public void closePort(IBinder token) throws RemoteException {
        }

        @Override
        public void closeDevice() throws RemoteException {
        }

        @Override
        public int connectPorts(IBinder token, FileDescriptor fd, int outputPortNumber) throws RemoteException {
            return 0;
        }

        @Override
        public MidiDeviceInfo getDeviceInfo() throws RemoteException {
            return null;
        }

        @Override
        public void setDeviceInfo(MidiDeviceInfo deviceInfo) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

