/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.bluetooth.BluetoothDevice;
import android.media.midi.IMidiDeviceListener;
import android.media.midi.IMidiDeviceOpenCallback;
import android.media.midi.IMidiDeviceServer;
import android.media.midi.IMidiManager;
import android.media.midi.MidiDevice;
import android.media.midi.MidiDeviceInfo;
import android.media.midi.MidiDeviceServer;
import android.media.midi.MidiDeviceStatus;
import android.media.midi.MidiReceiver;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.ArraySet;
import android.util.Log;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class MidiManager {
    private static final String TAG = "MidiManager";
    public static final int TRANSPORT_MIDI_BYTE_STREAM = 1;
    public static final int TRANSPORT_UNIVERSAL_MIDI_PACKETS = 2;
    public static final String BLUETOOTH_MIDI_SERVICE_INTENT = "android.media.midi.BluetoothMidiService";
    public static final String BLUETOOTH_MIDI_SERVICE_PACKAGE = "com.android.bluetoothmidiservice";
    public static final String BLUETOOTH_MIDI_SERVICE_CLASS = "com.android.bluetoothmidiservice.BluetoothMidiService";
    private final IMidiManager mService;
    private final IBinder mToken = new Binder();
    private ConcurrentHashMap<DeviceCallback, DeviceListener> mDeviceListeners = new ConcurrentHashMap();

    public MidiManager(IMidiManager service) {
        this.mService = service;
    }

    @Deprecated
    public void registerDeviceCallback(DeviceCallback callback, Handler handler) {
        Executor executor = null;
        if (handler != null) {
            executor = handler::post;
        }
        DeviceListener deviceListener = new DeviceListener(callback, executor, 1);
        try {
            this.mService.registerListener(this.mToken, deviceListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.mDeviceListeners.put(callback, deviceListener);
    }

    public void registerDeviceCallback(int transport, Executor executor, DeviceCallback callback) {
        Objects.requireNonNull(executor);
        DeviceListener deviceListener = new DeviceListener(callback, executor, transport);
        try {
            this.mService.registerListener(this.mToken, deviceListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.mDeviceListeners.put(callback, deviceListener);
    }

    public void unregisterDeviceCallback(DeviceCallback callback) {
        DeviceListener deviceListener = this.mDeviceListeners.remove(callback);
        if (deviceListener != null) {
            try {
                this.mService.unregisterListener(this.mToken, deviceListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public MidiDeviceInfo[] getDevices() {
        try {
            return this.mService.getDevices();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Set<MidiDeviceInfo> getDevicesForTransport(int transport) {
        try {
            MidiDeviceInfo[] devices = this.mService.getDevicesForTransport(transport);
            if (devices == null) {
                return Collections.emptySet();
            }
            return new ArraySet<MidiDeviceInfo>(devices);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void sendOpenDeviceResponse(final MidiDevice device, final OnDeviceOpenedListener listener, Handler handler) {
        if (handler != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onDeviceOpened(device);
                }
            });
        } else {
            listener.onDeviceOpened(device);
        }
    }

    public void openDevice(MidiDeviceInfo deviceInfo, OnDeviceOpenedListener listener, Handler handler) {
        final MidiDeviceInfo deviceInfoF = deviceInfo;
        final OnDeviceOpenedListener listenerF = listener;
        final Handler handlerF = handler;
        IMidiDeviceOpenCallback.Stub callback = new IMidiDeviceOpenCallback.Stub(){

            @Override
            public void onDeviceOpened(IMidiDeviceServer server, IBinder deviceToken) {
                MidiDevice device = server != null ? new MidiDevice(deviceInfoF, server, MidiManager.this.mService, MidiManager.this.mToken, deviceToken) : null;
                MidiManager.this.sendOpenDeviceResponse(device, listenerF, handlerF);
            }
        };
        try {
            this.mService.openDevice(this.mToken, deviceInfo, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void openBluetoothDevice(BluetoothDevice bluetoothDevice, OnDeviceOpenedListener listener, Handler handler) {
        final OnDeviceOpenedListener listenerF = listener;
        final Handler handlerF = handler;
        Log.d(TAG, "openBluetoothDevice() " + bluetoothDevice);
        IMidiDeviceOpenCallback.Stub callback = new IMidiDeviceOpenCallback.Stub(){

            @Override
            public void onDeviceOpened(IMidiDeviceServer server, IBinder deviceToken) {
                Log.d(MidiManager.TAG, "onDeviceOpened() server:" + server);
                MidiDevice device = null;
                if (server != null) {
                    try {
                        MidiDeviceInfo deviceInfo = server.getDeviceInfo();
                        device = new MidiDevice(deviceInfo, server, MidiManager.this.mService, MidiManager.this.mToken, deviceToken);
                    }
                    catch (RemoteException e) {
                        Log.e(MidiManager.TAG, "remote exception in getDeviceInfo()");
                    }
                }
                MidiManager.this.sendOpenDeviceResponse(device, listenerF, handlerF);
            }
        };
        try {
            this.mService.openBluetoothDevice(this.mToken, bluetoothDevice, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void closeBluetoothDevice(MidiDevice midiDevice) {
        try {
            midiDevice.close();
        }
        catch (IOException ex) {
            Log.e(TAG, "Exception closing BLE-MIDI device" + ex);
        }
    }

    public MidiDeviceServer createDeviceServer(MidiReceiver[] inputPortReceivers, int numOutputPorts, String[] inputPortNames, String[] outputPortNames, Bundle properties, int type, int defaultProtocol, MidiDeviceServer.Callback callback) {
        try {
            MidiDeviceServer server = new MidiDeviceServer(this.mService, inputPortReceivers, numOutputPorts, callback);
            MidiDeviceInfo deviceInfo = this.mService.registerDeviceServer(server.getBinderInterface(), inputPortReceivers.length, numOutputPorts, inputPortNames, outputPortNames, properties, type, defaultProtocol);
            if (deviceInfo == null) {
                Log.e(TAG, "registerVirtualDevice failed");
                return null;
            }
            return server;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class DeviceListener
    extends IMidiDeviceListener.Stub {
        private final DeviceCallback mCallback;
        private final Executor mExecutor;
        private final int mTransport;

        DeviceListener(DeviceCallback callback, Executor executor, int transport) {
            this.mCallback = callback;
            this.mExecutor = executor;
            this.mTransport = transport;
        }

        @Override
        public void onDeviceAdded(MidiDeviceInfo device) {
            if (this.shouldInvokeCallback(device)) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute(() -> this.mCallback.onDeviceAdded(device));
                } else {
                    this.mCallback.onDeviceAdded(device);
                }
            }
        }

        @Override
        public void onDeviceRemoved(MidiDeviceInfo device) {
            if (this.shouldInvokeCallback(device)) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute(() -> this.mCallback.onDeviceRemoved(device));
                } else {
                    this.mCallback.onDeviceRemoved(device);
                }
            }
        }

        @Override
        public void onDeviceStatusChanged(MidiDeviceStatus status) {
            if (this.mExecutor != null) {
                this.mExecutor.execute(() -> this.mCallback.onDeviceStatusChanged(status));
            } else {
                this.mCallback.onDeviceStatusChanged(status);
            }
        }

        private boolean shouldInvokeCallback(MidiDeviceInfo device) {
            if (this.mTransport == 2) {
                return device.getDefaultProtocol() != -1;
            }
            if (this.mTransport == 1) {
                return device.getDefaultProtocol() == -1;
            }
            Log.e(MidiManager.TAG, "Invalid transport type: " + this.mTransport);
            return false;
        }
    }

    public static class DeviceCallback {
        public void onDeviceAdded(MidiDeviceInfo device) {
        }

        public void onDeviceRemoved(MidiDeviceInfo device) {
        }

        public void onDeviceStatusChanged(MidiDeviceStatus status) {
        }
    }

    public static interface OnDeviceOpenedListener {
        public void onDeviceOpened(MidiDevice var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Transport {
    }
}

