/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.media.projection.MediaProjectionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMediaProjectionWatcherCallback
extends IInterface {
    public void onStart(MediaProjectionInfo var1) throws RemoteException;

    public void onStop(MediaProjectionInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaProjectionWatcherCallback {
        public static final String DESCRIPTOR = "android.media.projection.IMediaProjectionWatcherCallback";
        static final int TRANSACTION_onStart = 1;
        static final int TRANSACTION_onStop = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaProjectionWatcherCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaProjectionWatcherCallback) {
                return (IMediaProjectionWatcherCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onStart";
                }
                case 2: {
                    return "onStop";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    MediaProjectionInfo _arg0 = data.readTypedObject(MediaProjectionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onStart(_arg0);
                    break;
                }
                case 2: {
                    MediaProjectionInfo _arg0 = data.readTypedObject(MediaProjectionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onStop(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IMediaProjectionWatcherCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStart(MediaProjectionInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStop(MediaProjectionInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaProjectionWatcherCallback {
        @Override
        public void onStart(MediaProjectionInfo info) throws RemoteException {
        }

        @Override
        public void onStop(MediaProjectionInfo info) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

