/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.app.compat.CompatChanges;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.VirtualDisplayConfig;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionCallback;
import android.os.Handler;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.view.Surface;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;

public class MediaProjection {
    private static final String TAG = "MediaProjection";
    @VisibleForTesting
    static final long MEDIA_PROJECTION_REQUIRES_CALLBACK = 269849258L;
    private final IMediaProjection mImpl;
    private final Context mContext;
    private final DisplayManager mDisplayManager;
    private final Map<Callback, CallbackRecord> mCallbacks = new ArrayMap<Callback, CallbackRecord>();

    public MediaProjection(Context context, IMediaProjection impl) {
        this(context, impl, context.getSystemService(DisplayManager.class));
    }

    @VisibleForTesting
    public MediaProjection(Context context, IMediaProjection impl, DisplayManager displayManager) {
        this.mContext = context;
        this.mImpl = impl;
        try {
            this.mImpl.start(new MediaProjectionCallback());
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to start media projection", e);
        }
        this.mDisplayManager = displayManager;
    }

    public void registerCallback(Callback callback, Handler handler) {
        Callback c = Objects.requireNonNull(callback);
        if (handler == null) {
            handler = new Handler();
        }
        this.mCallbacks.put(c, new CallbackRecord(c, handler));
    }

    public void unregisterCallback(Callback callback) {
        Callback c = Objects.requireNonNull(callback);
        this.mCallbacks.remove(c);
    }

    public VirtualDisplay createVirtualDisplay(String name, int width, int height, int dpi, boolean isSecure, Surface surface, VirtualDisplay.Callback callback, Handler handler) {
        int flags = 18;
        if (isSecure) {
            flags |= 4;
        }
        VirtualDisplayConfig.Builder builder = new VirtualDisplayConfig.Builder(name, width, height, dpi).setFlags(flags);
        if (surface != null) {
            builder.setSurface(surface);
        }
        return this.createVirtualDisplay(builder, callback, handler);
    }

    public VirtualDisplay createVirtualDisplay(String name, int width, int height, int dpi, int flags, Surface surface, VirtualDisplay.Callback callback, Handler handler) {
        if (this.shouldMediaProjectionRequireCallback() && this.mCallbacks.isEmpty()) {
            throw new IllegalStateException("Must register a callback before starting capture, to manage resources in response to MediaProjection states.");
        }
        VirtualDisplayConfig.Builder builder = new VirtualDisplayConfig.Builder(name, width, height, dpi).setFlags(flags);
        if (surface != null) {
            builder.setSurface(surface);
        }
        return this.createVirtualDisplay(builder, callback, handler);
    }

    public VirtualDisplay createVirtualDisplay(VirtualDisplayConfig.Builder virtualDisplayConfig, VirtualDisplay.Callback callback, Handler handler) {
        virtualDisplayConfig.setWindowManagerMirroringEnabled(true);
        VirtualDisplay virtualDisplay = this.mDisplayManager.createVirtualDisplay(this, virtualDisplayConfig.build(), callback, handler);
        if (virtualDisplay == null) {
            Slog.w(TAG, "Failed to create virtual display.");
            return null;
        }
        return virtualDisplay;
    }

    private boolean shouldMediaProjectionRequireCallback() {
        return CompatChanges.isChangeEnabled(269849258L);
    }

    public void stop() {
        try {
            this.mImpl.stop();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to stop projection", e);
        }
    }

    public IMediaProjection getProjection() {
        return this.mImpl;
    }

    private class MediaProjectionCallback
    extends IMediaProjectionCallback.Stub {
        private MediaProjectionCallback() {
        }

        @Override
        public void onStop() {
            Slog.v(MediaProjection.TAG, "Dispatch stop to " + MediaProjection.this.mCallbacks.size() + " callbacks.");
            for (CallbackRecord cbr : MediaProjection.this.mCallbacks.values()) {
                cbr.onStop();
            }
        }

        @Override
        public void onCapturedContentResize(int width, int height) {
            for (CallbackRecord cbr : MediaProjection.this.mCallbacks.values()) {
                cbr.onCapturedContentResize(width, height);
            }
        }

        @Override
        public void onCapturedContentVisibilityChanged(boolean isVisible) {
            for (CallbackRecord cbr : MediaProjection.this.mCallbacks.values()) {
                cbr.onCapturedContentVisibilityChanged(isVisible);
            }
        }
    }

    public static abstract class Callback {
        public void onStop() {
        }

        public void onCapturedContentResize(int width, int height) {
        }

        public void onCapturedContentVisibilityChanged(boolean isVisible) {
        }
    }

    private static class CallbackRecord
    extends Callback {
        private final Callback mCallback;
        private final Handler mHandler;

        public CallbackRecord(Callback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        @Override
        public void onStop() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onStop();
                }
            });
        }

        @Override
        public void onCapturedContentResize(int width, int height) {
            this.mHandler.post(() -> this.mCallback.onCapturedContentResize(width, height));
        }

        @Override
        public void onCapturedContentVisibilityChanged(boolean isVisible) {
            this.mHandler.post(() -> this.mCallback.onCapturedContentVisibilityChanged(isVisible));
        }
    }
}

