/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.annotation.IntRange;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MediaProjectionConfig
implements Parcelable {
    public static final int CAPTURE_REGION_USER_CHOICE = 0;
    public static final int CAPTURE_REGION_FIXED_DISPLAY = 1;
    private int mDisplayToCapture;
    private int mRegionToCapture = 0;
    public static final Parcelable.Creator<MediaProjectionConfig> CREATOR = new Parcelable.Creator<MediaProjectionConfig>(){

        public MediaProjectionConfig[] newArray(int size) {
            return new MediaProjectionConfig[size];
        }

        @Override
        public MediaProjectionConfig createFromParcel(Parcel in) {
            return new MediaProjectionConfig(in);
        }
    };

    private MediaProjectionConfig() {
    }

    private MediaProjectionConfig(int captureRegion) {
        this.mRegionToCapture = captureRegion;
    }

    public static MediaProjectionConfig createConfigForDefaultDisplay() {
        MediaProjectionConfig config = new MediaProjectionConfig(1);
        config.mDisplayToCapture = 0;
        return config;
    }

    public static MediaProjectionConfig createConfigForUserChoice() {
        return new MediaProjectionConfig(0);
    }

    private static String captureRegionToString(int value) {
        switch (value) {
            case 0: {
                return "CAPTURE_REGION_USERS_CHOICE";
            }
            case 1: {
                return "CAPTURE_REGION_GIVEN_DISPLAY";
            }
        }
        return Integer.toHexString(value);
    }

    public String toString() {
        return "MediaProjectionConfig { displayToCapture = " + this.mDisplayToCapture + ", regionToCapture = " + MediaProjectionConfig.captureRegionToString(this.mRegionToCapture) + " }";
    }

    public int getDisplayToCapture() {
        return this.mDisplayToCapture;
    }

    public int getRegionToCapture() {
        return this.mRegionToCapture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaProjectionConfig that = (MediaProjectionConfig)o;
        return this.mDisplayToCapture == that.mDisplayToCapture && this.mRegionToCapture == that.mRegionToCapture;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mDisplayToCapture;
        _hash = 31 * _hash + this.mRegionToCapture;
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mDisplayToCapture);
        dest.writeInt(this.mRegionToCapture);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    MediaProjectionConfig(Parcel in) {
        int displayToCapture = in.readInt();
        int regionToCapture = in.readInt();
        this.mDisplayToCapture = displayToCapture;
        AnnotationValidations.validate(IntRange.class, null, this.mDisplayToCapture, "from", 0L, "to", 0L);
        this.mRegionToCapture = regionToCapture;
        AnnotationValidations.validate(CaptureRegion.class, null, this.mRegionToCapture);
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CaptureRegion {
    }
}

