/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.media.session.MediaSession;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.KeyEvent;

public interface IOnMediaKeyEventDispatchedListener
extends IInterface {
    public static final String DESCRIPTOR = "android.media.session.IOnMediaKeyEventDispatchedListener";

    public void onMediaKeyEventDispatched(KeyEvent var1, String var2, MediaSession.Token var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOnMediaKeyEventDispatchedListener {
        static final int TRANSACTION_onMediaKeyEventDispatched = 1;

        public Stub() {
            this.attachInterface(this, IOnMediaKeyEventDispatchedListener.DESCRIPTOR);
        }

        public static IOnMediaKeyEventDispatchedListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOnMediaKeyEventDispatchedListener.DESCRIPTOR);
            if (iin != null && iin instanceof IOnMediaKeyEventDispatchedListener) {
                return (IOnMediaKeyEventDispatchedListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onMediaKeyEventDispatched";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOnMediaKeyEventDispatchedListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    KeyEvent _arg0 = data.readTypedObject(KeyEvent.CREATOR);
                    String _arg1 = data.readString();
                    MediaSession.Token _arg2 = data.readTypedObject(MediaSession.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.onMediaKeyEventDispatched(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IOnMediaKeyEventDispatchedListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOnMediaKeyEventDispatchedListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMediaKeyEventDispatched(KeyEvent event, String packageName, MediaSession.Token sessionToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOnMediaKeyEventDispatchedListener.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    _data.writeString(packageName);
                    _data.writeTypedObject(sessionToken, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOnMediaKeyEventDispatchedListener {
        @Override
        public void onMediaKeyEventDispatched(KeyEvent event, String packageName, MediaSession.Token sessionToken) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

