/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.media.AudioAttributes;
import android.media.MediaMetadata;
import android.media.session.ISessionController;
import android.media.session.PlaybackState;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;

public interface ISession
extends IInterface {
    public void sendEvent(String var1, Bundle var2) throws RemoteException;

    public ISessionController getController() throws RemoteException;

    public void setFlags(int var1) throws RemoteException;

    public void setActive(boolean var1) throws RemoteException;

    public void setMediaButtonReceiver(PendingIntent var1) throws RemoteException;

    public void setMediaButtonBroadcastReceiver(ComponentName var1) throws RemoteException;

    public void setLaunchPendingIntent(PendingIntent var1) throws RemoteException;

    public void destroySession() throws RemoteException;

    public void setMetadata(MediaMetadata var1, long var2, String var4) throws RemoteException;

    public void setPlaybackState(PlaybackState var1) throws RemoteException;

    public void resetQueue() throws RemoteException;

    public IBinder getBinderForSetQueue() throws RemoteException;

    public void setQueueTitle(CharSequence var1) throws RemoteException;

    public void setExtras(Bundle var1) throws RemoteException;

    public void setRatingType(int var1) throws RemoteException;

    public void setPlaybackToLocal(AudioAttributes var1) throws RemoteException;

    public void setPlaybackToRemote(int var1, int var2, String var3) throws RemoteException;

    public void setCurrentVolume(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISession {
        public static final String DESCRIPTOR = "android.media.session.ISession";
        static final int TRANSACTION_sendEvent = 1;
        static final int TRANSACTION_getController = 2;
        static final int TRANSACTION_setFlags = 3;
        static final int TRANSACTION_setActive = 4;
        static final int TRANSACTION_setMediaButtonReceiver = 5;
        static final int TRANSACTION_setMediaButtonBroadcastReceiver = 6;
        static final int TRANSACTION_setLaunchPendingIntent = 7;
        static final int TRANSACTION_destroySession = 8;
        static final int TRANSACTION_setMetadata = 9;
        static final int TRANSACTION_setPlaybackState = 10;
        static final int TRANSACTION_resetQueue = 11;
        static final int TRANSACTION_getBinderForSetQueue = 12;
        static final int TRANSACTION_setQueueTitle = 13;
        static final int TRANSACTION_setExtras = 14;
        static final int TRANSACTION_setRatingType = 15;
        static final int TRANSACTION_setPlaybackToLocal = 16;
        static final int TRANSACTION_setPlaybackToRemote = 17;
        static final int TRANSACTION_setCurrentVolume = 18;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISession) {
                return (ISession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "sendEvent";
                }
                case 2: {
                    return "getController";
                }
                case 3: {
                    return "setFlags";
                }
                case 4: {
                    return "setActive";
                }
                case 5: {
                    return "setMediaButtonReceiver";
                }
                case 6: {
                    return "setMediaButtonBroadcastReceiver";
                }
                case 7: {
                    return "setLaunchPendingIntent";
                }
                case 8: {
                    return "destroySession";
                }
                case 9: {
                    return "setMetadata";
                }
                case 10: {
                    return "setPlaybackState";
                }
                case 11: {
                    return "resetQueue";
                }
                case 12: {
                    return "getBinderForSetQueue";
                }
                case 13: {
                    return "setQueueTitle";
                }
                case 14: {
                    return "setExtras";
                }
                case 15: {
                    return "setRatingType";
                }
                case 16: {
                    return "setPlaybackToLocal";
                }
                case 17: {
                    return "setPlaybackToRemote";
                }
                case 18: {
                    return "setCurrentVolume";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendEvent(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    ISessionController _result = this.getController();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setFlags(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setActive(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.setMediaButtonReceiver(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.setMediaButtonBroadcastReceiver(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.setLaunchPendingIntent(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    this.destroySession();
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    MediaMetadata _arg0 = data.readTypedObject(MediaMetadata.CREATOR);
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setMetadata(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    PlaybackState _arg0 = data.readTypedObject(PlaybackState.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPlaybackState(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    this.resetQueue();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IBinder _result = this.getBinderForSetQueue();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 13: {
                    CharSequence _arg0 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.setQueueTitle(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.setExtras(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setRatingType(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    AudioAttributes _arg0 = data.readTypedObject(AudioAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPlaybackToLocal(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setPlaybackToRemote(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setCurrentVolume(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 17;
        }

        private static class Proxy
        implements ISession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendEvent(String event, Bundle data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(event);
                    _data.writeTypedObject(data, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ISessionController getController() throws RemoteException {
                ISessionController _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = ISessionController.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFlags(int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActive(boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(active);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMediaButtonReceiver(PendingIntent mbr) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(mbr, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMediaButtonBroadcastReceiver(ComponentName broadcastReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(broadcastReceiver, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLaunchPendingIntent(PendingIntent pi) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(pi, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroySession() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMetadata(MediaMetadata metadata, long duration, String metadataDescription) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(metadata, 0);
                    _data.writeLong(duration);
                    _data.writeString(metadataDescription);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPlaybackState(PlaybackState state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(state, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetQueue() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getBinderForSetQueue() throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setQueueTitle(CharSequence title) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (title != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(title, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExtras(Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRatingType(int type) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPlaybackToLocal(AudioAttributes attributes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributes, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPlaybackToRemote(int control, int max, String controlId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(control);
                    _data.writeInt(max);
                    _data.writeString(controlId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCurrentVolume(int currentVolume) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(currentVolume);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISession {
        @Override
        public void sendEvent(String event, Bundle data) throws RemoteException {
        }

        @Override
        public ISessionController getController() throws RemoteException {
            return null;
        }

        @Override
        public void setFlags(int flags) throws RemoteException {
        }

        @Override
        public void setActive(boolean active) throws RemoteException {
        }

        @Override
        public void setMediaButtonReceiver(PendingIntent mbr) throws RemoteException {
        }

        @Override
        public void setMediaButtonBroadcastReceiver(ComponentName broadcastReceiver) throws RemoteException {
        }

        @Override
        public void setLaunchPendingIntent(PendingIntent pi) throws RemoteException {
        }

        @Override
        public void destroySession() throws RemoteException {
        }

        @Override
        public void setMetadata(MediaMetadata metadata, long duration, String metadataDescription) throws RemoteException {
        }

        @Override
        public void setPlaybackState(PlaybackState state) throws RemoteException {
        }

        @Override
        public void resetQueue() throws RemoteException {
        }

        @Override
        public IBinder getBinderForSetQueue() throws RemoteException {
            return null;
        }

        @Override
        public void setQueueTitle(CharSequence title) throws RemoteException {
        }

        @Override
        public void setExtras(Bundle extras) throws RemoteException {
        }

        @Override
        public void setRatingType(int type) throws RemoteException {
        }

        @Override
        public void setPlaybackToLocal(AudioAttributes attributes) throws RemoteException {
        }

        @Override
        public void setPlaybackToRemote(int control, int max, String controlId) throws RemoteException {
        }

        @Override
        public void setCurrentVolume(int currentVolume) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

