/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.content.pm.ParceledListSlice;
import android.media.MediaMetadata;
import android.media.session.MediaController;
import android.media.session.PlaybackState;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;

public interface ISessionControllerCallback
extends IInterface {
    public void onEvent(String var1, Bundle var2) throws RemoteException;

    public void onSessionDestroyed() throws RemoteException;

    public void onPlaybackStateChanged(PlaybackState var1) throws RemoteException;

    public void onMetadataChanged(MediaMetadata var1) throws RemoteException;

    public void onQueueChanged(ParceledListSlice var1) throws RemoteException;

    public void onQueueTitleChanged(CharSequence var1) throws RemoteException;

    public void onExtrasChanged(Bundle var1) throws RemoteException;

    public void onVolumeInfoChanged(MediaController.PlaybackInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISessionControllerCallback {
        public static final String DESCRIPTOR = "android.media.session.ISessionControllerCallback";
        static final int TRANSACTION_onEvent = 1;
        static final int TRANSACTION_onSessionDestroyed = 2;
        static final int TRANSACTION_onPlaybackStateChanged = 3;
        static final int TRANSACTION_onMetadataChanged = 4;
        static final int TRANSACTION_onQueueChanged = 5;
        static final int TRANSACTION_onQueueTitleChanged = 6;
        static final int TRANSACTION_onExtrasChanged = 7;
        static final int TRANSACTION_onVolumeInfoChanged = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISessionControllerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISessionControllerCallback) {
                return (ISessionControllerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onEvent";
                }
                case 2: {
                    return "onSessionDestroyed";
                }
                case 3: {
                    return "onPlaybackStateChanged";
                }
                case 4: {
                    return "onMetadataChanged";
                }
                case 5: {
                    return "onQueueChanged";
                }
                case 6: {
                    return "onQueueTitleChanged";
                }
                case 7: {
                    return "onExtrasChanged";
                }
                case 8: {
                    return "onVolumeInfoChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onEvent(_arg0, _arg1);
                    break;
                }
                case 2: {
                    this.onSessionDestroyed();
                    break;
                }
                case 3: {
                    PlaybackState _arg0 = data.readTypedObject(PlaybackState.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPlaybackStateChanged(_arg0);
                    break;
                }
                case 4: {
                    MediaMetadata _arg0 = data.readTypedObject(MediaMetadata.CREATOR);
                    data.enforceNoDataAvail();
                    this.onMetadataChanged(_arg0);
                    break;
                }
                case 5: {
                    ParceledListSlice _arg0 = data.readTypedObject(ParceledListSlice.CREATOR);
                    data.enforceNoDataAvail();
                    this.onQueueChanged(_arg0);
                    break;
                }
                case 6: {
                    CharSequence _arg0 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.onQueueTitleChanged(_arg0);
                    break;
                }
                case 7: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onExtrasChanged(_arg0);
                    break;
                }
                case 8: {
                    MediaController.PlaybackInfo _arg0 = data.readTypedObject(MediaController.PlaybackInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onVolumeInfoChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements ISessionControllerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(String event, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(event);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onSessionDestroyed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPlaybackStateChanged(PlaybackState state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(state, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMetadataChanged(MediaMetadata metadata) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(metadata, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQueueChanged(ParceledListSlice queue) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(queue, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQueueTitleChanged(CharSequence title) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (title != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(title, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onExtrasChanged(Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVolumeInfoChanged(MediaController.PlaybackInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISessionControllerCallback {
        @Override
        public void onEvent(String event, Bundle extras) throws RemoteException {
        }

        @Override
        public void onSessionDestroyed() throws RemoteException {
        }

        @Override
        public void onPlaybackStateChanged(PlaybackState state) throws RemoteException {
        }

        @Override
        public void onMetadataChanged(MediaMetadata metadata) throws RemoteException {
        }

        @Override
        public void onQueueChanged(ParceledListSlice queue) throws RemoteException {
        }

        @Override
        public void onQueueTitleChanged(CharSequence title) throws RemoteException {
        }

        @Override
        public void onExtrasChanged(Bundle extras) throws RemoteException {
        }

        @Override
        public void onVolumeInfoChanged(MediaController.PlaybackInfo info) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

