/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.content.ComponentName;
import android.media.IRemoteSessionCallback;
import android.media.session.IActiveSessionsListener;
import android.media.session.IOnMediaKeyEventDispatchedListener;
import android.media.session.IOnMediaKeyEventSessionChangedListener;
import android.media.session.IOnMediaKeyListener;
import android.media.session.IOnVolumeKeyLongPressListener;
import android.media.session.ISession;
import android.media.session.ISession2TokensListener;
import android.media.session.ISessionCallback;
import android.media.session.MediaSession;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public interface ISessionManager
extends IInterface {
    public ISession createSession(String var1, ISessionCallback var2, String var3, Bundle var4, int var5) throws RemoteException;

    public List<MediaSession.Token> getSessions(ComponentName var1, int var2) throws RemoteException;

    public MediaSession.Token getMediaKeyEventSession(String var1) throws RemoteException;

    public String getMediaKeyEventSessionPackageName(String var1) throws RemoteException;

    public void dispatchMediaKeyEvent(String var1, boolean var2, KeyEvent var3, boolean var4) throws RemoteException;

    public boolean dispatchMediaKeyEventToSessionAsSystemService(String var1, KeyEvent var2, MediaSession.Token var3) throws RemoteException;

    public void dispatchVolumeKeyEvent(String var1, String var2, boolean var3, KeyEvent var4, int var5, boolean var6) throws RemoteException;

    public void dispatchVolumeKeyEventToSessionAsSystemService(String var1, String var2, KeyEvent var3, MediaSession.Token var4) throws RemoteException;

    public void dispatchAdjustVolume(String var1, String var2, int var3, int var4, int var5) throws RemoteException;

    public void addSessionsListener(IActiveSessionsListener var1, ComponentName var2, int var3) throws RemoteException;

    public void removeSessionsListener(IActiveSessionsListener var1) throws RemoteException;

    public void addSession2TokensListener(ISession2TokensListener var1, int var2) throws RemoteException;

    public void removeSession2TokensListener(ISession2TokensListener var1) throws RemoteException;

    public void registerRemoteSessionCallback(IRemoteSessionCallback var1) throws RemoteException;

    public void unregisterRemoteSessionCallback(IRemoteSessionCallback var1) throws RemoteException;

    public boolean isGlobalPriorityActive() throws RemoteException;

    public void addOnMediaKeyEventDispatchedListener(IOnMediaKeyEventDispatchedListener var1) throws RemoteException;

    public void removeOnMediaKeyEventDispatchedListener(IOnMediaKeyEventDispatchedListener var1) throws RemoteException;

    public void addOnMediaKeyEventSessionChangedListener(IOnMediaKeyEventSessionChangedListener var1, String var2) throws RemoteException;

    public void removeOnMediaKeyEventSessionChangedListener(IOnMediaKeyEventSessionChangedListener var1) throws RemoteException;

    public void setOnVolumeKeyLongPressListener(IOnVolumeKeyLongPressListener var1) throws RemoteException;

    public void setOnMediaKeyListener(IOnMediaKeyListener var1) throws RemoteException;

    public boolean isTrusted(String var1, int var2, int var3) throws RemoteException;

    public void setCustomMediaKeyDispatcher(String var1) throws RemoteException;

    public void setCustomMediaSessionPolicyProvider(String var1) throws RemoteException;

    public boolean hasCustomMediaKeyDispatcher(String var1) throws RemoteException;

    public boolean hasCustomMediaSessionPolicyProvider(String var1) throws RemoteException;

    public int getSessionPolicies(MediaSession.Token var1) throws RemoteException;

    public void setSessionPolicies(MediaSession.Token var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISessionManager {
        public static final String DESCRIPTOR = "android.media.session.ISessionManager";
        static final int TRANSACTION_createSession = 1;
        static final int TRANSACTION_getSessions = 2;
        static final int TRANSACTION_getMediaKeyEventSession = 3;
        static final int TRANSACTION_getMediaKeyEventSessionPackageName = 4;
        static final int TRANSACTION_dispatchMediaKeyEvent = 5;
        static final int TRANSACTION_dispatchMediaKeyEventToSessionAsSystemService = 6;
        static final int TRANSACTION_dispatchVolumeKeyEvent = 7;
        static final int TRANSACTION_dispatchVolumeKeyEventToSessionAsSystemService = 8;
        static final int TRANSACTION_dispatchAdjustVolume = 9;
        static final int TRANSACTION_addSessionsListener = 10;
        static final int TRANSACTION_removeSessionsListener = 11;
        static final int TRANSACTION_addSession2TokensListener = 12;
        static final int TRANSACTION_removeSession2TokensListener = 13;
        static final int TRANSACTION_registerRemoteSessionCallback = 14;
        static final int TRANSACTION_unregisterRemoteSessionCallback = 15;
        static final int TRANSACTION_isGlobalPriorityActive = 16;
        static final int TRANSACTION_addOnMediaKeyEventDispatchedListener = 17;
        static final int TRANSACTION_removeOnMediaKeyEventDispatchedListener = 18;
        static final int TRANSACTION_addOnMediaKeyEventSessionChangedListener = 19;
        static final int TRANSACTION_removeOnMediaKeyEventSessionChangedListener = 20;
        static final int TRANSACTION_setOnVolumeKeyLongPressListener = 21;
        static final int TRANSACTION_setOnMediaKeyListener = 22;
        static final int TRANSACTION_isTrusted = 23;
        static final int TRANSACTION_setCustomMediaKeyDispatcher = 24;
        static final int TRANSACTION_setCustomMediaSessionPolicyProvider = 25;
        static final int TRANSACTION_hasCustomMediaKeyDispatcher = 26;
        static final int TRANSACTION_hasCustomMediaSessionPolicyProvider = 27;
        static final int TRANSACTION_getSessionPolicies = 28;
        static final int TRANSACTION_setSessionPolicies = 29;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISessionManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISessionManager) {
                return (ISessionManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createSession";
                }
                case 2: {
                    return "getSessions";
                }
                case 3: {
                    return "getMediaKeyEventSession";
                }
                case 4: {
                    return "getMediaKeyEventSessionPackageName";
                }
                case 5: {
                    return "dispatchMediaKeyEvent";
                }
                case 6: {
                    return "dispatchMediaKeyEventToSessionAsSystemService";
                }
                case 7: {
                    return "dispatchVolumeKeyEvent";
                }
                case 8: {
                    return "dispatchVolumeKeyEventToSessionAsSystemService";
                }
                case 9: {
                    return "dispatchAdjustVolume";
                }
                case 10: {
                    return "addSessionsListener";
                }
                case 11: {
                    return "removeSessionsListener";
                }
                case 12: {
                    return "addSession2TokensListener";
                }
                case 13: {
                    return "removeSession2TokensListener";
                }
                case 14: {
                    return "registerRemoteSessionCallback";
                }
                case 15: {
                    return "unregisterRemoteSessionCallback";
                }
                case 16: {
                    return "isGlobalPriorityActive";
                }
                case 17: {
                    return "addOnMediaKeyEventDispatchedListener";
                }
                case 18: {
                    return "removeOnMediaKeyEventDispatchedListener";
                }
                case 19: {
                    return "addOnMediaKeyEventSessionChangedListener";
                }
                case 20: {
                    return "removeOnMediaKeyEventSessionChangedListener";
                }
                case 21: {
                    return "setOnVolumeKeyLongPressListener";
                }
                case 22: {
                    return "setOnMediaKeyListener";
                }
                case 23: {
                    return "isTrusted";
                }
                case 24: {
                    return "setCustomMediaKeyDispatcher";
                }
                case 25: {
                    return "setCustomMediaSessionPolicyProvider";
                }
                case 26: {
                    return "hasCustomMediaKeyDispatcher";
                }
                case 27: {
                    return "hasCustomMediaSessionPolicyProvider";
                }
                case 28: {
                    return "getSessionPolicies";
                }
                case 29: {
                    return "setSessionPolicies";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    ISessionCallback _arg1 = ISessionCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    ISession _result = this.createSession(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<MediaSession.Token> _result = this.getSessions(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    MediaSession.Token _result = this.getMediaKeyEventSession(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getMediaKeyEventSessionPackageName(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    KeyEvent _arg2 = data.readTypedObject(KeyEvent.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.dispatchMediaKeyEvent(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    KeyEvent _arg1 = data.readTypedObject(KeyEvent.CREATOR);
                    MediaSession.Token _arg2 = data.readTypedObject(MediaSession.Token.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.dispatchMediaKeyEventToSessionAsSystemService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    KeyEvent _arg3 = data.readTypedObject(KeyEvent.CREATOR);
                    int _arg4 = data.readInt();
                    boolean _arg5 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.dispatchVolumeKeyEvent(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    KeyEvent _arg2 = data.readTypedObject(KeyEvent.CREATOR);
                    MediaSession.Token _arg3 = data.readTypedObject(MediaSession.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatchVolumeKeyEventToSessionAsSystemService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.dispatchAdjustVolume(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IActiveSessionsListener _arg0 = IActiveSessionsListener.Stub.asInterface(data.readStrongBinder());
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addSessionsListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IActiveSessionsListener _arg0 = IActiveSessionsListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeSessionsListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    ISession2TokensListener _arg0 = ISession2TokensListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addSession2TokensListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    ISession2TokensListener _arg0 = ISession2TokensListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeSession2TokensListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IRemoteSessionCallback _arg0 = IRemoteSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerRemoteSessionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IRemoteSessionCallback _arg0 = IRemoteSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterRemoteSessionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    boolean _result = this.isGlobalPriorityActive();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    IOnMediaKeyEventDispatchedListener _arg0 = IOnMediaKeyEventDispatchedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addOnMediaKeyEventDispatchedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    IOnMediaKeyEventDispatchedListener _arg0 = IOnMediaKeyEventDispatchedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeOnMediaKeyEventDispatchedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    IOnMediaKeyEventSessionChangedListener _arg0 = IOnMediaKeyEventSessionChangedListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.addOnMediaKeyEventSessionChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IOnMediaKeyEventSessionChangedListener _arg0 = IOnMediaKeyEventSessionChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeOnMediaKeyEventSessionChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    IOnVolumeKeyLongPressListener _arg0 = IOnVolumeKeyLongPressListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setOnVolumeKeyLongPressListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IOnMediaKeyListener _arg0 = IOnMediaKeyListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setOnMediaKeyListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isTrusted(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setCustomMediaKeyDispatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setCustomMediaSessionPolicyProvider(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasCustomMediaKeyDispatcher(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasCustomMediaSessionPolicyProvider(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    MediaSession.Token _arg0 = data.readTypedObject(MediaSession.Token.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getSessionPolicies(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 29: {
                    MediaSession.Token _arg0 = data.readTypedObject(MediaSession.Token.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSessionPolicies(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 28;
        }

        private static class Proxy
        implements ISessionManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ISession createSession(String packageName, ISessionCallback sessionCb, String tag, Bundle sessionInfo, int userId) throws RemoteException {
                ISession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(sessionCb);
                    _data.writeString(tag);
                    _data.writeTypedObject(sessionInfo, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = ISession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MediaSession.Token> getSessions(ComponentName compName, int userId) throws RemoteException {
                ArrayList<MediaSession.Token> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(compName, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(MediaSession.Token.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaSession.Token getMediaKeyEventSession(String packageName) throws RemoteException {
                MediaSession.Token _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MediaSession.Token.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getMediaKeyEventSessionPackageName(String packageName) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchMediaKeyEvent(String packageName, boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeBoolean(asSystemService);
                    _data.writeTypedObject(keyEvent, 0);
                    _data.writeBoolean(needWakeLock);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean dispatchMediaKeyEventToSessionAsSystemService(String packageName, KeyEvent keyEvent, MediaSession.Token sessionToken) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(keyEvent, 0);
                    _data.writeTypedObject(sessionToken, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchVolumeKeyEvent(String packageName, String opPackageName, boolean asSystemService, KeyEvent keyEvent, int stream, boolean musicOnly) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(opPackageName);
                    _data.writeBoolean(asSystemService);
                    _data.writeTypedObject(keyEvent, 0);
                    _data.writeInt(stream);
                    _data.writeBoolean(musicOnly);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchVolumeKeyEventToSessionAsSystemService(String packageName, String opPackageName, KeyEvent keyEvent, MediaSession.Token sessionToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(opPackageName);
                    _data.writeTypedObject(keyEvent, 0);
                    _data.writeTypedObject(sessionToken, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchAdjustVolume(String packageName, String opPackageName, int suggestedStream, int delta, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(opPackageName);
                    _data.writeInt(suggestedStream);
                    _data.writeInt(delta);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSessionsListener(IActiveSessionsListener listener, ComponentName compName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(compName, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSessionsListener(IActiveSessionsListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSession2TokensListener(ISession2TokensListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSession2TokensListener(ISession2TokensListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerRemoteSessionCallback(IRemoteSessionCallback rvc) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(rvc);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterRemoteSessionCallback(IRemoteSessionCallback rvc) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(rvc);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isGlobalPriorityActive() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnMediaKeyEventDispatchedListener(IOnMediaKeyEventDispatchedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnMediaKeyEventDispatchedListener(IOnMediaKeyEventDispatchedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnMediaKeyEventSessionChangedListener(IOnMediaKeyEventSessionChangedListener listener, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnMediaKeyEventSessionChangedListener(IOnMediaKeyEventSessionChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnVolumeKeyLongPressListener(IOnVolumeKeyLongPressListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMediaKeyListener(IOnMediaKeyListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTrusted(String controllerPackageName, int controllerPid, int controllerUid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(controllerPackageName);
                    _data.writeInt(controllerPid);
                    _data.writeInt(controllerUid);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCustomMediaKeyDispatcher(String name) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCustomMediaSessionPolicyProvider(String name) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasCustomMediaKeyDispatcher(String componentName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(componentName);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasCustomMediaSessionPolicyProvider(String componentName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(componentName);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSessionPolicies(MediaSession.Token token) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(token, 0);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionPolicies(MediaSession.Token token, int policies) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(token, 0);
                    _data.writeInt(policies);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISessionManager {
        @Override
        public ISession createSession(String packageName, ISessionCallback sessionCb, String tag, Bundle sessionInfo, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<MediaSession.Token> getSessions(ComponentName compName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public MediaSession.Token getMediaKeyEventSession(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public String getMediaKeyEventSessionPackageName(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void dispatchMediaKeyEvent(String packageName, boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) throws RemoteException {
        }

        @Override
        public boolean dispatchMediaKeyEventToSessionAsSystemService(String packageName, KeyEvent keyEvent, MediaSession.Token sessionToken) throws RemoteException {
            return false;
        }

        @Override
        public void dispatchVolumeKeyEvent(String packageName, String opPackageName, boolean asSystemService, KeyEvent keyEvent, int stream, boolean musicOnly) throws RemoteException {
        }

        @Override
        public void dispatchVolumeKeyEventToSessionAsSystemService(String packageName, String opPackageName, KeyEvent keyEvent, MediaSession.Token sessionToken) throws RemoteException {
        }

        @Override
        public void dispatchAdjustVolume(String packageName, String opPackageName, int suggestedStream, int delta, int flags) throws RemoteException {
        }

        @Override
        public void addSessionsListener(IActiveSessionsListener listener, ComponentName compName, int userId) throws RemoteException {
        }

        @Override
        public void removeSessionsListener(IActiveSessionsListener listener) throws RemoteException {
        }

        @Override
        public void addSession2TokensListener(ISession2TokensListener listener, int userId) throws RemoteException {
        }

        @Override
        public void removeSession2TokensListener(ISession2TokensListener listener) throws RemoteException {
        }

        @Override
        public void registerRemoteSessionCallback(IRemoteSessionCallback rvc) throws RemoteException {
        }

        @Override
        public void unregisterRemoteSessionCallback(IRemoteSessionCallback rvc) throws RemoteException {
        }

        @Override
        public boolean isGlobalPriorityActive() throws RemoteException {
            return false;
        }

        @Override
        public void addOnMediaKeyEventDispatchedListener(IOnMediaKeyEventDispatchedListener listener) throws RemoteException {
        }

        @Override
        public void removeOnMediaKeyEventDispatchedListener(IOnMediaKeyEventDispatchedListener listener) throws RemoteException {
        }

        @Override
        public void addOnMediaKeyEventSessionChangedListener(IOnMediaKeyEventSessionChangedListener listener, String packageName) throws RemoteException {
        }

        @Override
        public void removeOnMediaKeyEventSessionChangedListener(IOnMediaKeyEventSessionChangedListener listener) throws RemoteException {
        }

        @Override
        public void setOnVolumeKeyLongPressListener(IOnVolumeKeyLongPressListener listener) throws RemoteException {
        }

        @Override
        public void setOnMediaKeyListener(IOnMediaKeyListener listener) throws RemoteException {
        }

        @Override
        public boolean isTrusted(String controllerPackageName, int controllerPid, int controllerUid) throws RemoteException {
            return false;
        }

        @Override
        public void setCustomMediaKeyDispatcher(String name) throws RemoteException {
        }

        @Override
        public void setCustomMediaSessionPolicyProvider(String name) throws RemoteException {
        }

        @Override
        public boolean hasCustomMediaKeyDispatcher(String componentName) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasCustomMediaSessionPolicyProvider(String componentName) throws RemoteException {
            return false;
        }

        @Override
        public int getSessionPolicies(MediaSession.Token token) throws RemoteException {
            return 0;
        }

        @Override
        public void setSessionPolicies(MediaSession.Token token, int policies) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

