/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.Context;
import android.media.IRemoteSessionCallback;
import android.media.MediaCommunicationManager;
import android.media.MediaFrameworkPlatformInitializer;
import android.media.Session2Token;
import android.media.session.IActiveSessionsListener;
import android.media.session.IOnMediaKeyEventDispatchedListener;
import android.media.session.IOnMediaKeyEventSessionChangedListener;
import android.media.session.IOnMediaKeyListener;
import android.media.session.IOnVolumeKeyLongPressListener;
import android.media.session.ISession;
import android.media.session.ISession2TokensListener;
import android.media.session.ISessionManager;
import android.media.session.MediaController;
import android.media.session.MediaSession;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class MediaSessionManager {
    private static final String TAG = "SessionManager";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int RESULT_MEDIA_KEY_NOT_HANDLED = 0;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int RESULT_MEDIA_KEY_HANDLED = 1;
    private final ISessionManager mService;
    private final MediaCommunicationManager mCommunicationManager;
    private final OnMediaKeyEventDispatchedListenerStub mOnMediaKeyEventDispatchedListenerStub = new OnMediaKeyEventDispatchedListenerStub();
    private final OnMediaKeyEventSessionChangedListenerStub mOnMediaKeyEventSessionChangedListenerStub = new OnMediaKeyEventSessionChangedListenerStub();
    private final RemoteSessionCallbackStub mRemoteSessionCallbackStub = new RemoteSessionCallbackStub();
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<OnActiveSessionsChangedListener, SessionsChangedWrapper> mListeners = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<OnSession2TokensChangedListener, Session2TokensChangedWrapper> mSession2TokensListeners = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private final Map<OnMediaKeyEventDispatchedListener, Executor> mOnMediaKeyEventDispatchedListeners = new HashMap<OnMediaKeyEventDispatchedListener, Executor>();
    @GuardedBy(value={"mLock"})
    private final Map<OnMediaKeyEventSessionChangedListener, Executor> mMediaKeyEventSessionChangedCallbacks = new HashMap<OnMediaKeyEventSessionChangedListener, Executor>();
    @GuardedBy(value={"mLock"})
    private String mCurMediaKeyEventSessionPackage = "";
    @GuardedBy(value={"mLock"})
    private MediaSession.Token mCurMediaKeyEventSession;
    @GuardedBy(value={"mLock"})
    private final Map<RemoteSessionCallback, Executor> mRemoteSessionCallbacks = new ArrayMap<RemoteSessionCallback, Executor>();
    private Context mContext;
    private OnVolumeKeyLongPressListenerImpl mOnVolumeKeyLongPressListener;
    private OnMediaKeyListenerImpl mOnMediaKeyListener;

    public MediaSessionManager(Context context) {
        this.mContext = context;
        this.mService = ISessionManager.Stub.asInterface(MediaFrameworkPlatformInitializer.getMediaServiceManager().getMediaSessionServiceRegisterer().get());
        this.mCommunicationManager = (MediaCommunicationManager)context.getSystemService("media_communication");
    }

    public ISession createSession(MediaSession.CallbackStub cbStub, String tag, Bundle sessionInfo) {
        Objects.requireNonNull(cbStub, "cbStub shouldn't be null");
        Objects.requireNonNull(tag, "tag shouldn't be null");
        try {
            return this.mService.createSession(this.mContext.getPackageName(), cbStub, tag, sessionInfo, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void notifySession2Created(Session2Token token) {
    }

    public List<MediaController> getActiveSessions(ComponentName notificationListener) {
        return this.getActiveSessionsForUser(notificationListener, UserHandle.myUserId());
    }

    public MediaSession.Token getMediaKeyEventSession() {
        try {
            return this.mService.getMediaKeyEventSession(this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get media key event session", ex);
            return null;
        }
    }

    public String getMediaKeyEventSessionPackageName() {
        try {
            String packageName = this.mService.getMediaKeyEventSessionPackageName(this.mContext.getPackageName());
            return packageName != null ? packageName : "";
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Failed to get media key event session package name", ex);
            return "";
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @SuppressLint(value={"UserHandle"})
    public List<MediaController> getActiveSessionsForUser(ComponentName notificationListener, UserHandle userHandle) {
        Objects.requireNonNull(userHandle, "userHandle shouldn't be null");
        return this.getActiveSessionsForUser(notificationListener, userHandle.getIdentifier());
    }

    private List<MediaController> getActiveSessionsForUser(ComponentName notificationListener, int userId) {
        ArrayList<MediaController> controllers = new ArrayList<MediaController>();
        try {
            List<MediaSession.Token> tokens = this.mService.getSessions(notificationListener, userId);
            int size = tokens.size();
            for (int i = 0; i < size; ++i) {
                MediaController controller = new MediaController(this.mContext, tokens.get(i));
                controllers.add(controller);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get active sessions: ", e);
        }
        return controllers;
    }

    public List<Session2Token> getSession2Tokens() {
        return this.mCommunicationManager.getSession2Tokens();
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener) {
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, null);
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener, Handler handler) {
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, UserHandle.myUserId(), handler == null ? null : new HandlerExecutor(handler));
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @SuppressLint(value={"UserHandle"})
    public void addOnActiveSessionsChangedListener(ComponentName notificationListener, UserHandle userHandle, Executor executor, OnActiveSessionsChangedListener sessionListener) {
        Objects.requireNonNull(userHandle, "userHandle shouldn't be null");
        Objects.requireNonNull(executor, "executor shouldn't be null");
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, userHandle.getIdentifier(), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener, int userId, Executor executor) {
        Objects.requireNonNull(sessionListener, "sessionListener shouldn't be null");
        if (executor == null) {
            executor = new HandlerExecutor(new Handler());
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.get(sessionListener) != null) {
                Log.w(TAG, "Attempted to add session listener twice, ignoring.");
                return;
            }
            SessionsChangedWrapper wrapper = new SessionsChangedWrapper(this.mContext, sessionListener, executor);
            try {
                this.mService.addSessionsListener(wrapper.mStub, notificationListener, userId);
                this.mListeners.put(sessionListener, wrapper);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in addOnActiveSessionsChangedListener.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener) {
        Objects.requireNonNull(sessionListener, "sessionListener shouldn't be null");
        Object object = this.mLock;
        synchronized (object) {
            SessionsChangedWrapper wrapper = this.mListeners.remove(sessionListener);
            if (wrapper != null) {
                try {
                    this.mService.removeSessionsListener(wrapper.mStub);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in removeOnActiveSessionsChangedListener.", e);
                }
                finally {
                    wrapper.release();
                }
            }
        }
    }

    public void addOnSession2TokensChangedListener(OnSession2TokensChangedListener listener) {
        this.addOnSession2TokensChangedListener(UserHandle.myUserId(), listener, (Executor)new HandlerExecutor(new Handler()));
    }

    public void addOnSession2TokensChangedListener(OnSession2TokensChangedListener listener, Handler handler) {
        Objects.requireNonNull(handler, "handler shouldn't be null");
        this.addOnSession2TokensChangedListener(UserHandle.myUserId(), listener, (Executor)new HandlerExecutor(handler));
    }

    @SuppressLint(value={"UserHandle"})
    public void addOnSession2TokensChangedListener(UserHandle userHandle, OnSession2TokensChangedListener listener, Executor executor) {
        Objects.requireNonNull(userHandle, "userHandle shouldn't be null");
        Objects.requireNonNull(executor, "executor shouldn't be null");
        this.addOnSession2TokensChangedListener(userHandle.getIdentifier(), listener, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOnSession2TokensChangedListener(int userId, OnSession2TokensChangedListener listener, Executor executor) {
        Objects.requireNonNull(listener, "listener shouldn't be null");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSession2TokensListeners.get(listener) != null) {
                Log.w(TAG, "Attempted to add session listener twice, ignoring.");
                return;
            }
            Session2TokensChangedWrapper wrapper = new Session2TokensChangedWrapper(listener, executor);
            try {
                this.mService.addSession2TokensListener(wrapper.getStub(), userId);
                this.mSession2TokensListeners.put(listener, wrapper);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in addSessionTokensListener.", e);
                e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnSession2TokensChangedListener(OnSession2TokensChangedListener listener) {
        Session2TokensChangedWrapper wrapper;
        Objects.requireNonNull(listener, "listener shouldn't be null");
        Object object = this.mLock;
        synchronized (object) {
            wrapper = this.mSession2TokensListeners.remove(listener);
        }
        if (wrapper != null) {
            try {
                this.mService.removeSession2TokensListener(wrapper.getStub());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error in removeSessionTokensListener.", e);
                e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void registerRemoteSessionCallback(Executor executor, RemoteSessionCallback callback) {
        Objects.requireNonNull(executor, "executor shouldn't be null");
        Objects.requireNonNull(callback, "callback shouldn't be null");
        boolean shouldRegisterCallback = false;
        Object object = this.mLock;
        synchronized (object) {
            int prevCallbackCount = this.mRemoteSessionCallbacks.size();
            this.mRemoteSessionCallbacks.put(callback, executor);
            if (prevCallbackCount == 0 && this.mRemoteSessionCallbacks.size() == 1) {
                shouldRegisterCallback = true;
            }
        }
        if (shouldRegisterCallback) {
            try {
                this.mService.registerRemoteSessionCallback(this.mRemoteSessionCallbackStub);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to register remote volume controller callback", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void unregisterRemoteSessionCallback(RemoteSessionCallback callback) {
        Objects.requireNonNull(callback, "callback shouldn't be null");
        boolean shouldUnregisterCallback = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRemoteSessionCallbacks.remove(callback) != null && this.mRemoteSessionCallbacks.size() == 0) {
                shouldUnregisterCallback = true;
            }
        }
        try {
            if (shouldUnregisterCallback) {
                this.mService.unregisterRemoteSessionCallback(this.mRemoteSessionCallbackStub);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to unregister remote volume controller callback", e);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        this.dispatchMediaKeyEventInternal(keyEvent, false, needWakeLock);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void dispatchMediaKeyEventAsSystemService(KeyEvent keyEvent) {
        this.dispatchMediaKeyEventInternal(keyEvent, true, true);
    }

    private void dispatchMediaKeyEventInternal(KeyEvent keyEvent, boolean asSystemService, boolean needWakeLock) {
        Objects.requireNonNull(keyEvent, "keyEvent shouldn't be null");
        try {
            this.mService.dispatchMediaKeyEvent(this.mContext.getPackageName(), asSystemService, keyEvent, needWakeLock);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send key event.", e);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean dispatchMediaKeyEventToSessionAsSystemService(KeyEvent keyEvent, MediaSession.Token sessionToken) {
        Objects.requireNonNull(sessionToken, "sessionToken shouldn't be null");
        Objects.requireNonNull(keyEvent, "keyEvent shouldn't be null");
        if (!KeyEvent.isMediaSessionKey(keyEvent.getKeyCode())) {
            return false;
        }
        try {
            return this.mService.dispatchMediaKeyEventToSessionAsSystemService(this.mContext.getPackageName(), keyEvent, sessionToken);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send key event.", e);
            return false;
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void dispatchVolumeKeyEvent(KeyEvent keyEvent, int streamType, boolean musicOnly) {
        this.dispatchVolumeKeyEventInternal(keyEvent, streamType, musicOnly, false);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void dispatchVolumeKeyEventAsSystemService(KeyEvent keyEvent, int streamType) {
        this.dispatchVolumeKeyEventInternal(keyEvent, streamType, false, true);
    }

    private void dispatchVolumeKeyEventInternal(KeyEvent keyEvent, int stream, boolean musicOnly, boolean asSystemService) {
        Objects.requireNonNull(keyEvent, "keyEvent shouldn't be null");
        try {
            this.mService.dispatchVolumeKeyEvent(this.mContext.getPackageName(), this.mContext.getOpPackageName(), asSystemService, keyEvent, stream, musicOnly);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send volume key event.", e);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void dispatchVolumeKeyEventToSessionAsSystemService(KeyEvent keyEvent, MediaSession.Token sessionToken) {
        Objects.requireNonNull(sessionToken, "sessionToken shouldn't be null");
        Objects.requireNonNull(keyEvent, "keyEvent shouldn't be null");
        try {
            this.mService.dispatchVolumeKeyEventToSessionAsSystemService(this.mContext.getPackageName(), this.mContext.getOpPackageName(), keyEvent, sessionToken);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Error calling dispatchVolumeKeyEventAsSystemService", e);
        }
    }

    public void dispatchAdjustVolume(int suggestedStream, int direction, int flags) {
        try {
            this.mService.dispatchAdjustVolume(this.mContext.getPackageName(), this.mContext.getOpPackageName(), suggestedStream, direction, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send adjust volume.", e);
        }
    }

    public boolean isTrustedForMediaControl(RemoteUserInfo userInfo) {
        Objects.requireNonNull(userInfo, "userInfo shouldn't be null");
        if (userInfo.getPackageName() == null) {
            return false;
        }
        try {
            return this.mService.isTrusted(userInfo.getPackageName(), userInfo.getPid(), userInfo.getUid());
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Cannot communicate with the service.", e);
            return false;
        }
    }

    public boolean isGlobalPriorityActive() {
        try {
            return this.mService.isGlobalPriorityActive();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to check if the global priority is active.", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.SET_VOLUME_KEY_LONG_PRESS_LISTENER")
    public void setOnVolumeKeyLongPressListener(OnVolumeKeyLongPressListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (listener == null) {
                    this.mOnVolumeKeyLongPressListener = null;
                    this.mService.setOnVolumeKeyLongPressListener(null);
                } else {
                    if (handler == null) {
                        handler = new Handler();
                    }
                    this.mOnVolumeKeyLongPressListener = new OnVolumeKeyLongPressListenerImpl(listener, handler);
                    this.mService.setOnVolumeKeyLongPressListener(this.mOnVolumeKeyLongPressListener);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set volume key long press listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.SET_MEDIA_KEY_LISTENER")
    public void setOnMediaKeyListener(OnMediaKeyListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (listener == null) {
                    this.mOnMediaKeyListener = null;
                    this.mService.setOnMediaKeyListener(null);
                } else {
                    if (handler == null) {
                        handler = new Handler();
                    }
                    this.mOnMediaKeyListener = new OnMediaKeyListenerImpl(listener, handler);
                    this.mService.setOnMediaKeyListener(this.mOnMediaKeyListener);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set media key listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
    public void addOnMediaKeyEventDispatchedListener(Executor executor, OnMediaKeyEventDispatchedListener listener) {
        Objects.requireNonNull(executor, "executor shouldn't be null");
        Objects.requireNonNull(listener, "listener shouldn't be null");
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mOnMediaKeyEventDispatchedListeners.put(listener, executor);
                if (this.mOnMediaKeyEventDispatchedListeners.size() == 1) {
                    this.mService.addOnMediaKeyEventDispatchedListener(this.mOnMediaKeyEventDispatchedListenerStub);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set media key listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
    public void removeOnMediaKeyEventDispatchedListener(OnMediaKeyEventDispatchedListener listener) {
        Objects.requireNonNull(listener, "listener shouldn't be null");
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mOnMediaKeyEventDispatchedListeners.remove(listener);
                if (this.mOnMediaKeyEventDispatchedListeners.size() == 0) {
                    this.mService.removeOnMediaKeyEventDispatchedListener(this.mOnMediaKeyEventDispatchedListenerStub);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to set media key event dispatched listener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnMediaKeyEventSessionChangedListener(Executor executor, OnMediaKeyEventSessionChangedListener listener) {
        Objects.requireNonNull(executor, "executor shouldn't be null");
        Objects.requireNonNull(listener, "listener shouldn't be null");
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.mMediaKeyEventSessionChangedCallbacks.isEmpty()) {
                    this.mService.addOnMediaKeyEventSessionChangedListener(this.mOnMediaKeyEventSessionChangedListenerStub, this.mContext.getPackageName());
                }
                this.mMediaKeyEventSessionChangedCallbacks.put(listener, executor);
                executor.execute(() -> listener.onMediaKeyEventSessionChanged(this.mCurMediaKeyEventSessionPackage, this.mCurMediaKeyEventSession));
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to add MediaKeyEventSessionChangedListener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnMediaKeyEventSessionChangedListener(OnMediaKeyEventSessionChangedListener listener) {
        Objects.requireNonNull(listener, "listener shouldn't be null");
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.mMediaKeyEventSessionChangedCallbacks.remove(listener) != null && this.mMediaKeyEventSessionChangedCallbacks.isEmpty()) {
                    this.mService.removeOnMediaKeyEventSessionChangedListener(this.mOnMediaKeyEventSessionChangedListenerStub);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to remove MediaKeyEventSessionChangedListener", e);
            }
        }
    }

    @VisibleForTesting
    public void setCustomMediaKeyDispatcher(String name) {
        try {
            this.mService.setCustomMediaKeyDispatcher(name);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to set custom media key dispatcher name", e);
        }
    }

    @VisibleForTesting
    public void setCustomMediaSessionPolicyProvider(String name) {
        try {
            this.mService.setCustomMediaSessionPolicyProvider(name);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to set custom session policy provider name", e);
        }
    }

    @VisibleForTesting
    public boolean hasCustomMediaKeyDispatcher(String componentName) {
        Objects.requireNonNull(componentName, "componentName shouldn't be null");
        try {
            return this.mService.hasCustomMediaKeyDispatcher(componentName);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to check if custom media key dispatcher with given component name exists", e);
            return false;
        }
    }

    @VisibleForTesting
    public boolean hasCustomMediaSessionPolicyProvider(String componentName) {
        Objects.requireNonNull(componentName, "componentName shouldn't be null");
        try {
            return this.mService.hasCustomMediaSessionPolicyProvider(componentName);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to check if custom media session policy provider with given component name exists", e);
            return false;
        }
    }

    public int getSessionPolicies(MediaSession.Token token) {
        try {
            return this.mService.getSessionPolicies(token);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get session policies", e);
            return 0;
        }
    }

    public void setSessionPolicies(MediaSession.Token token, int policies) {
        try {
            this.mService.setSessionPolicies(token, policies);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to set session policies", e);
        }
    }

    private class OnMediaKeyEventDispatchedListenerStub
    extends IOnMediaKeyEventDispatchedListener.Stub {
        private OnMediaKeyEventDispatchedListenerStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaKeyEventDispatched(KeyEvent event, String packageName, MediaSession.Token sessionToken) {
            Object object = MediaSessionManager.this.mLock;
            synchronized (object) {
                for (Map.Entry<OnMediaKeyEventDispatchedListener, Executor> e : MediaSessionManager.this.mOnMediaKeyEventDispatchedListeners.entrySet()) {
                    e.getValue().execute(() -> ((OnMediaKeyEventDispatchedListener)e.getKey()).onMediaKeyEventDispatched(event, packageName, sessionToken));
                }
            }
        }
    }

    private class OnMediaKeyEventSessionChangedListenerStub
    extends IOnMediaKeyEventSessionChangedListener.Stub {
        private OnMediaKeyEventSessionChangedListenerStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaKeyEventSessionChanged(String packageName, MediaSession.Token sessionToken) {
            Object object = MediaSessionManager.this.mLock;
            synchronized (object) {
                MediaSessionManager.this.mCurMediaKeyEventSessionPackage = packageName;
                MediaSessionManager.this.mCurMediaKeyEventSession = sessionToken;
                for (Map.Entry<OnMediaKeyEventSessionChangedListener, Executor> e : MediaSessionManager.this.mMediaKeyEventSessionChangedCallbacks.entrySet()) {
                    e.getValue().execute(() -> ((OnMediaKeyEventSessionChangedListener)e.getKey()).onMediaKeyEventSessionChanged(packageName, sessionToken));
                }
            }
        }
    }

    private class RemoteSessionCallbackStub
    extends IRemoteSessionCallback.Stub {
        private RemoteSessionCallbackStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVolumeChanged(MediaSession.Token sessionToken, int flags) {
            ArrayMap<RemoteSessionCallback, Executor> callbacks = new ArrayMap<RemoteSessionCallback, Executor>();
            Iterator iterator = MediaSessionManager.this.mLock;
            synchronized (iterator) {
                callbacks.putAll(MediaSessionManager.this.mRemoteSessionCallbacks);
            }
            for (Map.Entry e : callbacks.entrySet()) {
                ((Executor)e.getValue()).execute(() -> ((RemoteSessionCallback)e.getKey()).onVolumeChanged(sessionToken, flags));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionChanged(MediaSession.Token sessionToken) {
            ArrayMap<RemoteSessionCallback, Executor> callbacks = new ArrayMap<RemoteSessionCallback, Executor>();
            Iterator iterator = MediaSessionManager.this.mLock;
            synchronized (iterator) {
                callbacks.putAll(MediaSessionManager.this.mRemoteSessionCallbacks);
            }
            for (Map.Entry e : callbacks.entrySet()) {
                ((Executor)e.getValue()).execute(() -> ((RemoteSessionCallback)e.getKey()).onDefaultRemoteSessionChanged(sessionToken));
            }
        }
    }

    public static interface OnActiveSessionsChangedListener {
        public void onActiveSessionsChanged(List<MediaController> var1);
    }

    private static class SessionsChangedWrapper {
        private Context mContext;
        private OnActiveSessionsChangedListener mListener;
        private Executor mExecutor;
        private final IActiveSessionsListener.Stub mStub = new IActiveSessionsListener.Stub(){

            @Override
            public void onActiveSessionsChanged(List<MediaSession.Token> tokens) {
                if (mExecutor != null) {
                    Executor executor = mExecutor;
                    executor.execute(() -> this.callOnActiveSessionsChangedListener(tokens));
                }
            }
        };

        public SessionsChangedWrapper(Context context, OnActiveSessionsChangedListener listener, Executor executor) {
            this.mContext = context;
            this.mListener = listener;
            this.mExecutor = executor;
        }

        private void callOnActiveSessionsChangedListener(List<MediaSession.Token> tokens) {
            Context context = this.mContext;
            if (context != null) {
                ArrayList<MediaController> controllers = new ArrayList<MediaController>();
                int size = tokens.size();
                for (int i = 0; i < size; ++i) {
                    controllers.add(new MediaController(context, tokens.get(i)));
                }
                OnActiveSessionsChangedListener listener = this.mListener;
                if (listener != null) {
                    listener.onActiveSessionsChanged(controllers);
                }
            }
        }

        private void release() {
            this.mListener = null;
            this.mContext = null;
            this.mExecutor = null;
        }
    }

    public static interface OnSession2TokensChangedListener {
        public void onSession2TokensChanged(List<Session2Token> var1);
    }

    private static class Session2TokensChangedWrapper {
        private final OnSession2TokensChangedListener mListener;
        private final Executor mExecutor;
        private final ISession2TokensListener.Stub mStub = new ISession2TokensListener.Stub(){

            @Override
            public void onSession2TokensChanged(List<Session2Token> tokens) {
                mExecutor.execute(() -> mListener.onSession2TokensChanged(tokens));
            }
        };

        Session2TokensChangedWrapper(OnSession2TokensChangedListener listener, Executor executor) {
            this.mListener = listener;
            this.mExecutor = executor;
        }

        public ISession2TokensListener.Stub getStub() {
            return this.mStub;
        }
    }

    public static class RemoteUserInfo {
        private final String mPackageName;
        private final int mPid;
        private final int mUid;

        public RemoteUserInfo(String packageName, int pid, int uid) {
            this.mPackageName = packageName;
            this.mPid = pid;
            this.mUid = uid;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public int getPid() {
            return this.mPid;
        }

        public int getUid() {
            return this.mUid;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RemoteUserInfo)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            RemoteUserInfo otherUserInfo = (RemoteUserInfo)obj;
            return TextUtils.equals(this.mPackageName, otherUserInfo.mPackageName) && this.mPid == otherUserInfo.mPid && this.mUid == otherUserInfo.mUid;
        }

        public int hashCode() {
            return Objects.hash(this.mPackageName, this.mPid, this.mUid);
        }
    }

    private static class OnVolumeKeyLongPressListenerImpl
    extends IOnVolumeKeyLongPressListener.Stub {
        private OnVolumeKeyLongPressListener mListener;
        private Handler mHandler;

        public OnVolumeKeyLongPressListenerImpl(OnVolumeKeyLongPressListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        @Override
        public void onVolumeKeyLongPress(final KeyEvent event) {
            if (this.mListener == null || this.mHandler == null) {
                Log.w(MediaSessionManager.TAG, "Failed to call volume key long-press listener. Either mListener or mHandler is null");
                return;
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mListener.onVolumeKeyLongPress(event);
                }
            });
        }
    }

    @SystemApi
    public static interface OnVolumeKeyLongPressListener {
        public void onVolumeKeyLongPress(KeyEvent var1);
    }

    private static class OnMediaKeyListenerImpl
    extends IOnMediaKeyListener.Stub {
        private OnMediaKeyListener mListener;
        private Handler mHandler;

        public OnMediaKeyListenerImpl(OnMediaKeyListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        @Override
        public void onMediaKey(final KeyEvent event, final ResultReceiver result) {
            if (this.mListener == null || this.mHandler == null) {
                Log.w(MediaSessionManager.TAG, "Failed to call media key listener. Either mListener or mHandler is null");
                return;
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    boolean handled = mListener.onMediaKey(event);
                    Log.d(MediaSessionManager.TAG, "The media key listener is returned " + handled);
                    if (result != null) {
                        result.send(handled ? 1 : 0, null);
                    }
                }
            });
        }
    }

    @SystemApi
    public static interface OnMediaKeyListener {
        public boolean onMediaKey(KeyEvent var1);
    }

    public static interface OnMediaKeyEventSessionChangedListener {
        public void onMediaKeyEventSessionChanged(String var1, MediaSession.Token var2);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static interface RemoteSessionCallback {
        public void onVolumeChanged(MediaSession.Token var1, int var2);

        public void onDefaultRemoteSessionChanged(MediaSession.Token var1);
    }

    @SystemApi
    public static interface OnMediaKeyEventDispatchedListener {
        public void onMediaKeyEventDispatched(KeyEvent var1, String var2, MediaSession.Token var3);
    }
}

