/*
 * Decompiled with CFR 0.152.
 */
package android.media.soundtrigger;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.hardware.soundtrigger.ModelParams;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.permission.ClearCallingIdentityContext;
import android.media.permission.Identity;
import android.media.permission.SafeCloseable;
import android.media.soundtrigger.SoundTriggerDetector;
import android.media.soundtrigger.SoundTriggerInstrumentation;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Slog;
import com.android.internal.app.ISoundTriggerService;
import com.android.internal.app.ISoundTriggerSession;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;

@SystemApi
public class SoundTriggerManager {
    private static final boolean DBG = false;
    private static final String TAG = "SoundTriggerManager";
    private final Context mContext;
    private final ISoundTriggerService mSoundTriggerService;
    private final ISoundTriggerSession mSoundTriggerSession;
    private final IBinder mBinderToken = new Binder();
    private final HashMap<UUID, SoundTriggerDetector> mReceiverInstanceMap = new HashMap();
    public static final int FLAG_MESSAGE_TYPE_UNKNOWN = -1;
    public static final int FLAG_MESSAGE_TYPE_RECOGNITION_EVENT = 0;
    public static final int FLAG_MESSAGE_TYPE_RECOGNITION_ERROR = 1;
    public static final int FLAG_MESSAGE_TYPE_RECOGNITION_PAUSED = 2;
    public static final int FLAG_MESSAGE_TYPE_RECOGNITION_RESUMED = 3;
    public static final String EXTRA_MESSAGE_TYPE = "android.media.soundtrigger.MESSAGE_TYPE";
    public static final String EXTRA_RECOGNITION_EVENT = "android.media.soundtrigger.RECOGNITION_EVENT";
    public static final String EXTRA_STATUS = "android.media.soundtrigger.STATUS";

    public SoundTriggerManager(Context context, ISoundTriggerService soundTriggerService) {
        try {
            Identity originatorIdentity = new Identity();
            originatorIdentity.packageName = ActivityThread.currentOpPackageName();
            try (SafeCloseable ignored = ClearCallingIdentityContext.create();){
                SoundTrigger.ModuleProperties moduleProperties = soundTriggerService.listModuleProperties(originatorIdentity).stream().filter(prop -> !prop.getSupportedModelArch().equals("injection")).findFirst().orElse(null);
                this.mSoundTriggerSession = moduleProperties != null ? soundTriggerService.attachAsOriginator(originatorIdentity, moduleProperties, this.mBinderToken) : null;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.mContext = context;
        this.mSoundTriggerService = soundTriggerService;
    }

    @SuppressLint(value={"ManagerLookup"})
    public SoundTriggerManager createManagerForModule(SoundTrigger.ModuleProperties moduleProperties) {
        return new SoundTriggerManager(this.mContext, this.mSoundTriggerService, Objects.requireNonNull(moduleProperties));
    }

    @SuppressLint(value={"ManagerLookup"})
    public SoundTriggerManager createManagerForTestModule() {
        return new SoundTriggerManager(this.mContext, this.mSoundTriggerService, this.getTestModuleProperties());
    }

    private SoundTrigger.ModuleProperties getTestModuleProperties() {
        SoundTrigger.ModuleProperties moduleProps = SoundTriggerManager.listModuleProperties().stream().filter(prop -> prop.getSupportedModelArch().equals("injection")).findFirst().orElse(null);
        if (moduleProps == null) {
            throw new AssertionError((Object)"Fake ST HAL should always be available");
        }
        return moduleProps;
    }

    private SoundTriggerManager(Context context, ISoundTriggerService soundTriggerService, SoundTrigger.ModuleProperties properties) {
        try {
            Identity originatorIdentity = new Identity();
            originatorIdentity.packageName = ActivityThread.currentOpPackageName();
            try (SafeCloseable ignored = ClearCallingIdentityContext.create();){
                this.mSoundTriggerSession = soundTriggerService.attachAsOriginator(originatorIdentity, Objects.requireNonNull(properties), this.mBinderToken);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.mContext = Objects.requireNonNull(context);
        this.mSoundTriggerService = Objects.requireNonNull(soundTriggerService);
    }

    public static List<SoundTrigger.ModuleProperties> listModuleProperties() {
        ISoundTriggerService service = ISoundTriggerService.Stub.asInterface(ServiceManager.getService("soundtrigger"));
        Identity originatorIdentity = new Identity();
        originatorIdentity.packageName = ActivityThread.currentOpPackageName();
        SafeCloseable ignored = ClearCallingIdentityContext.create();
        try {
            List<SoundTrigger.ModuleProperties> list = service.listModuleProperties(originatorIdentity);
            if (ignored != null) {
                ignored.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    public void updateModel(Model model) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        try {
            this.mSoundTriggerSession.updateSoundModel(model.getGenericSoundModel());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    public Model getModel(UUID soundModelId) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        try {
            SoundTrigger.GenericSoundModel model = this.mSoundTriggerSession.getSoundModel(new ParcelUuid(Objects.requireNonNull(soundModelId)));
            if (model == null) {
                return null;
            }
            return new Model(model);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    public void deleteModel(UUID soundModelId) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        try {
            this.mSoundTriggerSession.deleteSoundModel(new ParcelUuid(Objects.requireNonNull(soundModelId)));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    public SoundTriggerDetector createSoundTriggerDetector(UUID soundModelId, SoundTriggerDetector.Callback callback, Handler handler) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        SoundTriggerDetector oldInstance = this.mReceiverInstanceMap.get(soundModelId);
        if (oldInstance != null) {
            // empty if block
        }
        try {
            SoundTriggerDetector newInstance = new SoundTriggerDetector(this.mSoundTriggerSession, this.mSoundTriggerSession.getSoundModel(new ParcelUuid(Objects.requireNonNull(soundModelId))), callback, handler);
            this.mReceiverInstanceMap.put(soundModelId, newInstance);
            return newInstance;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    @UnsupportedAppUsage
    public int loadSoundModel(SoundTrigger.SoundModel soundModel) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        try {
            switch (soundModel.getType()) {
                case 1: {
                    return this.mSoundTriggerSession.loadGenericSoundModel((SoundTrigger.GenericSoundModel)soundModel);
                }
                case 0: {
                    return this.mSoundTriggerSession.loadKeyphraseSoundModel((SoundTrigger.KeyphraseSoundModel)soundModel);
                }
            }
            Slog.e(TAG, "Unkown model type");
            return Integer.MIN_VALUE;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    @UnsupportedAppUsage
    public int startRecognition(UUID soundModelId, Bundle params, ComponentName detectionService, SoundTrigger.RecognitionConfig config) {
        Objects.requireNonNull(soundModelId);
        Objects.requireNonNull(detectionService);
        Objects.requireNonNull(config);
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        try {
            return this.mSoundTriggerSession.startRecognitionForService(new ParcelUuid(soundModelId), params, detectionService, config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int stopRecognition(UUID soundModelId) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        try {
            return this.mSoundTriggerSession.stopRecognitionForService(new ParcelUuid(Objects.requireNonNull(soundModelId)));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int unloadSoundModel(UUID soundModelId) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        try {
            return this.mSoundTriggerSession.unloadSoundModel(new ParcelUuid(Objects.requireNonNull(soundModelId)));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    @UnsupportedAppUsage
    public boolean isRecognitionActive(UUID soundModelId) {
        if (soundModelId == null || this.mSoundTriggerSession == null) {
            return false;
        }
        try {
            return this.mSoundTriggerSession.isRecognitionActive(new ParcelUuid(soundModelId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getDetectionServiceOperationsTimeout() {
        try {
            return Settings.Global.getInt(this.mContext.getContentResolver(), "sound_trigger_detection_service_op_timeout");
        }
        catch (Settings.SettingNotFoundException e) {
            return Integer.MAX_VALUE;
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    @UnsupportedAppUsage
    public int getModelState(UUID soundModelId) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        if (soundModelId == null) {
            return Integer.MIN_VALUE;
        }
        try {
            return this.mSoundTriggerSession.getModelState(new ParcelUuid(soundModelId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    public SoundTrigger.ModuleProperties getModuleProperties() {
        if (this.mSoundTriggerSession == null) {
            return null;
        }
        try {
            return this.mSoundTriggerSession.getModuleProperties();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    public int setParameter(UUID soundModelId, @ModelParams int modelParam, int value) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        try {
            return this.mSoundTriggerSession.setParameter(new ParcelUuid(Objects.requireNonNull(soundModelId)), modelParam, value);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    public int getParameter(UUID soundModelId, @ModelParams int modelParam) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        try {
            return this.mSoundTriggerSession.getParameter(new ParcelUuid(Objects.requireNonNull(soundModelId)), modelParam);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    public SoundTrigger.ModelParamRange queryParameter(UUID soundModelId, @ModelParams int modelParam) {
        if (this.mSoundTriggerSession == null) {
            throw new IllegalStateException("No underlying SoundTriggerModule available");
        }
        try {
            return this.mSoundTriggerSession.queryParameter(new ParcelUuid(Objects.requireNonNull(soundModelId)), modelParam);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    public static SoundTriggerInstrumentation attachInstrumentation(Executor executor, SoundTriggerInstrumentation.GlobalCallback callback) {
        ISoundTriggerService service = ISoundTriggerService.Stub.asInterface(ServiceManager.getService("soundtrigger"));
        return new SoundTriggerInstrumentation(service, executor, callback);
    }

    public static class Model {
        private SoundTrigger.GenericSoundModel mGenericSoundModel;

        Model(SoundTrigger.GenericSoundModel soundTriggerModel) {
            this.mGenericSoundModel = soundTriggerModel;
        }

        public static Model create(UUID modelUuid, UUID vendorUuid, byte[] data, int version) {
            Objects.requireNonNull(modelUuid);
            Objects.requireNonNull(vendorUuid);
            return new Model(new SoundTrigger.GenericSoundModel(modelUuid, vendorUuid, data, version));
        }

        public static Model create(UUID modelUuid, UUID vendorUuid, byte[] data) {
            return Model.create(modelUuid, vendorUuid, data, -1);
        }

        public UUID getModelUuid() {
            return this.mGenericSoundModel.getUuid();
        }

        public UUID getVendorUuid() {
            return this.mGenericSoundModel.getVendorUuid();
        }

        public int getVersion() {
            return this.mGenericSoundModel.getVersion();
        }

        public byte[] getModelData() {
            return this.mGenericSoundModel.getData();
        }

        SoundTrigger.GenericSoundModel getGenericSoundModel() {
            return this.mGenericSoundModel;
        }

        public SoundTrigger.SoundModel getSoundModel() {
            return this.mGenericSoundModel;
        }
    }
}

