/*
 * Decompiled with CFR 0.152.
 */
package android.media.soundtrigger_middleware;

import android.media.soundtrigger_middleware.IAcknowledgeEvent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IInjectGlobalEvent
extends IInterface {
    public static final String DESCRIPTOR = "android$media$soundtrigger_middleware$IInjectGlobalEvent".replace('$', '.');

    public void triggerRestart() throws RemoteException;

    public void setResourceContention(boolean var1, IAcknowledgeEvent var2) throws RemoteException;

    public void triggerOnResourcesAvailable() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInjectGlobalEvent {
        static final int TRANSACTION_triggerRestart = 1;
        static final int TRANSACTION_setResourceContention = 2;
        static final int TRANSACTION_triggerOnResourcesAvailable = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInjectGlobalEvent asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInjectGlobalEvent) {
                return (IInjectGlobalEvent)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.triggerRestart();
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    IAcknowledgeEvent _arg1 = IAcknowledgeEvent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setResourceContention(_arg0, _arg1);
                    break;
                }
                case 3: {
                    this.triggerOnResourcesAvailable();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IInjectGlobalEvent {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            @Override
            public void triggerRestart() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setResourceContention(boolean isContended, IAcknowledgeEvent callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeBoolean(isContended);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void triggerOnResourcesAvailable() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInjectGlobalEvent {
        @Override
        public void triggerRestart() throws RemoteException {
        }

        @Override
        public void setResourceContention(boolean isContended, IAcknowledgeEvent callback) throws RemoteException {
        }

        @Override
        public void triggerOnResourcesAvailable() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

