/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SharedMemory;
import com.android.internal.util.AnnotationValidations;
import java.io.IOException;

public class AdBuffer
implements Parcelable {
    private final int mId;
    private final String mMimeType;
    private final SharedMemory mBuffer;
    private final int mOffset;
    private final int mLength;
    private final long mPresentationTimeUs;
    private final int mFlags;
    public static final Parcelable.Creator<AdBuffer> CREATOR = new Parcelable.Creator<AdBuffer>(){

        public AdBuffer[] newArray(int size) {
            return new AdBuffer[size];
        }

        @Override
        public AdBuffer createFromParcel(Parcel in) {
            return new AdBuffer(in);
        }
    };

    public AdBuffer(int id2, String mimeType, SharedMemory buffer, int offset, int length, long presentationTimeUs, int flags) {
        this.mId = id2;
        this.mMimeType = mimeType;
        AnnotationValidations.validate(NonNull.class, null, (Object)mimeType);
        this.mBuffer = buffer;
        AnnotationValidations.validate(NonNull.class, null, (Object)buffer);
        this.mOffset = offset;
        this.mLength = length;
        this.mPresentationTimeUs = presentationTimeUs;
        this.mFlags = flags;
    }

    public static AdBuffer dupAdBuffer(AdBuffer buffer) throws IOException {
        if (buffer == null) {
            return null;
        }
        return new AdBuffer(buffer.mId, buffer.mMimeType, SharedMemory.fromFileDescriptor(buffer.mBuffer.getFdDup()), buffer.mOffset, buffer.mLength, buffer.mPresentationTimeUs, buffer.mFlags);
    }

    public int getId() {
        return this.mId;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public SharedMemory getSharedMemory() {
        return this.mBuffer;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getLength() {
        return this.mLength;
    }

    public long getPresentationTimeUs() {
        return this.mPresentationTimeUs;
    }

    public int getFlags() {
        return this.mFlags;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mMimeType);
        dest.writeTypedObject(this.mBuffer, flags);
        dest.writeInt(this.mOffset);
        dest.writeInt(this.mLength);
        dest.writeLong(this.mPresentationTimeUs);
        dest.writeInt(this.mFlags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private AdBuffer(Parcel in) {
        int id2 = in.readInt();
        String mimeType = in.readString();
        SharedMemory buffer = in.readTypedObject(SharedMemory.CREATOR);
        int offset = in.readInt();
        int length = in.readInt();
        long presentationTimeUs = in.readLong();
        int flags = in.readInt();
        this.mId = id2;
        this.mMimeType = mimeType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMimeType);
        this.mBuffer = buffer;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBuffer);
        this.mOffset = offset;
        this.mLength = length;
        this.mPresentationTimeUs = presentationTimeUs;
        this.mFlags = flags;
    }
}

