/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.AttributionSource;
import android.content.Intent;
import android.graphics.Rect;
import android.media.AudioDeviceInfo;
import android.media.AudioPresentation;
import android.media.PlaybackParams;
import android.media.tv.AdBuffer;
import android.media.tv.AdRequest;
import android.media.tv.AdResponse;
import android.media.tv.AitInfo;
import android.media.tv.BroadcastInfoRequest;
import android.media.tv.BroadcastInfoResponse;
import android.media.tv.DvbDeviceInfo;
import android.media.tv.ITvInputClient;
import android.media.tv.ITvInputHardware;
import android.media.tv.ITvInputHardwareCallback;
import android.media.tv.ITvInputManager;
import android.media.tv.ITvInputManagerCallback;
import android.media.tv.TunedInfo;
import android.media.tv.TvContentRating;
import android.media.tv.TvContentRatingSystemInfo;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvStreamConfig;
import android.media.tv.TvTrackInfo;
import android.media.tv.interactive.TvInteractiveAppManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pools;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.View;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class TvInputManager {
    private static final String TAG = "TvInputManager";
    static final int DVB_DEVICE_START = 0;
    static final int DVB_DEVICE_END = 2;
    public static final int DVB_DEVICE_DEMUX = 0;
    public static final int DVB_DEVICE_DVR = 1;
    public static final int DVB_DEVICE_FRONTEND = 2;
    public static final int TV_MESSAGE_TYPE_WATERMARK = 1;
    public static final int TV_MESSAGE_TYPE_CLOSED_CAPTION = 2;
    public static final int TV_MESSAGE_TYPE_OTHER = 1000;
    public static final String TV_MESSAGE_KEY_STREAM_ID = "android.media.tv.TvInputManager.stream_id";
    public static final long TV_MESSAGE_GROUP_ID_NONE = -1L;
    public static final String TV_MESSAGE_KEY_GROUP_ID = "android.media.tv.TvInputManager.group_id";
    public static final String TV_MESSAGE_SUBTYPE_WATERMARKING_A335 = "ATSC A/335";
    public static final String TV_MESSAGE_SUBTYPE_CC_608E = "CTA 608-E";
    public static final String TV_MESSAGE_KEY_SUBTYPE = "android.media.tv.TvInputManager.subtype";
    public static final String TV_MESSAGE_KEY_RAW_DATA = "android.media.tv.TvInputManager.raw_data";
    static final int VIDEO_UNAVAILABLE_REASON_START = 0;
    static final int VIDEO_UNAVAILABLE_REASON_END = 18;
    public static final int VIDEO_UNAVAILABLE_REASON_UNKNOWN = 0;
    public static final int VIDEO_UNAVAILABLE_REASON_TUNING = 1;
    public static final int VIDEO_UNAVAILABLE_REASON_WEAK_SIGNAL = 2;
    public static final int VIDEO_UNAVAILABLE_REASON_BUFFERING = 3;
    public static final int VIDEO_UNAVAILABLE_REASON_AUDIO_ONLY = 4;
    public static final int VIDEO_UNAVAILABLE_REASON_NOT_CONNECTED = 5;
    public static final int VIDEO_UNAVAILABLE_REASON_INSUFFICIENT_RESOURCE = 6;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_INSUFFICIENT_OUTPUT_PROTECTION = 7;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_PVR_RECORDING_NOT_ALLOWED = 8;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_NO_LICENSE = 9;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_LICENSE_EXPIRED = 10;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_NEED_ACTIVATION = 11;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_NEED_PAIRING = 12;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_NO_CARD = 13;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_CARD_MUTE = 14;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_CARD_INVALID = 15;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_BLACKOUT = 16;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_REBOOTING = 17;
    public static final int VIDEO_UNAVAILABLE_REASON_CAS_UNKNOWN = 18;
    public static final int TIME_SHIFT_STATUS_UNKNOWN = 0;
    public static final int TIME_SHIFT_STATUS_UNSUPPORTED = 1;
    public static final int TIME_SHIFT_STATUS_UNAVAILABLE = 2;
    public static final int TIME_SHIFT_STATUS_AVAILABLE = 3;
    public static final long TIME_SHIFT_INVALID_TIME = Long.MIN_VALUE;
    public static final int TIME_SHIFT_MODE_OFF = 1;
    public static final int TIME_SHIFT_MODE_LOCAL = 2;
    public static final int TIME_SHIFT_MODE_NETWORK = 3;
    public static final int TIME_SHIFT_MODE_AUTO = 4;
    static final int RECORDING_ERROR_START = 0;
    static final int RECORDING_ERROR_END = 2;
    public static final int RECORDING_ERROR_UNKNOWN = 0;
    public static final int RECORDING_ERROR_INSUFFICIENT_SPACE = 1;
    public static final int RECORDING_ERROR_RESOURCE_BUSY = 2;
    public static final int INPUT_STATE_CONNECTED = 0;
    public static final int INPUT_STATE_CONNECTED_STANDBY = 1;
    public static final int INPUT_STATE_DISCONNECTED = 2;
    public static final int BROADCAST_INFO_TYPE_TS = 1;
    public static final int BROADCAST_INFO_TYPE_TABLE = 2;
    public static final int BROADCAST_INFO_TYPE_SECTION = 3;
    public static final int BROADCAST_INFO_TYPE_PES = 4;
    public static final int BROADCAST_INFO_STREAM_EVENT = 5;
    public static final int BROADCAST_INFO_TYPE_DSMCC = 6;
    public static final int BROADCAST_INFO_TYPE_COMMAND = 7;
    public static final int BROADCAST_INFO_TYPE_TIMELINE = 8;
    public static final int SIGNAL_STRENGTH_LOST = 1;
    public static final int SIGNAL_STRENGTH_WEAK = 2;
    public static final int SIGNAL_STRENGTH_STRONG = 3;
    public static final int UNKNOWN_CLIENT_PID = -1;
    public static final String ACTION_BLOCKED_RATINGS_CHANGED = "android.media.tv.action.BLOCKED_RATINGS_CHANGED";
    public static final String ACTION_PARENTAL_CONTROLS_ENABLED_CHANGED = "android.media.tv.action.PARENTAL_CONTROLS_ENABLED_CHANGED";
    public static final String ACTION_QUERY_CONTENT_RATING_SYSTEMS = "android.media.tv.action.QUERY_CONTENT_RATING_SYSTEMS";
    public static final String META_DATA_CONTENT_RATING_SYSTEMS = "android.media.tv.metadata.CONTENT_RATING_SYSTEMS";
    public static final String ACTION_SETUP_INPUTS = "android.media.tv.action.SETUP_INPUTS";
    public static final String ACTION_VIEW_RECORDING_SCHEDULES = "android.media.tv.action.VIEW_RECORDING_SCHEDULES";
    private final ITvInputManager mService;
    private final Object mLock;
    private final List<TvInputCallbackRecord> mCallbackRecords;
    private final Map<String, Integer> mStateMap;
    private final SparseArray<SessionCallbackRecord> mSessionCallbackRecordMap;
    private int mNextSeq;
    private final ITvInputClient mClient;
    private final int mUserId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TvInputManager(ITvInputManager service, int userId) {
        block6: {
            this.mLock = new Object();
            this.mCallbackRecords = new ArrayList<TvInputCallbackRecord>();
            this.mStateMap = new ArrayMap<String, Integer>();
            this.mSessionCallbackRecordMap = new SparseArray();
            this.mService = service;
            this.mUserId = userId;
            this.mClient = new ITvInputClient.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSessionCreated(String inputId, IBinder token, InputChannel channel, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for " + token);
                            return;
                        }
                        Session session = null;
                        if (token != null) {
                            session = new Session(token, channel, TvInputManager.this.mService, TvInputManager.this.mUserId, seq, TvInputManager.this.mSessionCallbackRecordMap);
                        } else {
                            TvInputManager.this.mSessionCallbackRecordMap.delete(seq);
                        }
                        record.postSessionCreated(session);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSessionReleased(int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        TvInputManager.this.mSessionCallbackRecordMap.delete(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq:" + seq);
                            return;
                        }
                        record.mSession.releaseInternal();
                        record.postSessionReleased();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onChannelRetuned(Uri channelUri, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postChannelRetuned(channelUri);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAudioPresentationsChanged(List<AudioPresentation> audioPresentations, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        if (record.mSession.updateAudioPresentations(audioPresentations)) {
                            record.postAudioPresentationsChanged(audioPresentations);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAudioPresentationSelected(int presentationId, int programId, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        if (record.mSession.updateAudioPresentationSelection(presentationId, programId)) {
                            record.postAudioPresentationSelected(presentationId, programId);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTracksChanged(List<TvTrackInfo> tracks, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        if (record.mSession.updateTracks(tracks)) {
                            record.postTracksChanged(tracks);
                            this.postVideoSizeChangedIfNeededLocked(record);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTrackSelected(int type, String trackId, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        if (record.mSession.updateTrackSelection(type, trackId)) {
                            record.postTrackSelected(type, trackId);
                            this.postVideoSizeChangedIfNeededLocked(record);
                        }
                    }
                }

                private void postVideoSizeChangedIfNeededLocked(SessionCallbackRecord record) {
                    TvTrackInfo track = record.mSession.getVideoTrackToNotify();
                    if (track != null) {
                        record.postVideoSizeChanged(track.getVideoWidth(), track.getVideoHeight());
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onVideoAvailable(int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postVideoAvailable();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onVideoUnavailable(int reason, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postVideoUnavailable(reason);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onContentAllowed(int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postContentAllowed();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onContentBlocked(String rating, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postContentBlocked(TvContentRating.unflattenFromString(rating));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onLayoutSurface(int left, int top, int right, int bottom, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postLayoutSurface(left, top, right, bottom);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSessionEvent(String eventType, Bundle eventArgs, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postSessionEvent(eventType, eventArgs);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTimeShiftStatusChanged(int status, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postTimeShiftStatusChanged(status);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTimeShiftStartPositionChanged(long timeMs, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postTimeShiftStartPositionChanged(timeMs);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTimeShiftCurrentPositionChanged(long timeMs, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postTimeShiftCurrentPositionChanged(timeMs);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAitInfoUpdated(AitInfo aitInfo, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postAitInfoUpdated(aitInfo);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSignalStrength(int strength, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postSignalStrength(strength);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCueingMessageAvailability(boolean available, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postCueingMessageAvailability(available);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTimeShiftMode(int mode, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postTimeShiftMode(mode);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAvailableSpeeds(float[] speeds, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postAvailableSpeeds(speeds);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTuned(Uri channelUri, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postTuned(channelUri);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTvMessage(int type, Bundle data, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postTvMessage(type, data);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onRecordingStopped(Uri recordedProgramUri, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postRecordingStopped(recordedProgramUri);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(int error, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postError(error);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBroadcastInfoResponse(BroadcastInfoResponse response, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postBroadcastInfoResponse(response);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAdResponse(AdResponse response, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postAdResponse(response);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAdBufferConsumed(AdBuffer buffer, int seq) {
                    SparseArray<SessionCallbackRecord> sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                    synchronized (sparseArray) {
                        SessionCallbackRecord record = TvInputManager.this.mSessionCallbackRecordMap.get(seq);
                        if (record == null) {
                            Log.e(TvInputManager.TAG, "Callback not found for seq " + seq);
                            return;
                        }
                        record.postAdBufferConsumed(buffer);
                    }
                }
            };
            ITvInputManagerCallback.Stub managerCallback = new ITvInputManagerCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInputAdded(String inputId) {
                    Object object = TvInputManager.this.mLock;
                    synchronized (object) {
                        TvInputManager.this.mStateMap.put(inputId, 0);
                        for (TvInputCallbackRecord record : TvInputManager.this.mCallbackRecords) {
                            record.postInputAdded(inputId);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInputRemoved(String inputId) {
                    Object object = TvInputManager.this.mLock;
                    synchronized (object) {
                        TvInputManager.this.mStateMap.remove(inputId);
                        for (TvInputCallbackRecord record : TvInputManager.this.mCallbackRecords) {
                            record.postInputRemoved(inputId);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInputUpdated(String inputId) {
                    Object object = TvInputManager.this.mLock;
                    synchronized (object) {
                        for (TvInputCallbackRecord record : TvInputManager.this.mCallbackRecords) {
                            record.postInputUpdated(inputId);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInputStateChanged(String inputId, int state) {
                    Object object = TvInputManager.this.mLock;
                    synchronized (object) {
                        TvInputManager.this.mStateMap.put(inputId, state);
                        for (TvInputCallbackRecord record : TvInputManager.this.mCallbackRecords) {
                            record.postInputStateChanged(inputId, state);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTvInputInfoUpdated(TvInputInfo inputInfo) {
                    Object object = TvInputManager.this.mLock;
                    synchronized (object) {
                        for (TvInputCallbackRecord record : TvInputManager.this.mCallbackRecords) {
                            record.postTvInputInfoUpdated(inputInfo);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCurrentTunedInfosUpdated(List<TunedInfo> currentTunedInfos) {
                    Object object = TvInputManager.this.mLock;
                    synchronized (object) {
                        for (TvInputCallbackRecord record : TvInputManager.this.mCallbackRecords) {
                            record.postCurrentTunedInfosUpdated(currentTunedInfos);
                        }
                    }
                }
            };
            try {
                if (this.mService == null) break block6;
                this.mService.registerCallback(managerCallback, this.mUserId);
                List<TvInputInfo> infos = this.mService.getTvInputList(this.mUserId);
                Object object = this.mLock;
                synchronized (object) {
                    for (TvInputInfo info : infos) {
                        String inputId = info.getId();
                        this.mStateMap.put(inputId, this.mService.getTvInputState(inputId, this.mUserId));
                    }
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public List<TvInputInfo> getTvInputList() {
        try {
            return this.mService.getTvInputList(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public TvInputInfo getTvInputInfo(String inputId) {
        Preconditions.checkNotNull(inputId);
        try {
            return this.mService.getTvInputInfo(inputId, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updateTvInputInfo(TvInputInfo inputInfo) {
        Preconditions.checkNotNull(inputInfo);
        try {
            this.mService.updateTvInputInfo(inputInfo, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInputState(String inputId) {
        Preconditions.checkNotNull(inputId);
        Object object = this.mLock;
        synchronized (object) {
            Integer state = this.mStateMap.get(inputId);
            if (state == null) {
                Log.w(TAG, "Unrecognized input ID: " + inputId);
                return 2;
            }
            return state;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TIS_EXTENSION_INTERFACE")
    public List<String> getAvailableExtensionInterfaceNames(String inputId) {
        Preconditions.checkNotNull(inputId);
        try {
            return this.mService.getAvailableExtensionInterfaceNames(inputId, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TIS_EXTENSION_INTERFACE")
    public IBinder getExtensionInterface(String inputId, String name) {
        Preconditions.checkNotNull(inputId);
        Preconditions.checkNotNull(name);
        try {
            return this.mService.getExtensionInterface(inputId, name, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(TvInputCallback callback, Handler handler) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(handler);
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackRecords.add(new TvInputCallbackRecord(callback, handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(TvInputCallback callback) {
        Preconditions.checkNotNull(callback);
        Object object = this.mLock;
        synchronized (object) {
            Iterator<TvInputCallbackRecord> it = this.mCallbackRecords.iterator();
            while (it.hasNext()) {
                TvInputCallbackRecord record = it.next();
                if (record.getCallback() != callback) continue;
                it.remove();
                break;
            }
        }
    }

    public boolean isParentalControlsEnabled() {
        try {
            return this.mService.isParentalControlsEnabled(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PARENTAL_CONTROLS")
    public void setParentalControlsEnabled(boolean enabled) {
        try {
            this.mService.setParentalControlsEnabled(enabled, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isRatingBlocked(TvContentRating rating) {
        Preconditions.checkNotNull(rating);
        try {
            return this.mService.isRatingBlocked(rating.flattenToString(), this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<TvContentRating> getBlockedRatings() {
        try {
            ArrayList<TvContentRating> ratings = new ArrayList<TvContentRating>();
            for (String rating : this.mService.getBlockedRatings(this.mUserId)) {
                ratings.add(TvContentRating.unflattenFromString(rating));
            }
            return ratings;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PARENTAL_CONTROLS")
    public void addBlockedRating(TvContentRating rating) {
        Preconditions.checkNotNull(rating);
        try {
            this.mService.addBlockedRating(rating.flattenToString(), this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PARENTAL_CONTROLS")
    public void removeBlockedRating(TvContentRating rating) {
        Preconditions.checkNotNull(rating);
        try {
            this.mService.removeBlockedRating(rating.flattenToString(), this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_CONTENT_RATING_SYSTEMS")
    public List<TvContentRatingSystemInfo> getTvContentRatingSystemList() {
        try {
            return this.mService.getTvContentRatingSystemList(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NOTIFY_TV_INPUTS")
    public void notifyPreviewProgramBrowsableDisabled(String packageName, long programId) {
        Intent intent = new Intent();
        intent.setAction("android.media.tv.action.PREVIEW_PROGRAM_BROWSABLE_DISABLED");
        intent.putExtra("android.media.tv.extra.PREVIEW_PROGRAM_ID", programId);
        intent.setPackage(packageName);
        try {
            this.mService.sendTvInputNotifyIntent(intent, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NOTIFY_TV_INPUTS")
    public void notifyWatchNextProgramBrowsableDisabled(String packageName, long programId) {
        Intent intent = new Intent();
        intent.setAction("android.media.tv.action.WATCH_NEXT_PROGRAM_BROWSABLE_DISABLED");
        intent.putExtra("android.media.tv.extra.WATCH_NEXT_PROGRAM_ID", programId);
        intent.setPackage(packageName);
        try {
            this.mService.sendTvInputNotifyIntent(intent, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NOTIFY_TV_INPUTS")
    public void notifyPreviewProgramAddedToWatchNext(String packageName, long previewProgramId, long watchNextProgramId) {
        Intent intent = new Intent();
        intent.setAction("android.media.tv.action.PREVIEW_PROGRAM_ADDED_TO_WATCH_NEXT");
        intent.putExtra("android.media.tv.extra.PREVIEW_PROGRAM_ID", previewProgramId);
        intent.putExtra("android.media.tv.extra.WATCH_NEXT_PROGRAM_ID", watchNextProgramId);
        intent.setPackage(packageName);
        try {
            this.mService.sendTvInputNotifyIntent(intent, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createSession(String inputId, AttributionSource tvAppAttributionSource, SessionCallback callback, Handler handler) {
        this.createSessionInternal(inputId, tvAppAttributionSource, false, callback, handler);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TUNER_RESOURCE_ACCESS")
    public int getClientPid(String sessionId) {
        return this.getClientPidInternal(sessionId);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TUNER_RESOURCE_ACCESS")
    public int getClientPriority(int useCase, String sessionId) {
        Preconditions.checkNotNull(sessionId);
        if (!this.isValidUseCase(useCase)) {
            throw new IllegalArgumentException("Invalid use case: " + useCase);
        }
        return this.getClientPriorityInternal(useCase, sessionId);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TUNER_RESOURCE_ACCESS")
    public int getClientPriority(int useCase) {
        if (!this.isValidUseCase(useCase)) {
            throw new IllegalArgumentException("Invalid use case: " + useCase);
        }
        return this.getClientPriorityInternal(useCase, null);
    }

    public void createRecordingSession(String inputId, SessionCallback callback, Handler handler) {
        this.createSessionInternal(inputId, null, true, callback, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessionInternal(String inputId, AttributionSource tvAppAttributionSource, boolean isRecordingSession, SessionCallback callback, Handler handler) {
        Preconditions.checkNotNull(inputId);
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(handler);
        SessionCallbackRecord record = new SessionCallbackRecord(callback, handler);
        SparseArray<SessionCallbackRecord> sparseArray = this.mSessionCallbackRecordMap;
        synchronized (sparseArray) {
            int seq = this.mNextSeq++;
            this.mSessionCallbackRecordMap.put(seq, record);
            try {
                this.mService.createSession(this.mClient, inputId, tvAppAttributionSource, isRecordingSession, seq, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private int getClientPidInternal(String sessionId) {
        Preconditions.checkNotNull(sessionId);
        int clientPid = -1;
        try {
            clientPid = this.mService.getClientPid(sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return clientPid;
    }

    private int getClientPriorityInternal(int useCase, String sessionId) {
        try {
            return this.mService.getClientPriority(useCase, sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private boolean isValidUseCase(int useCase) {
        return useCase == 100 || useCase == 200 || useCase == 300 || useCase == 400 || useCase == 500;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CAPTURE_TV_INPUT")
    public List<TvStreamConfig> getAvailableTvStreamConfigList(String inputId) {
        try {
            return this.mService.getAvailableTvStreamConfigList(inputId, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CAPTURE_TV_INPUT")
    public boolean captureFrame(String inputId, Surface surface, TvStreamConfig config) {
        try {
            return this.mService.captureFrame(inputId, surface, config, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CAPTURE_TV_INPUT")
    public boolean isSingleSessionActive() {
        try {
            return this.mService.isSingleSessionActive(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TV_INPUT_HARDWARE")
    public List<TvInputHardwareInfo> getHardwareList() {
        try {
            return this.mService.getHardwareList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TV_INPUT_HARDWARE")
    public Hardware acquireTvInputHardware(int deviceId, HardwareCallback callback, TvInputInfo info) {
        return this.acquireTvInputHardware(deviceId, info, callback);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TV_INPUT_HARDWARE")
    public Hardware acquireTvInputHardware(int deviceId, TvInputInfo info, HardwareCallback callback) {
        Preconditions.checkNotNull(info);
        Preconditions.checkNotNull(callback);
        return this.acquireTvInputHardwareInternal(deviceId, info, null, 400, new Executor(){

            @Override
            public void execute(Runnable r) {
                r.run();
            }
        }, callback);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TV_INPUT_HARDWARE")
    public Hardware acquireTvInputHardware(int deviceId, TvInputInfo info, String tvInputSessionId, int priorityHint, Executor executor, HardwareCallback callback) {
        Preconditions.checkNotNull(info);
        Preconditions.checkNotNull(callback);
        return this.acquireTvInputHardwareInternal(deviceId, info, tvInputSessionId, priorityHint, executor, callback);
    }

    public void addHardwareDevice(int deviceId) {
        try {
            this.mService.addHardwareDevice(deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeHardwareDevice(int deviceId) {
        try {
            this.mService.removeHardwareDevice(deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private Hardware acquireTvInputHardwareInternal(int deviceId, TvInputInfo info, String tvInputSessionId, int priorityHint, final Executor executor, final HardwareCallback callback) {
        try {
            ITvInputHardware hardware = this.mService.acquireTvInputHardware(deviceId, new ITvInputHardwareCallback.Stub(){

                @Override
                public void onReleased() {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onReleased());
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onStreamConfigChanged(TvStreamConfig[] configs) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onStreamConfigChanged(configs));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            }, info, this.mUserId, tvInputSessionId, priorityHint);
            if (hardware == null) {
                return null;
            }
            return new Hardware(hardware);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TV_INPUT_HARDWARE")
    public void releaseTvInputHardware(int deviceId, Hardware hardware) {
        try {
            this.mService.releaseTvInputHardware(deviceId, hardware.getInterface(), this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DVB_DEVICE")
    public List<DvbDeviceInfo> getDvbDeviceList() {
        try {
            return this.mService.getDvbDeviceList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DVB_DEVICE")
    public ParcelFileDescriptor openDvbDevice(DvbDeviceInfo info, int deviceType) {
        try {
            if (0 > deviceType || 2 < deviceType) {
                throw new IllegalArgumentException("Invalid DVB device: " + deviceType);
            }
            return this.mService.openDvbDevice(info, deviceType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestChannelBrowsable(Uri channelUri) {
        try {
            this.mService.requestChannelBrowsable(channelUri, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_TUNED_INFO")
    public List<TunedInfo> getCurrentTunedInfos() {
        try {
            return this.mService.getCurrentTunedInfos(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class TvInputCallbackRecord {
        private final TvInputCallback mCallback;
        private final Handler mHandler;

        public TvInputCallbackRecord(TvInputCallback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        public TvInputCallback getCallback() {
            return this.mCallback;
        }

        public void postInputAdded(final String inputId) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onInputAdded(inputId);
                }
            });
        }

        public void postInputRemoved(final String inputId) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onInputRemoved(inputId);
                }
            });
        }

        public void postInputUpdated(final String inputId) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onInputUpdated(inputId);
                }
            });
        }

        public void postInputStateChanged(final String inputId, final int state) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onInputStateChanged(inputId, state);
                }
            });
        }

        public void postTvInputInfoUpdated(final TvInputInfo inputInfo) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onTvInputInfoUpdated(inputInfo);
                }
            });
        }

        public void postCurrentTunedInfosUpdated(final List<TunedInfo> currentTunedInfos) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onCurrentTunedInfosUpdated(currentTunedInfos);
                }
            });
        }
    }

    public static abstract class TvInputCallback {
        public void onInputStateChanged(String inputId, int state) {
        }

        public void onInputAdded(String inputId) {
        }

        public void onInputRemoved(String inputId) {
        }

        public void onInputUpdated(String inputId) {
        }

        public void onTvInputInfoUpdated(TvInputInfo inputInfo) {
        }

        @SystemApi
        @RequiresPermission(value="android.permission.ACCESS_TUNED_INFO")
        public void onCurrentTunedInfosUpdated(List<TunedInfo> tunedInfos) {
        }
    }

    public static abstract class SessionCallback {
        public void onSessionCreated(Session session) {
        }

        public void onSessionReleased(Session session) {
        }

        public void onChannelRetuned(Session session, Uri channelUri) {
        }

        public void onAudioPresentationsChanged(Session session, List<AudioPresentation> audioPresentations) {
        }

        public void onAudioPresentationSelected(Session session, int presentationId, int programId) {
        }

        public void onTracksChanged(Session session, List<TvTrackInfo> tracks) {
        }

        public void onTrackSelected(Session session, int type, String trackId) {
        }

        public void onVideoSizeChanged(Session session, int width, int height) {
        }

        public void onVideoAvailable(Session session) {
        }

        public void onVideoUnavailable(Session session, int reason) {
        }

        public void onContentAllowed(Session session) {
        }

        public void onContentBlocked(Session session, TvContentRating rating) {
        }

        public void onLayoutSurface(Session session, int left, int top, int right, int bottom) {
        }

        public void onSessionEvent(Session session, String eventType, Bundle eventArgs) {
        }

        public void onTimeShiftStatusChanged(Session session, int status) {
        }

        public void onTimeShiftStartPositionChanged(Session session, long timeMs) {
        }

        public void onTimeShiftCurrentPositionChanged(Session session, long timeMs) {
        }

        public void onAitInfoUpdated(Session session, AitInfo aitInfo) {
        }

        public void onSignalStrengthUpdated(Session session, int strength) {
        }

        public void onCueingMessageAvailability(Session session, boolean available) {
        }

        public void onTimeShiftMode(Session session, int mode) {
        }

        public void onAvailableSpeeds(Session session, float[] speeds) {
        }

        public void onTuned(Session session, Uri channelUri) {
        }

        public void onTvMessage(Session session, int type, Bundle data) {
        }

        void onRecordingStopped(Session session, Uri recordedProgramUri) {
        }

        void onError(Session session, int error) {
        }
    }

    private static class SessionCallbackRecord {
        private final SessionCallback mSessionCallback;
        private final Handler mHandler;
        private Session mSession;

        SessionCallbackRecord(SessionCallback sessionCallback, Handler handler) {
            this.mSessionCallback = sessionCallback;
            this.mHandler = handler;
        }

        void postSessionCreated(final Session session) {
            this.mSession = session;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onSessionCreated(session);
                }
            });
        }

        void postSessionReleased() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onSessionReleased(mSession);
                }
            });
        }

        void postChannelRetuned(final Uri channelUri) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onChannelRetuned(mSession, channelUri);
                }
            });
        }

        void postAudioPresentationsChanged(final List<AudioPresentation> audioPresentations) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onAudioPresentationsChanged(mSession, audioPresentations);
                }
            });
        }

        void postAudioPresentationSelected(final int presentationId, final int programId) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onAudioPresentationSelected(mSession, presentationId, programId);
                }
            });
        }

        void postTracksChanged(final List<TvTrackInfo> tracks) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onTracksChanged(mSession, tracks);
                    if (mSession.mIAppNotificationEnabled && mSession.getInteractiveAppSession() != null) {
                        mSession.getInteractiveAppSession().notifyTracksChanged(tracks);
                    }
                }
            });
        }

        void postTrackSelected(final int type, final String trackId) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onTrackSelected(mSession, type, trackId);
                    if (mSession.mIAppNotificationEnabled && mSession.getInteractiveAppSession() != null) {
                        mSession.getInteractiveAppSession().notifyTrackSelected(type, trackId);
                    }
                }
            });
        }

        void postVideoSizeChanged(final int width, final int height) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onVideoSizeChanged(mSession, width, height);
                }
            });
        }

        void postVideoAvailable() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onVideoAvailable(mSession);
                    if (mSession.mIAppNotificationEnabled && mSession.getInteractiveAppSession() != null) {
                        mSession.getInteractiveAppSession().notifyVideoAvailable();
                    }
                }
            });
        }

        void postVideoUnavailable(final int reason) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onVideoUnavailable(mSession, reason);
                    if (mSession.mIAppNotificationEnabled && mSession.getInteractiveAppSession() != null) {
                        mSession.getInteractiveAppSession().notifyVideoUnavailable(reason);
                    }
                }
            });
        }

        void postContentAllowed() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onContentAllowed(mSession);
                    if (mSession.mIAppNotificationEnabled && mSession.getInteractiveAppSession() != null) {
                        mSession.getInteractiveAppSession().notifyContentAllowed();
                    }
                }
            });
        }

        void postContentBlocked(final TvContentRating rating) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onContentBlocked(mSession, rating);
                    if (mSession.mIAppNotificationEnabled && mSession.getInteractiveAppSession() != null) {
                        mSession.getInteractiveAppSession().notifyContentBlocked(rating);
                    }
                }
            });
        }

        void postLayoutSurface(final int left, final int top, final int right, final int bottom) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onLayoutSurface(mSession, left, top, right, bottom);
                }
            });
        }

        void postSessionEvent(final String eventType, final Bundle eventArgs) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onSessionEvent(mSession, eventType, eventArgs);
                }
            });
        }

        void postTimeShiftStatusChanged(final int status) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onTimeShiftStatusChanged(mSession, status);
                }
            });
        }

        void postTimeShiftStartPositionChanged(final long timeMs) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onTimeShiftStartPositionChanged(mSession, timeMs);
                }
            });
        }

        void postTimeShiftCurrentPositionChanged(final long timeMs) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onTimeShiftCurrentPositionChanged(mSession, timeMs);
                }
            });
        }

        void postAitInfoUpdated(final AitInfo aitInfo) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onAitInfoUpdated(mSession, aitInfo);
                }
            });
        }

        void postSignalStrength(final int strength) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onSignalStrengthUpdated(mSession, strength);
                    if (mSession.mIAppNotificationEnabled && mSession.getInteractiveAppSession() != null) {
                        mSession.getInteractiveAppSession().notifySignalStrength(strength);
                    }
                }
            });
        }

        void postCueingMessageAvailability(final boolean available) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onCueingMessageAvailability(mSession, available);
                }
            });
        }

        void postTimeShiftMode(final int mode) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onTimeShiftMode(mSession, mode);
                }
            });
        }

        void postAvailableSpeeds(final float[] speeds) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onAvailableSpeeds(mSession, speeds);
                }
            });
        }

        void postTuned(final Uri channelUri) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onTuned(mSession, channelUri);
                    if (mSession.mIAppNotificationEnabled && mSession.getInteractiveAppSession() != null) {
                        mSession.getInteractiveAppSession().notifyTuned(channelUri);
                    }
                }
            });
        }

        void postTvMessage(final int type, final Bundle data) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onTvMessage(mSession, type, data);
                    if (mSession.mIAppNotificationEnabled && mSession.getInteractiveAppSession() != null) {
                        mSession.getInteractiveAppSession().notifyTvMessage(type, data);
                    }
                }
            });
        }

        void postRecordingStopped(final Uri recordedProgramUri) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onRecordingStopped(mSession, recordedProgramUri);
                }
            });
        }

        void postError(final int error) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mSessionCallback.onError(mSession, error);
                }
            });
        }

        void postBroadcastInfoResponse(final BroadcastInfoResponse response) {
            if (this.mSession.mIAppNotificationEnabled) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (mSession.getInteractiveAppSession() != null) {
                            mSession.getInteractiveAppSession().notifyBroadcastInfoResponse(response);
                        }
                    }
                });
            }
        }

        void postAdResponse(final AdResponse response) {
            if (this.mSession.mIAppNotificationEnabled) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (mSession.getInteractiveAppSession() != null) {
                            mSession.getInteractiveAppSession().notifyAdResponse(response);
                        }
                    }
                });
            }
        }

        void postAdBufferConsumed(final AdBuffer buffer) {
            if (this.mSession.mIAppNotificationEnabled) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (mSession.getInteractiveAppSession() != null) {
                            mSession.getInteractiveAppSession().notifyAdBufferConsumed(buffer);
                        }
                    }
                });
            }
        }
    }

    @SystemApi
    public static abstract class HardwareCallback {
        public abstract void onReleased();

        public abstract void onStreamConfigChanged(TvStreamConfig[] var1);
    }

    @SystemApi
    public static class Hardware {
        private final ITvInputHardware mInterface;

        private Hardware(ITvInputHardware hardwareInterface) {
            this.mInterface = hardwareInterface;
        }

        private ITvInputHardware getInterface() {
            return this.mInterface;
        }

        public boolean setSurface(Surface surface, TvStreamConfig config) {
            try {
                return this.mInterface.setSurface(surface, config);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setStreamVolume(float volume) {
            try {
                this.mInterface.setStreamVolume(volume);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        @SystemApi
        public boolean dispatchKeyEventToHdmi(KeyEvent event) {
            return false;
        }

        public void overrideAudioSink(int audioType, String audioAddress, int samplingRate, int channelMask, int format) {
            try {
                this.mInterface.overrideAudioSink(audioType, audioAddress, samplingRate, channelMask, format);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void overrideAudioSink(AudioDeviceInfo device, int samplingRate, int channelMask, int format) {
            Objects.requireNonNull(device);
            try {
                this.mInterface.overrideAudioSink(AudioDeviceInfo.convertDeviceTypeToInternalDevice(device.getType()), device.getAddress(), samplingRate, channelMask, format);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Session {
        static final int DISPATCH_IN_PROGRESS = -1;
        static final int DISPATCH_NOT_HANDLED = 0;
        static final int DISPATCH_HANDLED = 1;
        private static final long INPUT_SESSION_NOT_RESPONDING_TIMEOUT = 2500L;
        private final ITvInputManager mService;
        private final int mUserId;
        private final int mSeq;
        private final InputEventHandler mHandler = new InputEventHandler(Looper.getMainLooper());
        private final Pools.Pool<PendingEvent> mPendingEventPool = new Pools.SimplePool<PendingEvent>(20);
        private final SparseArray<PendingEvent> mPendingEvents = new SparseArray(20);
        private final SparseArray<SessionCallbackRecord> mSessionCallbackRecordMap;
        private IBinder mToken;
        private TvInputEventSender mSender;
        private InputChannel mChannel;
        private final Object mMetadataLock = new Object();
        private final List<AudioPresentation> mAudioPresentations = new ArrayList<AudioPresentation>();
        private final List<TvTrackInfo> mAudioTracks = new ArrayList<TvTrackInfo>();
        private final List<TvTrackInfo> mVideoTracks = new ArrayList<TvTrackInfo>();
        private final List<TvTrackInfo> mSubtitleTracks = new ArrayList<TvTrackInfo>();
        private int mSelectedAudioProgramId = -1;
        private int mSelectedAudioPresentationId = -1;
        private String mSelectedAudioTrackId;
        private String mSelectedVideoTrackId;
        private String mSelectedSubtitleTrackId;
        private int mVideoWidth;
        private int mVideoHeight;
        private TvInteractiveAppManager.Session mIAppSession;
        private boolean mIAppNotificationEnabled = false;

        private Session(IBinder token, InputChannel channel, ITvInputManager service, int userId, int seq, SparseArray<SessionCallbackRecord> sessionCallbackRecordMap) {
            this.mToken = token;
            this.mChannel = channel;
            this.mService = service;
            this.mUserId = userId;
            this.mSeq = seq;
            this.mSessionCallbackRecordMap = sessionCallbackRecordMap;
        }

        public TvInteractiveAppManager.Session getInteractiveAppSession() {
            return this.mIAppSession;
        }

        public void setInteractiveAppSession(TvInteractiveAppManager.Session iAppSession) {
            this.mIAppSession = iAppSession;
        }

        public void release() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.releaseSession(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.releaseInternal();
        }

        void setMain() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setMainSession(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void setSurface(Surface surface) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setSurface(this.mToken, surface, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void dispatchSurfaceChanged(int format, int width, int height) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.dispatchSurfaceChanged(this.mToken, format, width, height, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void setStreamVolume(float volume) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                if (volume < 0.0f || volume > 1.0f) {
                    throw new IllegalArgumentException("volume should be between 0.0f and 1.0f");
                }
                this.mService.setVolume(this.mToken, volume, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void tune(Uri channelUri) {
            this.tune(channelUri, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tune(Uri channelUri, Bundle params) {
            Preconditions.checkNotNull(channelUri);
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            Object object = this.mMetadataLock;
            synchronized (object) {
                this.mAudioPresentations.clear();
                this.mAudioTracks.clear();
                this.mVideoTracks.clear();
                this.mSubtitleTracks.clear();
                this.mSelectedAudioProgramId = -1;
                this.mSelectedAudioPresentationId = -1;
                this.mSelectedAudioTrackId = null;
                this.mSelectedVideoTrackId = null;
                this.mSelectedSubtitleTrackId = null;
                this.mVideoWidth = 0;
                this.mVideoHeight = 0;
            }
            try {
                this.mService.tune(this.mToken, channelUri, params, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void setCaptionEnabled(boolean enabled) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setCaptionEnabled(this.mToken, enabled, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectAudioPresentation(int presentationId, int programId) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (presentationId != -1 && !this.containsAudioPresentation(this.mAudioPresentations, presentationId)) {
                    Log.w(TvInputManager.TAG, "Invalid audio presentation id: " + presentationId);
                    return;
                }
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.selectAudioPresentation(this.mToken, presentationId, programId, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean containsAudioPresentation(List<AudioPresentation> audioPresentations, int presentationId) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                for (AudioPresentation audioPresentation : audioPresentations) {
                    if (audioPresentation.getPresentationId() != presentationId) continue;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<AudioPresentation> getAudioPresentations() {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (this.mAudioPresentations == null) {
                    return new ArrayList<AudioPresentation>();
                }
                return new ArrayList<AudioPresentation>(this.mAudioPresentations);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSelectedProgramId() {
            Object object = this.mMetadataLock;
            synchronized (object) {
                return this.mSelectedAudioProgramId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSelectedAudioPresentationId() {
            Object object = this.mMetadataLock;
            synchronized (object) {
                return this.mSelectedAudioPresentationId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean updateAudioPresentations(List<AudioPresentation> audioPresentations) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                this.mAudioPresentations.clear();
                for (AudioPresentation presentation : audioPresentations) {
                    this.mAudioPresentations.add(presentation);
                }
                return !this.mAudioPresentations.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean updateAudioPresentationSelection(int presentationId, int programId) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (programId != this.mSelectedAudioProgramId || presentationId != this.mSelectedAudioPresentationId) {
                    this.mSelectedAudioPresentationId = presentationId;
                    this.mSelectedAudioProgramId = programId;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectTrack(int type, String trackId) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (type == 0) {
                    if (trackId != null && !this.containsTrack(this.mAudioTracks, trackId)) {
                        Log.w(TvInputManager.TAG, "Invalid audio trackId: " + trackId);
                        return;
                    }
                } else if (type == 1) {
                    if (trackId != null && !this.containsTrack(this.mVideoTracks, trackId)) {
                        Log.w(TvInputManager.TAG, "Invalid video trackId: " + trackId);
                        return;
                    }
                } else if (type == 2) {
                    if (trackId != null && !this.containsTrack(this.mSubtitleTracks, trackId)) {
                        Log.w(TvInputManager.TAG, "Invalid subtitle trackId: " + trackId);
                        return;
                    }
                } else {
                    throw new IllegalArgumentException("invalid type: " + type);
                }
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.selectTrack(this.mToken, type, trackId, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private boolean containsTrack(List<TvTrackInfo> tracks, String trackId) {
            for (TvTrackInfo track : tracks) {
                if (!track.getId().equals(trackId)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<TvTrackInfo> getTracks(int type) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (type == 0) {
                    if (this.mAudioTracks == null) {
                        return null;
                    }
                    return new ArrayList<TvTrackInfo>(this.mAudioTracks);
                }
                if (type == 1) {
                    if (this.mVideoTracks == null) {
                        return null;
                    }
                    return new ArrayList<TvTrackInfo>(this.mVideoTracks);
                }
                if (type == 2) {
                    if (this.mSubtitleTracks == null) {
                        return null;
                    }
                    return new ArrayList<TvTrackInfo>(this.mSubtitleTracks);
                }
            }
            throw new IllegalArgumentException("invalid type: " + type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getSelectedTrack(int type) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (type == 0) {
                    return this.mSelectedAudioTrackId;
                }
                if (type == 1) {
                    return this.mSelectedVideoTrackId;
                }
                if (type == 2) {
                    return this.mSelectedSubtitleTrackId;
                }
            }
            throw new IllegalArgumentException("invalid type: " + type);
        }

        public void setInteractiveAppNotificationEnabled(boolean enabled) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setInteractiveAppNotificationEnabled(this.mToken, enabled, this.mUserId);
                this.mIAppNotificationEnabled = enabled;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean updateTracks(List<TvTrackInfo> tracks) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                this.mAudioTracks.clear();
                this.mVideoTracks.clear();
                this.mSubtitleTracks.clear();
                for (TvTrackInfo track : tracks) {
                    if (track.getType() == 0) {
                        this.mAudioTracks.add(track);
                        continue;
                    }
                    if (track.getType() == 1) {
                        this.mVideoTracks.add(track);
                        continue;
                    }
                    if (track.getType() != 2) continue;
                    this.mSubtitleTracks.add(track);
                }
                return !this.mAudioTracks.isEmpty() || !this.mVideoTracks.isEmpty() || !this.mSubtitleTracks.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean updateTrackSelection(int type, String trackId) {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (type == 0 && !TextUtils.equals(trackId, this.mSelectedAudioTrackId)) {
                    this.mSelectedAudioTrackId = trackId;
                    return true;
                }
                if (type == 1 && !TextUtils.equals(trackId, this.mSelectedVideoTrackId)) {
                    this.mSelectedVideoTrackId = trackId;
                    return true;
                }
                if (type == 2 && !TextUtils.equals(trackId, this.mSelectedSubtitleTrackId)) {
                    this.mSelectedSubtitleTrackId = trackId;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TvTrackInfo getVideoTrackToNotify() {
            Object object = this.mMetadataLock;
            synchronized (object) {
                if (!this.mVideoTracks.isEmpty() && this.mSelectedVideoTrackId != null) {
                    for (TvTrackInfo track : this.mVideoTracks) {
                        if (!track.getId().equals(this.mSelectedVideoTrackId)) continue;
                        int videoWidth = track.getVideoWidth();
                        int videoHeight = track.getVideoHeight();
                        if (this.mVideoWidth == videoWidth && this.mVideoHeight == videoHeight) continue;
                        this.mVideoWidth = videoWidth;
                        this.mVideoHeight = videoHeight;
                        return track;
                    }
                }
            }
            return null;
        }

        void timeShiftPlay(Uri recordedProgramUri) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftPlay(this.mToken, recordedProgramUri, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void timeShiftPause() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftPause(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void timeShiftResume() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftResume(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void timeShiftSeekTo(long timeMs) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftSeekTo(this.mToken, timeMs, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void timeShiftSetPlaybackParams(PlaybackParams params) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftSetPlaybackParams(this.mToken, params, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void timeShiftSetMode(int mode) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftSetMode(this.mToken, mode, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void timeShiftEnablePositionTracking(boolean enable) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.timeShiftEnablePositionTracking(this.mToken, enable, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void notifyTvMessage(int type, Bundle data) {
            try {
                this.mService.notifyTvMessage(this.mToken, type, data, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void setTvMessageEnabled(int type, boolean enabled) {
            try {
                this.mService.setTvMessageEnabled(this.mToken, type, enabled, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void startRecording(Uri programUri) {
            this.startRecording(programUri, null);
        }

        void startRecording(Uri programUri, Bundle params) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.startRecording(this.mToken, programUri, params, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void stopRecording() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.stopRecording(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void pauseRecording(Bundle params) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.pauseRecording(this.mToken, params, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void resumeRecording(Bundle params) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.resumeRecording(this.mToken, params, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void sendAppPrivateCommand(String action, Bundle data) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.sendAppPrivateCommand(this.mToken, action, data, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void createOverlayView(View view, Rect frame) {
            Preconditions.checkNotNull(view);
            Preconditions.checkNotNull(frame);
            if (view.getWindowToken() == null) {
                throw new IllegalStateException("view must be attached to a window");
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.createOverlayView(this.mToken, view.getWindowToken(), frame, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void relayoutOverlayView(Rect frame) {
            Preconditions.checkNotNull(frame);
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.relayoutOverlayView(this.mToken, frame, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void removeOverlayView() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.removeOverlayView(this.mToken, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void unblockContent(TvContentRating unblockedRating) {
            Preconditions.checkNotNull(unblockedRating);
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.unblockContent(this.mToken, unblockedRating.flattenToString(), this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int dispatchInputEvent(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
            Preconditions.checkNotNull(event);
            Preconditions.checkNotNull(callback);
            Preconditions.checkNotNull(handler);
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                if (this.mChannel == null) {
                    return 0;
                }
                PendingEvent p = this.obtainPendingEventLocked(event, token, callback, handler);
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    return this.sendInputEventOnMainLooperLocked(p);
                }
                Message msg = this.mHandler.obtainMessage(1, p);
                msg.setAsynchronous(true);
                this.mHandler.sendMessage(msg);
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendInputEventAndReportResultOnMainLooper(PendingEvent p) {
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                int result = this.sendInputEventOnMainLooperLocked(p);
                if (result == -1) {
                    return;
                }
            }
            this.invokeFinishedInputEventCallback(p, false);
        }

        private int sendInputEventOnMainLooperLocked(PendingEvent p) {
            if (this.mChannel != null) {
                InputEvent event;
                int seq;
                if (this.mSender == null) {
                    this.mSender = new TvInputEventSender(this.mChannel, this.mHandler.getLooper());
                }
                if (this.mSender.sendInputEvent(seq = (event = p.mEvent).getSequenceNumber(), event)) {
                    this.mPendingEvents.put(seq, p);
                    Message msg = this.mHandler.obtainMessage(2, p);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageDelayed(msg, 2500L);
                    return -1;
                }
                Log.w(TvInputManager.TAG, "Unable to send input event to session: " + this.mToken + " dropping:" + event);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishedInputEvent(int seq, boolean handled, boolean timeout) {
            PendingEvent p;
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                int index = this.mPendingEvents.indexOfKey(seq);
                if (index < 0) {
                    return;
                }
                p = this.mPendingEvents.valueAt(index);
                this.mPendingEvents.removeAt(index);
                if (timeout) {
                    Log.w(TvInputManager.TAG, "Timeout waiting for session to handle input event after 2500 ms: " + this.mToken);
                } else {
                    this.mHandler.removeMessages(2, p);
                }
            }
            this.invokeFinishedInputEventCallback(p, handled);
        }

        void invokeFinishedInputEventCallback(PendingEvent p, boolean handled) {
            p.mHandled = handled;
            if (p.mEventHandler.getLooper().isCurrentThread()) {
                p.run();
            } else {
                Message msg = Message.obtain(p.mEventHandler, p);
                msg.setAsynchronous(true);
                msg.sendToTarget();
            }
        }

        private void flushPendingEventsLocked() {
            this.mHandler.removeMessages(3);
            int count = this.mPendingEvents.size();
            for (int i = 0; i < count; ++i) {
                int seq = this.mPendingEvents.keyAt(i);
                Message msg = this.mHandler.obtainMessage(3, seq, 0);
                msg.setAsynchronous(true);
                msg.sendToTarget();
            }
        }

        private PendingEvent obtainPendingEventLocked(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
            PendingEvent p = this.mPendingEventPool.acquire();
            if (p == null) {
                p = new PendingEvent();
            }
            p.mEvent = event;
            p.mEventToken = token;
            p.mCallback = callback;
            p.mEventHandler = handler;
            return p;
        }

        private void recyclePendingEventLocked(PendingEvent p) {
            p.recycle();
            this.mPendingEventPool.release(p);
        }

        IBinder getToken() {
            return this.mToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseInternal() {
            this.mToken = null;
            Object object = this.mHandler;
            synchronized (object) {
                if (this.mChannel != null) {
                    if (this.mSender != null) {
                        this.flushPendingEventsLocked();
                        this.mSender.dispose();
                        this.mSender = null;
                    }
                    this.mChannel.dispose();
                    this.mChannel = null;
                }
            }
            object = this.mSessionCallbackRecordMap;
            synchronized (object) {
                this.mSessionCallbackRecordMap.delete(this.mSeq);
            }
        }

        public void requestBroadcastInfo(BroadcastInfoRequest request) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.requestBroadcastInfo(this.mToken, request, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void removeBroadcastInfo(int requestId) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.removeBroadcastInfo(this.mToken, requestId, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void requestAd(AdRequest request) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.requestAd(this.mToken, request, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void notifyAdBufferReady(AdBuffer buffer) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.notifyAdBufferReady(this.mToken, buffer, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            finally {
                if (buffer != null) {
                    buffer.getSharedMemory().close();
                }
            }
        }

        private class InputEventHandler
        extends Handler {
            public static final int MSG_SEND_INPUT_EVENT = 1;
            public static final int MSG_TIMEOUT_INPUT_EVENT = 2;
            public static final int MSG_FLUSH_INPUT_EVENT = 3;

            InputEventHandler(Looper looper) {
                super(looper, null, true);
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        Session.this.sendInputEventAndReportResultOnMainLooper((PendingEvent)msg.obj);
                        return;
                    }
                    case 2: {
                        Session.this.finishedInputEvent(msg.arg1, false, true);
                        return;
                    }
                    case 3: {
                        Session.this.finishedInputEvent(msg.arg1, false, false);
                        return;
                    }
                }
            }
        }

        public static interface FinishedInputEventCallback {
            public void onFinishedInputEvent(Object var1, boolean var2);
        }

        private class PendingEvent
        implements Runnable {
            public InputEvent mEvent;
            public Object mEventToken;
            public FinishedInputEventCallback mCallback;
            public Handler mEventHandler;
            public boolean mHandled;

            private PendingEvent() {
            }

            public void recycle() {
                this.mEvent = null;
                this.mEventToken = null;
                this.mCallback = null;
                this.mEventHandler = null;
                this.mHandled = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.mCallback.onFinishedInputEvent(this.mEventToken, this.mHandled);
                Handler handler = this.mEventHandler;
                synchronized (handler) {
                    Session.this.recyclePendingEventLocked(this);
                }
            }
        }

        private class TvInputEventSender
        extends InputEventSender {
            public TvInputEventSender(InputChannel inputChannel, Looper looper) {
                super(inputChannel, looper);
            }

            @Override
            public void onInputEventFinished(int seq, boolean handled) {
                Session.this.finishedInputEvent(seq, handled, false);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SignalStrength {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BroadcastInfoType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InputState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecordingError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimeShiftMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimeShiftStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TvMessageType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoUnavailableReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DvbDeviceType {
    }
}

