/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.interactive;

import android.graphics.Rect;
import android.media.tv.AdBuffer;
import android.media.tv.AdRequest;
import android.media.tv.BroadcastInfoRequest;
import android.media.tv.TvRecordingInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.InputChannel;

public interface ITvInteractiveAppClient
extends IInterface {
    public static final String DESCRIPTOR = "android.media.tv.interactive.ITvInteractiveAppClient";

    public void onSessionCreated(String var1, IBinder var2, InputChannel var3, int var4) throws RemoteException;

    public void onSessionReleased(int var1) throws RemoteException;

    public void onLayoutSurface(int var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void onBroadcastInfoRequest(BroadcastInfoRequest var1, int var2) throws RemoteException;

    public void onRemoveBroadcastInfo(int var1, int var2) throws RemoteException;

    public void onSessionStateChanged(int var1, int var2, int var3) throws RemoteException;

    public void onBiInteractiveAppCreated(Uri var1, String var2, int var3) throws RemoteException;

    public void onTeletextAppStateChanged(int var1, int var2) throws RemoteException;

    public void onAdBufferReady(AdBuffer var1, int var2) throws RemoteException;

    public void onCommandRequest(String var1, Bundle var2, int var3) throws RemoteException;

    public void onTimeShiftCommandRequest(String var1, Bundle var2, int var3) throws RemoteException;

    public void onSetVideoBounds(Rect var1, int var2) throws RemoteException;

    public void onRequestCurrentVideoBounds(int var1) throws RemoteException;

    public void onRequestCurrentChannelUri(int var1) throws RemoteException;

    public void onRequestCurrentChannelLcn(int var1) throws RemoteException;

    public void onRequestStreamVolume(int var1) throws RemoteException;

    public void onRequestTrackInfoList(int var1) throws RemoteException;

    public void onRequestCurrentTvInputId(int var1) throws RemoteException;

    public void onRequestTimeShiftMode(int var1) throws RemoteException;

    public void onRequestAvailableSpeeds(int var1) throws RemoteException;

    public void onRequestStartRecording(String var1, Uri var2, int var3) throws RemoteException;

    public void onRequestStopRecording(String var1, int var2) throws RemoteException;

    public void onRequestScheduleRecording(String var1, String var2, Uri var3, Uri var4, Bundle var5, int var6) throws RemoteException;

    public void onRequestScheduleRecording2(String var1, String var2, Uri var3, long var4, long var6, int var8, Bundle var9, int var10) throws RemoteException;

    public void onSetTvRecordingInfo(String var1, TvRecordingInfo var2, int var3) throws RemoteException;

    public void onRequestTvRecordingInfo(String var1, int var2) throws RemoteException;

    public void onRequestTvRecordingInfoList(int var1, int var2) throws RemoteException;

    public void onRequestSigning(String var1, String var2, String var3, byte[] var4, int var5) throws RemoteException;

    public void onAdRequest(AdRequest var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInteractiveAppClient {
        static final int TRANSACTION_onSessionCreated = 1;
        static final int TRANSACTION_onSessionReleased = 2;
        static final int TRANSACTION_onLayoutSurface = 3;
        static final int TRANSACTION_onBroadcastInfoRequest = 4;
        static final int TRANSACTION_onRemoveBroadcastInfo = 5;
        static final int TRANSACTION_onSessionStateChanged = 6;
        static final int TRANSACTION_onBiInteractiveAppCreated = 7;
        static final int TRANSACTION_onTeletextAppStateChanged = 8;
        static final int TRANSACTION_onAdBufferReady = 9;
        static final int TRANSACTION_onCommandRequest = 10;
        static final int TRANSACTION_onTimeShiftCommandRequest = 11;
        static final int TRANSACTION_onSetVideoBounds = 12;
        static final int TRANSACTION_onRequestCurrentVideoBounds = 13;
        static final int TRANSACTION_onRequestCurrentChannelUri = 14;
        static final int TRANSACTION_onRequestCurrentChannelLcn = 15;
        static final int TRANSACTION_onRequestStreamVolume = 16;
        static final int TRANSACTION_onRequestTrackInfoList = 17;
        static final int TRANSACTION_onRequestCurrentTvInputId = 18;
        static final int TRANSACTION_onRequestTimeShiftMode = 19;
        static final int TRANSACTION_onRequestAvailableSpeeds = 20;
        static final int TRANSACTION_onRequestStartRecording = 21;
        static final int TRANSACTION_onRequestStopRecording = 22;
        static final int TRANSACTION_onRequestScheduleRecording = 23;
        static final int TRANSACTION_onRequestScheduleRecording2 = 24;
        static final int TRANSACTION_onSetTvRecordingInfo = 25;
        static final int TRANSACTION_onRequestTvRecordingInfo = 26;
        static final int TRANSACTION_onRequestTvRecordingInfoList = 27;
        static final int TRANSACTION_onRequestSigning = 28;
        static final int TRANSACTION_onAdRequest = 29;

        public Stub() {
            this.attachInterface(this, ITvInteractiveAppClient.DESCRIPTOR);
        }

        public static ITvInteractiveAppClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITvInteractiveAppClient.DESCRIPTOR);
            if (iin != null && iin instanceof ITvInteractiveAppClient) {
                return (ITvInteractiveAppClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSessionCreated";
                }
                case 2: {
                    return "onSessionReleased";
                }
                case 3: {
                    return "onLayoutSurface";
                }
                case 4: {
                    return "onBroadcastInfoRequest";
                }
                case 5: {
                    return "onRemoveBroadcastInfo";
                }
                case 6: {
                    return "onSessionStateChanged";
                }
                case 7: {
                    return "onBiInteractiveAppCreated";
                }
                case 8: {
                    return "onTeletextAppStateChanged";
                }
                case 9: {
                    return "onAdBufferReady";
                }
                case 10: {
                    return "onCommandRequest";
                }
                case 11: {
                    return "onTimeShiftCommandRequest";
                }
                case 12: {
                    return "onSetVideoBounds";
                }
                case 13: {
                    return "onRequestCurrentVideoBounds";
                }
                case 14: {
                    return "onRequestCurrentChannelUri";
                }
                case 15: {
                    return "onRequestCurrentChannelLcn";
                }
                case 16: {
                    return "onRequestStreamVolume";
                }
                case 17: {
                    return "onRequestTrackInfoList";
                }
                case 18: {
                    return "onRequestCurrentTvInputId";
                }
                case 19: {
                    return "onRequestTimeShiftMode";
                }
                case 20: {
                    return "onRequestAvailableSpeeds";
                }
                case 21: {
                    return "onRequestStartRecording";
                }
                case 22: {
                    return "onRequestStopRecording";
                }
                case 23: {
                    return "onRequestScheduleRecording";
                }
                case 24: {
                    return "onRequestScheduleRecording2";
                }
                case 25: {
                    return "onSetTvRecordingInfo";
                }
                case 26: {
                    return "onRequestTvRecordingInfo";
                }
                case 27: {
                    return "onRequestTvRecordingInfoList";
                }
                case 28: {
                    return "onRequestSigning";
                }
                case 29: {
                    return "onAdRequest";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITvInteractiveAppClient.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    InputChannel _arg2 = data.readTypedObject(InputChannel.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionCreated(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionReleased(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onLayoutSurface(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 4: {
                    BroadcastInfoRequest _arg0 = data.readTypedObject(BroadcastInfoRequest.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBroadcastInfoRequest(_arg0, _arg1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRemoveBroadcastInfo(_arg0, _arg1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionStateChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBiInteractiveAppCreated(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTeletextAppStateChanged(_arg0, _arg1);
                    break;
                }
                case 9: {
                    AdBuffer _arg0 = data.readTypedObject(AdBuffer.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAdBufferReady(_arg0, _arg1);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCommandRequest(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTimeShiftCommandRequest(_arg0, _arg1, _arg2);
                    break;
                }
                case 12: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSetVideoBounds(_arg0, _arg1);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestCurrentVideoBounds(_arg0);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestCurrentChannelUri(_arg0);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestCurrentChannelLcn(_arg0);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestStreamVolume(_arg0);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestTrackInfoList(_arg0);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestCurrentTvInputId(_arg0);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestTimeShiftMode(_arg0);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestAvailableSpeeds(_arg0);
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestStartRecording(_arg0, _arg1, _arg2);
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestStopRecording(_arg0, _arg1);
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Uri _arg2 = data.readTypedObject(Uri.CREATOR);
                    Uri _arg3 = data.readTypedObject(Uri.CREATOR);
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestScheduleRecording(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Uri _arg2 = data.readTypedObject(Uri.CREATOR);
                    long _arg3 = data.readLong();
                    long _arg4 = data.readLong();
                    int _arg5 = data.readInt();
                    Bundle _arg6 = data.readTypedObject(Bundle.CREATOR);
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestScheduleRecording2(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    TvRecordingInfo _arg1 = data.readTypedObject(TvRecordingInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSetTvRecordingInfo(_arg0, _arg1, _arg2);
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestTvRecordingInfo(_arg0, _arg1);
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestTvRecordingInfoList(_arg0, _arg1);
                    break;
                }
                case 28: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    byte[] _arg3 = data.createByteArray();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestSigning(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 29: {
                    AdRequest _arg0 = data.readTypedObject(AdRequest.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAdRequest(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 28;
        }

        private static class Proxy
        implements ITvInteractiveAppClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITvInteractiveAppClient.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionCreated(String iAppServiceId, IBinder token, InputChannel channel, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(iAppServiceId);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(channel, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionReleased(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutSurface(int left, int top, int right, int bottom, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(left);
                    _data.writeInt(top);
                    _data.writeInt(right);
                    _data.writeInt(bottom);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastInfoRequest(BroadcastInfoRequest request, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoveBroadcastInfo(int id2, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionStateChanged(int state, int err, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(state);
                    _data.writeInt(err);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiInteractiveAppCreated(Uri biIAppUri, String biIAppId, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeTypedObject(biIAppUri, 0);
                    _data.writeString(biIAppId);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTeletextAppStateChanged(int state, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(state);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdBufferReady(AdBuffer buffer, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeTypedObject(buffer, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCommandRequest(String cmdType, Bundle parameters, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(cmdType);
                    _data.writeTypedObject(parameters, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeShiftCommandRequest(String cmdType, Bundle parameters, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(cmdType);
                    _data.writeTypedObject(parameters, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetVideoBounds(Rect rect, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeTypedObject(rect, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentVideoBounds(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentChannelUri(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentChannelLcn(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestStreamVolume(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestTrackInfoList(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestCurrentTvInputId(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestTimeShiftMode(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestAvailableSpeeds(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestStartRecording(String requestId, Uri programUri, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(requestId);
                    _data.writeTypedObject(programUri, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestStopRecording(String recordingId, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(recordingId);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestScheduleRecording(String requestId, String inputId, Uri channelUri, Uri programUri, Bundle params, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(requestId);
                    _data.writeString(inputId);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeTypedObject(programUri, 0);
                    _data.writeTypedObject(params, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestScheduleRecording2(String requestId, String inputId, Uri channelUri, long start, long duration, int repeat, Bundle params, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(requestId);
                    _data.writeString(inputId);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeLong(start);
                    _data.writeLong(duration);
                    _data.writeInt(repeat);
                    _data.writeTypedObject(params, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetTvRecordingInfo(String recordingId, TvRecordingInfo recordingInfo, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(recordingId);
                    _data.writeTypedObject(recordingInfo, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestTvRecordingInfo(String recordingId, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(recordingId);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestTvRecordingInfoList(int type, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestSigning(String id2, String algorithm, String alias, byte[] data, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeString(algorithm);
                    _data.writeString(alias);
                    _data.writeByteArray(data);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdRequest(AdRequest request, int Seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppClient.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(Seq);
                    boolean bl = this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvInteractiveAppClient {
        @Override
        public void onSessionCreated(String iAppServiceId, IBinder token, InputChannel channel, int seq) throws RemoteException {
        }

        @Override
        public void onSessionReleased(int seq) throws RemoteException {
        }

        @Override
        public void onLayoutSurface(int left, int top, int right, int bottom, int seq) throws RemoteException {
        }

        @Override
        public void onBroadcastInfoRequest(BroadcastInfoRequest request, int seq) throws RemoteException {
        }

        @Override
        public void onRemoveBroadcastInfo(int id2, int seq) throws RemoteException {
        }

        @Override
        public void onSessionStateChanged(int state, int err, int seq) throws RemoteException {
        }

        @Override
        public void onBiInteractiveAppCreated(Uri biIAppUri, String biIAppId, int seq) throws RemoteException {
        }

        @Override
        public void onTeletextAppStateChanged(int state, int seq) throws RemoteException {
        }

        @Override
        public void onAdBufferReady(AdBuffer buffer, int seq) throws RemoteException {
        }

        @Override
        public void onCommandRequest(String cmdType, Bundle parameters, int seq) throws RemoteException {
        }

        @Override
        public void onTimeShiftCommandRequest(String cmdType, Bundle parameters, int seq) throws RemoteException {
        }

        @Override
        public void onSetVideoBounds(Rect rect, int seq) throws RemoteException {
        }

        @Override
        public void onRequestCurrentVideoBounds(int seq) throws RemoteException {
        }

        @Override
        public void onRequestCurrentChannelUri(int seq) throws RemoteException {
        }

        @Override
        public void onRequestCurrentChannelLcn(int seq) throws RemoteException {
        }

        @Override
        public void onRequestStreamVolume(int seq) throws RemoteException {
        }

        @Override
        public void onRequestTrackInfoList(int seq) throws RemoteException {
        }

        @Override
        public void onRequestCurrentTvInputId(int seq) throws RemoteException {
        }

        @Override
        public void onRequestTimeShiftMode(int seq) throws RemoteException {
        }

        @Override
        public void onRequestAvailableSpeeds(int seq) throws RemoteException {
        }

        @Override
        public void onRequestStartRecording(String requestId, Uri programUri, int seq) throws RemoteException {
        }

        @Override
        public void onRequestStopRecording(String recordingId, int seq) throws RemoteException {
        }

        @Override
        public void onRequestScheduleRecording(String requestId, String inputId, Uri channelUri, Uri programUri, Bundle params, int seq) throws RemoteException {
        }

        @Override
        public void onRequestScheduleRecording2(String requestId, String inputId, Uri channelUri, long start, long duration, int repeat, Bundle params, int seq) throws RemoteException {
        }

        @Override
        public void onSetTvRecordingInfo(String recordingId, TvRecordingInfo recordingInfo, int seq) throws RemoteException {
        }

        @Override
        public void onRequestTvRecordingInfo(String recordingId, int seq) throws RemoteException {
        }

        @Override
        public void onRequestTvRecordingInfoList(int type, int seq) throws RemoteException {
        }

        @Override
        public void onRequestSigning(String id2, String algorithm, String alias, byte[] data, int seq) throws RemoteException {
        }

        @Override
        public void onAdRequest(AdRequest request, int Seq) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

