/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.interactive;

import android.graphics.Rect;
import android.media.PlaybackParams;
import android.media.tv.AdBuffer;
import android.media.tv.AdResponse;
import android.media.tv.BroadcastInfoResponse;
import android.media.tv.TvRecordingInfo;
import android.media.tv.TvTrackInfo;
import android.media.tv.interactive.AppLinkInfo;
import android.media.tv.interactive.ITvInteractiveAppClient;
import android.media.tv.interactive.ITvInteractiveAppManagerCallback;
import android.media.tv.interactive.TvInteractiveAppServiceInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;

public interface ITvInteractiveAppManager
extends IInterface {
    public static final String DESCRIPTOR = "android.media.tv.interactive.ITvInteractiveAppManager";

    public List<TvInteractiveAppServiceInfo> getTvInteractiveAppServiceList(int var1) throws RemoteException;

    public List<AppLinkInfo> getAppLinkInfoList(int var1) throws RemoteException;

    public void registerAppLinkInfo(String var1, AppLinkInfo var2, int var3) throws RemoteException;

    public void unregisterAppLinkInfo(String var1, AppLinkInfo var2, int var3) throws RemoteException;

    public void sendAppLinkCommand(String var1, Bundle var2, int var3) throws RemoteException;

    public void startInteractiveApp(IBinder var1, int var2) throws RemoteException;

    public void stopInteractiveApp(IBinder var1, int var2) throws RemoteException;

    public void resetInteractiveApp(IBinder var1, int var2) throws RemoteException;

    public void createBiInteractiveApp(IBinder var1, Uri var2, Bundle var3, int var4) throws RemoteException;

    public void destroyBiInteractiveApp(IBinder var1, String var2, int var3) throws RemoteException;

    public void setTeletextAppEnabled(IBinder var1, boolean var2, int var3) throws RemoteException;

    public void sendCurrentVideoBounds(IBinder var1, Rect var2, int var3) throws RemoteException;

    public void sendCurrentChannelUri(IBinder var1, Uri var2, int var3) throws RemoteException;

    public void sendCurrentChannelLcn(IBinder var1, int var2, int var3) throws RemoteException;

    public void sendStreamVolume(IBinder var1, float var2, int var3) throws RemoteException;

    public void sendTrackInfoList(IBinder var1, List<TvTrackInfo> var2, int var3) throws RemoteException;

    public void sendCurrentTvInputId(IBinder var1, String var2, int var3) throws RemoteException;

    public void sendTimeShiftMode(IBinder var1, int var2, int var3) throws RemoteException;

    public void sendAvailableSpeeds(IBinder var1, float[] var2, int var3) throws RemoteException;

    public void sendSigningResult(IBinder var1, String var2, byte[] var3, int var4) throws RemoteException;

    public void sendTvRecordingInfo(IBinder var1, TvRecordingInfo var2, int var3) throws RemoteException;

    public void sendTvRecordingInfoList(IBinder var1, List<TvRecordingInfo> var2, int var3) throws RemoteException;

    public void notifyError(IBinder var1, String var2, Bundle var3, int var4) throws RemoteException;

    public void notifyTimeShiftPlaybackParams(IBinder var1, PlaybackParams var2, int var3) throws RemoteException;

    public void notifyTimeShiftStatusChanged(IBinder var1, String var2, int var3, int var4) throws RemoteException;

    public void notifyTimeShiftStartPositionChanged(IBinder var1, String var2, long var3, int var5) throws RemoteException;

    public void notifyTimeShiftCurrentPositionChanged(IBinder var1, String var2, long var3, int var5) throws RemoteException;

    public void notifyRecordingConnectionFailed(IBinder var1, String var2, String var3, int var4) throws RemoteException;

    public void notifyRecordingDisconnected(IBinder var1, String var2, String var3, int var4) throws RemoteException;

    public void notifyRecordingTuned(IBinder var1, String var2, Uri var3, int var4) throws RemoteException;

    public void notifyRecordingError(IBinder var1, String var2, int var3, int var4) throws RemoteException;

    public void notifyRecordingScheduled(IBinder var1, String var2, String var3, int var4) throws RemoteException;

    public void createSession(ITvInteractiveAppClient var1, String var2, int var3, int var4, int var5) throws RemoteException;

    public void releaseSession(IBinder var1, int var2) throws RemoteException;

    public void notifyTuned(IBinder var1, Uri var2, int var3) throws RemoteException;

    public void notifyTrackSelected(IBinder var1, int var2, String var3, int var4) throws RemoteException;

    public void notifyTracksChanged(IBinder var1, List<TvTrackInfo> var2, int var3) throws RemoteException;

    public void notifyVideoAvailable(IBinder var1, int var2) throws RemoteException;

    public void notifyVideoUnavailable(IBinder var1, int var2, int var3) throws RemoteException;

    public void notifyContentAllowed(IBinder var1, int var2) throws RemoteException;

    public void notifyContentBlocked(IBinder var1, String var2, int var3) throws RemoteException;

    public void notifySignalStrength(IBinder var1, int var2, int var3) throws RemoteException;

    public void notifyRecordingStarted(IBinder var1, String var2, String var3, int var4) throws RemoteException;

    public void notifyRecordingStopped(IBinder var1, String var2, int var3) throws RemoteException;

    public void notifyTvMessage(IBinder var1, int var2, Bundle var3, int var4) throws RemoteException;

    public void setSurface(IBinder var1, Surface var2, int var3) throws RemoteException;

    public void dispatchSurfaceChanged(IBinder var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void notifyBroadcastInfoResponse(IBinder var1, BroadcastInfoResponse var2, int var3) throws RemoteException;

    public void notifyAdResponse(IBinder var1, AdResponse var2, int var3) throws RemoteException;

    public void notifyAdBufferConsumed(IBinder var1, AdBuffer var2, int var3) throws RemoteException;

    public void createMediaView(IBinder var1, IBinder var2, Rect var3, int var4) throws RemoteException;

    public void relayoutMediaView(IBinder var1, Rect var2, int var3) throws RemoteException;

    public void removeMediaView(IBinder var1, int var2) throws RemoteException;

    public void registerCallback(ITvInteractiveAppManagerCallback var1, int var2) throws RemoteException;

    public void unregisterCallback(ITvInteractiveAppManagerCallback var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInteractiveAppManager {
        static final int TRANSACTION_getTvInteractiveAppServiceList = 1;
        static final int TRANSACTION_getAppLinkInfoList = 2;
        static final int TRANSACTION_registerAppLinkInfo = 3;
        static final int TRANSACTION_unregisterAppLinkInfo = 4;
        static final int TRANSACTION_sendAppLinkCommand = 5;
        static final int TRANSACTION_startInteractiveApp = 6;
        static final int TRANSACTION_stopInteractiveApp = 7;
        static final int TRANSACTION_resetInteractiveApp = 8;
        static final int TRANSACTION_createBiInteractiveApp = 9;
        static final int TRANSACTION_destroyBiInteractiveApp = 10;
        static final int TRANSACTION_setTeletextAppEnabled = 11;
        static final int TRANSACTION_sendCurrentVideoBounds = 12;
        static final int TRANSACTION_sendCurrentChannelUri = 13;
        static final int TRANSACTION_sendCurrentChannelLcn = 14;
        static final int TRANSACTION_sendStreamVolume = 15;
        static final int TRANSACTION_sendTrackInfoList = 16;
        static final int TRANSACTION_sendCurrentTvInputId = 17;
        static final int TRANSACTION_sendTimeShiftMode = 18;
        static final int TRANSACTION_sendAvailableSpeeds = 19;
        static final int TRANSACTION_sendSigningResult = 20;
        static final int TRANSACTION_sendTvRecordingInfo = 21;
        static final int TRANSACTION_sendTvRecordingInfoList = 22;
        static final int TRANSACTION_notifyError = 23;
        static final int TRANSACTION_notifyTimeShiftPlaybackParams = 24;
        static final int TRANSACTION_notifyTimeShiftStatusChanged = 25;
        static final int TRANSACTION_notifyTimeShiftStartPositionChanged = 26;
        static final int TRANSACTION_notifyTimeShiftCurrentPositionChanged = 27;
        static final int TRANSACTION_notifyRecordingConnectionFailed = 28;
        static final int TRANSACTION_notifyRecordingDisconnected = 29;
        static final int TRANSACTION_notifyRecordingTuned = 30;
        static final int TRANSACTION_notifyRecordingError = 31;
        static final int TRANSACTION_notifyRecordingScheduled = 32;
        static final int TRANSACTION_createSession = 33;
        static final int TRANSACTION_releaseSession = 34;
        static final int TRANSACTION_notifyTuned = 35;
        static final int TRANSACTION_notifyTrackSelected = 36;
        static final int TRANSACTION_notifyTracksChanged = 37;
        static final int TRANSACTION_notifyVideoAvailable = 38;
        static final int TRANSACTION_notifyVideoUnavailable = 39;
        static final int TRANSACTION_notifyContentAllowed = 40;
        static final int TRANSACTION_notifyContentBlocked = 41;
        static final int TRANSACTION_notifySignalStrength = 42;
        static final int TRANSACTION_notifyRecordingStarted = 43;
        static final int TRANSACTION_notifyRecordingStopped = 44;
        static final int TRANSACTION_notifyTvMessage = 45;
        static final int TRANSACTION_setSurface = 46;
        static final int TRANSACTION_dispatchSurfaceChanged = 47;
        static final int TRANSACTION_notifyBroadcastInfoResponse = 48;
        static final int TRANSACTION_notifyAdResponse = 49;
        static final int TRANSACTION_notifyAdBufferConsumed = 50;
        static final int TRANSACTION_createMediaView = 51;
        static final int TRANSACTION_relayoutMediaView = 52;
        static final int TRANSACTION_removeMediaView = 53;
        static final int TRANSACTION_registerCallback = 54;
        static final int TRANSACTION_unregisterCallback = 55;

        public Stub() {
            this.attachInterface(this, ITvInteractiveAppManager.DESCRIPTOR);
        }

        public static ITvInteractiveAppManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITvInteractiveAppManager.DESCRIPTOR);
            if (iin != null && iin instanceof ITvInteractiveAppManager) {
                return (ITvInteractiveAppManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getTvInteractiveAppServiceList";
                }
                case 2: {
                    return "getAppLinkInfoList";
                }
                case 3: {
                    return "registerAppLinkInfo";
                }
                case 4: {
                    return "unregisterAppLinkInfo";
                }
                case 5: {
                    return "sendAppLinkCommand";
                }
                case 6: {
                    return "startInteractiveApp";
                }
                case 7: {
                    return "stopInteractiveApp";
                }
                case 8: {
                    return "resetInteractiveApp";
                }
                case 9: {
                    return "createBiInteractiveApp";
                }
                case 10: {
                    return "destroyBiInteractiveApp";
                }
                case 11: {
                    return "setTeletextAppEnabled";
                }
                case 12: {
                    return "sendCurrentVideoBounds";
                }
                case 13: {
                    return "sendCurrentChannelUri";
                }
                case 14: {
                    return "sendCurrentChannelLcn";
                }
                case 15: {
                    return "sendStreamVolume";
                }
                case 16: {
                    return "sendTrackInfoList";
                }
                case 17: {
                    return "sendCurrentTvInputId";
                }
                case 18: {
                    return "sendTimeShiftMode";
                }
                case 19: {
                    return "sendAvailableSpeeds";
                }
                case 20: {
                    return "sendSigningResult";
                }
                case 21: {
                    return "sendTvRecordingInfo";
                }
                case 22: {
                    return "sendTvRecordingInfoList";
                }
                case 23: {
                    return "notifyError";
                }
                case 24: {
                    return "notifyTimeShiftPlaybackParams";
                }
                case 25: {
                    return "notifyTimeShiftStatusChanged";
                }
                case 26: {
                    return "notifyTimeShiftStartPositionChanged";
                }
                case 27: {
                    return "notifyTimeShiftCurrentPositionChanged";
                }
                case 28: {
                    return "notifyRecordingConnectionFailed";
                }
                case 29: {
                    return "notifyRecordingDisconnected";
                }
                case 30: {
                    return "notifyRecordingTuned";
                }
                case 31: {
                    return "notifyRecordingError";
                }
                case 32: {
                    return "notifyRecordingScheduled";
                }
                case 33: {
                    return "createSession";
                }
                case 34: {
                    return "releaseSession";
                }
                case 35: {
                    return "notifyTuned";
                }
                case 36: {
                    return "notifyTrackSelected";
                }
                case 37: {
                    return "notifyTracksChanged";
                }
                case 38: {
                    return "notifyVideoAvailable";
                }
                case 39: {
                    return "notifyVideoUnavailable";
                }
                case 40: {
                    return "notifyContentAllowed";
                }
                case 41: {
                    return "notifyContentBlocked";
                }
                case 42: {
                    return "notifySignalStrength";
                }
                case 43: {
                    return "notifyRecordingStarted";
                }
                case 44: {
                    return "notifyRecordingStopped";
                }
                case 45: {
                    return "notifyTvMessage";
                }
                case 46: {
                    return "setSurface";
                }
                case 47: {
                    return "dispatchSurfaceChanged";
                }
                case 48: {
                    return "notifyBroadcastInfoResponse";
                }
                case 49: {
                    return "notifyAdResponse";
                }
                case 50: {
                    return "notifyAdBufferConsumed";
                }
                case 51: {
                    return "createMediaView";
                }
                case 52: {
                    return "relayoutMediaView";
                }
                case 53: {
                    return "removeMediaView";
                }
                case 54: {
                    return "registerCallback";
                }
                case 55: {
                    return "unregisterCallback";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITvInteractiveAppManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<TvInteractiveAppServiceInfo> _result = this.getTvInteractiveAppServiceList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AppLinkInfo> _result = this.getAppLinkInfoList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    AppLinkInfo _arg1 = data.readTypedObject(AppLinkInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerAppLinkInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    AppLinkInfo _arg1 = data.readTypedObject(AppLinkInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterAppLinkInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendAppLinkCommand(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startInteractiveApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopInteractiveApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.resetInteractiveApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createBiInteractiveApp(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroyBiInteractiveApp(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setTeletextAppEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IBinder _arg0 = data.readStrongBinder();
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendCurrentVideoBounds(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    IBinder _arg0 = data.readStrongBinder();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendCurrentChannelUri(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendCurrentChannelLcn(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IBinder _arg0 = data.readStrongBinder();
                    float _arg1 = data.readFloat();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendStreamVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    IBinder _arg0 = data.readStrongBinder();
                    ArrayList<TvTrackInfo> _arg1 = data.createTypedArrayList(TvTrackInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendTrackInfoList(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendCurrentTvInputId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendTimeShiftMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    float[] _arg1 = data.createFloatArray();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendAvailableSpeeds(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    byte[] _arg2 = data.createByteArray();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendSigningResult(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    IBinder _arg0 = data.readStrongBinder();
                    TvRecordingInfo _arg1 = data.readTypedObject(TvRecordingInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendTvRecordingInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IBinder _arg0 = data.readStrongBinder();
                    ArrayList<TvRecordingInfo> _arg1 = data.createTypedArrayList(TvRecordingInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendTvRecordingInfoList(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyError(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IBinder _arg0 = data.readStrongBinder();
                    PlaybackParams _arg1 = data.readTypedObject(PlaybackParams.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTimeShiftPlaybackParams(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTimeShiftStatusChanged(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTimeShiftStartPositionChanged(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTimeShiftCurrentPositionChanged(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyRecordingConnectionFailed(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyRecordingDisconnected(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    Uri _arg2 = data.readTypedObject(Uri.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyRecordingTuned(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyRecordingError(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyRecordingScheduled(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    ITvInteractiveAppClient _arg0 = ITvInteractiveAppClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createSession(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseSession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    IBinder _arg0 = data.readStrongBinder();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTuned(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTrackSelected(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    IBinder _arg0 = data.readStrongBinder();
                    ArrayList<TvTrackInfo> _arg1 = data.createTypedArrayList(TvTrackInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTracksChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyVideoAvailable(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyVideoUnavailable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyContentAllowed(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyContentBlocked(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifySignalStrength(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyRecordingStarted(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyRecordingStopped(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTvMessage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    IBinder _arg0 = data.readStrongBinder();
                    Surface _arg1 = data.readTypedObject(Surface.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSurface(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.dispatchSurfaceChanged(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    IBinder _arg0 = data.readStrongBinder();
                    BroadcastInfoResponse _arg1 = data.readTypedObject(BroadcastInfoResponse.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyBroadcastInfoResponse(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    IBinder _arg0 = data.readStrongBinder();
                    AdResponse _arg1 = data.readTypedObject(AdResponse.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyAdResponse(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    IBinder _arg0 = data.readStrongBinder();
                    AdBuffer _arg1 = data.readTypedObject(AdBuffer.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyAdBufferConsumed(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    Rect _arg2 = data.readTypedObject(Rect.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createMediaView(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    IBinder _arg0 = data.readStrongBinder();
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.relayoutMediaView(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeMediaView(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    ITvInteractiveAppManagerCallback _arg0 = ITvInteractiveAppManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    ITvInteractiveAppManagerCallback _arg0 = ITvInteractiveAppManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 54;
        }

        private static class Proxy
        implements ITvInteractiveAppManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITvInteractiveAppManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<TvInteractiveAppServiceInfo> getTvInteractiveAppServiceList(int userId) throws RemoteException {
                ArrayList<TvInteractiveAppServiceInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(TvInteractiveAppServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AppLinkInfo> getAppLinkInfoList(int userId) throws RemoteException {
                ArrayList<AppLinkInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AppLinkInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAppLinkInfo(String tiasId, AppLinkInfo info, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeString(tiasId);
                    _data.writeTypedObject(info, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAppLinkInfo(String tiasId, AppLinkInfo info, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeString(tiasId);
                    _data.writeTypedObject(info, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendAppLinkCommand(String tiasId, Bundle command, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeString(tiasId);
                    _data.writeTypedObject(command, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createBiInteractiveApp(IBinder sessionToken, Uri biIAppUri, Bundle params, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(biIAppUri, 0);
                    _data.writeTypedObject(params, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyBiInteractiveApp(IBinder sessionToken, String biIAppId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(biIAppId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTeletextAppEnabled(IBinder sessionToken, boolean enable, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeBoolean(enable);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCurrentVideoBounds(IBinder sessionToken, Rect bounds, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(bounds, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCurrentChannelUri(IBinder sessionToken, Uri channelUri, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCurrentChannelLcn(IBinder sessionToken, int lcn, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(lcn);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendStreamVolume(IBinder sessionToken, float volume, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeFloat(volume);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendTrackInfoList(IBinder sessionToken, List<TvTrackInfo> tracks, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedList(tracks, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCurrentTvInputId(IBinder sessionToken, String inputId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(inputId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendTimeShiftMode(IBinder sessionToken, int mode, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(mode);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendAvailableSpeeds(IBinder sessionToken, float[] speeds, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeFloatArray(speeds);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSigningResult(IBinder sessionToken, String signingId, byte[] result, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(signingId);
                    _data.writeByteArray(result);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendTvRecordingInfo(IBinder sessionToken, TvRecordingInfo recordingInfo, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(recordingInfo, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendTvRecordingInfoList(IBinder sessionToken, List<TvRecordingInfo> recordingInfoList, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedList(recordingInfoList, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyError(IBinder sessionToken, String errMsg, Bundle params, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(errMsg);
                    _data.writeTypedObject(params, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTimeShiftPlaybackParams(IBinder sessionToken, PlaybackParams params, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(params, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTimeShiftStatusChanged(IBinder sessionToken, String inputId, int status, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(inputId);
                    _data.writeInt(status);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTimeShiftStartPositionChanged(IBinder sessionToken, String inputId, long timeMs, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(inputId);
                    _data.writeLong(timeMs);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTimeShiftCurrentPositionChanged(IBinder sessionToken, String inputId, long timeMs, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(inputId);
                    _data.writeLong(timeMs);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRecordingConnectionFailed(IBinder sessionToken, String recordingId, String inputId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(recordingId);
                    _data.writeString(inputId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRecordingDisconnected(IBinder sessionToken, String recordingId, String inputId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(recordingId);
                    _data.writeString(inputId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRecordingTuned(IBinder sessionToken, String recordingId, Uri channelUri, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(recordingId);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRecordingError(IBinder sessionToken, String recordingId, int err, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(recordingId);
                    _data.writeInt(err);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRecordingScheduled(IBinder sessionToken, String recordingId, String requestId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(recordingId);
                    _data.writeString(requestId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createSession(ITvInteractiveAppClient client, String iAppServiceId, int type, int seq, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeString(iAppServiceId);
                    _data.writeInt(type);
                    _data.writeInt(seq);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSession(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTuned(IBinder sessionToken, Uri channelUri, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTrackSelected(IBinder sessionToken, int type, String trackId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(type);
                    _data.writeString(trackId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTracksChanged(IBinder sessionToken, List<TvTrackInfo> tracks, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedList(tracks, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyVideoAvailable(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyVideoUnavailable(IBinder sessionToken, int reason, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(reason);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyContentAllowed(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyContentBlocked(IBinder sessionToken, String rating, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(rating);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySignalStrength(IBinder sessionToken, int stength, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(stength);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRecordingStarted(IBinder sessionToken, String recordingId, String requestId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(recordingId);
                    _data.writeString(requestId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyRecordingStopped(IBinder sessionToken, String recordingId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(recordingId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTvMessage(IBinder sessionToken, int type, Bundle data, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(type);
                    _data.writeTypedObject(data, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSurface(IBinder sessionToken, Surface surface, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(surface, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchSurfaceChanged(IBinder sessionToken, int format, int width, int height, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(format);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyBroadcastInfoResponse(IBinder sessionToken, BroadcastInfoResponse response, int UserId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(response, 0);
                    _data.writeInt(UserId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAdResponse(IBinder sessionToken, AdResponse response, int UserId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(response, 0);
                    _data.writeInt(UserId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAdBufferConsumed(IBinder sessionToken, AdBuffer buffer, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(buffer, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createMediaView(IBinder sessionToken, IBinder windowToken, Rect frame, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeStrongBinder(windowToken);
                    _data.writeTypedObject(frame, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void relayoutMediaView(IBinder sessionToken, Rect frame, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(frame, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeMediaView(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(ITvInteractiveAppManagerCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(ITvInteractiveAppManagerCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManager.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvInteractiveAppManager {
        @Override
        public List<TvInteractiveAppServiceInfo> getTvInteractiveAppServiceList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<AppLinkInfo> getAppLinkInfoList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void registerAppLinkInfo(String tiasId, AppLinkInfo info, int userId) throws RemoteException {
        }

        @Override
        public void unregisterAppLinkInfo(String tiasId, AppLinkInfo info, int userId) throws RemoteException {
        }

        @Override
        public void sendAppLinkCommand(String tiasId, Bundle command, int userId) throws RemoteException {
        }

        @Override
        public void startInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void stopInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void resetInteractiveApp(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void createBiInteractiveApp(IBinder sessionToken, Uri biIAppUri, Bundle params, int userId) throws RemoteException {
        }

        @Override
        public void destroyBiInteractiveApp(IBinder sessionToken, String biIAppId, int userId) throws RemoteException {
        }

        @Override
        public void setTeletextAppEnabled(IBinder sessionToken, boolean enable, int userId) throws RemoteException {
        }

        @Override
        public void sendCurrentVideoBounds(IBinder sessionToken, Rect bounds, int userId) throws RemoteException {
        }

        @Override
        public void sendCurrentChannelUri(IBinder sessionToken, Uri channelUri, int userId) throws RemoteException {
        }

        @Override
        public void sendCurrentChannelLcn(IBinder sessionToken, int lcn, int userId) throws RemoteException {
        }

        @Override
        public void sendStreamVolume(IBinder sessionToken, float volume, int userId) throws RemoteException {
        }

        @Override
        public void sendTrackInfoList(IBinder sessionToken, List<TvTrackInfo> tracks, int userId) throws RemoteException {
        }

        @Override
        public void sendCurrentTvInputId(IBinder sessionToken, String inputId, int userId) throws RemoteException {
        }

        @Override
        public void sendTimeShiftMode(IBinder sessionToken, int mode, int userId) throws RemoteException {
        }

        @Override
        public void sendAvailableSpeeds(IBinder sessionToken, float[] speeds, int userId) throws RemoteException {
        }

        @Override
        public void sendSigningResult(IBinder sessionToken, String signingId, byte[] result, int userId) throws RemoteException {
        }

        @Override
        public void sendTvRecordingInfo(IBinder sessionToken, TvRecordingInfo recordingInfo, int userId) throws RemoteException {
        }

        @Override
        public void sendTvRecordingInfoList(IBinder sessionToken, List<TvRecordingInfo> recordingInfoList, int userId) throws RemoteException {
        }

        @Override
        public void notifyError(IBinder sessionToken, String errMsg, Bundle params, int userId) throws RemoteException {
        }

        @Override
        public void notifyTimeShiftPlaybackParams(IBinder sessionToken, PlaybackParams params, int userId) throws RemoteException {
        }

        @Override
        public void notifyTimeShiftStatusChanged(IBinder sessionToken, String inputId, int status, int userId) throws RemoteException {
        }

        @Override
        public void notifyTimeShiftStartPositionChanged(IBinder sessionToken, String inputId, long timeMs, int userId) throws RemoteException {
        }

        @Override
        public void notifyTimeShiftCurrentPositionChanged(IBinder sessionToken, String inputId, long timeMs, int userId) throws RemoteException {
        }

        @Override
        public void notifyRecordingConnectionFailed(IBinder sessionToken, String recordingId, String inputId, int userId) throws RemoteException {
        }

        @Override
        public void notifyRecordingDisconnected(IBinder sessionToken, String recordingId, String inputId, int userId) throws RemoteException {
        }

        @Override
        public void notifyRecordingTuned(IBinder sessionToken, String recordingId, Uri channelUri, int userId) throws RemoteException {
        }

        @Override
        public void notifyRecordingError(IBinder sessionToken, String recordingId, int err, int userId) throws RemoteException {
        }

        @Override
        public void notifyRecordingScheduled(IBinder sessionToken, String recordingId, String requestId, int userId) throws RemoteException {
        }

        @Override
        public void createSession(ITvInteractiveAppClient client, String iAppServiceId, int type, int seq, int userId) throws RemoteException {
        }

        @Override
        public void releaseSession(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void notifyTuned(IBinder sessionToken, Uri channelUri, int userId) throws RemoteException {
        }

        @Override
        public void notifyTrackSelected(IBinder sessionToken, int type, String trackId, int userId) throws RemoteException {
        }

        @Override
        public void notifyTracksChanged(IBinder sessionToken, List<TvTrackInfo> tracks, int userId) throws RemoteException {
        }

        @Override
        public void notifyVideoAvailable(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void notifyVideoUnavailable(IBinder sessionToken, int reason, int userId) throws RemoteException {
        }

        @Override
        public void notifyContentAllowed(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void notifyContentBlocked(IBinder sessionToken, String rating, int userId) throws RemoteException {
        }

        @Override
        public void notifySignalStrength(IBinder sessionToken, int stength, int userId) throws RemoteException {
        }

        @Override
        public void notifyRecordingStarted(IBinder sessionToken, String recordingId, String requestId, int userId) throws RemoteException {
        }

        @Override
        public void notifyRecordingStopped(IBinder sessionToken, String recordingId, int userId) throws RemoteException {
        }

        @Override
        public void notifyTvMessage(IBinder sessionToken, int type, Bundle data, int userId) throws RemoteException {
        }

        @Override
        public void setSurface(IBinder sessionToken, Surface surface, int userId) throws RemoteException {
        }

        @Override
        public void dispatchSurfaceChanged(IBinder sessionToken, int format, int width, int height, int userId) throws RemoteException {
        }

        @Override
        public void notifyBroadcastInfoResponse(IBinder sessionToken, BroadcastInfoResponse response, int UserId) throws RemoteException {
        }

        @Override
        public void notifyAdResponse(IBinder sessionToken, AdResponse response, int UserId) throws RemoteException {
        }

        @Override
        public void notifyAdBufferConsumed(IBinder sessionToken, AdBuffer buffer, int userId) throws RemoteException {
        }

        @Override
        public void createMediaView(IBinder sessionToken, IBinder windowToken, Rect frame, int userId) throws RemoteException {
        }

        @Override
        public void relayoutMediaView(IBinder sessionToken, Rect frame, int userId) throws RemoteException {
        }

        @Override
        public void removeMediaView(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void registerCallback(ITvInteractiveAppManagerCallback callback, int userId) throws RemoteException {
        }

        @Override
        public void unregisterCallback(ITvInteractiveAppManagerCallback callback, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

