/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.interactive;

import android.media.tv.interactive.TvInteractiveAppServiceInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITvInteractiveAppManagerCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.tv.interactive.ITvInteractiveAppManagerCallback";

    public void onInteractiveAppServiceAdded(String var1) throws RemoteException;

    public void onInteractiveAppServiceRemoved(String var1) throws RemoteException;

    public void onInteractiveAppServiceUpdated(String var1) throws RemoteException;

    public void onTvInteractiveAppServiceInfoUpdated(TvInteractiveAppServiceInfo var1) throws RemoteException;

    public void onStateChanged(String var1, int var2, int var3, int var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInteractiveAppManagerCallback {
        static final int TRANSACTION_onInteractiveAppServiceAdded = 1;
        static final int TRANSACTION_onInteractiveAppServiceRemoved = 2;
        static final int TRANSACTION_onInteractiveAppServiceUpdated = 3;
        static final int TRANSACTION_onTvInteractiveAppServiceInfoUpdated = 4;
        static final int TRANSACTION_onStateChanged = 5;

        public Stub() {
            this.attachInterface(this, ITvInteractiveAppManagerCallback.DESCRIPTOR);
        }

        public static ITvInteractiveAppManagerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITvInteractiveAppManagerCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ITvInteractiveAppManagerCallback) {
                return (ITvInteractiveAppManagerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onInteractiveAppServiceAdded";
                }
                case 2: {
                    return "onInteractiveAppServiceRemoved";
                }
                case 3: {
                    return "onInteractiveAppServiceUpdated";
                }
                case 4: {
                    return "onTvInteractiveAppServiceInfoUpdated";
                }
                case 5: {
                    return "onStateChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITvInteractiveAppManagerCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onInteractiveAppServiceAdded(_arg0);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onInteractiveAppServiceRemoved(_arg0);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onInteractiveAppServiceUpdated(_arg0);
                    break;
                }
                case 4: {
                    TvInteractiveAppServiceInfo _arg0 = data.readTypedObject(TvInteractiveAppServiceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTvInteractiveAppServiceInfoUpdated(_arg0);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStateChanged(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements ITvInteractiveAppManagerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITvInteractiveAppManagerCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInteractiveAppServiceAdded(String iAppServiceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManagerCallback.DESCRIPTOR);
                    _data.writeString(iAppServiceId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInteractiveAppServiceRemoved(String iAppServiceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManagerCallback.DESCRIPTOR);
                    _data.writeString(iAppServiceId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInteractiveAppServiceUpdated(String iAppServiceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManagerCallback.DESCRIPTOR);
                    _data.writeString(iAppServiceId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTvInteractiveAppServiceInfoUpdated(TvInteractiveAppServiceInfo tvIAppInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManagerCallback.DESCRIPTOR);
                    _data.writeTypedObject(tvIAppInfo, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStateChanged(String iAppServiceId, int type, int state, int err) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITvInteractiveAppManagerCallback.DESCRIPTOR);
                    _data.writeString(iAppServiceId);
                    _data.writeInt(type);
                    _data.writeInt(state);
                    _data.writeInt(err);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvInteractiveAppManagerCallback {
        @Override
        public void onInteractiveAppServiceAdded(String iAppServiceId) throws RemoteException {
        }

        @Override
        public void onInteractiveAppServiceRemoved(String iAppServiceId) throws RemoteException {
        }

        @Override
        public void onInteractiveAppServiceUpdated(String iAppServiceId) throws RemoteException {
        }

        @Override
        public void onTvInteractiveAppServiceInfoUpdated(TvInteractiveAppServiceInfo tvIAppInfo) throws RemoteException {
        }

        @Override
        public void onStateChanged(String iAppServiceId, int type, int state, int err) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

