/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.tunerresourcemanager;

import android.annotation.SuppressLint;
import android.media.tv.tunerresourcemanager.CasSessionRequest;
import android.media.tv.tunerresourcemanager.IResourcesReclaimListener;
import android.media.tv.tunerresourcemanager.ITunerResourceManager;
import android.media.tv.tunerresourcemanager.ResourceClientProfile;
import android.media.tv.tunerresourcemanager.TunerCiCamRequest;
import android.media.tv.tunerresourcemanager.TunerDemuxInfo;
import android.media.tv.tunerresourcemanager.TunerDemuxRequest;
import android.media.tv.tunerresourcemanager.TunerDescramblerRequest;
import android.media.tv.tunerresourcemanager.TunerFrontendInfo;
import android.media.tv.tunerresourcemanager.TunerFrontendRequest;
import android.media.tv.tunerresourcemanager.TunerLnbRequest;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public class TunerResourceManager {
    private static final String TAG = "TunerResourceManager";
    private static final boolean DEBUG = Log.isLoggable("TunerResourceManager", 3);
    public static final int INVALID_RESOURCE_HANDLE = -1;
    public static final int INVALID_OWNER_ID = -1;
    public static final int TUNER_RESOURCE_TYPE_FRONTEND = 0;
    public static final int TUNER_RESOURCE_TYPE_DEMUX = 1;
    public static final int TUNER_RESOURCE_TYPE_DESCRAMBLER = 2;
    public static final int TUNER_RESOURCE_TYPE_LNB = 3;
    public static final int TUNER_RESOURCE_TYPE_CAS_SESSION = 4;
    public static final int TUNER_RESOURCE_TYPE_FRONTEND_CICAM = 5;
    public static final int TUNER_RESOURCE_TYPE_MAX = 6;
    private final ITunerResourceManager mService;
    private final int mUserId;

    public TunerResourceManager(ITunerResourceManager service, int userId) {
        this.mService = service;
        this.mUserId = userId;
    }

    public void registerClientProfile(ResourceClientProfile profile, final Executor executor, final ResourcesReclaimListener listener, int[] clientId) {
        try {
            this.mService.registerClientProfile(profile, new IResourcesReclaimListener.Stub(){

                @Override
                public void onReclaimResources() {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> listener.onReclaimResources());
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            }, clientId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterClientProfile(int clientId) {
        try {
            this.mService.unregisterClientProfile(clientId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean updateClientPriority(int clientId, int priority, int niceValue) {
        boolean result = false;
        try {
            result = this.mService.updateClientPriority(clientId, priority, niceValue);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public boolean hasUnusedFrontend(int frontendType) {
        boolean result = false;
        try {
            result = this.mService.hasUnusedFrontend(frontendType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public boolean isLowestPriority(int clientId, int frontendType) {
        boolean result = false;
        try {
            result = this.mService.isLowestPriority(clientId, frontendType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public void storeResourceMap(int resourceType) {
        try {
            this.mService.storeResourceMap(resourceType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void clearResourceMap(int resourceType) {
        try {
            this.mService.clearResourceMap(resourceType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void restoreResourceMap(int resourceType) {
        try {
            this.mService.restoreResourceMap(resourceType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setFrontendInfoList(TunerFrontendInfo[] infos) {
        try {
            this.mService.setFrontendInfoList(infos);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setDemuxInfoList(TunerDemuxInfo[] infos) {
        try {
            this.mService.setDemuxInfoList(infos);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updateCasInfo(int casSystemId, int maxSessionNum) {
        try {
            this.mService.updateCasInfo(casSystemId, maxSessionNum);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setLnbInfoList(int[] lnbIds) {
        try {
            this.mService.setLnbInfoList(lnbIds);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean acquireLock(int clientId) {
        try {
            return this.mService.acquireLock(clientId, Thread.currentThread().getId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean releaseLock(int clientId) {
        try {
            return this.mService.releaseLock(clientId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean requestFrontend(TunerFrontendRequest request, int[] frontendHandle) {
        boolean result = false;
        try {
            result = this.mService.requestFrontend(request, frontendHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public boolean setMaxNumberOfFrontends(int frontendType, int maxNum) {
        boolean result = false;
        try {
            result = this.mService.setMaxNumberOfFrontends(frontendType, maxNum);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public int getMaxNumberOfFrontends(int frontendType) {
        int result = -1;
        try {
            result = this.mService.getMaxNumberOfFrontends(frontendType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public void shareFrontend(int selfClientId, int targetClientId) {
        try {
            this.mService.shareFrontend(selfClientId, targetClientId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean transferOwner(int resourceType, int currentOwnerId, int newOwnerId) {
        try {
            return this.mService.transferOwner(resourceType, currentOwnerId, newOwnerId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean requestDemux(TunerDemuxRequest request, int[] demuxHandle) {
        boolean result = false;
        try {
            result = this.mService.requestDemux(request, demuxHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public boolean requestDescrambler(TunerDescramblerRequest request, int[] descramblerHandle) {
        boolean result = false;
        try {
            result = this.mService.requestDescrambler(request, descramblerHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public boolean requestCasSession(CasSessionRequest request, int[] casSessionHandle) {
        boolean result = false;
        try {
            result = this.mService.requestCasSession(request, casSessionHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public boolean requestCiCam(TunerCiCamRequest request, int[] ciCamHandle) {
        boolean result = false;
        try {
            result = this.mService.requestCiCam(request, ciCamHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public boolean requestLnb(TunerLnbRequest request, int[] lnbHandle) {
        boolean result = false;
        try {
            result = this.mService.requestLnb(request, lnbHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    public void releaseFrontend(int frontendHandle, int clientId) {
        try {
            this.mService.releaseFrontend(frontendHandle, clientId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void releaseDemux(int demuxHandle, int clientId) {
        try {
            this.mService.releaseDemux(demuxHandle, clientId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void releaseDescrambler(int descramblerHandle, int clientId) {
        try {
            this.mService.releaseDescrambler(descramblerHandle, clientId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void releaseCasSession(int casSessionHandle, int clientId) {
        try {
            this.mService.releaseCasSession(casSessionHandle, clientId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void releaseCiCam(int ciCamHandle, int clientId) {
        try {
            this.mService.releaseCiCam(ciCamHandle, clientId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void releaseLnb(int lnbHandle, int clientId) {
        try {
            this.mService.releaseLnb(lnbHandle, clientId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isHigherPriority(ResourceClientProfile challengerProfile, ResourceClientProfile holderProfile) {
        try {
            return this.mService.isHigherPriority(challengerProfile, holderProfile);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getClientPriority(int useCase, int pid) {
        try {
            return this.mService.getClientPriority(useCase, pid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"ShowingMemberInHiddenClass"})
    public int getConfigPriority(int useCase, boolean isForeground) {
        try {
            return this.mService.getConfigPriority(useCase, isForeground);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static abstract class ResourcesReclaimListener {
        public abstract void onReclaimResources();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TunerResourceType {
    }
}

