/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.SystemApi;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class DataElement
implements Parcelable {
    private final int mKey;
    private final byte[] mValue;
    public static final Parcelable.Creator<DataElement> CREATOR = new Parcelable.Creator<DataElement>(){

        @Override
        public DataElement createFromParcel(Parcel in) {
            int key = in.readInt();
            byte[] value = new byte[in.readInt()];
            in.readByteArray(value);
            return new DataElement(key, value);
        }

        public DataElement[] newArray(int size) {
            return new DataElement[size];
        }
    };

    public static boolean isValidType(int type) {
        return type == 100 || type == 9 || type == 101 || type == 102 || type == 0 || type == 1 || type == 2 || type == 3 || type == 4 || type == 5 || type == 6 || type == 7 || type == 8 || type == 10 || type == 11;
    }

    public boolean isIdentityDataType() {
        return this.mKey == 1 || this.mKey == 2 || this.mKey == 3 || this.mKey == 4;
    }

    public static boolean isTestDeType(int type) {
        return type >= 2147483520 && type <= Integer.MAX_VALUE;
    }

    public DataElement(int key, byte[] value) {
        Preconditions.checkArgument(value != null, "value cannot be null");
        this.mKey = key;
        this.mValue = value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataElement) {
            return this.mKey == ((DataElement)obj).mKey && Arrays.equals(this.mValue, ((DataElement)obj).mValue);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mKey, Arrays.hashCode(this.mValue));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mKey);
        dest.writeInt(this.mValue.length);
        dest.writeByteArray(this.mValue);
    }

    public int getKey() {
        return this.mKey;
    }

    public byte[] getValue() {
        return this.mValue;
    }

    public static @interface DataType {
        public static final int BLE_SERVICE_DATA = 100;
        public static final int BLE_ADDRESS = 101;
        public static final int SCAN_MODE = 102;
        public static final int SALT = 0;
        public static final int PRIVATE_IDENTITY = 1;
        public static final int TRUSTED_IDENTITY = 2;
        public static final int PUBLIC_IDENTITY = 3;
        public static final int PROVISIONED_IDENTITY = 4;
        public static final int TX_POWER = 5;
        public static final int ACTION = 6;
        public static final int MODEL_ID = 7;
        public static final int EDDYSTONE_EPHEMERAL_IDENTIFIER = 8;
        public static final int ACCOUNT_KEY_DATA = 9;
        public static final int CONNECTION_STATUS = 10;
        public static final int BATTERY = 11;
        public static final int TEST_DE_BEGIN = 2147483520;
        public static final int TEST_DE_END = Integer.MAX_VALUE;
    }
}

