/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.nearby.NearbyDevice;
import android.nearby.PresenceDevice;
import android.nearby.PublicCredential;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

public class NearbyDeviceParcelable
implements Parcelable {
    public static final Parcelable.Creator<NearbyDeviceParcelable> CREATOR = new Parcelable.Creator<NearbyDeviceParcelable>(){

        @Override
        public NearbyDeviceParcelable createFromParcel(Parcel in) {
            Builder builder = new Builder();
            builder.setDeviceId(in.readLong());
            builder.setScanType(in.readInt());
            if (in.readInt() == 1) {
                builder.setName(in.readString());
            }
            builder.setMedium(in.readInt());
            builder.setTxPower(in.readInt());
            builder.setRssi(in.readInt());
            builder.setAction(in.readInt());
            builder.setPublicCredential(in.readParcelable(PublicCredential.class.getClassLoader(), PublicCredential.class));
            if (in.readInt() == 1) {
                builder.setFastPairModelId(in.readString());
            }
            if (in.readInt() == 1) {
                builder.setBluetoothAddress(in.readString());
            }
            if (in.readInt() == 1) {
                int dataLength = in.readInt();
                byte[] data = new byte[dataLength];
                in.readByteArray(data);
                builder.setData(data);
            }
            if (in.readInt() == 1) {
                int saltLength = in.readInt();
                byte[] salt = new byte[saltLength];
                in.readByteArray(salt);
                builder.setData(salt);
            }
            if (in.readInt() == 1) {
                builder.setPresenceDevice(in.readParcelable(PresenceDevice.class.getClassLoader(), PresenceDevice.class));
            }
            if (in.readInt() == 1) {
                int encryptionKeyTagLength = in.readInt();
                byte[] keyTag = new byte[encryptionKeyTagLength];
                in.readByteArray(keyTag);
                builder.setData(keyTag);
            }
            return builder.build();
        }

        public NearbyDeviceParcelable[] newArray(int size) {
            return new NearbyDeviceParcelable[size];
        }
    };
    private final long mDeviceId;
    int mScanType;
    private final String mName;
    @NearbyDevice.Medium
    private final int mMedium;
    private final int mTxPower;
    private final int mRssi;
    private final int mAction;
    private final PublicCredential mPublicCredential;
    private final String mBluetoothAddress;
    private final String mFastPairModelId;
    private final byte[] mData;
    private final byte[] mSalt;
    private final PresenceDevice mPresenceDevice;
    private final byte[] mEncryptionKeyTag;

    private NearbyDeviceParcelable(long deviceId, int scanType, String name, int medium, int TxPower, int rssi, int action, PublicCredential publicCredential, String fastPairModelId, String bluetoothAddress, byte[] data, byte[] salt, PresenceDevice presenceDevice, byte[] encryptionKeyTag) {
        this.mDeviceId = deviceId;
        this.mScanType = scanType;
        this.mName = name;
        this.mMedium = medium;
        this.mTxPower = TxPower;
        this.mRssi = rssi;
        this.mAction = action;
        this.mPublicCredential = publicCredential;
        this.mFastPairModelId = fastPairModelId;
        this.mBluetoothAddress = bluetoothAddress;
        this.mData = data;
        this.mSalt = salt;
        this.mPresenceDevice = presenceDevice;
        this.mEncryptionKeyTag = encryptionKeyTag;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mDeviceId);
        dest.writeInt(this.mScanType);
        dest.writeInt(this.mName == null ? 0 : 1);
        if (this.mName != null) {
            dest.writeString(this.mName);
        }
        dest.writeInt(this.mMedium);
        dest.writeInt(this.mTxPower);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mAction);
        dest.writeParcelable(this.mPublicCredential, flags);
        dest.writeInt(this.mFastPairModelId == null ? 0 : 1);
        if (this.mFastPairModelId != null) {
            dest.writeString(this.mFastPairModelId);
        }
        dest.writeInt(this.mBluetoothAddress == null ? 0 : 1);
        if (this.mBluetoothAddress != null) {
            dest.writeString(this.mBluetoothAddress);
        }
        dest.writeInt(this.mData == null ? 0 : 1);
        if (this.mData != null) {
            dest.writeInt(this.mData.length);
            dest.writeByteArray(this.mData);
        }
        dest.writeInt(this.mSalt == null ? 0 : 1);
        if (this.mSalt != null) {
            dest.writeInt(this.mSalt.length);
            dest.writeByteArray(this.mSalt);
        }
        dest.writeInt(this.mPresenceDevice == null ? 0 : 1);
        if (this.mPresenceDevice != null) {
            dest.writeParcelable(this.mPresenceDevice, 0);
        }
        dest.writeInt(this.mEncryptionKeyTag == null ? 0 : 1);
        if (this.mEncryptionKeyTag != null) {
            dest.writeInt(this.mEncryptionKeyTag.length);
            dest.writeByteArray(this.mEncryptionKeyTag);
        }
    }

    public String toString() {
        return "NearbyDeviceParcelable[deviceId=" + this.mDeviceId + ", scanType=" + this.mScanType + ", name=" + this.mName + ", medium=" + NearbyDevice.mediumToString(this.mMedium) + ", txPower=" + this.mTxPower + ", rssi=" + this.mRssi + ", action=" + this.mAction + ", bluetoothAddress=" + this.mBluetoothAddress + ", fastPairModelId=" + this.mFastPairModelId + ", data=" + Arrays.toString(this.mData) + ", salt=" + Arrays.toString(this.mSalt) + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof NearbyDeviceParcelable) {
            NearbyDeviceParcelable otherNearbyDeviceParcelable = (NearbyDeviceParcelable)other;
            return this.mDeviceId == otherNearbyDeviceParcelable.mDeviceId && this.mScanType == otherNearbyDeviceParcelable.mScanType && Objects.equals(this.mName, otherNearbyDeviceParcelable.mName) && this.mMedium == otherNearbyDeviceParcelable.mMedium && this.mTxPower == otherNearbyDeviceParcelable.mTxPower && this.mRssi == otherNearbyDeviceParcelable.mRssi && this.mAction == otherNearbyDeviceParcelable.mAction && Objects.equals(this.mPublicCredential, otherNearbyDeviceParcelable.mPublicCredential) && Objects.equals(this.mBluetoothAddress, otherNearbyDeviceParcelable.mBluetoothAddress) && Objects.equals(this.mFastPairModelId, otherNearbyDeviceParcelable.mFastPairModelId) && Arrays.equals(this.mData, otherNearbyDeviceParcelable.mData) && Arrays.equals(this.mSalt, otherNearbyDeviceParcelable.mSalt) && Objects.equals(this.mPresenceDevice, otherNearbyDeviceParcelable.mPresenceDevice) && Arrays.equals(this.mEncryptionKeyTag, otherNearbyDeviceParcelable.mEncryptionKeyTag);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mDeviceId, this.mScanType, this.mName, this.mMedium, this.mRssi, this.mAction, this.mPublicCredential.hashCode(), this.mBluetoothAddress, this.mFastPairModelId, Arrays.hashCode(this.mData), Arrays.hashCode(this.mSalt), this.mPresenceDevice, Arrays.hashCode(this.mEncryptionKeyTag));
    }

    public long getDeviceId() {
        return this.mDeviceId;
    }

    public int getScanType() {
        return this.mScanType;
    }

    public String getName() {
        return this.mName;
    }

    @NearbyDevice.Medium
    public int getMedium() {
        return this.mMedium;
    }

    public int getTxPower() {
        return this.mTxPower;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getAction() {
        return this.mAction;
    }

    public PublicCredential getPublicCredential() {
        return this.mPublicCredential;
    }

    public String getFastPairModelId() {
        return this.mFastPairModelId;
    }

    public String getBluetoothAddress() {
        return this.mBluetoothAddress;
    }

    public byte[] getData() {
        return this.mData;
    }

    public byte[] getSalt() {
        return this.mSalt;
    }

    public PresenceDevice getPresenceDevice() {
        return this.mPresenceDevice;
    }

    public byte[] getEncryptionKeyTag() {
        return this.mEncryptionKeyTag;
    }

    public static class Builder {
        private long mDeviceId = -1L;
        private String mName;
        @NearbyDevice.Medium
        private int mMedium;
        private int mTxPower;
        private int mRssi;
        private int mAction;
        private PublicCredential mPublicCredential;
        int mScanType;
        private String mFastPairModelId;
        private String mBluetoothAddress;
        private byte[] mData;
        private byte[] mSalt;
        private PresenceDevice mPresenceDevice;
        private byte[] mEncryptionKeyTag;

        public Builder setDeviceId(long deviceId) {
            this.mDeviceId = deviceId;
            return this;
        }

        public Builder setScanType(int scanType) {
            this.mScanType = scanType;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setMedium(@NearbyDevice.Medium int medium) {
            this.mMedium = medium;
            return this;
        }

        public Builder setTxPower(int txPower) {
            this.mTxPower = txPower;
            return this;
        }

        public Builder setRssi(int rssi) {
            this.mRssi = rssi;
            return this;
        }

        public Builder setAction(int action) {
            this.mAction = action;
            return this;
        }

        public Builder setPublicCredential(PublicCredential publicCredential) {
            this.mPublicCredential = publicCredential;
            return this;
        }

        public Builder setFastPairModelId(String fastPairModelId) {
            this.mFastPairModelId = fastPairModelId;
            return this;
        }

        public Builder setBluetoothAddress(String bluetoothAddress) {
            this.mBluetoothAddress = bluetoothAddress;
            return this;
        }

        public Builder setData(byte[] data) {
            this.mData = data;
            return this;
        }

        public Builder setEncryptionKeyTag(byte[] encryptionKeyTag) {
            this.mEncryptionKeyTag = encryptionKeyTag;
            return this;
        }

        public Builder setSalt(byte[] salt) {
            this.mSalt = salt;
            return this;
        }

        public Builder setPresenceDevice(PresenceDevice presenceDevice) {
            this.mPresenceDevice = presenceDevice;
            return this;
        }

        public NearbyDeviceParcelable build() {
            return new NearbyDeviceParcelable(this.mDeviceId, this.mScanType, this.mName, this.mMedium, this.mTxPower, this.mRssi, this.mAction, this.mPublicCredential, this.mFastPairModelId, this.mBluetoothAddress, this.mData, this.mSalt, this.mPresenceDevice, this.mEncryptionKeyTag);
        }
    }
}

