/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class OffloadCapability
implements Parcelable {
    private final boolean mFastPairSupported;
    private final boolean mNearbyShareSupported;
    private final long mVersion;
    public static final Parcelable.Creator<OffloadCapability> CREATOR = new Parcelable.Creator<OffloadCapability>(){

        @Override
        public OffloadCapability createFromParcel(Parcel in) {
            boolean isFastPairSupported = in.readBoolean();
            boolean isNearbyShareSupported = in.readBoolean();
            long version = in.readLong();
            return new Builder().setFastPairSupported(isFastPairSupported).setNearbyShareSupported(isNearbyShareSupported).setVersion(version).build();
        }

        public OffloadCapability[] newArray(int size) {
            return new OffloadCapability[size];
        }
    };

    public boolean isFastPairSupported() {
        return this.mFastPairSupported;
    }

    public boolean isNearbyShareSupported() {
        return this.mNearbyShareSupported;
    }

    public long getVersion() {
        return this.mVersion;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBoolean(this.mFastPairSupported);
        dest.writeBoolean(this.mNearbyShareSupported);
        dest.writeLong(this.mVersion);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private OffloadCapability(boolean fastPairSupported, boolean nearbyShareSupported, long version) {
        this.mFastPairSupported = fastPairSupported;
        this.mNearbyShareSupported = nearbyShareSupported;
        this.mVersion = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffloadCapability)) {
            return false;
        }
        OffloadCapability that = (OffloadCapability)o;
        return this.isFastPairSupported() == that.isFastPairSupported() && this.isNearbyShareSupported() == that.isNearbyShareSupported() && this.getVersion() == that.getVersion();
    }

    public int hashCode() {
        return Objects.hash(this.isFastPairSupported(), this.isNearbyShareSupported(), this.getVersion());
    }

    public String toString() {
        return "OffloadCapability{fastPairSupported=" + this.mFastPairSupported + ", nearbyShareSupported=" + this.mNearbyShareSupported + ", version=" + this.mVersion + '}';
    }

    public static class Builder {
        private boolean mFastPairSupported;
        private boolean mNearbyShareSupported;
        private long mVersion;

        public Builder setFastPairSupported(boolean fastPairSupported) {
            this.mFastPairSupported = fastPairSupported;
            return this;
        }

        public Builder setNearbyShareSupported(boolean nearbyShareSupported) {
            this.mNearbyShareSupported = nearbyShareSupported;
            return this;
        }

        public Builder setVersion(long version) {
            this.mVersion = version;
            return this;
        }

        public OffloadCapability build() {
            return new OffloadCapability(this.mFastPairSupported, this.mNearbyShareSupported, this.mVersion);
        }
    }
}

