/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.SystemApi;
import android.nearby.DataElement;
import android.nearby.NearbyDevice;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@SystemApi
public class PresenceDevice
extends NearbyDevice
implements Parcelable {
    private final String mDeviceId;
    private final byte[] mSalt;
    private final byte[] mSecretId;
    private final byte[] mEncryptedIdentity;
    private final int mDeviceType;
    private final String mDeviceImageUrl;
    private final long mDiscoveryTimestampMillis;
    private final List<DataElement> mExtendedProperties;
    public static final Parcelable.Creator<PresenceDevice> CREATOR = new Parcelable.Creator<PresenceDevice>(){

        @Override
        public PresenceDevice createFromParcel(Parcel in) {
            int i;
            String name = null;
            if (in.readInt() == 1) {
                name = in.readString();
            }
            int size = in.readInt();
            ArrayList<Integer> mediums = new ArrayList<Integer>();
            for (int i2 = 0; i2 < size; ++i2) {
                mediums.add(in.readInt());
            }
            int rssi = in.readInt();
            byte[] salt = new byte[in.readInt()];
            in.readByteArray(salt);
            byte[] secretId = new byte[in.readInt()];
            in.readByteArray(secretId);
            byte[] encryptedIdentity = new byte[in.readInt()];
            in.readByteArray(encryptedIdentity);
            String deviceId = in.readString();
            int deviceType = in.readInt();
            String deviceImageUrl = null;
            if (in.readInt() == 1) {
                deviceImageUrl = in.readString();
            }
            long discoveryTimeMillis = in.readLong();
            int dataElementSize = in.readInt();
            ArrayList<DataElement> dataElements = new ArrayList<DataElement>();
            for (int i3 = 0; i3 < dataElementSize; ++i3) {
                dataElements.add(in.readParcelable(DataElement.class.getClassLoader(), DataElement.class));
            }
            Builder builder = new Builder(deviceId, salt, secretId, encryptedIdentity).setName(name).setRssi(rssi).setDeviceType(deviceType).setDeviceImageUrl(deviceImageUrl).setDiscoveryTimestampMillis(discoveryTimeMillis);
            for (i = 0; i < mediums.size(); ++i) {
                builder.addMedium((Integer)mediums.get(i));
            }
            for (i = 0; i < dataElements.size(); ++i) {
                builder.addExtendedProperty((DataElement)dataElements.get(i));
            }
            return builder.build();
        }

        public PresenceDevice[] newArray(int size) {
            return new PresenceDevice[size];
        }
    };

    public String getDeviceId() {
        return this.mDeviceId;
    }

    public byte[] getSalt() {
        return this.mSalt;
    }

    public byte[] getSecretId() {
        return this.mSecretId;
    }

    public byte[] getEncryptedIdentity() {
        return this.mEncryptedIdentity;
    }

    public int getDeviceType() {
        return this.mDeviceType;
    }

    public String getDeviceImageUrl() {
        return this.mDeviceImageUrl;
    }

    public long getDiscoveryTimestampMillis() {
        return this.mDiscoveryTimestampMillis;
    }

    public List<DataElement> getExtendedProperties() {
        return this.mExtendedProperties;
    }

    @Override
    public boolean equals(Object other) {
        PresenceDevice otherDevice;
        if (other instanceof PresenceDevice && super.equals(otherDevice = (PresenceDevice)other)) {
            return Arrays.equals(this.mSalt, otherDevice.mSalt) && Arrays.equals(this.mSecretId, otherDevice.mSecretId) && Arrays.equals(this.mEncryptedIdentity, otherDevice.mEncryptedIdentity) && Objects.equals(this.mDeviceId, otherDevice.mDeviceId) && this.mDeviceType == otherDevice.mDeviceType && Objects.equals(this.mDeviceImageUrl, otherDevice.mDeviceImageUrl) && this.mDiscoveryTimestampMillis == otherDevice.mDiscoveryTimestampMillis && Objects.equals(this.mExtendedProperties, otherDevice.mExtendedProperties);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.getMediums(), this.getRssi(), Arrays.hashCode(this.mSalt), Arrays.hashCode(this.mSecretId), Arrays.hashCode(this.mEncryptedIdentity), this.mDeviceId, this.mDeviceType, this.mDeviceImageUrl, this.mDiscoveryTimestampMillis, this.mExtendedProperties);
    }

    private PresenceDevice(String deviceName, List<Integer> mMediums, int rssi, String deviceId, byte[] salt, byte[] secretId, byte[] encryptedIdentity, int deviceType, String deviceImageUrl, long discoveryTimestampMillis, List<DataElement> extendedProperties) {
        super(deviceName, mMediums, rssi);
        this.mDeviceId = deviceId;
        this.mSalt = salt;
        this.mSecretId = secretId;
        this.mEncryptedIdentity = encryptedIdentity;
        this.mDeviceType = deviceType;
        this.mDeviceImageUrl = deviceImageUrl;
        this.mDiscoveryTimestampMillis = discoveryTimestampMillis;
        this.mExtendedProperties = extendedProperties;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        String name = this.getName();
        dest.writeInt(name == null ? 0 : 1);
        if (name != null) {
            dest.writeString(name);
        }
        List<Integer> mediums = this.getMediums();
        dest.writeInt(mediums.size());
        Iterator<Object> iterator = mediums.iterator();
        while (iterator.hasNext()) {
            int medium = iterator.next();
            dest.writeInt(medium);
        }
        dest.writeInt(this.getRssi());
        dest.writeInt(this.mSalt.length);
        dest.writeByteArray(this.mSalt);
        dest.writeInt(this.mSecretId.length);
        dest.writeByteArray(this.mSecretId);
        dest.writeInt(this.mEncryptedIdentity.length);
        dest.writeByteArray(this.mEncryptedIdentity);
        dest.writeString(this.mDeviceId);
        dest.writeInt(this.mDeviceType);
        dest.writeInt(this.mDeviceImageUrl == null ? 0 : 1);
        if (this.mDeviceImageUrl != null) {
            dest.writeString(this.mDeviceImageUrl);
        }
        dest.writeLong(this.mDiscoveryTimestampMillis);
        dest.writeInt(this.mExtendedProperties.size());
        for (DataElement dataElement : this.mExtendedProperties) {
            dest.writeParcelable(dataElement, 0);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private final List<DataElement> mExtendedProperties;
        private final List<Integer> mMediums;
        private final String mDeviceId;
        private final byte[] mSalt;
        private final byte[] mSecretId;
        private final byte[] mEncryptedIdentity;
        private String mName;
        private int mRssi;
        private int mDeviceType;
        private String mDeviceImageUrl;
        private long mDiscoveryTimestampMillis;

        public Builder(String deviceId, byte[] salt, byte[] secretId, byte[] encryptedIdentity) {
            Objects.requireNonNull(deviceId);
            Objects.requireNonNull(salt);
            Objects.requireNonNull(secretId);
            Objects.requireNonNull(encryptedIdentity);
            this.mDeviceId = deviceId;
            this.mSalt = salt;
            this.mSecretId = secretId;
            this.mEncryptedIdentity = encryptedIdentity;
            this.mMediums = new ArrayList<Integer>();
            this.mExtendedProperties = new ArrayList<DataElement>();
            this.mRssi = -127;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addMedium(@NearbyDevice.Medium int medium) {
            this.mMediums.add(medium);
            return this;
        }

        public Builder setRssi(int rssi) {
            this.mRssi = rssi;
            return this;
        }

        public Builder setDeviceType(int deviceType) {
            this.mDeviceType = deviceType;
            return this;
        }

        public Builder setDeviceImageUrl(String deviceImageUrl) {
            this.mDeviceImageUrl = deviceImageUrl;
            return this;
        }

        public Builder setDiscoveryTimestampMillis(long discoveryTimestampMillis) {
            this.mDiscoveryTimestampMillis = discoveryTimestampMillis;
            return this;
        }

        public Builder addExtendedProperty(DataElement dataElement) {
            Objects.requireNonNull(dataElement);
            this.mExtendedProperties.add(dataElement);
            return this;
        }

        public PresenceDevice build() {
            return new PresenceDevice(this.mName, this.mMediums, this.mRssi, this.mDeviceId, this.mSalt, this.mSecretId, this.mEncryptedIdentity, this.mDeviceType, this.mDeviceImageUrl, this.mDiscoveryTimestampMillis, this.mExtendedProperties);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceType {
        public static final int UNKNOWN = 0;
        public static final int PHONE = 1;
        public static final int TABLET = 2;
        public static final int DISPLAY = 3;
        public static final int LAPTOP = 4;
        public static final int TV = 5;
        public static final int WATCH = 6;
    }
}

