/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.EthernetNetworkManagementException;
import android.net.EthernetNetworkUpdateRequest;
import android.net.IEthernetManager;
import android.net.IEthernetServiceListener;
import android.net.IpConfiguration;
import android.net.connectivity.android.net.INetworkInterfaceOutcomeReceiver;
import android.net.connectivity.android.net.ITetheredInterfaceCallback;
import android.net.connectivity.com.android.modules.utils.BackgroundThread;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;

@SystemApi
public class EthernetManager {
    private static final String TAG = "EthernetManager";
    private final IEthernetManager mService;
    @GuardedBy(value={"mListenerLock"})
    private final ArrayMap<InterfaceStateListener, IEthernetServiceListener> mIfaceServiceListeners = new ArrayMap();
    @GuardedBy(value={"mListenerLock"})
    private final ArrayMap<IntConsumer, IEthernetServiceListener> mStateServiceListeners = new ArrayMap();
    final Object mListenerLock = new Object();
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int ETHERNET_STATE_DISABLED = 0;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int ETHERNET_STATE_ENABLED = 1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int STATE_ABSENT = 0;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int STATE_LINK_DOWN = 1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int STATE_LINK_UP = 2;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int ROLE_NONE = 0;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int ROLE_CLIENT = 1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int ROLE_SERVER = 2;

    public EthernetManager(Context context, IEthernetManager service) {
        this.mService = service;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public IpConfiguration getConfiguration(String iface) {
        try {
            return this.mService.getConfiguration(iface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setConfiguration(String iface, IpConfiguration config) {
        try {
            this.mService.setConfiguration(iface, config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isAvailable() {
        return this.getAvailableInterfaces().length > 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isAvailable(String iface) {
        try {
            return this.mService.isAvailable(iface);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void addListener(Listener listener) {
        this.addListener(listener, BackgroundThread.getExecutor());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void addListener(Listener listener, Executor executor) {
        this.addInterfaceStateListener(executor, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public void addInterfaceStateListener(final Executor executor, final InterfaceStateListener listener) {
        if (listener == null || executor == null) {
            throw new NullPointerException("listener and executor must not be null");
        }
        IEthernetServiceListener.Stub serviceListener = new IEthernetServiceListener.Stub(){

            @Override
            public void onEthernetStateChanged(int state) {
            }

            @Override
            public void onInterfaceStateChanged(String iface, int state, int role, IpConfiguration configuration) {
                executor.execute(() -> listener.onInterfaceStateChanged(iface, state, role, configuration));
            }
        };
        Object object = this.mListenerLock;
        synchronized (object) {
            this.addServiceListener(serviceListener);
            this.mIfaceServiceListeners.put(listener, serviceListener);
        }
    }

    @GuardedBy(value={"mListenerLock"})
    private void addServiceListener(IEthernetServiceListener listener) {
        try {
            this.mService.addListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String[] getAvailableInterfaces() {
        try {
            return this.mService.getAvailableInterfaces();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void removeInterfaceStateListener(InterfaceStateListener listener) {
        Objects.requireNonNull(listener);
        Object object = this.mListenerLock;
        synchronized (object) {
            this.maybeRemoveServiceListener(this.mIfaceServiceListeners.remove(listener));
        }
    }

    @GuardedBy(value={"mListenerLock"})
    private void maybeRemoveServiceListener(IEthernetServiceListener listener) {
        if (listener == null) {
            return;
        }
        try {
            this.mService.removeListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.removeInterfaceStateListener(listener);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void setIncludeTestInterfaces(boolean include) {
        try {
            this.mService.setIncludeTestInterfaces(include);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public TetheredInterfaceRequest requestTetheredInterface(final Executor executor, final TetheredInterfaceCallback callback) {
        Objects.requireNonNull(callback, "Callback must be non-null");
        Objects.requireNonNull(executor, "Executor must be non-null");
        ITetheredInterfaceCallback.Stub cbInternal = new ITetheredInterfaceCallback.Stub(){

            @Override
            public void onAvailable(String iface) {
                executor.execute(() -> callback.onAvailable(iface));
            }

            @Override
            public void onUnavailable() {
                executor.execute(() -> callback.onUnavailable());
            }
        };
        try {
            this.mService.requestTetheredInterface(cbInternal);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new TetheredInterfaceRequest(this.mService, cbInternal);
    }

    private NetworkInterfaceOutcomeReceiver makeNetworkInterfaceOutcomeReceiver(Executor executor, OutcomeReceiver<String, EthernetNetworkManagementException> callback) {
        if (null != callback) {
            Objects.requireNonNull(executor, "Pass a non-null executor, or a null callback");
        }
        NetworkInterfaceOutcomeReceiver proxy = null == callback ? null : new NetworkInterfaceOutcomeReceiver(executor, callback);
        return proxy;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK", "android.permission.MANAGE_ETHERNET_NETWORKS"})
    public void updateConfiguration(String iface, EthernetNetworkUpdateRequest request, Executor executor, OutcomeReceiver<String, EthernetNetworkManagementException> callback) {
        Objects.requireNonNull(iface, "iface must be non-null");
        Objects.requireNonNull(request, "request must be non-null");
        NetworkInterfaceOutcomeReceiver proxy = this.makeNetworkInterfaceOutcomeReceiver(executor, callback);
        try {
            this.mService.updateConfiguration(iface, request, proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK", "android.permission.MANAGE_ETHERNET_NETWORKS"})
    public void enableInterface(String iface, Executor executor, OutcomeReceiver<String, EthernetNetworkManagementException> callback) {
        Objects.requireNonNull(iface, "iface must be non-null");
        NetworkInterfaceOutcomeReceiver proxy = this.makeNetworkInterfaceOutcomeReceiver(executor, callback);
        try {
            this.mService.enableInterface(iface, proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK", "android.permission.MANAGE_ETHERNET_NETWORKS"})
    public void disableInterface(String iface, Executor executor, OutcomeReceiver<String, EthernetNetworkManagementException> callback) {
        Objects.requireNonNull(iface, "iface must be non-null");
        NetworkInterfaceOutcomeReceiver proxy = this.makeNetworkInterfaceOutcomeReceiver(executor, callback);
        try {
            this.mService.disableInterface(iface, proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK", "android.permission.NETWORK_SETTINGS"})
    public void setEthernetEnabled(boolean enabled) {
        try {
            this.mService.setEthernetEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public void addEthernetStateListener(final Executor executor, final IntConsumer listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        IEthernetServiceListener.Stub serviceListener = new IEthernetServiceListener.Stub(){

            @Override
            public void onEthernetStateChanged(int state) {
                executor.execute(() -> listener.accept(state));
            }

            @Override
            public void onInterfaceStateChanged(String iface, int state, int role, IpConfiguration configuration) {
            }
        };
        Object object = this.mListenerLock;
        synchronized (object) {
            this.addServiceListener(serviceListener);
            this.mStateServiceListeners.put(listener, serviceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public void removeEthernetStateListener(IntConsumer listener) {
        Objects.requireNonNull(listener);
        Object object = this.mListenerLock;
        synchronized (object) {
            this.maybeRemoveServiceListener(this.mStateServiceListeners.remove(listener));
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public List<String> getInterfaceList() {
        try {
            return this.mService.getInterfaceList();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public static interface Listener
    extends InterfaceStateListener {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public void onAvailabilityChanged(String var1, boolean var2);

        @Override
        default public void onInterfaceStateChanged(String iface, int state, int role, IpConfiguration configuration) {
            this.onAvailabilityChanged(iface, state >= 2);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static interface InterfaceStateListener {
        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public void onInterfaceStateChanged(String var1, int var2, int var3, IpConfiguration var4);
    }

    public static interface TetheredInterfaceCallback {
        public void onAvailable(String var1);

        public void onUnavailable();
    }

    public static class TetheredInterfaceRequest {
        private final IEthernetManager mService;
        private final ITetheredInterfaceCallback mCb;

        private TetheredInterfaceRequest(IEthernetManager service, ITetheredInterfaceCallback cb) {
            this.mService = service;
            this.mCb = cb;
        }

        public void release() {
            try {
                this.mService.releaseTetheredInterface(this.mCb);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    private static class NetworkInterfaceOutcomeReceiver
    extends INetworkInterfaceOutcomeReceiver.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<String, EthernetNetworkManagementException> mCallback;

        NetworkInterfaceOutcomeReceiver(Executor executor, OutcomeReceiver<String, EthernetNetworkManagementException> callback) {
            Objects.requireNonNull(executor, "Pass a non-null executor");
            Objects.requireNonNull(callback, "Pass a non-null callback");
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onResult(String iface) {
            this.mExecutor.execute(() -> this.mCallback.onResult(iface));
        }

        @Override
        public void onError(EthernetNetworkManagementException e) {
            this.mExecutor.execute(() -> this.mCallback.onError(e));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Role {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InterfaceState {
    }
}

