/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.INetworkAgentRegistry;
import android.net.NattKeepalivePacketData;
import android.net.TcpKeepalivePacketData;
import android.net.connectivity.android.net.QosFilterParcelable;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkAgent
extends IInterface {
    public static final String DESCRIPTOR = "android.net.INetworkAgent";

    public void onRegistered(INetworkAgentRegistry var1) throws RemoteException;

    public void onDisconnected() throws RemoteException;

    public void onBandwidthUpdateRequested() throws RemoteException;

    public void onValidationStatusChanged(int var1, String var2) throws RemoteException;

    public void onSaveAcceptUnvalidated(boolean var1) throws RemoteException;

    public void onStartNattSocketKeepalive(int var1, int var2, NattKeepalivePacketData var3) throws RemoteException;

    public void onStartTcpSocketKeepalive(int var1, int var2, TcpKeepalivePacketData var3) throws RemoteException;

    public void onStopSocketKeepalive(int var1) throws RemoteException;

    public void onSignalStrengthThresholdsUpdated(int[] var1) throws RemoteException;

    public void onPreventAutomaticReconnect() throws RemoteException;

    public void onAddNattKeepalivePacketFilter(int var1, NattKeepalivePacketData var2) throws RemoteException;

    public void onAddTcpKeepalivePacketFilter(int var1, TcpKeepalivePacketData var2) throws RemoteException;

    public void onRemoveKeepalivePacketFilter(int var1) throws RemoteException;

    public void onQosFilterCallbackRegistered(int var1, QosFilterParcelable var2) throws RemoteException;

    public void onQosCallbackUnregistered(int var1) throws RemoteException;

    public void onNetworkCreated() throws RemoteException;

    public void onNetworkDestroyed() throws RemoteException;

    public void onDscpPolicyStatusUpdated(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkAgent {
        static final int TRANSACTION_onRegistered = 1;
        static final int TRANSACTION_onDisconnected = 2;
        static final int TRANSACTION_onBandwidthUpdateRequested = 3;
        static final int TRANSACTION_onValidationStatusChanged = 4;
        static final int TRANSACTION_onSaveAcceptUnvalidated = 5;
        static final int TRANSACTION_onStartNattSocketKeepalive = 6;
        static final int TRANSACTION_onStartTcpSocketKeepalive = 7;
        static final int TRANSACTION_onStopSocketKeepalive = 8;
        static final int TRANSACTION_onSignalStrengthThresholdsUpdated = 9;
        static final int TRANSACTION_onPreventAutomaticReconnect = 10;
        static final int TRANSACTION_onAddNattKeepalivePacketFilter = 11;
        static final int TRANSACTION_onAddTcpKeepalivePacketFilter = 12;
        static final int TRANSACTION_onRemoveKeepalivePacketFilter = 13;
        static final int TRANSACTION_onQosFilterCallbackRegistered = 14;
        static final int TRANSACTION_onQosCallbackUnregistered = 15;
        static final int TRANSACTION_onNetworkCreated = 16;
        static final int TRANSACTION_onNetworkDestroyed = 17;
        static final int TRANSACTION_onDscpPolicyStatusUpdated = 18;

        public Stub() {
            this.attachInterface(this, INetworkAgent.DESCRIPTOR);
        }

        public static INetworkAgent asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkAgent.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkAgent) {
                return (INetworkAgent)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onRegistered";
                }
                case 2: {
                    return "onDisconnected";
                }
                case 3: {
                    return "onBandwidthUpdateRequested";
                }
                case 4: {
                    return "onValidationStatusChanged";
                }
                case 5: {
                    return "onSaveAcceptUnvalidated";
                }
                case 6: {
                    return "onStartNattSocketKeepalive";
                }
                case 7: {
                    return "onStartTcpSocketKeepalive";
                }
                case 8: {
                    return "onStopSocketKeepalive";
                }
                case 9: {
                    return "onSignalStrengthThresholdsUpdated";
                }
                case 10: {
                    return "onPreventAutomaticReconnect";
                }
                case 11: {
                    return "onAddNattKeepalivePacketFilter";
                }
                case 12: {
                    return "onAddTcpKeepalivePacketFilter";
                }
                case 13: {
                    return "onRemoveKeepalivePacketFilter";
                }
                case 14: {
                    return "onQosFilterCallbackRegistered";
                }
                case 15: {
                    return "onQosCallbackUnregistered";
                }
                case 16: {
                    return "onNetworkCreated";
                }
                case 17: {
                    return "onNetworkDestroyed";
                }
                case 18: {
                    return "onDscpPolicyStatusUpdated";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkAgent.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    INetworkAgentRegistry _arg0 = INetworkAgentRegistry.Stub.asInterface(data.readStrongBinder());
                    this.onRegistered(_arg0);
                    break;
                }
                case 2: {
                    this.onDisconnected();
                    break;
                }
                case 3: {
                    this.onBandwidthUpdateRequested();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.onValidationStatusChanged(_arg0, _arg1);
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    this.onSaveAcceptUnvalidated(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    NattKeepalivePacketData _arg2 = data.readTypedObject(NattKeepalivePacketData.CREATOR);
                    this.onStartNattSocketKeepalive(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    TcpKeepalivePacketData _arg2 = data.readTypedObject(TcpKeepalivePacketData.CREATOR);
                    this.onStartTcpSocketKeepalive(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    this.onStopSocketKeepalive(_arg0);
                    break;
                }
                case 9: {
                    int[] _arg0 = data.createIntArray();
                    this.onSignalStrengthThresholdsUpdated(_arg0);
                    break;
                }
                case 10: {
                    this.onPreventAutomaticReconnect();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    NattKeepalivePacketData _arg1 = data.readTypedObject(NattKeepalivePacketData.CREATOR);
                    this.onAddNattKeepalivePacketFilter(_arg0, _arg1);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    TcpKeepalivePacketData _arg1 = data.readTypedObject(TcpKeepalivePacketData.CREATOR);
                    this.onAddTcpKeepalivePacketFilter(_arg0, _arg1);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    this.onRemoveKeepalivePacketFilter(_arg0);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    QosFilterParcelable _arg1 = data.readTypedObject(QosFilterParcelable.CREATOR);
                    this.onQosFilterCallbackRegistered(_arg0, _arg1);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    this.onQosCallbackUnregistered(_arg0);
                    break;
                }
                case 16: {
                    this.onNetworkCreated();
                    break;
                }
                case 17: {
                    this.onNetworkDestroyed();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onDscpPolicyStatusUpdated(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 17;
        }

        private static class Proxy
        implements INetworkAgent {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkAgent.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistered(INetworkAgentRegistry registry) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeStrongInterface(registry);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDisconnected() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onBandwidthUpdateRequested() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onValidationStatusChanged(int validationStatus, String captivePortalUrl) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(validationStatus);
                    _data.writeString(captivePortalUrl);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSaveAcceptUnvalidated(boolean acceptUnvalidated) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeBoolean(acceptUnvalidated);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartNattSocketKeepalive(int slot, int intervalDurationMs, NattKeepalivePacketData packetData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    _data.writeInt(intervalDurationMs);
                    _data.writeTypedObject(packetData, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartTcpSocketKeepalive(int slot, int intervalDurationMs, TcpKeepalivePacketData packetData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    _data.writeInt(intervalDurationMs);
                    _data.writeTypedObject(packetData, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStopSocketKeepalive(int slot) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSignalStrengthThresholdsUpdated(int[] thresholds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeIntArray(thresholds);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onPreventAutomaticReconnect() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAddNattKeepalivePacketFilter(int slot, NattKeepalivePacketData packetData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    _data.writeTypedObject(packetData, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAddTcpKeepalivePacketFilter(int slot, TcpKeepalivePacketData packetData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    _data.writeTypedObject(packetData, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoveKeepalivePacketFilter(int slot) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQosFilterCallbackRegistered(int qosCallbackId, QosFilterParcelable filterParcel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(qosCallbackId);
                    _data.writeTypedObject(filterParcel, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQosCallbackUnregistered(int qosCallbackId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(qosCallbackId);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onNetworkCreated() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onNetworkDestroyed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDscpPolicyStatusUpdated(int policyId, int status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(policyId);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkAgent {
        @Override
        public void onRegistered(INetworkAgentRegistry registry) throws RemoteException {
        }

        @Override
        public void onDisconnected() throws RemoteException {
        }

        @Override
        public void onBandwidthUpdateRequested() throws RemoteException {
        }

        @Override
        public void onValidationStatusChanged(int validationStatus, String captivePortalUrl) throws RemoteException {
        }

        @Override
        public void onSaveAcceptUnvalidated(boolean acceptUnvalidated) throws RemoteException {
        }

        @Override
        public void onStartNattSocketKeepalive(int slot, int intervalDurationMs, NattKeepalivePacketData packetData) throws RemoteException {
        }

        @Override
        public void onStartTcpSocketKeepalive(int slot, int intervalDurationMs, TcpKeepalivePacketData packetData) throws RemoteException {
        }

        @Override
        public void onStopSocketKeepalive(int slot) throws RemoteException {
        }

        @Override
        public void onSignalStrengthThresholdsUpdated(int[] thresholds) throws RemoteException {
        }

        @Override
        public void onPreventAutomaticReconnect() throws RemoteException {
        }

        @Override
        public void onAddNattKeepalivePacketFilter(int slot, NattKeepalivePacketData packetData) throws RemoteException {
        }

        @Override
        public void onAddTcpKeepalivePacketFilter(int slot, TcpKeepalivePacketData packetData) throws RemoteException {
        }

        @Override
        public void onRemoveKeepalivePacketFilter(int slot) throws RemoteException {
        }

        @Override
        public void onQosFilterCallbackRegistered(int qosCallbackId, QosFilterParcelable filterParcel) throws RemoteException {
        }

        @Override
        public void onQosCallbackUnregistered(int qosCallbackId) throws RemoteException {
        }

        @Override
        public void onNetworkCreated() throws RemoteException {
        }

        @Override
        public void onNetworkDestroyed() throws RemoteException {
        }

        @Override
        public void onDscpPolicyStatusUpdated(int policyId, int status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

