/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Network;
import android.net.VpnProfileState;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnProfile;
import java.util.ArrayList;
import java.util.List;

public interface IVpnManager
extends IInterface {
    public static final String DESCRIPTOR = "android.net.IVpnManager";

    public boolean prepareVpn(String var1, String var2, int var3) throws RemoteException;

    public void setVpnPackageAuthorization(String var1, int var2, int var3) throws RemoteException;

    public ParcelFileDescriptor establishVpn(VpnConfig var1) throws RemoteException;

    public boolean addVpnAddress(String var1, int var2) throws RemoteException;

    public boolean removeVpnAddress(String var1, int var2) throws RemoteException;

    public boolean setUnderlyingNetworksForVpn(Network[] var1) throws RemoteException;

    public boolean provisionVpnProfile(VpnProfile var1, String var2) throws RemoteException;

    public void deleteVpnProfile(String var1) throws RemoteException;

    public String startVpnProfile(String var1) throws RemoteException;

    public void stopVpnProfile(String var1) throws RemoteException;

    public VpnProfileState getProvisionedVpnProfileState(String var1) throws RemoteException;

    public boolean setAppExclusionList(int var1, String var2, List<String> var3) throws RemoteException;

    public List<String> getAppExclusionList(int var1, String var2) throws RemoteException;

    public boolean isAlwaysOnVpnPackageSupported(int var1, String var2) throws RemoteException;

    public boolean setAlwaysOnVpnPackage(int var1, String var2, boolean var3, List<String> var4) throws RemoteException;

    public String getAlwaysOnVpnPackage(int var1) throws RemoteException;

    public boolean isVpnLockdownEnabled(int var1) throws RemoteException;

    public List<String> getVpnLockdownAllowlist(int var1) throws RemoteException;

    public boolean isCallerCurrentAlwaysOnVpnApp() throws RemoteException;

    public boolean isCallerCurrentAlwaysOnVpnLockdownApp() throws RemoteException;

    public void startLegacyVpn(VpnProfile var1) throws RemoteException;

    public LegacyVpnInfo getLegacyVpnInfo(int var1) throws RemoteException;

    public boolean updateLockdownVpn() throws RemoteException;

    public VpnConfig getVpnConfig(int var1) throws RemoteException;

    public void factoryReset() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVpnManager {
        static final int TRANSACTION_prepareVpn = 1;
        static final int TRANSACTION_setVpnPackageAuthorization = 2;
        static final int TRANSACTION_establishVpn = 3;
        static final int TRANSACTION_addVpnAddress = 4;
        static final int TRANSACTION_removeVpnAddress = 5;
        static final int TRANSACTION_setUnderlyingNetworksForVpn = 6;
        static final int TRANSACTION_provisionVpnProfile = 7;
        static final int TRANSACTION_deleteVpnProfile = 8;
        static final int TRANSACTION_startVpnProfile = 9;
        static final int TRANSACTION_stopVpnProfile = 10;
        static final int TRANSACTION_getProvisionedVpnProfileState = 11;
        static final int TRANSACTION_setAppExclusionList = 12;
        static final int TRANSACTION_getAppExclusionList = 13;
        static final int TRANSACTION_isAlwaysOnVpnPackageSupported = 14;
        static final int TRANSACTION_setAlwaysOnVpnPackage = 15;
        static final int TRANSACTION_getAlwaysOnVpnPackage = 16;
        static final int TRANSACTION_isVpnLockdownEnabled = 17;
        static final int TRANSACTION_getVpnLockdownAllowlist = 18;
        static final int TRANSACTION_isCallerCurrentAlwaysOnVpnApp = 19;
        static final int TRANSACTION_isCallerCurrentAlwaysOnVpnLockdownApp = 20;
        static final int TRANSACTION_startLegacyVpn = 21;
        static final int TRANSACTION_getLegacyVpnInfo = 22;
        static final int TRANSACTION_updateLockdownVpn = 23;
        static final int TRANSACTION_getVpnConfig = 24;
        static final int TRANSACTION_factoryReset = 25;

        public Stub() {
            this.attachInterface(this, IVpnManager.DESCRIPTOR);
        }

        public static IVpnManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVpnManager.DESCRIPTOR);
            if (iin != null && iin instanceof IVpnManager) {
                return (IVpnManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "prepareVpn";
                }
                case 2: {
                    return "setVpnPackageAuthorization";
                }
                case 3: {
                    return "establishVpn";
                }
                case 4: {
                    return "addVpnAddress";
                }
                case 5: {
                    return "removeVpnAddress";
                }
                case 6: {
                    return "setUnderlyingNetworksForVpn";
                }
                case 7: {
                    return "provisionVpnProfile";
                }
                case 8: {
                    return "deleteVpnProfile";
                }
                case 9: {
                    return "startVpnProfile";
                }
                case 10: {
                    return "stopVpnProfile";
                }
                case 11: {
                    return "getProvisionedVpnProfileState";
                }
                case 12: {
                    return "setAppExclusionList";
                }
                case 13: {
                    return "getAppExclusionList";
                }
                case 14: {
                    return "isAlwaysOnVpnPackageSupported";
                }
                case 15: {
                    return "setAlwaysOnVpnPackage";
                }
                case 16: {
                    return "getAlwaysOnVpnPackage";
                }
                case 17: {
                    return "isVpnLockdownEnabled";
                }
                case 18: {
                    return "getVpnLockdownAllowlist";
                }
                case 19: {
                    return "isCallerCurrentAlwaysOnVpnApp";
                }
                case 20: {
                    return "isCallerCurrentAlwaysOnVpnLockdownApp";
                }
                case 21: {
                    return "startLegacyVpn";
                }
                case 22: {
                    return "getLegacyVpnInfo";
                }
                case 23: {
                    return "updateLockdownVpn";
                }
                case 24: {
                    return "getVpnConfig";
                }
                case 25: {
                    return "factoryReset";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVpnManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.prepareVpn(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setVpnPackageAuthorization(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    VpnConfig _arg0 = data.readTypedObject(VpnConfig.CREATOR);
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.establishVpn(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.addVpnAddress(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeVpnAddress(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    Network[] _arg0 = data.createTypedArray(Network.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setUnderlyingNetworksForVpn(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    VpnProfile _arg0 = data.readTypedObject(VpnProfile.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.provisionVpnProfile(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.deleteVpnProfile(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.startVpnProfile(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.stopVpnProfile(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    VpnProfileState _result = this.getProvisionedVpnProfileState(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    data.enforceNoDataAvail();
                    boolean _result = this.setAppExclusionList(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getAppExclusionList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAlwaysOnVpnPackageSupported(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    ArrayList<String> _arg3 = data.createStringArrayList();
                    data.enforceNoDataAvail();
                    boolean _result = this.setAlwaysOnVpnPackage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getAlwaysOnVpnPackage(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isVpnLockdownEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getVpnLockdownAllowlist(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 19: {
                    boolean _result = this.isCallerCurrentAlwaysOnVpnApp();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    boolean _result = this.isCallerCurrentAlwaysOnVpnLockdownApp();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    VpnProfile _arg0 = data.readTypedObject(VpnProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.startLegacyVpn(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    LegacyVpnInfo _result = this.getLegacyVpnInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 23: {
                    boolean _result = this.updateLockdownVpn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    VpnConfig _result = this.getVpnConfig(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 25: {
                    this.factoryReset();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 24;
        }

        private static class Proxy
        implements IVpnManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVpnManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean prepareVpn(String oldPackage, String newPackage, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeString(oldPackage);
                    _data.writeString(newPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVpnPackageAuthorization(String packageName, int userId, int vpnType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(vpnType);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor establishVpn(VpnConfig config) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addVpnAddress(String address, int prefixLength) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(prefixLength);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeVpnAddress(String address, int prefixLength) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeInt(prefixLength);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setUnderlyingNetworksForVpn(Network[] networks) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeTypedArray(networks, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean provisionVpnProfile(VpnProfile profile, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteVpnProfile(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String startVpnProfile(String packageName) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopVpnProfile(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VpnProfileState getProvisionedVpnProfileState(String packageName) throws RemoteException {
                VpnProfileState _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VpnProfileState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAppExclusionList(int userId, String vpnPackage, List<String> excludedApps) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(vpnPackage);
                    _data.writeStringList(excludedApps);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAppExclusionList(int userId, String vpnPackage) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(vpnPackage);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAlwaysOnVpnPackageSupported(int userId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAlwaysOnVpnPackage(int userId, String packageName, boolean lockdown, List<String> lockdownAllowlist) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    _data.writeBoolean(lockdown);
                    _data.writeStringList(lockdownAllowlist);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getAlwaysOnVpnPackage(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVpnLockdownEnabled(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getVpnLockdownAllowlist(int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCallerCurrentAlwaysOnVpnApp() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCallerCurrentAlwaysOnVpnLockdownApp() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startLegacyVpn(VpnProfile profile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeTypedObject(profile, 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LegacyVpnInfo getLegacyVpnInfo(int userId) throws RemoteException {
                LegacyVpnInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(LegacyVpnInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateLockdownVpn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VpnConfig getVpnConfig(int userId) throws RemoteException {
                VpnConfig _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VpnConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void factoryReset() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVpnManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVpnManager {
        @Override
        public boolean prepareVpn(String oldPackage, String newPackage, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setVpnPackageAuthorization(String packageName, int userId, int vpnType) throws RemoteException {
        }

        @Override
        public ParcelFileDescriptor establishVpn(VpnConfig config) throws RemoteException {
            return null;
        }

        @Override
        public boolean addVpnAddress(String address, int prefixLength) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeVpnAddress(String address, int prefixLength) throws RemoteException {
            return false;
        }

        @Override
        public boolean setUnderlyingNetworksForVpn(Network[] networks) throws RemoteException {
            return false;
        }

        @Override
        public boolean provisionVpnProfile(VpnProfile profile, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void deleteVpnProfile(String packageName) throws RemoteException {
        }

        @Override
        public String startVpnProfile(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void stopVpnProfile(String packageName) throws RemoteException {
        }

        @Override
        public VpnProfileState getProvisionedVpnProfileState(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public boolean setAppExclusionList(int userId, String vpnPackage, List<String> excludedApps) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getAppExclusionList(int userId, String vpnPackage) throws RemoteException {
            return null;
        }

        @Override
        public boolean isAlwaysOnVpnPackageSupported(int userId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean setAlwaysOnVpnPackage(int userId, String packageName, boolean lockdown, List<String> lockdownAllowlist) throws RemoteException {
            return false;
        }

        @Override
        public String getAlwaysOnVpnPackage(int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isVpnLockdownEnabled(int userId) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getVpnLockdownAllowlist(int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isCallerCurrentAlwaysOnVpnApp() throws RemoteException {
            return false;
        }

        @Override
        public boolean isCallerCurrentAlwaysOnVpnLockdownApp() throws RemoteException {
            return false;
        }

        @Override
        public void startLegacyVpn(VpnProfile profile) throws RemoteException {
        }

        @Override
        public LegacyVpnInfo getLegacyVpnInfo(int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean updateLockdownVpn() throws RemoteException {
            return false;
        }

        @Override
        public VpnConfig getVpnConfig(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void factoryReset() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

