/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.IIpSecService;
import android.net.IpSecConfig;
import android.net.IpSecSpiResponse;
import android.net.IpSecTransform;
import android.net.IpSecTransformResponse;
import android.net.IpSecTunnelInterfaceResponse;
import android.net.IpSecUdpEncapResponse;
import android.net.LinkAddress;
import android.net.Network;
import android.net.connectivity.com.android.modules.utils.build.SdkLevel;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.AndroidException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Objects;

public class IpSecManager {
    private static final String TAG = "IpSecManager";
    public static final String FEATURE_IPSEC_TUNNEL_MIGRATION = "android.software.ipsec_tunnel_migration";
    public static final int DIRECTION_IN = 0;
    public static final int DIRECTION_OUT = 1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int DIRECTION_FWD = 2;
    public static final int INVALID_SECURITY_PARAMETER_INDEX = 0;
    public static final int INVALID_RESOURCE_ID = -1;
    private final Context mContext;
    private final IIpSecService mService;

    public SecurityParameterIndex allocateSecurityParameterIndex(InetAddress destinationAddress) throws ResourceUnavailableException {
        try {
            return new SecurityParameterIndex(this.mService, destinationAddress, 0);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowUncheckedExceptionFromServiceSpecificException(e);
        }
        catch (SpiUnavailableException unlikely) {
            throw new ResourceUnavailableException("No SPIs available");
        }
    }

    public SecurityParameterIndex allocateSecurityParameterIndex(InetAddress destinationAddress, int requestedSpi) throws SpiUnavailableException, ResourceUnavailableException {
        if (requestedSpi == 0) {
            throw new IllegalArgumentException("Requested SPI must be a valid (non-zero) SPI");
        }
        try {
            return new SecurityParameterIndex(this.mService, destinationAddress, requestedSpi);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowUncheckedExceptionFromServiceSpecificException(e);
        }
    }

    public void applyTransportModeTransform(Socket socket, int direction, IpSecTransform transform) throws IOException {
        socket.getSoLinger();
        this.applyTransportModeTransform(socket.getFileDescriptor$(), direction, transform);
    }

    public void applyTransportModeTransform(DatagramSocket socket, int direction, IpSecTransform transform) throws IOException {
        this.applyTransportModeTransform(socket.getFileDescriptor$(), direction, transform);
    }

    public void applyTransportModeTransform(FileDescriptor socket, int direction, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup(socket);){
            this.mService.applyTransportModeTransform(pfd, direction, transform.getResourceId());
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeTransportModeTransforms(Socket socket) throws IOException {
        socket.getSoLinger();
        this.removeTransportModeTransforms(socket.getFileDescriptor$());
    }

    public void removeTransportModeTransforms(DatagramSocket socket) throws IOException {
        this.removeTransportModeTransforms(socket.getFileDescriptor$());
    }

    public void removeTransportModeTransforms(FileDescriptor socket) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup(socket);){
            this.mService.removeTransportModeTransforms(pfd);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeTunnelModeTransform(Network net, IpSecTransform transform) {
    }

    public UdpEncapsulationSocket openUdpEncapsulationSocket(int port) throws IOException, ResourceUnavailableException {
        if (port == 0) {
            throw new IllegalArgumentException("Specified port must be a valid port number!");
        }
        try {
            return new UdpEncapsulationSocket(this.mService, port);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
    }

    public UdpEncapsulationSocket openUdpEncapsulationSocket() throws IOException, ResourceUnavailableException {
        try {
            return new UdpEncapsulationSocket(this.mService, 0);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_IPSEC_TUNNELS")
    public IpSecTunnelInterface createIpSecTunnelInterface(InetAddress localAddress, InetAddress remoteAddress, Network underlyingNetwork) throws ResourceUnavailableException, IOException {
        try {
            return new IpSecTunnelInterface(this.mContext, this.mService, localAddress, remoteAddress, underlyingNetwork);
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_IPSEC_TUNNELS")
    public void applyTunnelModeTransform(IpSecTunnelInterface tunnel, int direction, IpSecTransform transform) throws IOException {
        try {
            this.mService.applyTunnelModeTransform(tunnel.getResourceId(), direction, transform.getResourceId(), this.mContext.getOpPackageName());
        }
        catch (ServiceSpecificException e) {
            throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_IPSEC_TUNNELS")
    public void startTunnelModeTransformMigration(IpSecTransform transform, InetAddress newSourceAddress, InetAddress newDestinationAddress) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Transform migration only supported for Android 14+");
        }
        Objects.requireNonNull(transform, "transform was null");
        Objects.requireNonNull(newSourceAddress, "newSourceAddress was null");
        Objects.requireNonNull(newDestinationAddress, "newDestinationAddress was null");
        try {
            this.mService.migrateTransform(transform.getResourceId(), newSourceAddress.getHostAddress(), newDestinationAddress.getHostAddress(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public IpSecTransformResponse createTransform(IpSecConfig config, IBinder binder, String callingPackage) {
        try {
            return this.mService.createTransform(config, binder, callingPackage);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void deleteTransform(int resourceId) {
        try {
            this.mService.deleteTransform(resourceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public IpSecManager(Context ctx, IIpSecService service) {
        this.mContext = ctx;
        this.mService = Objects.requireNonNull(service, "missing service");
    }

    private static void maybeHandleServiceSpecificException(ServiceSpecificException sse) {
        if (sse.errorCode == OsConstants.EINVAL) {
            throw new IllegalArgumentException(sse);
        }
        if (sse.errorCode == OsConstants.EAGAIN) {
            throw new IllegalStateException(sse);
        }
        if (sse.errorCode == OsConstants.EOPNOTSUPP || sse.errorCode == OsConstants.EPROTONOSUPPORT) {
            throw new UnsupportedOperationException(sse);
        }
    }

    static RuntimeException rethrowUncheckedExceptionFromServiceSpecificException(ServiceSpecificException sse) {
        IpSecManager.maybeHandleServiceSpecificException(sse);
        throw new RuntimeException(sse);
    }

    static IOException rethrowCheckedExceptionFromServiceSpecificException(ServiceSpecificException sse) throws IOException {
        IpSecManager.maybeHandleServiceSpecificException(sse);
        throw new ErrnoException("IpSec encountered errno=" + sse.errorCode, sse.errorCode).rethrowAsIOException();
    }

    public static class SecurityParameterIndex
    implements AutoCloseable {
        private final IIpSecService mService;
        private final InetAddress mDestinationAddress;
        private final CloseGuard mCloseGuard = CloseGuard.get();
        private int mSpi = 0;
        private int mResourceId = -1;

        public int getSpi() {
            return this.mSpi;
        }

        @Override
        public void close() {
            try {
                this.mService.releaseSecurityParameterIndex(this.mResourceId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (Exception e) {
                Log.e(IpSecManager.TAG, "Failed to close " + this + ", Exception=" + e);
            }
            finally {
                this.mResourceId = -1;
                this.mCloseGuard.close();
            }
        }

        protected void finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        private SecurityParameterIndex(IIpSecService service, InetAddress destinationAddress, int spi) throws ResourceUnavailableException, SpiUnavailableException {
            this.mService = service;
            this.mDestinationAddress = destinationAddress;
            try {
                IpSecSpiResponse result = this.mService.allocateSecurityParameterIndex(destinationAddress.getHostAddress(), spi, new Binder());
                if (result == null) {
                    throw new NullPointerException("Received null response from IpSecService");
                }
                int status = result.status;
                switch (status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more SPIs may be allocated by this requester.");
                    }
                    case 2: {
                        throw new SpiUnavailableException("Requested SPI is unavailable", spi);
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + status);
                    }
                }
                this.mSpi = result.spi;
                this.mResourceId = result.resourceId;
                if (this.mSpi == 0) {
                    throw new RuntimeException("Invalid SPI returned by IpSecService: " + status);
                }
                if (this.mResourceId == -1) {
                    throw new RuntimeException("Invalid Resource ID returned by IpSecService: " + status);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("close");
        }

        @VisibleForTesting
        public int getResourceId() {
            return this.mResourceId;
        }

        public String toString() {
            return "SecurityParameterIndex{spi=" + this.mSpi + ",resourceId=" + this.mResourceId + "}";
        }
    }

    public static class SpiUnavailableException
    extends AndroidException {
        private final int mSpi;

        SpiUnavailableException(String msg, int spi) {
            super(msg + " (spi: " + spi + ")");
            this.mSpi = spi;
        }

        public int getSpi() {
            return this.mSpi;
        }
    }

    public static class ResourceUnavailableException
    extends AndroidException {
        ResourceUnavailableException(String msg) {
            super(msg);
        }
    }

    public static class UdpEncapsulationSocket
    implements AutoCloseable {
        private final ParcelFileDescriptor mPfd;
        private final IIpSecService mService;
        private int mResourceId = -1;
        private final int mPort;
        private final CloseGuard mCloseGuard = CloseGuard.get();

        private UdpEncapsulationSocket(IIpSecService service, int port) throws ResourceUnavailableException, IOException {
            this.mService = service;
            try {
                IpSecUdpEncapResponse result = this.mService.openUdpEncapsulationSocket(port, new Binder());
                switch (result.status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more Sockets may be allocated by this requester.");
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + result.status);
                    }
                }
                this.mResourceId = result.resourceId;
                this.mPort = result.port;
                this.mPfd = result.fileDescriptor;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("close");
        }

        public FileDescriptor getFileDescriptor() {
            if (this.mPfd == null) {
                return null;
            }
            return this.mPfd.getFileDescriptor();
        }

        public int getPort() {
            return this.mPort;
        }

        @Override
        public void close() throws IOException {
            try {
                this.mService.closeUdpEncapsulationSocket(this.mResourceId);
                this.mResourceId = -1;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (Exception e) {
                Log.e(IpSecManager.TAG, "Failed to close " + this + ", Exception=" + e);
            }
            finally {
                this.mResourceId = -1;
                this.mCloseGuard.close();
            }
            try {
                this.mPfd.close();
            }
            catch (IOException e) {
                Log.e(IpSecManager.TAG, "Failed to close UDP Encapsulation Socket with Port= " + this.mPort);
                throw e;
            }
        }

        protected void finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public int getResourceId() {
            return this.mResourceId;
        }

        public String toString() {
            return "UdpEncapsulationSocket{port=" + this.mPort + ",resourceId=" + this.mResourceId + "}";
        }
    }

    @SystemApi
    public static class IpSecTunnelInterface
    implements AutoCloseable {
        private final String mOpPackageName;
        private final IIpSecService mService;
        private final InetAddress mRemoteAddress;
        private final InetAddress mLocalAddress;
        private final Network mUnderlyingNetwork;
        private final CloseGuard mCloseGuard = CloseGuard.get();
        private String mInterfaceName;
        private int mResourceId = -1;

        public String getInterfaceName() {
            return this.mInterfaceName;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MANAGE_IPSEC_TUNNELS")
        public void addAddress(InetAddress address, int prefixLen) throws IOException {
            try {
                this.mService.addAddressToTunnelInterface(this.mResourceId, new LinkAddress(address, prefixLen), this.mOpPackageName);
            }
            catch (ServiceSpecificException e) {
                throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MANAGE_IPSEC_TUNNELS")
        public void removeAddress(InetAddress address, int prefixLen) throws IOException {
            try {
                this.mService.removeAddressFromTunnelInterface(this.mResourceId, new LinkAddress(address, prefixLen), this.mOpPackageName);
            }
            catch (ServiceSpecificException e) {
                throw IpSecManager.rethrowCheckedExceptionFromServiceSpecificException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @RequiresPermission(value="android.permission.MANAGE_IPSEC_TUNNELS")
        public void setUnderlyingNetwork(Network underlyingNetwork) throws IOException {
            try {
                this.mService.setNetworkForTunnelInterface(this.mResourceId, underlyingNetwork, this.mOpPackageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private IpSecTunnelInterface(Context ctx, IIpSecService service, InetAddress localAddress, InetAddress remoteAddress, Network underlyingNetwork) throws ResourceUnavailableException, IOException {
            this.mOpPackageName = ctx.getOpPackageName();
            this.mService = service;
            this.mLocalAddress = localAddress;
            this.mRemoteAddress = remoteAddress;
            this.mUnderlyingNetwork = underlyingNetwork;
            try {
                IpSecTunnelInterfaceResponse result = this.mService.createTunnelInterface(localAddress.getHostAddress(), remoteAddress.getHostAddress(), underlyingNetwork, new Binder(), this.mOpPackageName);
                switch (result.status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more tunnel interfaces may be allocated by this requester.");
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + result.status);
                    }
                }
                this.mResourceId = result.resourceId;
                this.mInterfaceName = result.interfaceName;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("close");
        }

        @Override
        public void close() {
            try {
                this.mService.deleteTunnelInterface(this.mResourceId, this.mOpPackageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (Exception e) {
                Log.e(IpSecManager.TAG, "Failed to close " + this + ", Exception=" + e);
            }
            finally {
                this.mResourceId = -1;
                this.mCloseGuard.close();
            }
        }

        protected void finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        @VisibleForTesting
        public int getResourceId() {
            return this.mResourceId;
        }

        public String toString() {
            return "IpSecTunnelInterface{ifname=" + this.mInterfaceName + ",resourceId=" + this.mResourceId + "}";
        }
    }

    public static interface Status {
        public static final int OK = 0;
        public static final int RESOURCE_UNAVAILABLE = 1;
        public static final int SPI_UNAVAILABLE = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PolicyDirection {
    }
}

