/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.net.NetworkScore;
import android.net.connectivity.android.net.INetworkOfferCallback;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.concurrent.Executor;

@SystemApi
public class NetworkProvider {
    public static final int ID_NONE = -1;
    public static final int FIRST_PROVIDER_ID = 1;
    public static final int CMD_REQUEST_NETWORK = 1;
    public static final int CMD_CANCEL_REQUEST = 2;
    private final Messenger mMessenger;
    private final String mName;
    private final Context mContext;
    private int mProviderId = -1;
    @GuardedBy(value={"mProxies"})
    private final ArrayList<NetworkOfferCallbackProxy> mProxies = new ArrayList();

    @SystemApi
    public NetworkProvider(Context context, Looper looper, String name) {
        Handler handler = new Handler(looper){

            @Override
            public void handleMessage(Message m) {
                switch (m.what) {
                    case 1: {
                        NetworkProvider.this.onNetworkRequested((NetworkRequest)m.obj, m.arg1, m.arg2);
                        break;
                    }
                    case 2: {
                        NetworkProvider.this.onNetworkRequestWithdrawn((NetworkRequest)m.obj);
                        break;
                    }
                    default: {
                        Log.e(NetworkProvider.this.mName, "Unhandled message: " + m.what);
                    }
                }
            }
        };
        this.mContext = context;
        this.mMessenger = new Messenger(handler);
        this.mName = name;
    }

    public Messenger getMessenger() {
        return this.mMessenger;
    }

    public String getName() {
        return this.mName;
    }

    public int getProviderId() {
        return this.mProviderId;
    }

    public void setProviderId(int providerId) {
        this.mProviderId = providerId;
    }

    @SystemApi
    public void onNetworkRequested(NetworkRequest request, int score, int providerId) {
    }

    @SystemApi
    public void onNetworkRequestWithdrawn(NetworkRequest request) {
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_FACTORY")
    public void declareNetworkRequestUnfulfillable(NetworkRequest request) {
        ConnectivityManager.from(this.mContext).declareNetworkRequestUnfulfillable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkOfferCallbackProxy findProxyForCallback(NetworkOfferCallback cb) {
        ArrayList<NetworkOfferCallbackProxy> arrayList = this.mProxies;
        synchronized (arrayList) {
            for (NetworkOfferCallbackProxy p : this.mProxies) {
                if (p.callback != cb) continue;
                return p;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_FACTORY")
    public void registerNetworkOffer(NetworkScore score, NetworkCapabilities caps, Executor executor, NetworkOfferCallback callback) {
        int providerId = this.mProviderId;
        if (providerId == -1) {
            return;
        }
        NetworkOfferCallbackProxy proxy = null;
        ArrayList<NetworkOfferCallbackProxy> arrayList = this.mProxies;
        synchronized (arrayList) {
            for (NetworkOfferCallbackProxy existingProxy : this.mProxies) {
                if (existingProxy.callback != callback) continue;
                proxy = existingProxy;
                break;
            }
            if (null == proxy) {
                proxy = new NetworkOfferCallbackProxy(callback, executor);
                this.mProxies.add(proxy);
            }
        }
        this.mContext.getSystemService(ConnectivityManager.class).offerNetwork(providerId, score, caps, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_FACTORY")
    public void unregisterNetworkOffer(NetworkOfferCallback callback) {
        NetworkOfferCallbackProxy proxy = this.findProxyForCallback(callback);
        if (null == proxy) {
            return;
        }
        ArrayList<NetworkOfferCallbackProxy> arrayList = this.mProxies;
        synchronized (arrayList) {
            this.mProxies.remove(proxy);
        }
        this.mContext.getSystemService(ConnectivityManager.class).unofferNetwork(proxy);
    }

    private class NetworkOfferCallbackProxy
    extends INetworkOfferCallback.Stub {
        public final NetworkOfferCallback callback;
        private final Executor mExecutor;

        NetworkOfferCallbackProxy(NetworkOfferCallback callback, Executor executor) {
            this.callback = callback;
            this.mExecutor = executor;
        }

        @Override
        public void onNetworkNeeded(NetworkRequest request) {
            this.mExecutor.execute(() -> this.callback.onNetworkNeeded(request));
        }

        @Override
        public void onNetworkUnneeded(NetworkRequest request) {
            this.mExecutor.execute(() -> this.callback.onNetworkUnneeded(request));
        }
    }

    @SystemApi
    public static interface NetworkOfferCallback {
        public void onNetworkNeeded(NetworkRequest var1);

        public void onNetworkUnneeded(NetworkRequest var1);
    }
}

