/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.app.usage.NetworkStatsManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.NetworkIdentity;
import android.net.NetworkStats;
import android.net.connectivity.com.android.modules.utils.build.SdkLevel;
import android.net.connectivity.com.android.net.module.util.CollectionUtils;
import android.net.connectivity.com.android.net.module.util.NetworkIdentityUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NetworkTemplate
implements Parcelable {
    private static final String TAG = NetworkTemplate.class.getSimpleName();
    public static final int MATCH_MOBILE = 1;
    public static final int MATCH_WIFI = 4;
    public static final int MATCH_ETHERNET = 5;
    public static final int MATCH_BLUETOOTH = 8;
    public static final int MATCH_PROXY = 9;
    public static final int MATCH_CARRIER = 10;
    @VisibleForTesting
    public static final int MATCH_TEST = 11;
    public static final String WIFI_NETWORKID_ALL;
    public static final String WIFI_NETWORK_KEY_ALL;
    public static final int NETWORK_TYPE_ALL = -1;
    public static final int OEM_MANAGED_ALL = -1;
    public static final int OEM_MANAGED_NO = 0;
    public static final int OEM_MANAGED_YES = -2;
    public static final int OEM_MANAGED_PAID = 1;
    public static final int OEM_MANAGED_PRIVATE = 2;
    private final int mMatchRule;
    private final String[] mMatchSubscriberIds;
    private final String[] mMatchWifiNetworkKeys;
    private final int mMetered;
    private final int mRoaming;
    private final int mDefaultNetwork;
    private final int mRatType;
    private final int mOemManaged;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<NetworkTemplate> CREATOR;

    private static boolean isKnownMatchRule(int rule) {
        switch (rule) {
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private static Set<String> setOf(String item) {
        if (item == null) {
            HashSet<Object> set = new HashSet<Object>();
            set.add(null);
            return Collections.unmodifiableSet(set);
        }
        return Set.of(item);
    }

    private static void throwAtLeastU() {
        if (SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on Android U or above");
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@code Builder} instead.")
    public static NetworkTemplate buildTemplateMobileAll(String subscriberId) {
        return new Builder(1).setMeteredness(1).setSubscriberIds(NetworkTemplate.setOf(subscriberId)).build();
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static NetworkTemplate buildTemplateMobileWildcard() {
        return new Builder(1).setMeteredness(1).build();
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@code Builder} instead.")
    public static NetworkTemplate buildTemplateWifiWildcard() {
        return new Builder(4).build();
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@code Builder} instead.")
    public static NetworkTemplate buildTemplateWifi() {
        return NetworkTemplate.buildTemplateWifiWildcard();
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@code Builder} instead.")
    public static NetworkTemplate buildTemplateEthernet() {
        return new Builder(5).build();
    }

    public static NetworkTemplate buildTemplateBluetooth() {
        return new Builder(8).build();
    }

    public static NetworkTemplate buildTemplateProxy() {
        return new NetworkTemplate(9, null, null);
    }

    public static NetworkTemplate buildTemplateCarrierMetered(String subscriberId) {
        NetworkTemplate.throwAtLeastU();
        return new Builder(10).setSubscriberIds(Set.of(subscriberId)).setMeteredness(1).build();
    }

    public static NetworkTemplate buildTemplateMobileWithRatType(String subscriberId, int ratType, int metered) {
        NetworkTemplate.throwAtLeastU();
        return new Builder(1).setSubscriberIds(TextUtils.isEmpty(subscriberId) ? Collections.emptySet() : Set.of(subscriberId)).setMeteredness(metered).setRatType(ratType).build();
    }

    public static NetworkTemplate buildTemplateWifi(String wifiNetworkKey) {
        return new Builder(4).setWifiNetworkKeys(Set.of(wifiNetworkKey)).build();
    }

    public static NetworkTemplate buildTemplateWifi(String wifiNetworkKey, String subscriberId) {
        NetworkTemplate.throwAtLeastU();
        return new Builder(4).setSubscriberIds(NetworkTemplate.setOf(subscriberId)).setWifiNetworkKeys(wifiNetworkKey == null ? Collections.emptySet() : Set.of(wifiNetworkKey)).build();
    }

    private static void checkValidMatchSubscriberIds(int matchRule, String[] matchSubscriberIds) {
        switch (matchRule) {
            case 10: {
                if (matchSubscriberIds.length == 0) {
                    throw new IllegalArgumentException("matchSubscriberIds may not contain null for rule " + NetworkTemplate.getMatchRuleName(matchRule));
                }
                if (!CollectionUtils.contains(matchSubscriberIds, null)) break;
                throw new IllegalArgumentException("matchSubscriberIds may not contain null for rule " + NetworkTemplate.getMatchRuleName(matchRule));
            }
            case 1: {
                int firstSdk = _Original_Build.VERSION.DEVICE_INITIAL_SDK_INT;
                if (firstSdk > 33 && CollectionUtils.contains(matchSubscriberIds, null)) {
                    throw new IllegalArgumentException("checkValidMatchSubscriberIds list of ids may not contain null for rule " + NetworkTemplate.getMatchRuleName(matchRule));
                }
                return;
            }
            default: {
                return;
            }
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@code Builder} instead.")
    public NetworkTemplate(int matchRule, String subscriberId, String wifiNetworkKey) {
        String[] stringArray;
        String[] stringArray2;
        int n = NetworkTemplate.getBackwardsCompatibleMatchRule(matchRule);
        if (subscriberId != null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = subscriberId;
        } else {
            stringArray2 = new String[]{};
        }
        if (wifiNetworkKey != null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = wifiNetworkKey;
        } else {
            stringArray = new String[]{};
        }
        this(n, stringArray2, stringArray, NetworkTemplate.getMeterednessForBackwardsCompatibility(matchRule), -1, -1, -1, -1);
        if (matchRule == 6 || matchRule == 7) {
            Log.e(TAG, "Use MATCH_MOBILE with empty subscriberIds or MATCH_WIFI with empty wifiNetworkKeys instead of template with matchRule=" + matchRule);
        }
    }

    private static int getBackwardsCompatibleMatchRule(int matchRule) {
        if (6 == matchRule) {
            return 1;
        }
        if (7 == matchRule) {
            return 4;
        }
        return matchRule;
    }

    private static int getMeterednessForBackwardsCompatibility(int matchRule) {
        if (NetworkTemplate.getBackwardsCompatibleMatchRule(matchRule) == 1 || matchRule == 10) {
            return 1;
        }
        return -1;
    }

    public NetworkTemplate(int matchRule, String subscriberId, String[] matchSubscriberIds, String wifiNetworkKey) {
        String[] stringArray;
        int n = NetworkTemplate.getBackwardsCompatibleMatchRule(matchRule);
        if (wifiNetworkKey != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = wifiNetworkKey;
        } else {
            stringArray = new String[]{};
        }
        this(n, matchSubscriberIds, stringArray, NetworkTemplate.getMeterednessForBackwardsCompatibility(matchRule), -1, -1, -1, -1);
    }

    public NetworkTemplate(int matchRule, String subscriberId, String[] matchSubscriberIds, String[] matchWifiNetworkKeys, int metered, int roaming, int defaultNetwork, int ratType, int oemManaged, int subscriberIdMatchRule) {
        this(NetworkTemplate.getBackwardsCompatibleMatchRule(matchRule), matchSubscriberIds == null ? new String[]{} : matchSubscriberIds, matchWifiNetworkKeys, metered, roaming, defaultNetwork, ratType, oemManaged);
        NetworkTemplate.throwAtLeastU();
    }

    public NetworkTemplate(int matchRule, String[] matchSubscriberIds, String[] matchWifiNetworkKeys, int metered, int roaming, int defaultNetwork, int ratType, int oemManaged) {
        Objects.requireNonNull(matchWifiNetworkKeys);
        Objects.requireNonNull(matchSubscriberIds);
        this.mMatchRule = matchRule;
        this.mMatchSubscriberIds = matchSubscriberIds;
        this.mMatchWifiNetworkKeys = matchWifiNetworkKeys;
        this.mMetered = metered;
        this.mRoaming = roaming;
        this.mDefaultNetwork = defaultNetwork;
        this.mRatType = ratType;
        this.mOemManaged = oemManaged;
        NetworkTemplate.checkValidMatchSubscriberIds(matchRule, matchSubscriberIds);
        if (!NetworkTemplate.isKnownMatchRule(matchRule)) {
            throw new IllegalArgumentException("Unknown network template rule " + matchRule + " will not match any identity.");
        }
    }

    private NetworkTemplate(Parcel in) {
        this.mMatchRule = in.readInt();
        this.mMatchSubscriberIds = in.createStringArray();
        this.mMatchWifiNetworkKeys = in.createStringArray();
        this.mMetered = in.readInt();
        this.mRoaming = in.readInt();
        this.mDefaultNetwork = in.readInt();
        this.mRatType = in.readInt();
        this.mOemManaged = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMatchRule);
        dest.writeStringArray(this.mMatchSubscriberIds);
        dest.writeStringArray(this.mMatchWifiNetworkKeys);
        dest.writeInt(this.mMetered);
        dest.writeInt(this.mRoaming);
        dest.writeInt(this.mDefaultNetwork);
        dest.writeInt(this.mRatType);
        dest.writeInt(this.mOemManaged);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NetworkTemplate: ");
        builder.append("matchRule=").append(NetworkTemplate.getMatchRuleName(this.mMatchRule));
        if (this.mMatchSubscriberIds != null) {
            builder.append(", matchSubscriberIds=").append(Arrays.toString(NetworkIdentityUtils.scrubSubscriberIds(this.mMatchSubscriberIds)));
        }
        builder.append(", matchWifiNetworkKeys=").append(Arrays.toString(this.mMatchWifiNetworkKeys));
        if (this.mMetered != -1) {
            builder.append(", metered=").append(NetworkStats.meteredToString(this.mMetered));
        }
        if (this.mRoaming != -1) {
            builder.append(", roaming=").append(NetworkStats.roamingToString(this.mRoaming));
        }
        if (this.mDefaultNetwork != -1) {
            builder.append(", defaultNetwork=").append(NetworkStats.defaultNetworkToString(this.mDefaultNetwork));
        }
        if (this.mRatType != -1) {
            builder.append(", ratType=").append(this.mRatType);
        }
        if (this.mOemManaged != -1) {
            builder.append(", oemManaged=").append(NetworkTemplate.getOemManagedNames(this.mOemManaged));
        }
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.mMatchRule, Arrays.hashCode(this.mMatchSubscriberIds), Arrays.hashCode(this.mMatchWifiNetworkKeys), this.mMetered, this.mRoaming, this.mDefaultNetwork, this.mRatType, this.mOemManaged);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkTemplate) {
            NetworkTemplate other = (NetworkTemplate)obj;
            return this.mMatchRule == other.mMatchRule && this.mMetered == other.mMetered && this.mRoaming == other.mRoaming && this.mDefaultNetwork == other.mDefaultNetwork && this.mRatType == other.mRatType && this.mOemManaged == other.mOemManaged && Arrays.equals(this.mMatchSubscriberIds, other.mMatchSubscriberIds) && Arrays.equals(this.mMatchWifiNetworkKeys, other.mMatchWifiNetworkKeys);
        }
        return false;
    }

    public boolean isMatchRuleMobile() {
        switch (this.mMatchRule) {
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getMatchRule() {
        return this.mMatchRule;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Caller should use {@code getSubscriberIds} instead.")
    public String getSubscriberId() {
        return CollectionUtils.isEmpty(this.mMatchSubscriberIds) ? null : this.mMatchSubscriberIds[0];
    }

    public Set<String> getSubscriberIds() {
        return new ArraySet<String>(Arrays.asList(this.mMatchSubscriberIds));
    }

    public Set<String> getWifiNetworkKeys() {
        return new ArraySet<String>(Arrays.asList(this.mMatchWifiNetworkKeys));
    }

    public String getNetworkId() {
        return this.getWifiNetworkKeys().isEmpty() ? null : this.getWifiNetworkKeys().iterator().next();
    }

    public int getMeteredness() {
        return this.mMetered;
    }

    public int getRoaming() {
        return this.mRoaming;
    }

    public int getDefaultNetworkStatus() {
        return this.mDefaultNetwork;
    }

    public int getRatType() {
        return this.mRatType;
    }

    public int getOemManaged() {
        return this.mOemManaged;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean matches(NetworkIdentity ident) {
        Objects.requireNonNull(ident);
        if (!this.matchesMetered(ident)) {
            return false;
        }
        if (!this.matchesRoaming(ident)) {
            return false;
        }
        if (!this.matchesDefaultNetwork(ident)) {
            return false;
        }
        if (!this.matchesOemNetwork(ident)) {
            return false;
        }
        switch (this.mMatchRule) {
            case 1: {
                return this.matchesMobile(ident);
            }
            case 4: {
                return this.matchesWifi(ident);
            }
            case 5: {
                return this.matchesEthernet(ident);
            }
            case 8: {
                return this.matchesBluetooth(ident);
            }
            case 9: {
                return this.matchesProxy(ident);
            }
            case 10: {
                return this.matchesCarrier(ident);
            }
            case 11: {
                return this.matchesTest(ident);
            }
        }
        return false;
    }

    private boolean matchesMetered(NetworkIdentity ident) {
        return this.mMetered == -1 || this.mMetered == 1 && ident.mMetered || this.mMetered == 0 && !ident.mMetered;
    }

    private boolean matchesRoaming(NetworkIdentity ident) {
        return this.mRoaming == -1 || this.mRoaming == 1 && ident.mRoaming || this.mRoaming == 0 && !ident.mRoaming;
    }

    private boolean matchesDefaultNetwork(NetworkIdentity ident) {
        return this.mDefaultNetwork == -1 || this.mDefaultNetwork == 1 && ident.mDefaultNetwork || this.mDefaultNetwork == 0 && !ident.mDefaultNetwork;
    }

    private boolean matchesOemNetwork(NetworkIdentity ident) {
        return this.mOemManaged == -1 || this.mOemManaged == -2 && ident.mOemManaged != 0 || this.mOemManaged == ident.mOemManaged;
    }

    private boolean matchesCollapsedRatType(NetworkIdentity ident) {
        return this.mRatType == -1 || NetworkStatsManager.getCollapsedRatType(this.mRatType) == NetworkStatsManager.getCollapsedRatType(ident.mRatType);
    }

    public boolean matchesSubscriberId(String subscriberId) {
        return this.mMatchSubscriberIds.length == 0 || CollectionUtils.contains(this.mMatchSubscriberIds, subscriberId);
    }

    private boolean matchesWifiNetworkKey(String wifiNetworkKey) {
        if (wifiNetworkKey == null) {
            return CollectionUtils.isEmpty(this.mMatchWifiNetworkKeys);
        }
        return CollectionUtils.isEmpty(this.mMatchWifiNetworkKeys) || CollectionUtils.contains(this.mMatchWifiNetworkKeys, wifiNetworkKey);
    }

    private boolean matchesMobile(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return (CollectionUtils.isEmpty(this.mMatchSubscriberIds) || CollectionUtils.contains(this.mMatchSubscriberIds, ident.mSubscriberId)) && ident.mType == 0 && this.matchesCollapsedRatType(ident);
    }

    private boolean matchesWifi(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: {
                return this.matchesSubscriberId(ident.mSubscriberId) && this.matchesWifiNetworkKey(ident.mWifiNetworkKey);
            }
            case 13: {
                return CollectionUtils.isEmpty(this.mMatchWifiNetworkKeys);
            }
        }
        return false;
    }

    private boolean matchesEthernet(NetworkIdentity ident) {
        return ident.mType == 9;
    }

    private boolean matchesCarrier(NetworkIdentity ident) {
        return ident.mSubscriberId != null && !CollectionUtils.isEmpty(this.mMatchSubscriberIds) && CollectionUtils.contains(this.mMatchSubscriberIds, ident.mSubscriberId);
    }

    private boolean matchesTest(NetworkIdentity ident) {
        return ident.mType == 18 && (CollectionUtils.isEmpty(this.mMatchWifiNetworkKeys) || CollectionUtils.contains(this.mMatchWifiNetworkKeys, ident.mWifiNetworkKey));
    }

    private boolean matchesBluetooth(NetworkIdentity ident) {
        return ident.mType == 7;
    }

    private boolean matchesProxy(NetworkIdentity ident) {
        return ident.mType == 16;
    }

    private static String getMatchRuleName(int matchRule) {
        switch (matchRule) {
            case 1: {
                return "MOBILE";
            }
            case 4: {
                return "WIFI";
            }
            case 5: {
                return "ETHERNET";
            }
            case 8: {
                return "BLUETOOTH";
            }
            case 9: {
                return "PROXY";
            }
            case 10: {
                return "CARRIER";
            }
            case 11: {
                return "TEST";
            }
        }
        return "UNKNOWN(" + matchRule + ")";
    }

    private static String getOemManagedNames(int oemManaged) {
        switch (oemManaged) {
            case -1: {
                return "OEM_MANAGED_ALL";
            }
            case 0: {
                return "OEM_MANAGED_NO";
            }
            case -2: {
                return "OEM_MANAGED_YES";
            }
        }
        return NetworkIdentity.getOemManagedNames(oemManaged);
    }

    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="There is no alternative for {@code NetworkTemplate.normalize}.Callers should have their own logic to merge template for different IMSIs and stop calling this function.")
    public static NetworkTemplate normalize(NetworkTemplate template, String[] merged) {
        return NetworkTemplate.normalizeImpl(template, Collections.singletonList(merged));
    }

    public static NetworkTemplate normalize(NetworkTemplate template, List<String[]> mergedList) {
        NetworkTemplate.throwAtLeastU();
        return NetworkTemplate.normalizeImpl(template, mergedList);
    }

    private static NetworkTemplate normalizeImpl(NetworkTemplate template, List<String[]> mergedList) {
        if (CollectionUtils.isEmpty(template.mMatchSubscriberIds)) {
            return template;
        }
        for (String[] merged : mergedList) {
            String[] stringArray;
            if (!CollectionUtils.contains(merged, template.mMatchSubscriberIds[0])) continue;
            String[] matchWifiNetworkKeys = template.mMatchWifiNetworkKeys;
            int n = template.mMatchRule;
            if (CollectionUtils.isEmpty(matchWifiNetworkKeys)) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = matchWifiNetworkKeys[0];
            }
            return new NetworkTemplate(n, merged, stringArray, template.mMatchRule == 1 || template.mMatchRule == 10 ? 1 : -1, -1, -1, -1, -1);
        }
        return template;
    }

    static {
        WIFI_NETWORK_KEY_ALL = WIFI_NETWORKID_ALL = null;
        CREATOR = new Parcelable.Creator<NetworkTemplate>(){

            @Override
            public NetworkTemplate createFromParcel(Parcel in) {
                return new NetworkTemplate(in);
            }

            public NetworkTemplate[] newArray(int size) {
                return new NetworkTemplate[size];
            }
        };
    }

    public static class Builder {
        private final int mMatchRule;
        private final SortedSet<String> mMatchSubscriberIds = new TreeSet(Comparator.nullsFirst(Comparator.naturalOrder()));
        private final SortedSet<String> mMatchWifiNetworkKeys = new TreeSet<String>();
        private int mMetered;
        private int mRoaming;
        private int mDefaultNetwork;
        private int mRatType;
        private int mOemManaged;

        public Builder(int matchRule) {
            Builder.assertRequestableMatchRule(matchRule);
            this.mMatchRule = matchRule;
            this.mMetered = -1;
            this.mRoaming = -1;
            this.mDefaultNetwork = -1;
            this.mRatType = -1;
            this.mOemManaged = -1;
        }

        public Builder setSubscriberIds(Set<String> subscriberIds) {
            Objects.requireNonNull(subscriberIds);
            this.mMatchSubscriberIds.clear();
            this.mMatchSubscriberIds.addAll(subscriberIds);
            return this;
        }

        public Builder setWifiNetworkKeys(Set<String> wifiNetworkKeys) {
            Objects.requireNonNull(wifiNetworkKeys);
            for (String key : wifiNetworkKeys) {
                if (key != null) continue;
                throw new IllegalArgumentException("Null is not a valid key");
            }
            this.mMatchWifiNetworkKeys.clear();
            this.mMatchWifiNetworkKeys.addAll(wifiNetworkKeys);
            return this;
        }

        public Builder setMeteredness(int metered) {
            this.mMetered = metered;
            return this;
        }

        public Builder setRoaming(int roaming) {
            this.mRoaming = roaming;
            return this;
        }

        public Builder setDefaultNetworkStatus(int defaultNetwork) {
            this.mDefaultNetwork = defaultNetwork;
            return this;
        }

        public Builder setRatType(int ratType) {
            this.mRatType = ratType;
            return this;
        }

        public Builder setOemManaged(int oemManaged) {
            this.mOemManaged = oemManaged;
            return this;
        }

        private static void assertRequestableMatchRule(int matchRule) {
            if (!NetworkTemplate.isKnownMatchRule(matchRule) || matchRule == 9) {
                throw new IllegalArgumentException("Invalid match rule: " + NetworkTemplate.getMatchRuleName(matchRule));
            }
        }

        private void assertRequestableParameters() {
            this.validateWifiNetworkKeys();
        }

        private void validateWifiNetworkKeys() {
            if (this.mMatchRule != 4 && this.mMatchRule != 11 && !this.mMatchWifiNetworkKeys.isEmpty()) {
                throw new IllegalArgumentException("Trying to build non wifi match rule: " + this.mMatchRule + " with wifi network keys");
            }
        }

        public NetworkTemplate build() {
            this.assertRequestableParameters();
            return new NetworkTemplate(this.mMatchRule, this.mMatchSubscriberIds.toArray(new String[0]), this.mMatchWifiNetworkKeys.toArray(new String[0]), this.mMetered, this.mRoaming, this.mDefaultNetwork, this.mRatType, this.mOemManaged);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OemManaged {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TemplateMatchRule {
    }
}

