/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.DnsResolver;
import android.net.InetAddresses;
import android.net.IpPrefix;
import android.net.Network;
import android.net.connectivity.android.net.TcpRepairWindow;
import android.net.connectivity.com.android.net.module.util.Inet4AddressUtils;
import android.system.ErrnoException;
import android.util.Log;
import android.util.Pair;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.TreeSet;

public class NetworkUtils {
    private static final String TAG = "NetworkUtils";

    public static void attachDropAllBPFFilter(FileDescriptor fileDescriptor) throws SocketException {
        OverrideMethod.invokeV("android.net.NetworkUtils#attachDropAllBPFFilter(Ljava/io/FileDescriptor;)V", true, null);
    }

    public static void detachBPFFilter(FileDescriptor fileDescriptor) throws SocketException {
        OverrideMethod.invokeV("android.net.NetworkUtils#detachBPFFilter(Ljava/io/FileDescriptor;)V", true, null);
    }

    private static boolean bindProcessToNetworkHandle(long l) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#bindProcessToNetworkHandle(J)Z", true, null) != 0;
    }

    public static boolean bindProcessToNetwork(int netId) {
        return NetworkUtils.bindProcessToNetworkHandle(new Network(netId).getNetworkHandle());
    }

    private static long getBoundNetworkHandleForProcess() {
        return OverrideMethod.invokeL("android.net.NetworkUtils#getBoundNetworkHandleForProcess()J", true, null);
    }

    public static int getBoundNetworkForProcess() {
        long netHandle = NetworkUtils.getBoundNetworkHandleForProcess();
        return netHandle == 0L ? 0 : Network.fromNetworkHandle(netHandle).getNetId();
    }

    @Deprecated
    public static boolean bindProcessToNetworkForHostResolution(int n) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#bindProcessToNetworkForHostResolution(I)Z", true, null) != 0;
    }

    private static int bindSocketToNetworkHandle(FileDescriptor fileDescriptor, long l) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#bindSocketToNetworkHandle(Ljava/io/FileDescriptor;J)I", true, null);
    }

    public static int bindSocketToNetwork(FileDescriptor fd, int netId) {
        return NetworkUtils.bindSocketToNetworkHandle(fd, new Network(netId).getNetworkHandle());
    }

    public static boolean queryUserAccess(int uid, int netId) {
        return false;
    }

    private static FileDescriptor resNetworkSend(long l, byte[] byArray, int n, int n2) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("android.net.NetworkUtils#resNetworkSend(J[BII)Ljava/io/FileDescriptor;", true, null);
    }

    public static FileDescriptor resNetworkSend(int netId, byte[] msg, int msglen, int flags) throws ErrnoException {
        return NetworkUtils.resNetworkSend(new Network(netId).getNetworkHandle(), msg, msglen, flags);
    }

    private static FileDescriptor resNetworkQuery(long l, String string2, int n, int n2, int n3) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("android.net.NetworkUtils#resNetworkQuery(JLjava/lang/String;III)Ljava/io/FileDescriptor;", true, null);
    }

    public static FileDescriptor resNetworkQuery(int netId, String dname, int nsClass, int nsType, int flags) throws ErrnoException {
        return NetworkUtils.resNetworkQuery(new Network(netId).getNetworkHandle(), dname, nsClass, nsType, flags);
    }

    public static DnsResolver.DnsResponse resNetworkResult(FileDescriptor fileDescriptor) throws ErrnoException {
        return (DnsResolver.DnsResponse)OverrideMethod.invokeA("android.net.NetworkUtils#resNetworkResult(Ljava/io/FileDescriptor;)Landroid/net/DnsResolver$DnsResponse;", true, null);
    }

    public static void resNetworkCancel(FileDescriptor fileDescriptor) {
        OverrideMethod.invokeV("android.net.NetworkUtils#resNetworkCancel(Ljava/io/FileDescriptor;)V", true, null);
    }

    public static Network getDnsNetwork() throws ErrnoException {
        return (Network)OverrideMethod.invokeA("android.net.NetworkUtils#getDnsNetwork()Landroid/net/Network;", true, null);
    }

    public static TcpRepairWindow getTcpRepairWindow(FileDescriptor fileDescriptor) throws ErrnoException {
        return (TcpRepairWindow)OverrideMethod.invokeA("android.net.NetworkUtils#getTcpRepairWindow(Ljava/io/FileDescriptor;)Landroid/net/connectivity/android/net/TcpRepairWindow;", true, null);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static InetAddress intToInetAddress(int hostAddress) {
        return Inet4AddressUtils.intToInet4AddressHTL(hostAddress);
    }

    @Deprecated
    public static int inetAddressToInt(Inet4Address inetAddr) throws IllegalArgumentException {
        return Inet4AddressUtils.inet4AddressToIntHTL(inetAddr);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static int prefixLengthToNetmaskInt(int prefixLength) throws IllegalArgumentException {
        return Inet4AddressUtils.prefixLengthToV4NetmaskIntHTL(prefixLength);
    }

    public static int netmaskIntToPrefixLength(int netmask) {
        return Integer.bitCount(netmask);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int netmaskToPrefixLength(Inet4Address netmask) {
        return Inet4AddressUtils.netmaskToPrefixLength(netmask);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28)
    public static InetAddress numericToInetAddress(String addrString) throws IllegalArgumentException {
        return InetAddresses.parseNumericAddress(addrString);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int getImplicitNetmask(Inet4Address address) {
        return Inet4AddressUtils.getImplicitNetmask(address);
    }

    public static Pair<InetAddress, Integer> parseIpAndMask(String ipAndMaskString) {
        InetAddress address = null;
        int prefixLength = -1;
        try {
            String[] pieces = ipAndMaskString.split("/", 2);
            prefixLength = Integer.parseInt(pieces[1]);
            address = InetAddresses.parseNumericAddress(pieces[0]);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (address == null || prefixLength == -1) {
            throw new IllegalArgumentException("Invalid IP address and mask " + ipAndMaskString);
        }
        return new Pair<Object, Integer>(address, prefixLength);
    }

    @Deprecated
    public static Pair<InetAddress, Integer> legacyParseIpAndMask(String ipAndMaskString) {
        InetAddress address = null;
        int prefixLength = -1;
        try {
            String[] pieces = ipAndMaskString.split("/", 2);
            prefixLength = Integer.parseInt(pieces[1]);
            if (pieces[0] == null || pieces[0].isEmpty()) {
                byte[] bytes = new byte[16];
                bytes[15] = 1;
                return new Pair<InetAddress, Integer>(Inet6Address.getByAddress("ip6-localhost", bytes, 0), prefixLength);
            }
            if (pieces[0].startsWith("[") && pieces[0].endsWith("]") && pieces[0].indexOf(58) != -1) {
                pieces[0] = pieces[0].substring(1, pieces[0].length() - 1);
            }
            address = InetAddresses.parseNumericAddress(pieces[0]);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (address == null || prefixLength == -1) {
            throw new IllegalArgumentException("Invalid IP address and mask " + ipAndMaskString);
        }
        return new Pair<Object, Integer>(address, prefixLength);
    }

    public static InetAddress hexToInet6Address(String addrHexString) throws IllegalArgumentException {
        try {
            return NetworkUtils.numericToInetAddress(String.format(Locale.US, "%s:%s:%s:%s:%s:%s:%s:%s", addrHexString.substring(0, 4), addrHexString.substring(4, 8), addrHexString.substring(8, 12), addrHexString.substring(12, 16), addrHexString.substring(16, 20), addrHexString.substring(20, 24), addrHexString.substring(24, 28), addrHexString.substring(28, 32)));
        }
        catch (Exception e) {
            Log.e(TAG, "error in hexToInet6Address(" + addrHexString + "): " + e);
            throw new IllegalArgumentException(e);
        }
    }

    @UnsupportedAppUsage
    public static String trimV4AddrZeros(String addr) {
        return Inet4AddressUtils.trimAddressZeros(addr);
    }

    private static TreeSet<IpPrefix> deduplicatePrefixSet(TreeSet<IpPrefix> src) {
        TreeSet<IpPrefix> dst = new TreeSet<IpPrefix>(src.comparator());
        block0: for (IpPrefix newPrefix : src) {
            for (IpPrefix existingPrefix : dst) {
                if (!existingPrefix.containsPrefix(newPrefix)) continue;
                continue block0;
            }
            dst.add(newPrefix);
        }
        return dst;
    }

    public static long routedIPv4AddressCount(TreeSet<IpPrefix> prefixes) {
        long routedIPCount = 0L;
        for (IpPrefix prefix : NetworkUtils.deduplicatePrefixSet(prefixes)) {
            if (!prefix.isIPv4()) {
                Log.wtf(TAG, "Non-IPv4 prefix in routedIPv4AddressCount");
            }
            int rank = 32 - prefix.getPrefixLength();
            routedIPCount += 1L << rank;
        }
        return routedIPCount;
    }

    public static BigInteger routedIPv6AddressCount(TreeSet<IpPrefix> prefixes) {
        BigInteger routedIPCount = BigInteger.ZERO;
        for (IpPrefix prefix : NetworkUtils.deduplicatePrefixSet(prefixes)) {
            if (!prefix.isIPv6()) {
                Log.wtf(TAG, "Non-IPv6 prefix in routedIPv6AddressCount");
            }
            int rank = 128 - prefix.getPrefixLength();
            routedIPCount = routedIPCount.add(BigInteger.ONE.shiftLeft(rank));
        }
        return routedIPCount;
    }

    static {
        System_Delegate.loadLibrary("framework-connectivity-jni");
    }
}

