/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.IConnectivityManager;
import android.net.Network;
import android.net.connectivity.android.net.ISocketKeepaliveCallback;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public abstract class SocketKeepalive
implements AutoCloseable {
    protected static final String TAG = "SocketKeepalive";
    @SystemApi
    public static final int SUCCESS = 0;
    public static final int SUCCESS_PAUSED = 1;
    public static final int NO_KEEPALIVE = -1;
    public static final int DATA_RECEIVED = -2;
    public static final int BINDER_DIED = -10;
    public static final int ERROR_INVALID_NETWORK = -20;
    public static final int ERROR_INVALID_IP_ADDRESS = -21;
    public static final int ERROR_INVALID_PORT = -22;
    public static final int ERROR_INVALID_LENGTH = -23;
    public static final int ERROR_INVALID_INTERVAL = -24;
    public static final int ERROR_INVALID_SOCKET = -25;
    public static final int ERROR_SOCKET_NOT_IDLE = -26;
    public static final int ERROR_STOP_REASON_UNINITIALIZED = -27;
    public static final int ERROR_UNSUPPORTED = -30;
    public static final int ERROR_HARDWARE_ERROR = -31;
    public static final int ERROR_INSUFFICIENT_RESOURCES = -32;
    @SystemApi
    public static final int ERROR_NO_SUCH_SLOT = -33;
    @SystemApi
    public static final int FLAG_AUTOMATIC_ON_OFF = 1;
    public static final int MIN_INTERVAL_SEC = 10;
    public static final int MAX_INTERVAL_SEC = 3600;
    protected final IConnectivityManager mService;
    protected final Network mNetwork;
    protected final ParcelFileDescriptor mPfd;
    protected final Executor mExecutor;
    protected final ISocketKeepaliveCallback mCallback;

    public SocketKeepalive(IConnectivityManager service, Network network, ParcelFileDescriptor pfd, final Executor executor, final Callback callback) {
        this.mService = service;
        this.mNetwork = network;
        this.mPfd = pfd;
        this.mExecutor = executor;
        this.mCallback = new ISocketKeepaliveCallback.Stub(){

            @Override
            public void onStarted() {
                long token = Binder.clearCallingIdentity();
                try {
                    SocketKeepalive.this.mExecutor.execute(() -> callback.onStarted());
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }

            @Override
            public void onResumed() {
                long token = Binder.clearCallingIdentity();
                try {
                    SocketKeepalive.this.mExecutor.execute(() -> callback.onResumed());
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }

            @Override
            public void onStopped() {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.onStopped());
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }

            @Override
            public void onPaused() {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.onPaused());
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int error) {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.onError(error));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }

            @Override
            public void onDataReceived() {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.onDataReceived());
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };
    }

    public void start(int intervalSec) {
        this.startImpl(intervalSec, 0, null);
    }

    @SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
    public void start(int intervalSec, int flags, Network underpinnedNetwork) {
        this.startImpl(intervalSec, flags, underpinnedNetwork);
    }

    protected abstract void startImpl(int var1, int var2, Network var3);

    public void stop() {
        this.stopImpl();
    }

    protected abstract void stopImpl();

    @Override
    public void close() {
        this.stop();
        try {
            this.mPfd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Callback {
        public void onStarted() {
        }

        public void onResumed() {
        }

        public void onStopped() {
        }

        public void onPaused() {
        }

        public void onError(int error) {
        }

        public void onDataReceived() {
        }
    }

    public static class InvalidSocketException
    extends ErrorCodeException {
        public InvalidSocketException(int error, Throwable e) {
            super(error, e);
        }

        public InvalidSocketException(int error) {
            super(error);
        }
    }

    public static class ErrorCodeException
    extends Exception {
        public final int error;

        public ErrorCodeException(int error, Throwable e) {
            super(e);
            this.error = error;
        }

        public ErrorCodeException(int error) {
            this.error = error;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StartFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeepaliveEvent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }
}

