/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.RouteInfo;
import android.net.connectivity.com.android.net.module.util.InetAddressUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StaticIpConfiguration
implements Parcelable {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public LinkAddress ipAddress;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public InetAddress gateway;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public final ArrayList<InetAddress> dnsServers = new ArrayList();
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String domains;
    public static final Parcelable.Creator<StaticIpConfiguration> CREATOR = new Parcelable.Creator<StaticIpConfiguration>(){

        @Override
        public StaticIpConfiguration createFromParcel(Parcel in) {
            return StaticIpConfiguration.readFromParcel(in);
        }

        public StaticIpConfiguration[] newArray(int size) {
            return new StaticIpConfiguration[size];
        }
    };

    @SystemApi
    public StaticIpConfiguration() {
    }

    @SystemApi
    public StaticIpConfiguration(StaticIpConfiguration source) {
        this();
        if (source != null) {
            this.ipAddress = source.ipAddress;
            this.gateway = source.gateway;
            this.dnsServers.addAll(source.dnsServers);
            this.domains = source.domains;
        }
    }

    @SystemApi
    public void clear() {
        this.ipAddress = null;
        this.gateway = null;
        this.dnsServers.clear();
        this.domains = null;
    }

    public LinkAddress getIpAddress() {
        return this.ipAddress;
    }

    public InetAddress getGateway() {
        return this.gateway;
    }

    public List<InetAddress> getDnsServers() {
        return this.dnsServers;
    }

    public String getDomains() {
        return this.domains;
    }

    @SystemApi
    public void addDnsServer(InetAddress server) {
        this.dnsServers.add(server);
    }

    @SystemApi
    public List<RouteInfo> getRoutes(String iface) {
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>(3);
        if (this.ipAddress != null) {
            RouteInfo connectedRoute = new RouteInfo(this.ipAddress, null, iface);
            routes.add(connectedRoute);
            if (this.gateway != null && !connectedRoute.matches(this.gateway)) {
                routes.add(RouteInfo.makeHostRoute(this.gateway, iface));
            }
        }
        if (this.gateway != null) {
            routes.add(new RouteInfo((IpPrefix)null, this.gateway, iface));
        }
        return routes;
    }

    public LinkProperties toLinkProperties(String iface) {
        LinkProperties lp = new LinkProperties();
        lp.setInterfaceName(iface);
        if (this.ipAddress != null) {
            lp.addLinkAddress(this.ipAddress);
        }
        for (RouteInfo route : this.getRoutes(iface)) {
            lp.addRoute(route);
        }
        for (InetAddress dns : this.dnsServers) {
            lp.addDnsServer(dns);
        }
        lp.setDomains(this.domains);
        return lp;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("IP address ");
        if (this.ipAddress != null) {
            str.append(this.ipAddress).append(" ");
        }
        str.append("Gateway ");
        if (this.gateway != null) {
            str.append(this.gateway.getHostAddress()).append(" ");
        }
        str.append(" DNS servers: [");
        for (InetAddress dnsServer : this.dnsServers) {
            str.append(" ").append(dnsServer.getHostAddress());
        }
        str.append(" ] Domains ");
        if (this.domains != null) {
            str.append(this.domains);
        }
        return str.toString();
    }

    public int hashCode() {
        int result = 13;
        result = 47 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 47 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
        result = 47 * result + (this.domains == null ? 0 : this.domains.hashCode());
        result = 47 * result + this.dnsServers.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticIpConfiguration)) {
            return false;
        }
        StaticIpConfiguration other = (StaticIpConfiguration)obj;
        return other != null && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.gateway, other.gateway) && this.dnsServers.equals(other.dnsServers) && Objects.equals(this.domains, other.domains);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.ipAddress, flags);
        InetAddressUtils.parcelInetAddress(dest, this.gateway, flags);
        dest.writeInt(this.dnsServers.size());
        for (InetAddress dnsServer : this.dnsServers) {
            InetAddressUtils.parcelInetAddress(dest, dnsServer, flags);
        }
        dest.writeString(this.domains);
    }

    public static StaticIpConfiguration readFromParcel(Parcel in) {
        StaticIpConfiguration s = new StaticIpConfiguration();
        s.ipAddress = (LinkAddress)in.readParcelable(null);
        s.gateway = InetAddressUtils.unparcelInetAddress(in);
        s.dnsServers.clear();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            s.dnsServers.add(InetAddressUtils.unparcelInetAddress(in));
        }
        s.domains = in.readString();
        return s;
    }

    public static class Builder {
        private LinkAddress mIpAddress;
        private InetAddress mGateway;
        private Iterable<InetAddress> mDnsServers;
        private String mDomains;

        public Builder setIpAddress(LinkAddress ipAddress) {
            if (ipAddress != null && !(ipAddress.getAddress() instanceof Inet4Address)) {
                throw new IllegalArgumentException("Only IPv4 addresses can be used for the IP configuration");
            }
            this.mIpAddress = ipAddress;
            return this;
        }

        public Builder setGateway(InetAddress gateway) {
            if (gateway != null && !(gateway instanceof Inet4Address)) {
                throw new IllegalArgumentException("Only IPv4 addresses can be used for the gateway configuration");
            }
            this.mGateway = gateway;
            return this;
        }

        public Builder setDnsServers(Iterable<InetAddress> dnsServers) {
            Objects.requireNonNull(dnsServers);
            for (InetAddress inetAddress : dnsServers) {
                if (inetAddress instanceof Inet4Address) continue;
                throw new IllegalArgumentException("Only IPv4 addresses can be used for the DNS server configuration");
            }
            this.mDnsServers = dnsServers;
            return this;
        }

        public Builder setDomains(String newDomains) {
            this.mDomains = newDomains;
            return this;
        }

        public StaticIpConfiguration build() {
            StaticIpConfiguration config = new StaticIpConfiguration();
            config.ipAddress = this.mIpAddress;
            config.gateway = this.mGateway;
            if (this.mDnsServers != null) {
                for (InetAddress server : this.mDnsServers) {
                    config.dnsServers.add(server);
                }
            }
            config.domains = this.mDomains;
            return config;
        }
    }
}

