/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import java.net.NetworkInterface;
import java.net.SocketException;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class TestNetworkInterface
implements Parcelable {
    private static final String TAG = "TestNetworkInterface";
    private final ParcelFileDescriptor mFileDescriptor;
    private final String mInterfaceName;
    private final MacAddress mMacAddress;
    private final int mMtu;
    public static final Parcelable.Creator<TestNetworkInterface> CREATOR = new Parcelable.Creator<TestNetworkInterface>(){

        @Override
        public TestNetworkInterface createFromParcel(Parcel in) {
            return new TestNetworkInterface(in);
        }

        public TestNetworkInterface[] newArray(int size) {
            return new TestNetworkInterface[size];
        }
    };

    @Override
    public int describeContents() {
        return this.mFileDescriptor != null ? 1 : 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mFileDescriptor, flags);
        out.writeString(this.mInterfaceName);
        out.writeParcelable(this.mMacAddress, flags);
        out.writeInt(this.mMtu);
    }

    public TestNetworkInterface(ParcelFileDescriptor pfd, String intf) {
        this.mFileDescriptor = pfd;
        this.mInterfaceName = intf;
        MacAddress macAddress = null;
        int mtu = 1500;
        try {
            NetworkInterface nif = NetworkInterface.getByName(this.mInterfaceName);
            byte[] hardwareAddress = nif.getHardwareAddress();
            if (hardwareAddress != null) {
                macAddress = MacAddress.fromBytes(nif.getHardwareAddress());
            }
            mtu = nif.getMTU();
        }
        catch (SocketException e) {
            Log.e(TAG, "Failed to fetch MacAddress or MTU size from NetworkInterface", e);
        }
        this.mMacAddress = macAddress;
        this.mMtu = mtu;
    }

    private TestNetworkInterface(Parcel in) {
        this.mFileDescriptor = (ParcelFileDescriptor)in.readParcelable(ParcelFileDescriptor.class.getClassLoader());
        this.mInterfaceName = in.readString();
        this.mMacAddress = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
        this.mMtu = in.readInt();
    }

    public ParcelFileDescriptor getFileDescriptor() {
        return this.mFileDescriptor;
    }

    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    public MacAddress getMacAddress() {
        return this.mMacAddress;
    }

    public int getMtu() {
        return this.mMtu;
    }
}

